/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20Module;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.CppModulesStateUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ClangScanEvent;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

public class UpdateFromWorkspaceEvent
extends ClangScanEvent {
    public UpdateFromWorkspaceEvent(@NotNull Project project) {
        if (project == null) {
            UpdateFromWorkspaceEvent.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    public void doScan() {
        if (!CppModulesStateUtil.areCpp20ModulesEnabled()) {
            return;
        }
        ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(this.myProject);
        if (provider2 == null) {
            ClangUtils.LOG.error("ClangLanguageServiceProvider not found");
            return;
        }
        ClangLanguageService service = provider2.getOrStart();
        if (service == null) {
            ClangUtils.LOG.error("ClangLanguageService not found");
            return;
        }
        HashSet<String> allSources = new HashSet<String>();
        ClangUrlConverter converter = service.getUrlConverter();
        Cpp20ModulesContext cpp20ModulesContext = new Cpp20ModulesContext(service.getContext().getCpp20ModuleMapPath(), service.getContext().getCpp20ModulesPath(), service.getContext().getModuleMapPath());
        boolean anythingWasAdded = false;
        for (OCResolveConfiguration config : OCWorkspace.getInstance((Project)this.myProject).getConfigurations()) {
            for (VirtualFile srcFile : config.getSources()) {
                ClangdCompilationCommand command;
                String name = srcFile.getName();
                if (allSources.contains(name)) continue;
                allSources.add(name);
                Map compilerFeatures = config.getCompilerSettings((OCLanguageKind)CLanguageKind.CPP, srcFile).getCompilerFeatures();
                Object isModule = compilerFeatures.get(OCCompilerFeatures.IS_MODULE);
                if ((isModule == null || !((Boolean)isModule).booleanValue()) && !CppModulesStateUtil.isCpp20ModuleFile(name)) continue;
                String modName = (String)ReadAction.compute(() -> {
                    Document document2 = FileDocumentManager.getInstance().getDocument(srcFile);
                    if (document2 == null) {
                        return null;
                    }
                    Ref isImpl = Ref.create();
                    return CppModulesStateUtil.getModuleName(document2.getImmutableCharSequence(), (Ref<Boolean>)isImpl);
                });
                try {
                    command = (ClangdCompilationCommand)CidrConcurrentUtilsKt.waitCancelAware(service.getClangIdeFacade().getCompilationCommandAsync(converter, this.myProject, srcFile, "", cpp20ModulesContext), (String)"compilation command");
                }
                catch (ExecutionException ex) {
                    ClangUtils.LOG.error((Throwable)ex);
                    command = null;
                }
                if (modName == null || command == null) continue;
                anythingWasAdded = true;
                this.myModulesState.addCppModule(new Cpp20Module(modName, command.ccParams, command.ppDefines, srcFile.getPath(), false));
            }
        }
        if (anythingWasAdded) {
            CppModulesStateUtil.updateModuleMap(this.myModulesState, this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/scan/events/UpdateFromWorkspaceEvent", "<init>"));
    }
}

