/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.memory;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDogListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangMemoryUsagePanel
implements CustomStatusBarWidget,
Activatable {
    public static final String WIDGET_ID = "ClangdMemory";
    @NotNull
    private final LazyInitializer.LazyValue<ClangMemoryUsagePanelImpl> impl;

    public ClangMemoryUsagePanel(@NotNull Project project) {
        if (project == null) {
            ClangMemoryUsagePanel.$$$reportNull$$$0(0);
        }
        this.impl = LazyInitializer.create(() -> new ClangMemoryUsagePanelImpl(project));
    }

    public void showNotify() {
        ((ClangMemoryUsagePanelImpl)((Object)this.impl.get())).updateState();
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    public JComponent getComponent() {
        return (JComponent)this.impl.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/clang/clangd/memory/ClangMemoryUsagePanel", "<init>"));
    }

    private class ClangMemoryUsagePanelImpl
    extends TextPanel {
        private static final Color USED_COLOR = JBColor.namedColor((String)"MemoryIndicator.usedBackground", (Color)new JBColor((Color)Gray._185, (Color)Gray._110));
        @NotNull
        private final Project myProject;
        private volatile long myLastReported;
        private volatile long myShown;
        private volatile long myLastLimit;
        private volatile long myLimitShown;
        private volatile long myLastAvgUsed;
        private volatile long myLastAvgUsedShown;
        private volatile long myLastMaxUsed;
        private volatile long myLastMaxUsedShown;
        private volatile long myIndexerLastReported;
        private volatile long myIndexerShown;
        private volatile long myIndexerLastLimit;
        private volatile long myIndexerLimitShown;
        private volatile long myIndexerLastAvgUsed;
        private volatile long myIndexerLastAvgUsedShown;
        private volatile long myIndexerLastMaxUsed;
        private volatile long myIndexerLastMaxUsedShown;
        private volatile long myStatelessIndexerLastReported;
        private volatile long myStatelessIndexerShown;
        private volatile long myStatelessIndexerLastLimit;
        private volatile long myStatelessIndexerLimitShown;
        private volatile long myStatelessIndexerLastAvgUsed;
        private volatile long myStatelessIndexerLastAvgUsedShown;
        private volatile long myStatelessIndexerLastMaxUsed;
        private volatile long myStatelessIndexerLastMaxUsedShown;

        ClangMemoryUsagePanelImpl(Project project) {
            ClangdIndexerService statelessIndexer;
            ClangLanguageService indexerService;
            ClangLanguageService mainService;
            if (project == null) {
                ClangMemoryUsagePanelImpl.$$$reportNull$$$0(0);
            }
            this.myLastReported = 0L;
            this.myShown = 0L;
            this.myLastLimit = 0L;
            this.myLimitShown = 0L;
            this.myLastAvgUsed = 0L;
            this.myLastAvgUsedShown = 0L;
            this.myLastMaxUsed = 0L;
            this.myLastMaxUsedShown = 0L;
            this.myIndexerLastReported = 0L;
            this.myIndexerShown = 0L;
            this.myIndexerLastLimit = 0L;
            this.myIndexerLimitShown = 0L;
            this.myIndexerLastAvgUsed = 0L;
            this.myIndexerLastAvgUsedShown = 0L;
            this.myIndexerLastMaxUsed = 0L;
            this.myIndexerLastMaxUsedShown = 0L;
            this.myStatelessIndexerLastReported = 0L;
            this.myStatelessIndexerShown = 0L;
            this.myStatelessIndexerLastLimit = 0L;
            this.myStatelessIndexerLimitShown = 0L;
            this.myStatelessIndexerLastAvgUsed = 0L;
            this.myStatelessIndexerLastAvgUsedShown = 0L;
            this.myStatelessIndexerLastMaxUsed = 0L;
            this.myStatelessIndexerLastMaxUsedShown = 0L;
            this.myProject = project;
            this.setOpaque(false);
            this.setFocusable(false);
            this.setTextAlignment(0.5f);
            final ClangLanguageServiceProvider clangServiceProvider = ClangLanguageServiceProvider.getProvider(this.myProject);
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                    ClangLanguageService service;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ClangLanguageService clangLanguageService = service = clangServiceProvider != null ? clangServiceProvider.getIfStarted() : null;
                    if (service != null) {
                        service.shutDownServer();
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/daemon/clang/clangd/memory/ClangMemoryUsagePanel$ClangMemoryUsagePanelImpl$1", "onClick"));
                }
            }.installOn((Component)((Object)this), true);
            this.setBorder(JBUI.CurrentTheme.StatusBar.Widget.border());
            this.updateToolTip();
            this.updateUI();
            UiNotifyConnector.installOn((Component)((Object)this), (Activatable)ClangMemoryUsagePanel.this);
            project.getMessageBus().connect().subscribe(ClangLanguageServiceProviderListener.TOPIC, (Object)new ClangLanguageServiceProviderListener(){

                @Override
                public void onServiceStarted(@NotNull ClangLanguageService service) {
                    if (service == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!service.isIndexer()) {
                        service.getMessageBus().connect(service.getAssociatedDisposable()).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)new MainListener());
                    } else if (service.getContext().isStatelessIndexer()) {
                        service.getMessageBus().connect(service.getAssociatedDisposable()).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)new StatelessIndexerListener());
                    } else if (service.getContext().isIndexer()) {
                        service.getMessageBus().connect(service.getAssociatedDisposable()).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)new IndexerListener());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/jetbrains/cidr/lang/daemon/clang/clangd/memory/ClangMemoryUsagePanel$ClangMemoryUsagePanelImpl$2", "onServiceStarted"));
                }
            });
            ClangLanguageService clangLanguageService = mainService = clangServiceProvider != null ? clangServiceProvider.getIfStarted() : null;
            if (mainService != null && mainService.isActive()) {
                mainService.getMessageBus().connect(mainService.getAssociatedDisposable()).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)new MainListener());
            }
            ClangLanguageService clangLanguageService2 = indexerService = clangServiceProvider != null ? clangServiceProvider.getIfStartedIndexer() : null;
            if (indexerService != null && indexerService.isActive()) {
                indexerService.getMessageBus().connect(indexerService.getAssociatedDisposable()).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)new IndexerListener());
            }
            ClangdIndexerService clangdIndexerService = statelessIndexer = clangServiceProvider != null ? clangServiceProvider.getIfStartedStatelessIndexer() : null;
            if (statelessIndexer != null && statelessIndexer.isActive()) {
                statelessIndexer.getMessageBus().connect(statelessIndexer.getAssociatedDisposable()).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)new StatelessIndexerListener());
            }
            this.setVisible(true);
            this.revalidate();
        }

        public void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            int barWidth = size.width;
            boolean disabled = this.myLimitShown <= 0L;
            long maxMem = disabled ? 0L : this.myLimitShown;
            long usedMem = disabled ? 0L : this.myShown;
            int usedBarLength = disabled ? 0 : (int)((long)barWidth * usedMem / maxMem);
            g.setColor(UIUtil.getPanelBackground());
            g.fillRect(0, 0, barWidth, size.height);
            g.setColor(USED_COLOR);
            g.fillRect(0, 0, usedBarLength, size.height);
            super.paintComponent(g);
        }

        protected String getTextForPreferredSize() {
            int maxLimit = this.myLastLimit < 1000L ? 999 : (this.myLastLimit < 10000L ? 9999 : 99999);
            String sample = ClangdBundle.message("language.cpp.clangd.memory.usage.message", maxLimit, maxLimit);
            return " " + sample;
        }

        private void updateState() {
            if (this.myLastReported != this.myShown || this.myLastAvgUsed != this.myLastAvgUsedShown || this.myLastMaxUsed != this.myLastMaxUsedShown || this.myLastLimit != this.myLimitShown || this.myIndexerLastReported != this.myIndexerShown || this.myIndexerLastLimit != this.myIndexerLimitShown || this.myIndexerLastAvgUsed != this.myIndexerLastAvgUsedShown || this.myIndexerLastMaxUsed != this.myIndexerLastMaxUsedShown || this.myStatelessIndexerLastReported != this.myStatelessIndexerShown || this.myStatelessIndexerLastLimit != this.myStatelessIndexerLimitShown || this.myStatelessIndexerLastAvgUsed != this.myStatelessIndexerLastAvgUsedShown || this.myStatelessIndexerLastMaxUsed != this.myStatelessIndexerLastMaxUsedShown) {
                this.myShown = this.myLastReported;
                this.myLimitShown = this.myLastLimit;
                this.myLastAvgUsedShown = this.myLastAvgUsed;
                this.myLastMaxUsedShown = this.myLastMaxUsed;
                this.myIndexerShown = this.myIndexerLastReported;
                this.myIndexerLimitShown = this.myIndexerLastLimit;
                this.myIndexerLastAvgUsedShown = this.myIndexerLastAvgUsed;
                this.myIndexerLastMaxUsedShown = this.myIndexerLastMaxUsed;
                this.myStatelessIndexerShown = this.myStatelessIndexerLastReported;
                this.myStatelessIndexerLimitShown = this.myStatelessIndexerLastLimit;
                this.myStatelessIndexerLastAvgUsedShown = this.myStatelessIndexerLastAvgUsed;
                this.myStatelessIndexerLastMaxUsedShown = this.myStatelessIndexerLastMaxUsed;
                boolean disabled = this.myLimitShown <= 0L;
                long maxMem = disabled ? 0L : this.myLimitShown;
                long usedMem = disabled ? 0L : this.myShown;
                String text = ClangdBundle.message("language.cpp.clangd.memory.usage.message", usedMem / 0x100000L, maxMem / 0x100000L);
                this.setText(text);
                this.updateToolTip();
            }
        }

        private void updateToolTip() {
            HtmlBuilder tooltip = new HtmlBuilder();
            tooltip.append(ClangdBundle.message("language.cpp.clangd.memory.usage.tooltip.message", this.myShown / 0x100000L, this.myLimitShown / 0x100000L, this.myLastMaxUsedShown / 0x100000L));
            if (ClangUtils.isClangdIndexerOn(this.myProject)) {
                tooltip.br();
                tooltip.append(ClangdBundle.message("language.cpp.clangd.indexer.memory.usage.tooltip.message", this.myIndexerShown / 0x100000L, this.myIndexerLimitShown / 0x100000L, this.myIndexerLastMaxUsedShown / 0x100000L));
            }
            if (ClangUtils.isClangdStatelessIndexerOn(this.myProject)) {
                tooltip.br();
                tooltip.append(ClangdBundle.message("language.cpp.clangd.stateless.indexer.memory.usage.tooltip.message", this.myStatelessIndexerShown / 0x100000L, this.myStatelessIndexerLimitShown / 0x100000L, this.myStatelessIndexerLastMaxUsedShown / 0x100000L));
            }
            this.setToolTipText(tooltip.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/clang/clangd/memory/ClangMemoryUsagePanel$ClangMemoryUsagePanelImpl", "<init>"));
        }

        private class MainListener
        implements ClangMemoryUsageWatchDogListener {
            private MainListener() {
            }

            @Override
            public void onMaxMemoryChanged(long maxMemory) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!ClangMemoryUsagePanelImpl.this.myProject.isDisposed()) {
                        ClangMemoryUsagePanelImpl.this.myLastLimit = maxMemory;
                        if (ClangMemoryUsagePanelImpl.this.isShowing()) {
                            ClangMemoryUsagePanelImpl.this.updateState();
                        }
                    }
                });
            }

            @Override
            public void onUsedMemoryChanged(long usedMemory) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!ClangMemoryUsagePanelImpl.this.myProject.isDisposed()) {
                        ClangMemoryUsageWatchDog memoryUsageWatchDog;
                        ClangMemoryUsagePanelImpl.this.myLastReported = usedMemory;
                        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(ClangMemoryUsagePanelImpl.this.myProject);
                        ClangMemoryUsageWatchDog clangMemoryUsageWatchDog = memoryUsageWatchDog = service != null ? service.getMemoryUsageWatchDog() : null;
                        if (memoryUsageWatchDog != null) {
                            ClangMemoryUsagePanelImpl.this.myLastLimit = memoryUsageWatchDog.getMaxMemory();
                            ClangMemoryUsagePanelImpl.this.myLastAvgUsed = memoryUsageWatchDog.getUsedAverageMemory();
                            ClangMemoryUsagePanelImpl.this.myLastMaxUsed = memoryUsageWatchDog.getUsedMaxMemory();
                        }
                        if (ClangMemoryUsagePanelImpl.this.isShowing()) {
                            ClangMemoryUsagePanelImpl.this.updateState();
                        }
                    }
                });
            }
        }

        private class IndexerListener
        implements ClangMemoryUsageWatchDogListener {
            private IndexerListener() {
            }

            @Override
            public void onMaxMemoryChanged(long maxMemory) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!ClangMemoryUsagePanelImpl.this.myProject.isDisposed()) {
                        ClangMemoryUsagePanelImpl.this.myIndexerLastLimit = maxMemory;
                        if (ClangMemoryUsagePanelImpl.this.isShowing()) {
                            ClangMemoryUsagePanelImpl.this.updateState();
                        }
                    }
                });
            }

            @Override
            public void onUsedMemoryChanged(long usedMemory) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!ClangMemoryUsagePanelImpl.this.myProject.isDisposed()) {
                        ClangMemoryUsagePanelImpl.this.myIndexerLastReported = usedMemory;
                        ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(ClangMemoryUsagePanelImpl.this.myProject);
                        if (provider2 == null) {
                            return;
                        }
                        ClangLanguageService indexer = provider2.getIfStartedIndexer();
                        if (indexer == null) {
                            return;
                        }
                        ClangMemoryUsageWatchDog memoryUsageWatchDog = indexer.getMemoryUsageWatchDog();
                        ClangMemoryUsagePanelImpl.this.myIndexerLastLimit = memoryUsageWatchDog.getMaxMemory();
                        ClangMemoryUsagePanelImpl.this.myIndexerLastAvgUsed = memoryUsageWatchDog.getUsedAverageMemory();
                        ClangMemoryUsagePanelImpl.this.myIndexerLastMaxUsed = memoryUsageWatchDog.getUsedMaxMemory();
                        if (ClangMemoryUsagePanelImpl.this.isShowing()) {
                            ClangMemoryUsagePanelImpl.this.updateState();
                        }
                    }
                });
            }
        }

        private class StatelessIndexerListener
        implements ClangMemoryUsageWatchDogListener {
            private StatelessIndexerListener() {
            }

            @Override
            public void onMaxMemoryChanged(long maxMemory) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!ClangMemoryUsagePanelImpl.this.myProject.isDisposed()) {
                        ClangMemoryUsagePanelImpl.this.myStatelessIndexerLastLimit = maxMemory;
                        if (ClangMemoryUsagePanelImpl.this.isShowing()) {
                            ClangMemoryUsagePanelImpl.this.updateState();
                        }
                    }
                });
            }

            @Override
            public void onUsedMemoryChanged(long usedMemory) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!ClangMemoryUsagePanelImpl.this.myProject.isDisposed()) {
                        ClangMemoryUsagePanelImpl.this.myStatelessIndexerLastReported = usedMemory;
                        ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(ClangMemoryUsagePanelImpl.this.myProject);
                        if (provider2 == null) {
                            return;
                        }
                        ClangdIndexerService indexer = provider2.getIfStartedStatelessIndexer();
                        if (indexer == null) {
                            return;
                        }
                        ClangMemoryUsageWatchDog memoryUsageWatchDog = indexer.getMemoryUsageWatchDog();
                        ClangMemoryUsagePanelImpl.this.myStatelessIndexerLastLimit = memoryUsageWatchDog.getMaxMemory();
                        ClangMemoryUsagePanelImpl.this.myStatelessIndexerLastAvgUsed = memoryUsageWatchDog.getUsedAverageMemory();
                        ClangMemoryUsagePanelImpl.this.myStatelessIndexerLastMaxUsed = memoryUsageWatchDog.getUsedMaxMemory();
                        if (ClangMemoryUsagePanelImpl.this.isShowing()) {
                            ClangMemoryUsagePanelImpl.this.updateState();
                        }
                    }
                });
            }
        }
    }
}

