/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidOpenTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPlannedInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lsp4j.TextDocumentItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangOpenNotification
extends ClangFileBasedNotification<OpenData>
implements ClangPlannedInteraction {
    @Nullable
    public static ClangOpenNotification create(@NotNull ClangDaemonContext context, @NotNull VirtualFile file, int version) {
        OpenData data;
        if (context == null) {
            ClangOpenNotification.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ClangOpenNotification.$$$reportNull$$$0(1);
        }
        return (data = ClangOpenNotification.doPrepare(context, file, version)) != null ? new ClangOpenNotification(context, file.getUrl(), version, data) : null;
    }

    private ClangOpenNotification(@NotNull ClangDaemonContext context, @NotNull String url, int version, @NotNull OpenData data) {
        if (context == null) {
            ClangOpenNotification.$$$reportNull$$$0(2);
        }
        if (url == null) {
            ClangOpenNotification.$$$reportNull$$$0(3);
        }
        if (data == null) {
            ClangOpenNotification.$$$reportNull$$$0(4);
        }
        super(context, url, version, false, data);
    }

    @Override
    @NotNull
    public List<Pair<String, ClangProperty>> getWrittenProperties() {
        List<Pair<String, ClangProperty>> list = Arrays.asList(Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.Ast)), Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.Content)), Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.SavedFlag)), Pair.create((Object)this.getUrl(), (Object)((Object)ClangProperty.FormatConfiguration)));
        if (list == null) {
            ClangOpenNotification.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (server == null) {
            ClangOpenNotification.$$$reportNull$$$0(6);
        }
        if (ws == null) {
            ClangOpenNotification.$$$reportNull$$$0(7);
        }
        assert (ws.isClosedRemotely(this.myUrl));
        return ClangOpenNotification.doSend(server, (OpenData)this.myParams);
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull OpenData params) {
        if (wf == null) {
            ClangOpenNotification.$$$reportNull$$$0(8);
        }
        if (params == null) {
            ClangOpenNotification.$$$reportNull$$$0(9);
        }
        super.toNextRemoteState(wf, params);
        wf.put(RemoteWorkspaceFile.IS_OPENED, true);
        wf.put(RemoteWorkspaceFile.IS_SAVED, params.params.isSaved());
        wf.put(RemoteWorkspaceFile.CONTENT, params.params.getTextDocument().getText());
    }

    @Nullable
    static OpenData doPrepare(@NotNull ClangDaemonContext context, @NotNull VirtualFile file, int version) {
        CharSequence fileText;
        if (context == null) {
            ClangOpenNotification.$$$reportNull$$$0(10);
        }
        if (file == null) {
            ClangOpenNotification.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (context.getProject().isDisposed()) {
            return null;
        }
        String url = file.getUrl();
        ClangIdeFacade ideFacade = context.getIdeFacade();
        boolean isFileSaved = !ideFacade.isModified(file);
        ClangFileFacade helper = ideFacade.getFileFacade(file);
        CharSequence charSequence = fileText = helper != null ? helper.getText() : null;
        if (fileText == null) {
            ClangUtils.warnClangd(LOG, "Failed to get text of a file " + url);
            return null;
        }
        return ClangOpenNotification.doPrepare(context, url, version, fileText.toString(), isFileSaved);
    }

    @NotNull
    static OpenData doPrepare(@NotNull ClangDaemonContext context, @NotNull String url, int version, @NotNull String content2, boolean saved) {
        if (context == null) {
            ClangOpenNotification.$$$reportNull$$$0(12);
        }
        if (url == null) {
            ClangOpenNotification.$$$reportNull$$$0(13);
        }
        if (content2 == null) {
            ClangOpenNotification.$$$reportNull$$$0(14);
        }
        String uri = context.getUrlConverter().toUriFromUrl(url);
        TextDocumentItem docItem = new TextDocumentItem(uri, "cpp", version, content2);
        ClionDidOpenTextDocumentParams params = new ClionDidOpenTextDocumentParams(docItem, saved);
        return new OpenData(context, url, params);
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull OpenData data) {
        if (server == null) {
            ClangOpenNotification.$$$reportNull$$$0(15);
        }
        if (data == null) {
            ClangOpenNotification.$$$reportNull$$$0(16);
        }
        server.clionDidOpen(data.params);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangOpenNotification";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ws";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wf";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangOpenNotification";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrittenProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sendNotificationImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toNextRemoteState";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doPrepare";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doSend";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class OpenData {
        @NotNull
        public final ClangDaemonContext context;
        @NotNull
        public final String url;
        @NotNull
        public final ClionDidOpenTextDocumentParams params;

        OpenData(@NotNull ClangDaemonContext context, @NotNull String url, @NotNull ClionDidOpenTextDocumentParams params) {
            if (context == null) {
                OpenData.$$$reportNull$$$0(0);
            }
            if (url == null) {
                OpenData.$$$reportNull$$$0(1);
            }
            if (params == null) {
                OpenData.$$$reportNull$$$0(2);
            }
            this.context = context;
            this.url = url;
            this.params = params;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "params";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangOpenNotification$OpenData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

