/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangCrashReporter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangReportUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangInternalCrashReporter;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangCrashReporter;", "myArtifactsPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "myCrashId", "Ljava/util/concurrent/atomic/AtomicInteger;", "doAdvancedReport", "", "context", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContext;", "message", "", "fileUrls", "", "report", "", "Companion", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangInternalCrashReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangInternalCrashReporter.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangInternalCrashReporter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n13#2:48\n*S KotlinDebug\n*F\n+ 1 ClangInternalCrashReporter.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangInternalCrashReporter\n*L\n45#1:48\n*E\n"})
public final class ClangInternalCrashReporter
implements ClangCrashReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path myArtifactsPath;
    @NotNull
    private final AtomicInteger myCrashId;
    @NotNull
    private static final Logger LOG;

    public ClangInternalCrashReporter(@NotNull Path myArtifactsPath) {
        Intrinsics.checkNotNullParameter((Object)myArtifactsPath, (String)"myArtifactsPath");
        this.myArtifactsPath = myArtifactsPath;
        this.myCrashId = new AtomicInteger(0);
    }

    @Override
    public void report(@NotNull ClangDaemonContext context, @NotNull String message, @Nullable List<String> fileUrls) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List<String> list = fileUrls;
        LOG.warn("ClangInternalCrashReporter: reporting a crash for " + (list != null ? list.size() : 0) + " files");
        Collection collection = fileUrls;
        if (collection == null || collection.isEmpty() || !this.doAdvancedReport(context, message, fileUrls)) {
            Path crashFile = this.myArtifactsPath.resolve("clangd_crash_" + this.myCrashId.incrementAndGet() + ".txt");
            FileUtil.writeToFile((File)crashFile.toFile(), (String)message);
            LOG.warn("ClangInternalCrashReporter: fallback to a simple crash report: " + crashFile + " was written");
        }
        LOG.error(message);
    }

    private final boolean doAdvancedReport(ClangDaemonContext context, String message, List<String> fileUrls) {
        AtomicBoolean reported = new AtomicBoolean(false);
        ClangReportUtils.withCrashLanguageService(context, arg_0 -> ClangInternalCrashReporter.doAdvancedReport$lambda$0((Function1)new Function1<ClangLanguageService, Unit>(fileUrls, message, this, reported){
            final /* synthetic */ List<String> $fileUrls;
            final /* synthetic */ String $message;
            final /* synthetic */ ClangInternalCrashReporter this$0;
            final /* synthetic */ AtomicBoolean $reported;
            {
                this.$fileUrls = $fileUrls;
                this.$message = $message;
                this.this$0 = $receiver;
                this.$reported = $reported;
                super(1);
            }

            public final void invoke(ClangLanguageService it) {
                Map<String, String> map = ClangReportUtils.prepareAsIsReport(it, this.$fileUrls);
                Intrinsics.checkNotNullExpressionValue(map, (String)"prepareAsIsReport(...)");
                Map<String, String> file2Content = map;
                if (!file2Content.isEmpty()) {
                    file2Content.put("crash_message.txt", this.$message);
                    byte[] zipReport = ClangReportUtils.makeZipArchive(file2Content);
                    Path crashFile = ClangInternalCrashReporter.access$getMyArtifactsPath$p(this.this$0).resolve("clangd_crash_" + ClangInternalCrashReporter.access$getMyCrashId$p(this.this$0).incrementAndGet() + ".zip");
                    FileUtil.writeToFile((File)crashFile.toFile(), (byte[])zipReport);
                    this.$reported.set(true);
                }
            }
        }, arg_0));
        return reported.get();
    }

    private static final void doAdvancedReport$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Path access$getMyArtifactsPath$p(ClangInternalCrashReporter $this) {
        return $this.myArtifactsPath;
    }

    public static final /* synthetic */ AtomicInteger access$getMyCrashId$p(ClangInternalCrashReporter $this) {
        return $this.myCrashId;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClangInternalCrashReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangInternalCrashReporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.c.clangd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

