/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdDumpIndexerCDBKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdReportIndexerBugActionKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.FailedUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.IndexerCDB;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangTraverseUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\f"}, d2={"collectIndexerFiles", "", "file2Content", "", "", "indexer", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "failedUsageInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/FailedUsageInfo;", "dangerousFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.c.clangd"})
public final class ClangdReportIndexerBugActionKt {
    private static final void collectIndexerFiles(Map<String, String> file2Content, ClangdIndexerService indexer, FailedUsageInfo failedUsageInfo, List<? extends VirtualFile> dangerousFiles) {
        Object indexerCDB;
        if (FileUtil.exists((String)indexer.getClangdModulesPath())) {
            ClangTraverseUtil.visitFilesIgnoringSymlinks(new File(indexer.getClangdModulesPath()), false, (Processor<? super File>)((Processor)arg_0 -> ClangdReportIndexerBugActionKt.collectIndexerFiles$lambda$0((Function1)new Function1<File, Boolean>(file2Content){
                final /* synthetic */ Map<String, String> $file2Content;
                {
                    this.$file2Content = $file2Content;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(File it) {
                    if (it.isFile()) {
                        Object object = new String[]{"macrodeps", "modulemap", "txt"};
                        Set set = SetsKt.setOf((Object[])object);
                        Intrinsics.checkNotNull((Object)it);
                        if (set.contains(FilesKt.getExtension((File)it))) {
                            object = this.$file2Content;
                            String string = "indexer_modules/" + it.getName();
                            String string2 = FileUtilRt.loadFile((File)it);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"loadFile(...)");
                            String string3 = string2;
                            object.put(string, string3);
                        }
                    }
                    return true;
                }
            }, arg_0)));
        }
        StringBuilder reportContent = new StringBuilder();
        if (failedUsageInfo != null) {
            reportContent.append(failedUsageInfo.toStringWithFullPath()).append("\n");
        }
        if (!dangerousFiles.isEmpty()) {
            reportContent.append("Collected files:\n").append(CollectionsKt.joinToString$default((Iterable)dangerousFiles, (CharSequence)"\n", null, null, (int)0, null, (Function1)collectIndexerFiles.2.INSTANCE, (int)30, null));
            indexerCDB = ClangdDumpIndexerCDBKt.prepareIndexerCDB(indexer, (Iterable<? extends VirtualFile>)dangerousFiles);
            file2Content.put("indexer_cdb/compile_commands.json", ((IndexerCDB)indexerCDB).getJsonCDB());
            for (Map.Entry object2 : ((IndexerCDB)indexerCDB).getMacros2File().entrySet()) {
                String content2 = (String)object2.getKey();
                String fileName = (String)object2.getValue();
                file2Content.put("indexer_cdb/" + fileName, content2);
            }
        }
        if (((CharSequence)reportContent).length() == 0) {
            reportContent.append("No failed find usage was found and no dangerous files were found");
        }
        indexerCDB = file2Content;
        String string = "report_content.txt";
        String string2 = reportContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = string2;
        indexerCDB.put((String)string, (String)string3);
        String state = null;
        try {
            CompletableFuture<String> completableFuture = indexer.requestServerState();
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"requestServerState(...)");
            String string4 = (String)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)completableFuture, (long)4000L, (String)"indexer state");
            if (string4 == null) {
                string4 = "no state";
            }
            state = string4;
        }
        catch (Exception ex) {
            String string5 = ex.getMessage();
            if (string5 == null) {
                string5 = "Exception happened";
            }
            state = string5;
        }
        List<String> list = indexer.getCopyOfAppLog();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCopyOfAppLog(...)");
        List<String> appLog = list;
        appLog.add(state);
        file2Content.put("indexer_modules/app_log.txt", CollectionsKt.joinToString$default((Iterable)appLog, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    private static final boolean collectIndexerFiles$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$collectIndexerFiles(Map file2Content, ClangdIndexerService indexer, FailedUsageInfo failedUsageInfo, List dangerousFiles) {
        ClangdReportIndexerBugActionKt.collectIndexerFiles(file2Content, indexer, failedUsageInfo, dangerousFiles);
    }
}

