/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DFARawTuple;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a \u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a \u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a&\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0016\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u00a8\u0006\u000f"}, d2={"getDfaInputFromClangd", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/annotator/DFARawTuple;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDfaInputFromIndexer", "showTuplesInEditor", "", "tuples", "fileName", "", "tuplesToString", "fileTuples", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangdDumpDfaTuples.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdDumpDfaTuples.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdDumpDfaTuplesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,73:1\n1477#2:74\n1502#2,3:75\n1505#2,3:85\n1477#2:88\n1502#2,3:89\n1505#2,3:99\n1549#2:102\n1620#2,3:103\n1855#2,2:106\n372#3,7:78\n372#3,7:92\n*S KotlinDebug\n*F\n+ 1 ClangdDumpDfaTuples.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdDumpDfaTuplesKt\n*L\n43#1:74\n43#1:75,3\n43#1:85,3\n46#1:88\n46#1:89,3\n46#1:99,3\n48#1:102\n48#1:103,3\n48#1:106,2\n43#1:78,7\n46#1:92,7\n*E\n"})
public final class ClangdDumpDfaTuplesKt {
    private static final void showTuplesInEditor(Project project, List<DFARawTuple> tuples, String fileName) {
        String content2 = ClangdDumpDfaTuplesKt.tuplesToString(tuples);
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new LightVirtualFile(fileName, (CharSequence)content2), true);
    }

    /*
     * WARNING - void declaration
     */
    private static final String tuplesToString(List<DFARawTuple> fileTuples) {
        Iterable list$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$tuplesToString_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$tuplesToString_u24lambda_u244.append("Count: " + CollectionsKt.toSet((Iterable)fileTuples).size());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Iterable $this$groupBy$iv = CollectionsKt.toSet((Iterable)fileTuples);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DFARawTuple it = (DFARawTuple)element$iv$iv;
            boolean bl2 = false;
            String key$iv$iv = it.getFunction();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        SortedMap functionToTuples = MapsKt.toSortedMap((Map)destination$iv$iv);
        for (Map.Entry entry : ((Map)functionToTuples).entrySet()) {
            Object $this$getOrPut$iv$iv$iv2;
            void $this$groupByTo$iv$iv2;
            String function = (String)entry.getKey();
            List functionTuples = (List)entry.getValue();
            StringBuilder stringBuilder3 = $this$tuplesToString_u24lambda_u244.append("Function: " + function);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNull((Object)functionTuples);
            Iterable iterable2 = functionTuples;
            boolean $i$f$groupBy2 = false;
            list$iv$iv = iterable2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                DFARawTuple it = (DFARawTuple)element$iv$iv;
                boolean bl4 = false;
                String key$iv$iv = it.getRelation();
                $this$getOrPut$iv$iv$iv2 = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv2 = (List)object;
                list$iv$iv2.add(element$iv$iv);
            }
            for (Map.Entry entry2 : destination$iv$iv2.entrySet()) {
                void $this$mapTo$iv$iv;
                String rel = (String)entry2.getKey();
                List tuples = (List)entry2.getValue();
                StringBuilder stringBuilder4 = $this$tuplesToString_u24lambda_u244.append("\t" + rel + ":");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                Iterable $this$map$iv = tuples;
                boolean $i$f$map = false;
                $this$getOrPut$iv$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    $this$getOrPut$iv$iv$iv2 = (DFARawTuple)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl6 = false;
                    collection.add(it.toString());
                }
                Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv3));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl7 = false;
                    StringBuilder stringBuilder5 = $this$tuplesToString_u24lambda_u244.append("\t\t" + it);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
                }
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final List<DFARawTuple> getDfaInputFromClangd(Project project, VirtualFile file) {
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(project);
        ClangLanguageService clangLanguageService = clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getIfStarted() : null;
        Intrinsics.checkNotNull((Object)clangLanguageService);
        ClangLanguageService service = clangLanguageService;
        List dfaInput = service.computeWithOpenedAndParsed(file, ClangdDumpDfaTuplesKt::getDfaInputFromClangd$lambda$5);
        return dfaInput;
    }

    private static final List<DFARawTuple> getDfaInputFromIndexer(Project project, VirtualFile file) {
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(project);
        ClangdIndexerService clangdIndexerService = clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getOrStartStatelessIndexer() : null;
        Intrinsics.checkNotNull((Object)clangdIndexerService);
        ClangdIndexerService service = clangdIndexerService;
        ClionClangDFAConfigParams config = service.getClangIdeFacade().getDFAOptions(project, file);
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref ref2 = ref;
        service.getDfaInput(file, config, arg_0 -> ClangdDumpDfaTuplesKt.getDfaInputFromIndexer$lambda$6(ref2, arg_0));
        return (List)ref2.get();
    }

    private static final List getDfaInputFromClangd$lambda$5(ClangParseResponse resp) {
        CompletableFuture<Supplier<List<DFARawTuple>>> completableFuture = resp.getDFAInput();
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getDFAInput(...)");
        Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)completableFuture, (long)Long.MAX_VALUE, (String)"dfaInput");
        return supplier != null ? (List)supplier.get() : null;
    }

    private static final void getDfaInputFromIndexer$lambda$6(Ref $ref, ClangResult it) {
        Intrinsics.checkNotNullParameter((Object)$ref, (String)"$ref");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Stream stream = (Stream)it.waitForResult();
        List list = stream != null ? stream.toList() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        $ref.set(list);
    }

    public static final /* synthetic */ List access$getDfaInputFromClangd(Project project, VirtualFile file) {
        return ClangdDumpDfaTuplesKt.getDfaInputFromClangd(project, file);
    }

    public static final /* synthetic */ void access$showTuplesInEditor(Project project, List tuples, String fileName) {
        ClangdDumpDfaTuplesKt.showTuplesInEditor(project, tuples, fileName);
    }

    public static final /* synthetic */ List access$getDfaInputFromIndexer(Project project, VirtualFile file) {
        return ClangdDumpDfaTuplesKt.getDfaInputFromIndexer(project, file);
    }
}

