/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DFARawTuple;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDfaResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDfaResponseHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionBuildDfaInputParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdIndexingTaskId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdIndexerService
extends ClangdLanguageService {
    @NotNull
    private final Set<String> myDangerousFiles;
    @NotNull
    private final List<String> myAppLog;
    @NotNull
    private final BackgroundTaskQueue myQueue;
    @Nullable
    private MyIndexingProgressTask myLastTask;
    private volatile boolean myPaused;
    @NotNull
    private final List<java.util.function.Consumer<Boolean>> myPausedListeners;
    @NotNull
    private final ScheduledFuture<?> myUnsavedWatcherFuture;

    public ClangdIndexerService(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangdIndexerService.$$$reportNull$$$0(0);
        }
        super(context);
        this.myDangerousFiles = new HashSet<String>();
        this.myAppLog = new LinkedList<String>();
        this.myLastTask = null;
        this.myPaused = false;
        this.myPausedListeners = new CopyOnWriteArrayList<java.util.function.Consumer<Boolean>>();
        this.myQueue = new BackgroundTaskQueue(context.getProject(), ClangdBundle.message("clangd.indexing.message", new Object[0]));
        this.myUnsavedWatcherFuture = this.startUnsavedFilesWatcher(context);
        this.installDangerousFilesListener();
        this.installIndexLoggerIfNeeded();
        this.installIndexingProgressIfNeeded(context);
    }

    public boolean isPaused() {
        return this.myPaused;
    }

    public void addPausedListener(@NotNull java.util.function.Consumer<Boolean> listener) {
        if (listener == null) {
            ClangdIndexerService.$$$reportNull$$$0(1);
        }
        this.myPausedListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<String> getCopyOfAppLog() {
        List<String> list = this.myAppLog;
        // MONITORENTER : list
        ArrayList<String> arrayList = new ArrayList<String>(this.myAppLog);
        // MONITOREXIT : list
        if (arrayList != null) return arrayList;
        ClangdIndexerService.$$$reportNull$$$0(2);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<String> getCopyOfDangerousFiles() {
        Set<String> set = this.myDangerousFiles;
        // MONITORENTER : set
        HashSet<String> hashSet = new HashSet<String>(this.myDangerousFiles);
        // MONITOREXIT : set
        if (hashSet != null) return hashSet;
        ClangdIndexerService.$$$reportNull$$$0(3);
        return hashSet;
    }

    @NotNull
    public CompletableFuture<String> requestServerState() {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("requestServerState").action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(server.clionRequestServerState(), result))).onSkipped(() -> result.complete("skipped")).onRejected(() -> result.complete("rejected")).requiresRecover(true).create());
        CompletableFuture<String> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Boolean> executeCommand(@NotNull ClangIndexerCommand command) {
        if (command == null) {
            ClangdIndexerService.$$$reportNull$$$0(5);
        }
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        java.util.function.Consumer<ClangRemoteWorkspace> handlePause = ws -> {
            if (command.isPause()) {
                ws.setPaused(true);
                this.changePaused(true);
            } else if (command.isResume()) {
                ws.setPaused(false);
                this.changePaused(false);
            }
        };
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction(command.getCommand()).action((server, ws) -> {
            ClangUtils.tie(result, server.clionIndexerCommand(new ClionIndexerCommandParams(command.getCommand(), command.getArgument())));
            handlePause.accept((ClangRemoteWorkspace)ws);
        }).onSkipped((Consumer<? super ClangRemoteWorkspace>)((Consumer)ws -> {
            result.complete(false);
            handlePause.accept((ClangRemoteWorkspace)ws);
        })).onRejected(() -> result.complete(false)).requiresRecover().create());
        CompletableFuture<Boolean> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    private void changePaused(boolean newValue) {
        this.myPaused = newValue;
        for (java.util.function.Consumer<Boolean> listener : this.myPausedListeners) {
            listener.accept(newValue);
        }
    }

    @NotNull
    public @NotNull List<@NotNull CompletableFuture<@Nullable Stream<DFARawTuple>>> getDfaInput(@NotNull List<VirtualFile> files, @NotNull ClionClangDFAConfigParams dfaConfigParams) {
        if (files == null) {
            ClangdIndexerService.$$$reportNull$$$0(7);
        }
        if (dfaConfigParams == null) {
            ClangdIndexerService.$$$reportNull$$$0(8);
        }
        ClangDfaResponseHandler dfaResponseHandler = this.getContext().getDfaResponseHandler();
        List responses = ContainerUtil.map(files, f -> dfaResponseHandler.createDfaInputResponse());
        ClionBuildDfaInputParams params = (ClionBuildDfaInputParams)ReadAction.compute(() -> this.createDfaInputParams(files, responses, dfaConfigParams));
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("getDfaInput").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionBuildDfaInput(params))).requiresRecover().onSkipped(() -> responses.forEach(response -> response.getResult().complete(null))).onRejected(() -> responses.forEach(response -> response.getResult().complete(null))).create());
        List list = ContainerUtil.map((Collection)responses, r -> r.getResult());
        if (list == null) {
            ClangdIndexerService.$$$reportNull$$$0(9);
        }
        return list;
    }

    public <E extends Throwable> void getDfaInput(@NotNull VirtualFile file, @NotNull ClionClangDFAConfigParams dfaConfigParams, @NotNull ClangResultConsumer<@Nullable Stream<DFARawTuple>, E> consumer) throws E {
        if (file == null) {
            ClangdIndexerService.$$$reportNull$$$0(10);
        }
        if (dfaConfigParams == null) {
            ClangdIndexerService.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            ClangdIndexerService.$$$reportNull$$$0(12);
        }
        CompletableFuture<Stream<DFARawTuple>> inputFuture = this.getDfaInput(Collections.singletonList(file), dfaConfigParams).get(0);
        ClangResultImpl<@Nullable Stream<DFARawTuple>> result = new ClangResultImpl<Stream<DFARawTuple>>("buildDfaInput", inputFuture, () -> {
            if (!inputFuture.isDone()) {
                this.executeCommand(ClangIndexerCommand.Companion.getCANCEL());
            }
        });
        ClangdIndexerService.applyConsumer(consumer, result);
    }

    @RequiresReadLock
    @NotNull
    private ClionBuildDfaInputParams createDfaInputParams(@NotNull List<VirtualFile> files, @NotNull List<ClangDfaResponse> responses, @NotNull ClionClangDFAConfigParams dfaConfigParams) {
        if (files == null) {
            ClangdIndexerService.$$$reportNull$$$0(13);
        }
        if (responses == null) {
            ClangdIndexerService.$$$reportNull$$$0(14);
        }
        if (dfaConfigParams == null) {
            ClangdIndexerService.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.softAssertReadAccess();
        assert (files.size() == responses.size()) : "Number of responses must be equal to the number of files";
        ClangUrlConverter converter = this.getUrlConverter();
        List targetUris = ContainerUtil.map(files, file -> converter.toUri((VirtualFile)file));
        List entryUris = ContainerUtil.map(files, file -> {
            String targetUri = converter.toUri((VirtualFile)file);
            if (!ClangdBridge.isSourceFile(this.myProject, file)) {
                ClangdCompilationCommand command;
                try {
                    command = (ClangdCompilationCommand)CidrConcurrentUtilsKt.waitCancelAware(this.getClangIdeFacade().getCompilationCommandAsync(converter, this.myProject, (VirtualFile)file, "", Cpp20ModulesContext.DISABLED), (String)"compilation command");
                }
                catch (ExecutionException ex) {
                    ClangUtils.LOG.error((Throwable)ex);
                    command = null;
                }
                if (command != null) {
                    return command.ccParams.getEntryUri();
                }
            }
            return targetUri;
        });
        List ids = ContainerUtil.map(responses, r -> r.getId());
        return new ClionBuildDfaInputParams(targetUris, entryUris, ids, dfaConfigParams);
    }

    @NotNull
    public CompletableFuture<Boolean> notifySettingsChanged(@NotNull ClionIndexerParams newParams) {
        if (newParams == null) {
            ClangdIndexerService.$$$reportNull$$$0(16);
        }
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("setMode").action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionSetIndexerOpts(newParams)))).onRejected(() -> result.complete(false)).onSkipped(() -> result.complete(false)).requiresRecover().create());
        CompletableFuture<Boolean> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(17);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public ClangStopData stop() {
        this.myUnsavedWatcherFuture.cancel(true);
        ClangStopData clangStopData = super.stop();
        if (clangStopData == null) {
            ClangdIndexerService.$$$reportNull$$$0(18);
        }
        return clangStopData;
    }

    private void installDangerousFilesListener() {
        this.getMessageBus().connect(this.getAssociatedDisposable()).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServerFailure() {
                Set<String> set = ClangdIndexerService.this.myDangerousFiles;
                synchronized (set) {
                    ClangdIndexerService.this.getContext().getTelemetry().getGeneralTelemetry().forEachParsedFile((path, stats) -> {
                        if (stats.parseStartedCounter > stats.parseFinishedCounter) {
                            ClangdIndexerService.this.myDangerousFiles.add((String)path);
                        }
                    });
                }
            }
        });
    }

    private void installIndexLoggerIfNeeded() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.getMessageBus().connect(this.getAssociatedDisposable()).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){
            private boolean indexStartedCame = false;
            private int lastReportedPercent = -1;

            @Override
            public void onIndexingStarted(@NotNull ClangdIndexingTaskId taskId) {
                if (taskId == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.indexStartedCame = true;
                this.lastReportedPercent = -1;
            }

            @Override
            public void onIndexingProgress(int percentage, @NlsSafe String message) {
                if (this.indexStartedCame) {
                    ClangdIndexerService.this.addAppLogMessage("Indexing started");
                    this.indexStartedCame = false;
                }
                if (percentage != this.lastReportedPercent) {
                    this.lastReportedPercent = percentage;
                    ClangdIndexerService.this.addAppLogMessage("Progress: " + message + " (" + percentage + "%)");
                }
            }

            @Override
            public void onIndexingFinished(@NotNull List<String> deletedPaths, @NotNull String symbolsDirPath) {
                if (deletedPaths == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (symbolsDirPath == null) {
                    2.$$$reportNull$$$0(2);
                }
                StringBuilder sb = new StringBuilder("Indexing finished! " + deletedPaths.size() + " deleted  (" + symbolsDirPath + ")");
                if (!deletedPaths.isEmpty()) {
                    sb.append("Deleted paths:\n");
                    for (String path : deletedPaths) {
                        sb.append("  ").append(path).append("\n");
                    }
                }
                ClangdIndexerService.this.addAppLogMessage(sb.toString());
            }

            @Override
            public void onIndexingMessage(@NotNull String message) {
                if (message == null) {
                    2.$$$reportNull$$$0(3);
                }
                ClangdIndexerService.this.addAppLogMessage(message);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "taskId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deletedPaths";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbolsDirPath";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onIndexingStarted";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onIndexingFinished";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onIndexingMessage";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAppLogMessage(@NotNull String message) {
        if (message == null) {
            ClangdIndexerService.$$$reportNull$$$0(19);
        }
        List<String> list = this.myAppLog;
        synchronized (list) {
            if (this.myAppLog.size() >= 4096) {
                this.myAppLog.remove(0);
            }
            this.myAppLog.add(message);
        }
    }

    private void installIndexingProgressIfNeeded(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangdIndexerService.$$$reportNull$$$0(20);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!ClangdSettings.getInstance(this.myProject).getIndexerShowProgress()) {
            return;
        }
        context.getMessageBus().connect((Disposable)context).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIndexingStarted(@NotNull ClangdIndexingTaskId taskId) {
                if (taskId == null) {
                    3.$$$reportNull$$$0(0);
                }
                BackgroundTaskQueue backgroundTaskQueue = ClangdIndexerService.this.myQueue;
                synchronized (backgroundTaskQueue) {
                    ClangdIndexerService.this.myQueue.clear();
                    if (ClangdIndexerService.this.myLastTask != null) {
                        ClangdIndexerService.this.myLastTask.myFinished.complete(true);
                        ClangdIndexerService.this.myLastTask = null;
                    }
                    ClangdIndexerService.this.myLastTask = new MyIndexingProgressTask(ClangdIndexerService.this.myProject, ClangdIndexerService.this, taskId);
                    ClangdIndexerService.this.myQueue.run((Task.Backgroundable)ClangdIndexerService.this.myLastTask);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIndexingProgress(int percentage, @NlsSafe String message) {
                BackgroundTaskQueue backgroundTaskQueue = ClangdIndexerService.this.myQueue;
                synchronized (backgroundTaskQueue) {
                    if (ClangdIndexerService.this.myLastTask != null && ClangdIndexerService.this.myLastTask.myAssignedIndicator != null) {
                        Objects.requireNonNull(ClangdIndexerService.this.myLastTask.myAssignedIndicator).setFraction((double)percentage / 100.0);
                        Objects.requireNonNull(ClangdIndexerService.this.myLastTask.myAssignedIndicator).setText2(message);
                    }
                }
            }

            @Override
            public void onIndexingCanceled() {
                this.onIndexingFinishedImpl();
            }

            @Override
            public void onIndexingFinished(@NotNull List<String> deletedSymbolsPaths, @NotNull String symbolsDirPath) {
                if (deletedSymbolsPaths == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (symbolsDirPath == null) {
                    3.$$$reportNull$$$0(2);
                }
                this.onIndexingFinishedImpl();
            }

            @Override
            public void onServerFailure() {
                this.onIndexingFinishedImpl();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void onIndexingFinishedImpl() {
                BackgroundTaskQueue backgroundTaskQueue = ClangdIndexerService.this.myQueue;
                synchronized (backgroundTaskQueue) {
                    if (ClangdIndexerService.this.myLastTask != null) {
                        ClangdIndexerService.this.myLastTask.myFinished.complete(true);
                        ClangdIndexerService.this.myLastTask = null;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "taskId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deletedSymbolsPaths";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbolsDirPath";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onIndexingStarted";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onIndexingFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private ScheduledFuture<?> startUnsavedFilesWatcher(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangdIndexerService.$$$reportNull$$$0(21);
        }
        ScheduledFuture<?> scheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            if (!context.isStopped()) {
                Set<String> unsavedUrlsAtIndexer = context.getRemoteWorkspace().getUnsavedFiles();
                ArrayList<VirtualFile> savedFiles = new ArrayList<VirtualFile>();
                for (String unsavedUrl : unsavedUrlsAtIndexer) {
                    VirtualFile vf = context.getIdeFacade().getVirtualFile(unsavedUrl);
                    if (vf == null || context.getIdeFacade().isModified(vf)) continue;
                    savedFiles.add(vf);
                }
                if (!savedFiles.isEmpty()) {
                    CidrLogService.LOG.warn("clangd-indexer: found " + savedFiles.size() + " unreported saved files");
                    for (VirtualFile savedFile : savedFiles) {
                        this.notifyDocumentSaved(savedFile);
                    }
                }
            }
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
        if (scheduledFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(22);
        }
        return scheduledFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 9, 17, 18, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaConfigParams";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responses";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParams";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyOfAppLog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyOfDangerousFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "requestServerState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCommand";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfaInput";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "notifySettingsChanged";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "startUnsavedFilesWatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addPausedListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDfaInput";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDfaInputParams";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notifySettingsChanged";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addAppLogMessage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "installIndexingProgressIfNeeded";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startUnsavedFilesWatcher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 9, 17, 18, 22 -> new IllegalStateException(string);
        };
    }

    private static class MyIndexingProgressTask
    extends Task.Backgroundable {
        private final ClangdIndexingTaskId myTaskId;
        private final ClangdIndexerService myService;
        private final CompletableFuture<Object> myFinished;
        @Nullable
        private volatile ProgressIndicator myAssignedIndicator;

        private MyIndexingProgressTask(@NotNull Project project, @NotNull ClangdIndexerService service, @NotNull ClangdIndexingTaskId taskId) {
            if (project == null) {
                MyIndexingProgressTask.$$$reportNull$$$0(0);
            }
            if (service == null) {
                MyIndexingProgressTask.$$$reportNull$$$0(1);
            }
            if (taskId == null) {
                MyIndexingProgressTask.$$$reportNull$$$0(2);
            }
            super(project, ClangdBundle.message("clangd.indexing.message", new Object[0]), true);
            this.myFinished = new CompletableFuture();
            this.myAssignedIndicator = null;
            this.myService = service;
            this.myTaskId = taskId;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyIndexingProgressTask.$$$reportNull$$$0(3);
            }
            try {
                this.myAssignedIndicator = indicator;
                switch (this.myTaskId) {
                    case preprocessing: {
                        Objects.requireNonNull(this.myAssignedIndicator).setText(ClangdBundle.message("clangd.preprocessing.message", new Object[0]));
                        break;
                    }
                    case indexing: {
                        Objects.requireNonNull(this.myAssignedIndicator).setText(ClangdBundle.message("clangd.indexing.message", new Object[0]));
                    }
                }
                indicator.setIndeterminate(false);
                indicator.setFraction(0.0);
                try {
                    CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(this.myFinished, (String)"indexing future");
                }
                catch (ProcessCanceledException ex) {
                    this.myService.executeCommand(ClangIndexerCommand.Companion.getCANCEL());
                }
                indicator.setFraction(1.0);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService$MyIndexingProgressTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

