/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdQuickFix
implements IntentionAction,
LocalQuickFix {
    @NotNull
    private final CodeAction myFixit;
    private final boolean myIsPreview;

    public ClangdQuickFix(@NotNull CodeAction fixit) {
        if (fixit == null) {
            ClangdQuickFix.$$$reportNull$$$0(0);
        }
        this(fixit, false);
    }

    public ClangdQuickFix(@NotNull CodeAction fixit, boolean isPreview) {
        if (fixit == null) {
            ClangdQuickFix.$$$reportNull$$$0(1);
        }
        this.myFixit = fixit;
        this.myIsPreview = isPreview;
    }

    private void invoke(PsiFile file, @NotNull Project project) {
        if (project == null) {
            ClangdQuickFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        HashMap<Document, List> editsByDocument = new HashMap<Document, List>();
        for (Map.Entry change : this.myFixit.getEdit().getChanges().entrySet()) {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl((String)change.getKey());
            if (virtualFile == null) continue;
            Document document2 = null;
            if (this.myIsPreview) {
                if (file.getOriginalFile().getVirtualFile().equals(virtualFile)) {
                    document2 = file.getViewProvider().getDocument();
                }
            } else {
                document2 = documentManager.getDocument(virtualFile);
            }
            if (document2 == null) continue;
            List edits = editsByDocument.computeIfAbsent(document2, d -> new ArrayList());
            edits.addAll((Collection)change.getValue());
        }
        if (editsByDocument.isEmpty()) {
            return;
        }
        for (Map.Entry documentEdits : editsByDocument.entrySet()) {
            Document document3 = (Document)documentEdits.getKey();
            List edits = (List)documentEdits.getValue();
            edits.stream().sorted(ClangdQuickFix.getEditsComparator()).forEach(edit -> document3.replaceString(ClangdQuickFix.getDocOffset(document3, edit.getRange().getStart()), ClangdQuickFix.getDocOffset(document3, edit.getRange().getEnd()), (CharSequence)edit.getNewText()));
            PsiDocumentManager.getInstance((Project)project).commitDocument(document3);
        }
    }

    @NotNull
    public String getText() {
        String string = this.getTextInternal();
        if (string == null) {
            ClangdQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            ClangdQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ClangdQuickFix.$$$reportNull$$$0(5);
        }
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ClangdQuickFix.$$$reportNull$$$0(6);
        }
        if (IntentionPreviewUtils.prepareElementForWrite((PsiElement)file)) {
            this.commitDocuments(file, project);
            this.invoke(file, project);
        }
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            ClangdQuickFix.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            ClangdQuickFix.$$$reportNull$$$0(8);
        }
        PsiFile file = descriptor.getPsiElement().getContainingFile();
        this.invoke(file.getProject(), null, file);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            ClangdQuickFix.$$$reportNull$$$0(9);
        }
        return new ClangdQuickFix(this.myFixit, true);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = ClangdBundle.message("language.cpp.clangd.quick.fix", new Object[0]);
        if (string == null) {
            ClangdQuickFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    @IntentionName
    private String getTextInternal() {
        return StringUtil.capitalize((String)this.myFixit.getTitle());
    }

    private void commitDocuments(@NotNull PsiFile file, @NotNull Project project) {
        List filesToChange;
        if (file == null) {
            ClangdQuickFix.$$$reportNull$$$0(11);
        }
        if (project == null) {
            ClangdQuickFix.$$$reportNull$$$0(12);
        }
        if ((filesToChange = this.myFixit.getEdit().getChanges().keySet().stream().distinct().toList()).size() > 1) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        } else {
            PsiDocumentManager.getInstance((Project)project).commitDocument(file.getViewProvider().getDocument());
        }
    }

    @NotNull
    private static Comparator<? super TextEdit> getEditsComparator() {
        Comparator comparator = (o1, o2) -> {
            Position lhsStart = o1.getRange().getStart();
            Position rhsStart = o2.getRange().getStart();
            if (lhsStart.getLine() != rhsStart.getLine()) {
                return rhsStart.getLine() - lhsStart.getLine();
            }
            return rhsStart.getCharacter() - lhsStart.getCharacter();
        };
        if (comparator == null) {
            ClangdQuickFix.$$$reportNull$$$0(13);
        }
        return comparator;
    }

    private static int getDocOffset(@NotNull Document doc, @NotNull Position pos) {
        if (doc == null) {
            ClangdQuickFix.$$$reportNull$$$0(14);
        }
        if (pos == null) {
            ClangdQuickFix.$$$reportNull$$$0(15);
        }
        return doc.getLineStartOffset(pos.getLine()) + pos.getCharacter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixit";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangdQuickFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangdQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditsComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "commitDocuments";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDocOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 13 -> new IllegalStateException(string);
        };
    }
}

