/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.registry;

import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.docker.view.registry.DockerRegistryProvider;
import com.intellij.docker.view.registry.DockerRegistryServiceViewContributor;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/view/registry/DockerRegistryManagerListener;", "Lcom/intellij/docker/registry/DockerRegistryManager$Listener;", "()V", "registryAdded", "", "registry", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "registryRemoved", "intellij.clouds.docker"})
final class DockerRegistryManagerListener
implements DockerRegistryManager.Listener {
    @Override
    public void registryAdded(@NotNull DockerRegistryConfiguration registry) {
        Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerRegistryServiceViewContributor.class));
    }

    @Override
    public void registryRemoved(@NotNull DockerRegistryConfiguration registry) {
        Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
        DockerRegistryProvider.Companion.removeRegistryRoot(registry);
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerRegistryServiceViewContributor.class));
    }
}

