/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.validation;

import com.google.common.net.InetAddresses;
import com.intellij.openapi.util.text.StringUtilRt;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0005*\u00020\u0002H\u0002\u00a8\u0006\b"}, d2={"isCidrFormat", "", "", "isIP", "isIPv4", "Ljava/net/InetAddress;", "isIPv6", "toIP", "intellij.clouds.docker.compose"})
public final class UiValidationUtilsKt {
    private static final InetAddress toIP(String $this$toIP) {
        Object object;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)InetAddresses.forString((String)$this$toIP));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (InetAddress)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static final boolean isIPv4(InetAddress $this$isIPv4) {
        return $this$isIPv4.getAddress().length == 4;
    }

    private static final boolean isIPv6(InetAddress $this$isIPv6) {
        return $this$isIPv6.getAddress().length == 16;
    }

    public static final boolean isIP(@NotNull String $this$isIP) {
        Intrinsics.checkNotNullParameter((Object)$this$isIP, (String)"<this>");
        return UiValidationUtilsKt.toIP($this$isIP) != null;
    }

    public static final boolean isIPv4(@NotNull String $this$isIPv4) {
        Intrinsics.checkNotNullParameter((Object)$this$isIPv4, (String)"<this>");
        InetAddress inetAddress = UiValidationUtilsKt.toIP($this$isIPv4);
        return inetAddress != null ? UiValidationUtilsKt.isIPv4(inetAddress) : false;
    }

    public static final boolean isIPv6(@NotNull String $this$isIPv6) {
        Intrinsics.checkNotNullParameter((Object)$this$isIPv6, (String)"<this>");
        InetAddress inetAddress = UiValidationUtilsKt.toIP($this$isIPv6);
        return inetAddress != null ? UiValidationUtilsKt.isIPv6(inetAddress) : false;
    }

    public static final boolean isCidrFormat(@NotNull String $this$isCidrFormat) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isCidrFormat, (String)"<this>");
        String string = StringUtilRt.unquoteString((String)$this$isCidrFormat);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
        String text2 = string;
        int slashIndex = StringsKt.indexOf$default((CharSequence)text2, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (slashIndex == -1) {
            return false;
        }
        String string2 = text2.substring(0, slashIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String address = string2;
        String string3 = text2.substring(slashIndex + 1, text2.length());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        Integer n = StringsKt.toIntOrNull((String)string3);
        if (n == null) {
            return false;
        }
        int suffix = n;
        InetAddress inetAddress = UiValidationUtilsKt.toIP(address);
        if (inetAddress != null) {
            InetAddress it = inetAddress;
            boolean bl2 = false;
            bl = UiValidationUtilsKt.isIPv4(it) ? (0 <= suffix ? suffix < 33 : false) : (UiValidationUtilsKt.isIPv6(it) ? (0 <= suffix ? suffix < 129 : false) : false);
        } else {
            bl = false;
        }
        return bl;
    }
}

