/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerTransitionStatus;
import com.intellij.docker.agent.DockerAgentVolume;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerVolumeRuntime;
import com.intellij.docker.ui.scaffold.Scaffold;
import com.intellij.docker.ui.scaffold.ScaffoldKt;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.docker.view.details.DockerAbstractDashboardTabKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/runtimes/DockerVolumeRuntimeImpl;", "Lcom/intellij/docker/runtimes/DockerVolumeRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "agentApplication", "Lcom/intellij/docker/agent/DockerAgentVolume;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/docker/agent/DockerAgentVolume;Lcom/intellij/openapi/project/Project;)V", "deleteVolume", "Ljava/util/concurrent/CompletableFuture;", "", "getHeaderComponent", "Lcom/intellij/docker/ui/scaffold/Scaffold$SimpleSegment;", "scaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "getHeaderComponent$intellij_clouds_docker", "Companion", "intellij.clouds.docker"})
public final class DockerVolumeRuntimeImpl
extends DockerVolumeRuntime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex SHA256 = new Regex("[0-9a-f]{64}");

    public DockerVolumeRuntimeImpl(@NotNull DockerRuntimeContext context, @NotNull DockerAgentVolume agentApplication, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)agentApplication, (String)"agentApplication");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(context, agentApplication, project);
    }

    @Override
    @NotNull
    public Scaffold.SimpleSegment getHeaderComponent$intellij_clouds_docker(@NotNull Scaffold scaffold) {
        Intrinsics.checkNotNullParameter((Object)scaffold, (String)"scaffold");
        DockerVolumeRuntimeImpl runtime2 = this;
        Scaffold $this$getHeaderComponent_u24lambda_u240 = scaffold;
        boolean bl = false;
        return $this$getHeaderComponent_u24lambda_u240.segment((Function1<? super Scaffold.SimpleSegment, Unit>)((Function1)new Function1<Scaffold.SimpleSegment, Unit>(runtime2){
            final /* synthetic */ DockerVolumeRuntimeImpl $runtime;
            {
                this.$runtime = $runtime;
                super(1);
            }

            public final void invoke(@NotNull Scaffold.SimpleSegment $this$segment) {
                Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
                $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)new Function1<Scaffold.SimpleSegment.TextFragment, Unit>(this.$runtime){
                    final /* synthetic */ DockerVolumeRuntimeImpl $runtime;
                    {
                        this.$runtime = $runtime;
                        super(1);
                    }

                    public final void invoke(@NotNull Scaffold.SimpleSegment.TextFragment $this$textFragment) {
                        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
                        boolean isInUse = DockerUtils.isInUse(this.$runtime);
                        $this$textFragment.setIcon(this.$runtime.getStatus().getIcon());
                        String string = this.$runtime.getVolume().getName();
                        if (string != null) {
                            String name2 = string;
                            boolean bl = false;
                            if (com.intellij.docker.runtimes.DockerVolumeRuntimeImpl$Companion.access$isSha256(DockerVolumeRuntimeImpl.Companion, name2)) {
                                $this$textFragment.append(DockerAbstractDashboardTabKt.shortenDockerId(name2), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                                $this$textFragment.setToolTipText(name2);
                            } else {
                                $this$textFragment.append(name2, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                            }
                        }
                        if (isInUse) {
                            $this$textFragment.append("  " + DockerBundle.message("DockerVolumeDashboardTab.in.use", new Object[0]), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        }
                    }
                }));
                $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)new Function1<Scaffold.SimpleSegment.TextFragment, Unit>(this.$runtime){
                    final /* synthetic */ DockerVolumeRuntimeImpl $runtime;
                    {
                        this.$runtime = $runtime;
                        super(1);
                    }

                    public final void invoke(@NotNull Scaffold.SimpleSegment.TextFragment $this$textFragment) {
                        String driver;
                        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
                        String string = this.$runtime.getVolume().getDriver();
                        if (string == null) {
                            string = "";
                        }
                        if (((CharSequence)(driver = string)).length() > 0) {
                            $this$textFragment.append(DockerBundle.message("DockerVolumeDetails.VolumePropertiesEditor.property.driver", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                            $this$textFragment.append("   " + driver, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                    }
                }));
                ScaffoldKt.button$default($this$segment, null, null, "Docker.RemoteServers.InspectContainerOrImage", null, 11, null);
                ScaffoldKt.button$default($this$segment, AllIcons.Actions.GC, DockerBundle.message("DockerAbstractDashboardTab.action.remove.hint", new Object[0]), "Docker.RemoteServers.DeleteVolume", null, 8, null);
            }
        }));
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> deleteVolume() {
        return this.runStatusTransition(DockerTransitionStatus.DELETING, this.getAgentApplication().deleteVolume());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/runtimes/DockerVolumeRuntimeImpl$Companion;", "", "()V", "SHA256", "Lkotlin/text/Regex;", "isSha256", "", "", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSha256(String $this$isSha256) {
            CharSequence charSequence = $this$isSha256;
            return !(charSequence == null || charSequence.length() == 0) && SHA256.matches((CharSequence)$this$isSha256);
        }

        public static final /* synthetic */ boolean access$isSha256(Companion $this, String $receiver) {
            return $this.isSha256($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

