/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run;

import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.run.runtime.DockerAgentBuildImageConfig;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class DockerHelpersImageCreator {
    private static final Logger LOG = Logger.getInstance(DockerHelpersImageCreator.class);
    private final String myImageName;
    private final String myLabel;
    private final String myWorkingDirectory;
    private final String myWorkingDirectoryEnv;
    private final String myServiceName;
    private boolean shouldInvalidateHelpersContainerAndImage;

    public DockerHelpersImageCreator(@NotNull String imageName2, @NotNull String label2, @NotNull String workingDirectory, @NotNull String workingDirectoryEnv, @NotNull String serviceName) {
        if (imageName2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(0);
        }
        if (label2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(2);
        }
        if (workingDirectoryEnv == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(3);
        }
        if (serviceName == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(4);
        }
        this.shouldInvalidateHelpersContainerAndImage = ApplicationManager.getApplication().isUnitTestMode() || ApplicationInfo.getInstance().getBuild().isSnapshot();
        this.myImageName = imageName2;
        this.myLabel = label2;
        this.myWorkingDirectory = workingDirectory;
        this.myWorkingDirectoryEnv = workingDirectoryEnv;
        this.myServiceName = serviceName;
    }

    protected void fillEnv(@NotNull Map<String, String> env2) {
        if (env2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(5);
        }
    }

    public DockerVolumesFrom @NotNull [] getHelpersContainerVolumesFrom(@NotNull RemoteDockerRuntime dockerRuntime2) throws IOException, ServerRuntimeException {
        if (dockerRuntime2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(6);
        }
        String containerId = this.getHelpersContainer(dockerRuntime2).getContainerId();
        DockerVolumesFrom[] dockerVolumesFromArray = new DockerVolumesFrom[]{new DockerVolumesFromContainerId(containerId)};
        if (dockerVolumesFromArray == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(7);
        }
        return dockerVolumesFromArray;
    }

    @NotNull
    public SharedVolume getHelpersContainerSharedVolume(@NotNull RemoteDockerRuntime dockerRuntime2) throws IOException, ServerRuntimeException {
        if (dockerRuntime2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(8);
        }
        String imageName2 = this.getImageName();
        String containerId = this.getHelpersContainer(dockerRuntime2).getContainerId();
        String volumeName = this.myServiceName + "_" + DockerHelpersImageCreator.getBuildVersion();
        return new SharedVolume(imageName2, containerId, this.myWorkingDirectory, this.myServiceName, volumeName);
    }

    @NotNull
    public synchronized RemoteDockerApplicationRuntime getHelpersContainer(@NotNull RemoteDockerRuntime dockerRuntime2) throws IOException, ServerRuntimeException {
        if (dockerRuntime2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(9);
        }
        String helpersTag = DockerHelpersImageCreator.getBuildVersion();
        String imageName2 = this.myImageName + ":" + helpersTag;
        String containerName2 = this.myImageName + "_" + helpersTag;
        this.ensureHelpersImagePresent(dockerRuntime2, imageName2, helpersTag);
        RemoteDockerApplicationRuntime applicationRuntime = dockerRuntime2.findContainerByNameOrId(containerName2);
        if (applicationRuntime != null) {
            if (this.shouldInvalidateHelpersContainerAndImage) {
                DockerHelpersImageCreator.deleteHelpersContainerAndImage(dockerRuntime2, applicationRuntime, imageName2);
                this.shouldInvalidateHelpersContainerAndImage = false;
            } else {
                RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = applicationRuntime;
                if (remoteDockerApplicationRuntime == null) {
                    DockerHelpersImageCreator.$$$reportNull$$$0(10);
                }
                return remoteDockerApplicationRuntime;
            }
        }
        String[] command = DockerHelpersImageCreator.getShContainerCommand();
        HashMap<String, String> env2 = new HashMap<String, String>();
        this.fillEnv(env2);
        DockerAgentDeploymentConfigImpl config2 = new DockerAgentDeploymentConfigImpl(imageName2, null).withEnvs(env2);
        config2.withContainerName(containerName2).withCommand(command);
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = RemoteDockerApplicationRuntime.createWithImageInitialization(dockerRuntime2, config2, () -> this.buildHelpersImage(dockerRuntime2, imageName2, helpersTag));
        if (remoteDockerApplicationRuntime == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(11);
        }
        return remoteDockerApplicationRuntime;
    }

    private static void deleteHelpersContainerAndImage(@NotNull RemoteDockerRuntime dockerRuntime2, @NotNull RemoteDockerApplicationRuntime helpersContainer, @NotNull String helpersImageName) {
        if (dockerRuntime2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(12);
        }
        if (helpersContainer == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(13);
        }
        if (helpersImageName == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(14);
        }
        helpersContainer.removeContainerWithVolumes();
        DockerAgentImage helpersImage = dockerRuntime2.findImageByName(helpersImageName);
        if (helpersImage != null) {
            try {
                helpersImage.deleteImage().join();
            }
            catch (RuntimeException e) {
                LOG.debug("Failed to delete helpers image " + helpersImageName + " for its invalidation", (Throwable)e);
            }
        }
    }

    private void ensureHelpersImagePresent(@NotNull RemoteDockerRuntime runtime2, @NotNull String imageName2, @NotNull String tag2) throws ServerRuntimeException, IOException {
        DockerAgentImage image;
        if (runtime2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(15);
        }
        if (imageName2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(16);
        }
        if (tag2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(17);
        }
        if ((image = runtime2.findImageByName(imageName2)) == null) {
            this.buildHelpersImage(runtime2, imageName2, tag2);
        }
    }

    @NotNull
    protected abstract List<File> getHelpersRoots() throws IOException;

    private void buildHelpersImage(@NotNull RemoteDockerRuntime dockerRuntime2, @NotNull String imageName2, @NotNull String helpersVersion) throws IOException, ServerRuntimeException {
        if (dockerRuntime2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(18);
        }
        if (imageName2 == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(19);
        }
        if (helpersVersion == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(20);
        }
        File dockerfile = FileUtil.createTempFile((String)(this.myImageName + "_"), (String)".dockerfile", (boolean)true);
        List<File> helpersDirs = this.getHelpersRoots();
        try (PrintWriter printWriter = new PrintWriter(dockerfile, StandardCharsets.UTF_8);){
            printWriter.println("FROM busybox");
            printWriter.println("LABEL " + this.myLabel + "=" + helpersVersion);
            printWriter.println("LABEL com.jetbrains.docker.helper.image=");
            printWriter.println("ENV " + this.myWorkingDirectoryEnv + " " + this.myWorkingDirectory);
            printWriter.println("WORKDIR ${" + this.myWorkingDirectoryEnv + "}");
            printWriter.println("COPY . ${" + this.myWorkingDirectoryEnv + "}");
            printWriter.println("VOLUME ${" + this.myWorkingDirectoryEnv + "}");
        }
        File dockerImageArchive = DockerProcessUtil.buildDockerImageArchive(dockerfile, helpersDirs.toArray(new File[0]));
        DockerAgentBuildImageConfig config2 = new DockerAgentBuildImageConfig(imageName2, dockerImageArchive, true);
        RemoteDockerApplicationRuntime.create(dockerRuntime2, config2);
    }

    public static String @NotNull [] getShContainerCommand() {
        String[] stringArray = new String[]{"/bin/sh"};
        if (stringArray == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    @NotNull
    private static String getBuildVersion() {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        if (string == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private String getImageName() {
        String string = this.myImageName + ":" + DockerHelpersImageCreator.getBuildVersion();
        if (string == null) {
            DockerHelpersImageCreator.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 11, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectoryEnv";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/DockerHelpersImageCreator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersContainer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersImageName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/DockerHelpersImageCreator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersContainerVolumesFrom";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersContainer";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getShContainerCommand";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildVersion";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillEnv";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersContainerVolumesFrom";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersContainerSharedVolume";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersContainer";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteHelpersContainerAndImage";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "ensureHelpersImagePresent";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildHelpersImage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 11, 21, 22, 23 -> new IllegalStateException(string);
        };
    }

    private static class DockerVolumesFromContainerId
    implements DockerVolumesFrom {
        private final String myContainerId;

        DockerVolumesFromContainerId(String containerId) {
            this.myContainerId = containerId;
        }

        @Override
        public String getContainerId() {
            return this.myContainerId;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }
}

