/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistryConfigurable;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.docker.registry.RegistrySelectionEditor;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u0012\u0010\u0014\u001a\u00020\u0012*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/docker/registry/RegistrySelectionEditor;", "", "registries", "", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "defaultRegistry", "(Ljava/util/List;Lcom/intellij/docker/registry/DockerRegistryConfiguration;)V", "myComboBoxModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "Lcom/intellij/docker/registry/RegistrySelectionEditor$AccountItem;", "myIsAccountEditable", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "myServerSelectionListener", "Ljava/lang/Runnable;", "selectedAccount", "getSelectedAccount", "()Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "setAccountSelectionListener", "", "listener", "addRegistrySelectionEditor", "Lcom/intellij/ui/dsl/builder/Panel;", "project", "Lcom/intellij/openapi/project/Project;", "AccountItem", "intellij.clouds.docker"})
final class RegistrySelectionEditor {
    @Nullable
    private Runnable myServerSelectionListener;
    @NotNull
    private final CollectionComboBoxModel<AccountItem> myComboBoxModel;
    @NotNull
    private final AtomicBooleanProperty myIsAccountEditable;

    public RegistrySelectionEditor(@NotNull List<? extends DockerRegistryConfiguration> registries, @Nullable DockerRegistryConfiguration defaultRegistry) {
        Intrinsics.checkNotNullParameter(registries, (String)"registries");
        this.myComboBoxModel = new CollectionComboBoxModel();
        this.myIsAccountEditable = new AtomicBooleanProperty(false);
        AccountItem defaultItem = null;
        for (DockerRegistryConfiguration dockerRegistryConfiguration : registries) {
            AccountItem item = new AccountItem(dockerRegistryConfiguration);
            this.myComboBoxModel.add((Object)item);
            if (dockerRegistryConfiguration != defaultRegistry) continue;
            defaultItem = item;
        }
        if (defaultItem == null) {
            defaultItem = new AccountItem(null);
            this.myComboBoxModel.add((Object)defaultItem);
            this.myIsAccountEditable.set(false);
        } else {
            this.myIsAccountEditable.set(true);
        }
        ListenerUiUtil.whenListChanged$default((ListModel)((ListModel)this.myComboBoxModel), null, (Function1)((Function1)new Function1<ListDataEvent, Unit>(){

            public final void invoke(@NotNull ListDataEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                myIsAccountEditable.set(this.getSelectedAccount() != null);
            }
        }), (int)1, null);
        this.myComboBoxModel.setSelectedItem((Object)defaultItem);
    }

    @Nullable
    public final DockerRegistryConfiguration getSelectedAccount() {
        AccountItem accountItem = (AccountItem)this.myComboBoxModel.getSelected();
        return accountItem != null ? accountItem.getAccount() : null;
    }

    public final void addRegistrySelectionEditor(@NotNull Panel $this$addRegistrySelectionEditor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$addRegistrySelectionEditor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = DockerBundle.message("configurable.PushImageConfigurable.registry.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$addRegistrySelectionEditor.row(string, (Function1)new Function1<Row, Unit>(this, project){
            final /* synthetic */ RegistrySelectionEditor this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)RegistrySelectionEditor.access$getMyComboBoxModel$p(this.this$0)), null, (int)2, null).resizableColumn().align(Align.FILL).applyToComponent((Function1)new Function1<ComboBox<AccountItem>, Unit>(this.this$0){
                    final /* synthetic */ RegistrySelectionEditor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ComboBox<AccountItem> $this$applyToComponent) {
                        Intrinsics.checkNotNullParameter($this$applyToComponent, (String)"$this$applyToComponent");
                        $this$applyToComponent.addActionListener(arg_0 -> addRegistrySelectionEditor.1.invoke$lambda$0(this.this$0, arg_0));
                    }

                    private static final void invoke$lambda$0(RegistrySelectionEditor this$0, ActionEvent it) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Runnable runnable = RegistrySelectionEditor.access$getMyServerSelectionListener$p(this$0);
                            if (runnable == null) break block0;
                            runnable.run();
                        }
                    }
                }).gap(RightGap.SMALL);
                String string = DockerBundle.message("DockerAbstractDashboardTab.action.edit.hint", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$row.button(string, (Function1)new Function1<ActionEvent, Unit>(this.$project, this.this$0){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ RegistrySelectionEditor this$0;
                    {
                        this.$project = $project;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            ShowSettingsUtil showSettingsUtil = ShowSettingsUtil.getInstance();
                            DockerRegistryConfiguration dockerRegistryConfiguration = this.this$0.getSelectedAccount();
                            Intrinsics.checkNotNull((Object)((Object)dockerRegistryConfiguration));
                            showSettingsUtil.editConfigurable(this.$project, (Configurable)new DockerRegistryConfigurable(dockerRegistryConfiguration, null, false));
                            RegistrySelectionEditor.access$getMyComboBoxModel$p(this.this$0).update();
                            Runnable runnable = RegistrySelectionEditor.access$getMyServerSelectionListener$p(this.this$0);
                            if (runnable == null) break block0;
                            runnable.run();
                        }
                    }
                }).gap(RightGap.SMALL).visibleIf((ObservableProperty)RegistrySelectionEditor.access$getMyIsAccountEditable$p(this.this$0));
                String string2 = DockerBundle.message("DockerAbstractDashboardTab.action.add", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$row.button(string2, (Function1)new Function1<ActionEvent, Unit>(this.$project, this.this$0){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ RegistrySelectionEditor this$0;
                    {
                        this.$project = $project;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        DockerRegistryConfiguration newAccount = new DockerRegistryConfiguration().withName(DockerRegistryManager.generateUniqueRegistryName());
                        Intrinsics.checkNotNull((Object)((Object)newAccount));
                        DockerRegistryConfigurable configurable = new DockerRegistryConfigurable(newAccount, null, true);
                        if (new SingleConfigurableEditor(this.$project, (Configurable)configurable, ShowSettingsUtilImpl.Companion.createDimensionKey((Configurable)configurable), false).showAndGet()) {
                            newAccount.setName(configurable.getDisplayName());
                            DockerRegistryManager.getInstance().addRegistry(newAccount);
                            AccountItem newAccountItem = new AccountItem(newAccount);
                            RegistrySelectionEditor.access$getMyComboBoxModel$p(this.this$0).add((Object)newAccountItem);
                            RegistrySelectionEditor.access$getMyComboBoxModel$p(this.this$0).setSelectedItem((Object)newAccountItem);
                        }
                    }
                }).gap(RightGap.SMALL);
            }
        });
    }

    public final void setAccountSelectionListener(@NotNull Runnable listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myServerSelectionListener = listener2;
    }

    public static final /* synthetic */ CollectionComboBoxModel access$getMyComboBoxModel$p(RegistrySelectionEditor $this) {
        return $this.myComboBoxModel;
    }

    public static final /* synthetic */ Runnable access$getMyServerSelectionListener$p(RegistrySelectionEditor $this) {
        return $this.myServerSelectionListener;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/registry/RegistrySelectionEditor$AccountItem;", "", "account", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "(Lcom/intellij/docker/registry/DockerRegistryConfiguration;)V", "getAccount", "()Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "toString", "", "intellij.clouds.docker"})
    private static final class AccountItem {
        @Nullable
        private final DockerRegistryConfiguration account;

        public AccountItem(@Nullable DockerRegistryConfiguration account) {
            this.account = account;
        }

        @Nullable
        public final DockerRegistryConfiguration getAccount() {
            return this.account;
        }

        @NotNull
        public String toString() {
            DockerRegistryConfiguration dockerRegistryConfiguration = this.account;
            String string = dockerRegistryConfiguration != null ? dockerRegistryConfiguration.getName() : null;
            if (string == null) {
                String string2 = DockerBundle.message("RegistrySelectionEditor.default.registry", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            return string;
        }
    }
}

