/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.deployment.ui.DockerBindingsFieldBase;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;

class DockerPortBindingsField
extends DockerBindingsFieldBase<DockerPortBindingImpl> {
    private static final DockerPortBindingImpl EMPTY = new DockerPortBindingImpl();

    DockerPortBindingsField() {
        this.addActionListener(e -> this.showDialog());
        this.setEditable(false);
    }

    private void showDialog() {
        DockerBindingsFieldBase.BindingsDialogBase<DockerPortBindingImpl> dialog2 = new DockerBindingsFieldBase.BindingsDialogBase<DockerPortBindingImpl>(this, new PortBindingsTable());
        dialog2.setTitle(DockerBundle.message("DockerPortBindingsField.dialogTitle", new Object[0]));
        dialog2.setEmptyText(DockerBundle.message("DockerPortBindingsField.dialogEmptyText", new Object[0]));
        dialog2.show();
    }

    @Override
    protected String stringify(@NotNull DockerPortBindingImpl binding) {
        if (binding == null) {
            DockerPortBindingsField.$$$reportNull$$$0(0);
        }
        return binding.toCommandLineString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "com/intellij/docker/deployment/ui/DockerPortBindingsField", "stringify"));
    }

    private static class PortBindingsTable
    extends DockerBindingsFieldBase.BindingsTableBase<DockerPortBindingImpl> {
        private static final AbstractTableCellEditor PROTOCOL_EDITOR = DockerBindingsFieldBase.newComboEditor("tcp", "udp");

        private PortBindingsTable() {
        }

        protected ListTableModel createListModel() {
            DockerBindingsFieldBase.BindingsTableBase.IntegerColumnBase<DockerPortBindingImpl> hostPort = new DockerBindingsFieldBase.BindingsTableBase.IntegerColumnBase<DockerPortBindingImpl>(DockerBundle.message("DockerPortBindingsField.PortBindingsTable.hostPort", new Object[0]), DockerPortBindingImpl::getHostPort, DockerPortBindingImpl::setHostPort){

                public String getPreferredStringValue() {
                    return "65534-65535";
                }
            };
            DockerBindingsFieldBase.BindingsTableBase.IntegerColumnBase<DockerPortBindingImpl> containerPort = new DockerBindingsFieldBase.BindingsTableBase.IntegerColumnBase<DockerPortBindingImpl>(DockerBundle.message("DockerPortBindingsField.PortBindingsTable.containerPort", new Object[0]), DockerPortBindingImpl::getContainerPort, DockerPortBindingImpl::setContainerPort, false){

                public String getPreferredStringValue() {
                    return "65534-65535";
                }
            };
            DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerPortBindingImpl> protocol = new DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerPortBindingImpl>(DockerBundle.message("DockerPortBindingsField.PortBindingsTable.protocol", new Object[0]), DockerPortBindingImpl::getProtocol, DockerPortBindingImpl::setProtocol){

                @NotNull
                public TableCellEditor getEditor(DockerPortBindingImpl binding) {
                    AbstractTableCellEditor abstractTableCellEditor = PROTOCOL_EDITOR;
                    if (abstractTableCellEditor == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return abstractTableCellEditor;
                }

                public String getPreferredStringValue() {
                    return "tcp";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deployment/ui/DockerPortBindingsField$PortBindingsTable$3", "getEditor"));
                }
            };
            DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerPortBindingImpl> hostIp = new DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerPortBindingImpl>(DockerBundle.message("DockerPortBindingsField.PortBindingsTable.hostIP", new Object[0]), DockerPortBindingImpl::getHostIp, DockerPortBindingImpl::setHostIp){

                public String getPreferredStringValue() {
                    return "255.255.255.255";
                }
            };
            return new ListTableModel(new ColumnInfo[]{hostPort, containerPort, protocol, hostIp});
        }

        protected DockerPortBindingImpl createElement() {
            return new DockerPortBindingImpl();
        }

        protected boolean isEmpty(DockerPortBindingImpl element) {
            return EMPTY.equals(element);
        }

        protected DockerPortBindingImpl cloneElement(DockerPortBindingImpl variable) {
            return new DockerPortBindingImpl(variable);
        }

        protected boolean canDeleteElement(DockerPortBindingImpl selection) {
            return true;
        }
    }
}

