/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.impl.DockerRepoTagsKt;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.docker.image.DockerImagePsiReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlReferenceType;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/composeFile/DockerImageReferenceType;", "Lorg/jetbrains/yaml/meta/model/YamlReferenceType;", "typeName", "", "displayName", "(Ljava/lang/String;Ljava/lang/String;)V", "getReferencesFromValue", "", "Lcom/intellij/psi/PsiReference;", "valueScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "(Lorg/jetbrains/yaml/psi/YAMLScalar;)[Lcom/intellij/psi/PsiReference;", "validateScalarValue", "", "scalarValue", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "Companion", "intellij.clouds.docker.compose"})
public class DockerImageReferenceType
extends YamlReferenceType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex EMBEDDED_VARIABLE_REF = new Regex("\\$\\{[^}]+}");

    public DockerImageReferenceType(@NotNull String typeName, @NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        super(typeName, displayName);
    }

    public /* synthetic */ DockerImageReferenceType(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        this(string, string2);
    }

    @NotNull
    public PsiReference[] getReferencesFromValue(@NotNull YAMLScalar valueScalar) {
        Intrinsics.checkNotNullParameter((Object)valueScalar, (String)"valueScalar");
        String fullText = DockerImageReferenceType.Companion.unquoteTextValue(valueScalar);
        DockerRepoTag dockerRepoTag = DockerRepoTag.fromString(StringsKt.substringBefore((String)fullText, (char)' ', (String)fullText));
        Intrinsics.checkNotNullExpressionValue((Object)dockerRepoTag, (String)"fromString(...)");
        DockerRepoTag parsedTag = dockerRepoTag;
        String string = parsedTag.getQualifiedRepository();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedRepository(...)");
        String image = string;
        PsiReference[] psiReferenceArray = new PsiReference[1];
        PsiElement psiElement = (PsiElement)valueScalar;
        String string2 = valueScalar.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        psiReferenceArray[0] = DockerImagePsiReference.Companion.createDockerImagePsiReference(psiElement, parsedTag, DockerImageReferenceType.Companion.rangeOf(string2, image));
        return psiReferenceArray;
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String text2 = DockerImageReferenceType.Companion.unquoteTextValue(scalarValue);
        if (StringsKt.isBlank((CharSequence)text2)) {
            return;
        }
        String trimmedReference = ((Object)StringsKt.trim((CharSequence)text2)).toString();
        CharSequence charSequence = trimmedReference;
        if (new Regex("\\s+").containsMatchIn(charSequence)) {
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("DockerImageReferenceType.error.multiple", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        charSequence = trimmedReference;
        if (EMBEDDED_VARIABLE_REF.containsMatchIn(charSequence)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)text2, (Object)trimmedReference) || !DockerRepoTagsKt.isValidRepoTag(trimmedReference)) {
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("DockerImageReferenceType.error.format", new Object[0]), new LocalQuickFix[0]);
            return;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\f\u0010\r\u001a\u00020\u0006*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/composeFile/DockerImageReferenceType$Companion;", "", "()V", "EMBEDDED_VARIABLE_REF", "Lkotlin/text/Regex;", "quote", "", "Lorg/jetbrains/yaml/psi/YAMLQuotedText;", "getQuote", "(Lorg/jetbrains/yaml/psi/YAMLQuotedText;)Ljava/lang/String;", "rangeOf", "Lcom/intellij/openapi/util/TextRange;", "subString", "unquoteTextValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "intellij.clouds.docker.compose"})
    public static final class Companion {
        private Companion() {
        }

        private final TextRange rangeOf(String $this$rangeOf, String subString) {
            TextRange textRange;
            int start2 = StringsKt.indexOf$default((CharSequence)$this$rangeOf, (String)subString, (int)0, (boolean)false, (int)6, null);
            if (start2 < 0) {
                TextRange textRange2 = TextRange.allOf((String)subString);
                textRange = textRange2;
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"allOf(...)");
            } else {
                textRange = new TextRange(start2, start2 + subString.length());
            }
            return textRange;
        }

        private final String unquoteTextValue(YAMLScalar $this$unquoteTextValue) {
            String string;
            if ($this$unquoteTextValue instanceof YAMLQuotedText) {
                String string2 = ((YAMLQuotedText)$this$unquoteTextValue).getTextValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTextValue(...)");
                string = StringsKt.removeSurrounding((String)string2, (CharSequence)this.getQuote((YAMLQuotedText)$this$unquoteTextValue));
            } else {
                String string3 = $this$unquoteTextValue.getTextValue();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTextValue(...)");
            }
            return string;
        }

        private final String getQuote(YAMLQuotedText $this$quote) {
            return $this$quote.isSingleQuote() ? "'" : "\"";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

