/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001 B7\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003JA\u0010\u0019\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/docker/agent/util/DockerComposeData;", "", "service", "", "project", "workingDir", "files", "", "Ljava/nio/file/Path;", "version", "Lcom/intellij/docker/agent/util/DockerComposeData$Version;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lcom/intellij/docker/agent/util/DockerComposeData$Version;)V", "getFiles", "()Ljava/util/Set;", "getProject", "()Ljava/lang/String;", "getService", "getVersion", "()Lcom/intellij/docker/agent/util/DockerComposeData$Version;", "getWorkingDir", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Version", "intellij.clouds.docker.agent"})
public final class DockerComposeData {
    @NotNull
    private final String service;
    @NotNull
    private final String project;
    @NotNull
    private final String workingDir;
    @NotNull
    private final Set<Path> files;
    @NotNull
    private final Version version;

    public DockerComposeData(@Nls @NotNull String service, @Nls @NotNull String project, @NotNull String workingDir2, @NotNull Set<? extends Path> files, @NotNull Version version2) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workingDir2, (String)"workingDir");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        this.service = service;
        this.project = project;
        this.workingDir = workingDir2;
        this.files = files;
        this.version = version2;
    }

    @NotNull
    public final String getService() {
        return this.service;
    }

    @NotNull
    public final String getProject() {
        return this.project;
    }

    @NotNull
    public final String getWorkingDir() {
        return this.workingDir;
    }

    @NotNull
    public final Set<Path> getFiles() {
        return this.files;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    @NotNull
    public final String component1() {
        return this.service;
    }

    @NotNull
    public final String component2() {
        return this.project;
    }

    @NotNull
    public final String component3() {
        return this.workingDir;
    }

    @NotNull
    public final Set<Path> component4() {
        return this.files;
    }

    @NotNull
    public final Version component5() {
        return this.version;
    }

    @NotNull
    public final DockerComposeData copy(@Nls @NotNull String service, @Nls @NotNull String project, @NotNull String workingDir2, @NotNull Set<? extends Path> files, @NotNull Version version2) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workingDir2, (String)"workingDir");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return new DockerComposeData(service, project, workingDir2, files, version2);
    }

    public static /* synthetic */ DockerComposeData copy$default(DockerComposeData dockerComposeData, String string, String string2, String string3, Set set, Version version2, int n, Object object) {
        if ((n & 1) != 0) {
            string = dockerComposeData.service;
        }
        if ((n & 2) != 0) {
            string2 = dockerComposeData.project;
        }
        if ((n & 4) != 0) {
            string3 = dockerComposeData.workingDir;
        }
        if ((n & 8) != 0) {
            set = dockerComposeData.files;
        }
        if ((n & 0x10) != 0) {
            version2 = dockerComposeData.version;
        }
        return dockerComposeData.copy(string, string2, string3, set, version2);
    }

    @NotNull
    public String toString() {
        return "DockerComposeData(service=" + this.service + ", project=" + this.project + ", workingDir=" + this.workingDir + ", files=" + this.files + ", version=" + this.version + ")";
    }

    public int hashCode() {
        int result2 = this.service.hashCode();
        result2 = result2 * 31 + this.project.hashCode();
        result2 = result2 * 31 + this.workingDir.hashCode();
        result2 = result2 * 31 + ((Object)this.files).hashCode();
        result2 = result2 * 31 + this.version.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DockerComposeData)) {
            return false;
        }
        DockerComposeData dockerComposeData = (DockerComposeData)other;
        if (!Intrinsics.areEqual((Object)this.service, (Object)dockerComposeData.service)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.project, (Object)dockerComposeData.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.workingDir, (Object)dockerComposeData.workingDir)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.files, dockerComposeData.files)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.version, (Object)dockerComposeData.version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0002J\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/docker/agent/util/DockerComposeData$Version;", "", "major", "", "minor", "bugfix", "(III)V", "getBugfix", "()I", "getMajor", "getMinor", "compareTo", "version", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.clouds.docker.agent"})
    public static final class Version {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int major;
        private final int minor;
        private final int bugfix;

        public Version(int major, int minor, int bugfix) {
            this.major = major;
            this.minor = minor;
            this.bugfix = bugfix;
        }

        public final int getMajor() {
            return this.major;
        }

        public final int getMinor() {
            return this.minor;
        }

        public final int getBugfix() {
            return this.bugfix;
        }

        public final int compareTo(@NotNull Version version2) {
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            return this.compareTo(version2.major, version2.minor, version2.bugfix);
        }

        public final int compareTo(int major, int minor, int bugfix) {
            int result2 = this.major - major;
            if (result2 != 0) {
                return result2;
            }
            result2 = this.minor - minor;
            return result2 != 0 ? result2 : this.bugfix - bugfix;
        }

        public final int component1() {
            return this.major;
        }

        public final int component2() {
            return this.minor;
        }

        public final int component3() {
            return this.bugfix;
        }

        @NotNull
        public final Version copy(int major, int minor, int bugfix) {
            return new Version(major, minor, bugfix);
        }

        public static /* synthetic */ Version copy$default(Version version2, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = version2.major;
            }
            if ((n4 & 2) != 0) {
                n2 = version2.minor;
            }
            if ((n4 & 4) != 0) {
                n3 = version2.bugfix;
            }
            return version2.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "Version(major=" + this.major + ", minor=" + this.minor + ", bugfix=" + this.bugfix + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.major);
            result2 = result2 * 31 + Integer.hashCode(this.minor);
            result2 = result2 * 31 + Integer.hashCode(this.bugfix);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Version)) {
                return false;
            }
            Version version2 = (Version)other;
            if (this.major != version2.major) {
                return false;
            }
            if (this.minor != version2.minor) {
                return false;
            }
            return this.bugfix == version2.bugfix;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/util/DockerComposeData$Version$Companion;", "", "()V", "from", "Lcom/intellij/docker/agent/util/DockerComposeData$Version;", "versionString", "", "parseNumber", "", "num", "intellij.clouds.docker.agent"})
        @SourceDebugExtension(value={"SMAP\ndockerComposeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerComposeUtils.kt\ncom/intellij/docker/agent/util/DockerComposeData$Version$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,416:1\n731#2,9:417\n37#3,2:426\n*S KotlinDebug\n*F\n+ 1 dockerComposeUtils.kt\ncom/intellij/docker/agent/util/DockerComposeData$Version$Companion\n*L\n79#1:417,9\n79#1:426,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Version from(@NotNull String versionString) {
                int minor;
                List list2;
                Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
                CharSequence charSequence = versionString;
                Regex regex = new Regex("\\.");
                int n = 0;
                List $this$dropLastWhile$iv = regex.split(charSequence, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] versionChunks = thisCollection$iv.toArray(new String[0]);
                if (versionChunks.length == 0) {
                    return null;
                }
                int major = this.parseNumber(versionChunks[0]);
                if (major < 0) {
                    return null;
                }
                int n2 = minor = versionChunks.length > 1 ? this.parseNumber(versionChunks[1]) : 0;
                if (minor < 0) {
                    return new Version(major, 0, 0);
                }
                int patch = versionChunks.length > 2 ? this.parseNumber(versionChunks[2]) : 0;
                return patch < 0 ? new Version(major, minor, 0) : new Version(major, minor, patch);
            }

            private final int parseNumber(String num) {
                CharSequence charSequence = num;
                Regex regex = new Regex("(\\d+).*");
                String string = "$1";
                Integer n = StringsKt.toIntOrNull((String)regex.replaceFirst(charSequence, string));
                return n != null ? n : -1;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

