/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.pipe;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AsyncDockerCmd;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.progress.AgentResultCallbackTemplate;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u0014*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000eH$J\u0006\u0010\u000f\u001a\u00020\fJ\r\u0010\u0010\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe;", "CMD_T", "Lcom/github/dockerjava/api/command/AsyncDockerCmd;", "Lcom/github/dockerjava/api/model/Frame;", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "context", "Lcom/intellij/docker/agent/DockerAgentContext;", "(Lcom/intellij/docker/agent/DockerAgentContext;)V", "getContext", "()Lcom/intellij/docker/agent/DockerAgentContext;", "myCloseFunction", "Lkotlin/Function0;", "", "callback", "Lcom/intellij/docker/agent/progress/AgentResultCallbackTemplate$Adapter;", "close", "cmd", "()Lcom/github/dockerjava/api/command/AsyncDockerCmd;", "start", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe;", "Companion", "MyDockerResultCallback", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerAsyncCmdAbstractPipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerAsyncCmdAbstractPipe.kt\ncom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n*L\n1#1,86:1\n1#2:87\n7#3:88\n*S KotlinDebug\n*F\n+ 1 DockerAsyncCmdAbstractPipe.kt\ncom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe\n*L\n84#1:88\n*E\n"})
public abstract class DockerAsyncCmdAbstractPipe<CMD_T extends AsyncDockerCmd<CMD_T, Frame>>
extends DockerTerminalPipe.WithTty {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerAgentContext context;
    @Nullable
    private volatile Function0<Unit> myCloseFunction;
    @NotNull
    private static final Logger logger;

    public DockerAsyncCmdAbstractPipe(@NotNull DockerAgentContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context.getAgent().getScope());
        this.context = context;
    }

    @NotNull
    protected final DockerAgentContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DockerTerminalPipe start() {
        Closeable closeable = (Closeable)this.cmd();
        Throwable throwable = null;
        try {
            AsyncDockerCmd it = (AsyncDockerCmd)closeable;
            boolean bl = false;
            AgentResultCallbackTemplate.Adapter adapter = (AgentResultCallbackTemplate.Adapter)it.exec((ResultCallback)this.callback());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return this;
    }

    @NotNull
    protected abstract CMD_T cmd();

    @NotNull
    protected abstract AgentResultCallbackTemplate.Adapter<Frame> callback();

    @Override
    public final void close() {
        Function0<Unit> function0 = this.myCloseFunction;
        if (function0 != null) {
            function0.invoke();
        }
        super.close();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = LoggerFactory.getLogger(DockerAsyncCmdAbstractPipe.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0014J\u0006\u0010\u0007\u001a\u00020\u0005J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe$MyDockerResultCallback;", "Lcom/intellij/docker/agent/progress/AgentResultCallbackTemplate$Adapter;", "Lcom/github/dockerjava/api/model/Frame;", "(Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe;)V", "beforeClose", "", "beforeStart", "close", "onNext", "frame", "onStart", "stream", "Ljava/io/Closeable;", "intellij.clouds.docker.agent"})
    protected class MyDockerResultCallback
    extends AgentResultCallbackTemplate.Adapter<Frame> {
        protected void beforeClose() {
            DockerAsyncCmdAbstractPipe.this.setShowCursor(false);
            DockerAsyncCmdAbstractPipe.this.printInfo(DockerAgentBundle.Companion.message("DockerAsyncCmdAbstractPipe.disconnected.from.container", new Object[0]));
        }

        protected void beforeStart() {
        }

        @Override
        public final void onStart(@Nullable Closeable stream) {
            this.beforeStart();
            DockerAsyncCmdAbstractPipe.this.myCloseFunction = (Function0)new Function0<Unit>(this){
                final /* synthetic */ MyDockerResultCallback this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    MyDockerResultCallback.access$close$s514145071(this.this$0);
                }
            };
            super.onStart(stream);
        }

        @Override
        public void onNext(@Nullable Frame frame) {
            if (frame != null) {
                byte[] byArray = frame.getPayload();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPayload(...)");
                byte[] byArray2 = byArray;
                Charset charset = Charsets.UTF_8;
                String payload = StringsKt.replace$default((String)new String(byArray2, charset), (String)"\n", (String)"\r\n", (boolean)false, (int)4, null);
                byte[] byArray3 = payload.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                byte[] toPrint = byArray3;
                try {
                    StreamType streamType = frame.getStreamType();
                    switch (streamType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[streamType.ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            ChannelsKt.trySendBlocking((SendChannel)((SendChannel)DockerAsyncCmdAbstractPipe.this.getOutToTerminalChannel()), (Object)toPrint);
                            break;
                        }
                        default: {
                            LoggerFactory.getLogger(MyDockerResultCallback.class).error("unknown stream type:" + frame.getStreamType());
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    this.onError(e);
                }
            }
        }

        @Override
        public final void close() {
            this.beforeClose();
            super.close();
            DockerAsyncCmdAbstractPipe.this.close();
        }

        public static final /* synthetic */ void access$close$s514145071(MyDockerResultCallback $this) {
            super.close();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[StreamType.values().length];
                try {
                    nArray[StreamType.STDOUT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StreamType.RAW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StreamType.STDERR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

