/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action.compose;

import com.intellij.docker.action.compose.ComposeServiceActionBase;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0094@\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/action/compose/ComposeDeleteServiceAction;", "Lcom/intellij/docker/action/compose/ComposeServiceActionBase;", "()V", "doActionPerformed", "", "serviceRuntime", "Lcom/intellij/docker/runtimes/ComposeServiceRuntime;", "(Lcom/intellij/docker/runtimes/ComposeServiceRuntime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUserConfirmation", "", "serviceName", "", "containerCount", "", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.clouds.docker"})
public final class ComposeDeleteServiceAction
extends ComposeServiceActionBase {
    public ComposeDeleteServiceAction() {
        super(true);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            super.update(e);
        }
    }

    @Override
    @Nullable
    protected Object doActionPerformed(@NotNull ComposeServiceRuntime serviceRuntime, @NotNull Continuation<? super Unit> $completion) {
        int size = serviceRuntime.getCountOfContainers();
        if (size != 0 && this.getUserConfirmation(serviceRuntime.getServiceName(), size)) {
            Object object = serviceRuntime.deleteAllContainers($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final boolean getUserConfirmation(String serviceName, int containerCount) {
        Object[] objectArray = switch (containerCount) {
            case 0 -> throw new IllegalArgumentException();
            case 1 -> DockerBundle.message("DockerDeleteProvider.confirmation.container.one", new Object[0]);
            default -> {
                Object[] var5_3 = new Object[]{containerCount};
                yield DockerBundle.message("DockerDeleteProvider.confirmation.container.many", var5_3);
            }
        };
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] containersPiece = objectArray;
        objectArray = new Object[]{containersPiece, serviceName};
        return Messages.showYesNoDialog(null, (String)DockerBundle.message("ComposeDeleteServiceAction.confirmation", objectArray), (String)DockerBundle.message("DockerDeleteProvider.confirmation.title", new Object[0]), (Icon)Messages.getWarningIcon()) == 0;
    }
}

