/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.packagemanager.parallel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.packagemanager.bundle.PackageManagerBundle;
import com.jetbrains.cidr.packagemanager.calling.CallEngineStatus;
import com.jetbrains.cidr.packagemanager.calling.TaskBuilder;
import com.jetbrains.cidr.packagemanager.calling.VcpkgExecutionFail;
import com.jetbrains.cidr.packagemanager.utils.JsonUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J5\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\u000b\u0010!\u001a\u00070\"\u00a2\u0006\u0002\b#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H 0\u001cH\u0002J&\u0010%\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H 0\u001cJ&\u0010'\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H 0\u001cJ\u0012\u0010)\u001a\u0004\u0018\u00010\u00122\u0006\u0010*\u001a\u00020+H&J\u0012\u0010,\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020+H\u0007J\b\u0010-\u001a\u00020\u001dH\u0002J\b\u0010.\u001a\u00020\u001dH\u0002J\n\u0010/\u001a\u0004\u0018\u00010\u0012H\u0002J\n\u00100\u001a\u0004\u0018\u00010\u0012H\u0005J\u0012\u00101\u001a\u00020\u001d2\b\u00102\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u00103\u001a\u00020\u001d2\b\u00102\u001a\u0004\u0018\u00010\u0012H\u0005J\u001c\u00104\u001a\u0002052\u0014\u0010$\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u001d0\u001cR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/jetbrains/cidr/packagemanager/parallel/FileInMemoryModificatorJson;", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)V", "fileLock", "Ljava/util/concurrent/locks/ReentrantLock;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getPath", "()Ljava/nio/file/Path;", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "state", "getState", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "setState", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;)V", "stateField", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "subscribers", "", "Lkotlin/Function1;", "", "addAbstractOperation", "Lcom/jetbrains/cidr/packagemanager/calling/TaskBuilder;", "RESULT", "name", "", "Lorg/jetbrains/annotations/Nls;", "operation", "addSlowReadOperation", "reading", "addWriteOperation", "adding", "defaultContains", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getReadyPathWithCreating", "launchRead", "launchWrite", "loadNode", "loadNodeFromFile", "saveNode", "node", "saveNodeToFile", "subscribe", "", "intellij.clion.packageManager"})
@SourceDebugExtension(value={"SMAP\nFileInMemoryModificatorJson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileInMemoryModificatorJson.kt\ncom/jetbrains/cidr/packagemanager/parallel/FileInMemoryModificatorJson\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public abstract class FileInMemoryModificatorJson {
    @NotNull
    private final Project project;
    @NotNull
    private final Path path;
    @NotNull
    private AtomicProperty<ObjectNode> stateField;
    @NotNull
    private final List<Function1<ObjectNode, Unit>> subscribers;
    @NotNull
    private final ReentrantLock fileLock;
    @NotNull
    private final ObjectMapper objectMapper;

    /*
     * WARNING - void declaration
     */
    public FileInMemoryModificatorJson(@NotNull Project project, @NotNull Path path) {
        void $this$stateField_u24lambda_u240;
        AtomicProperty atomicProperty;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.project = project;
        this.path = path;
        AtomicProperty atomicProperty2 = atomicProperty = new AtomicProperty(null);
        FileInMemoryModificatorJson fileInMemoryModificatorJson = this;
        boolean bl = false;
        $this$stateField_u24lambda_u240.afterChange((Function1)new Function1<ObjectNode, Unit>(this){
            final /* synthetic */ FileInMemoryModificatorJson this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable ObjectNode objectNode) {
                Iterable $this$forEach$iv = FileInMemoryModificatorJson.access$getSubscribers$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl = false;
                    it.invoke((Object)objectNode);
                }
            }
        });
        fileInMemoryModificatorJson.stateField = atomicProperty;
        this.subscribers = new ArrayList();
        this.fileLock = new ReentrantLock();
        this.objectMapper = new ObjectMapper();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            /*
             * WARNING - void declaration
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Iterable iterable = events;
                FileInMemoryModificatorJson fileInMemoryModificatorJson = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VFileEvent fileEvent = (VFileEvent)element$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)Path.of(fileEvent.getPath(), new String[0]), (Object)fileInMemoryModificatorJson.getPath())) {
                        fileInMemoryModificatorJson.launchRead();
                        continue;
                    }
                    if (!(fileEvent instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)fileEvent).isRename() || !Intrinsics.areEqual((Object)Path.of(((VFilePropertyChangeEvent)fileEvent).getNewPath(), new String[0]), (Object)fileInMemoryModificatorJson.getPath()) && !Intrinsics.areEqual((Object)Path.of(((VFilePropertyChangeEvent)fileEvent).getOldPath(), new String[0]), (Object)fileInMemoryModificatorJson.getPath())) continue;
                    fileInMemoryModificatorJson.launchRead();
                }
            }
        });
        this.launchRead();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Nullable
    public abstract ObjectNode defaultContains(@NotNull ProgressIndicator var1);

    @Nullable
    public final ObjectNode getState() {
        return (ObjectNode)this.stateField.get();
    }

    public final void setState(@Nullable ObjectNode value) {
        this.stateField.set((Object)value);
        this.launchWrite();
    }

    @RequiresBackgroundThread
    @Nullable
    protected final ObjectNode loadNodeFromFile() {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(PathsKt.readText$default((Path)this.path, null, (int)1, null));
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
            return JsonUtils.Companion.safeObjectNode(jsonNode);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
        catch (JsonMappingException jsonMappingException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    protected final void saveNodeToFile(@Nullable ObjectNode node) {
        if (node == null) {
            Files.delete(this.path);
        } else {
            Object object = this.path;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                BufferedWriter it = (BufferedWriter)object;
                boolean bl = false;
                ObjectWriter objectWriter = this.objectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
                objectWriter.writeValue((Writer)it, (Object)node);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)CollectionsKt.listOf((Object)this.path.toFile()));
    }

    public final boolean subscribe(@NotNull Function1<? super ObjectNode, Unit> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        return this.subscribers.add(operation);
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @Nullable
    public final Path getReadyPathWithCreating(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl;
            Object object = this.path;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                boolean bl2;
                BufferedWriter it = (BufferedWriter)object;
                boolean bl3 = false;
                ObjectNode node = this.defaultContains(indicator);
                if (node == null) {
                    bl2 = false;
                } else {
                    ObjectWriter objectWriter = this.objectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
                    objectWriter.writeValue((Writer)it, (Object)node);
                    bl2 = true;
                }
                bl = bl2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            boolean successful = bl;
            if (!successful) {
                return null;
            }
        }
        this.stateField.set((Object)this.loadNodeFromFile());
        return this.path;
    }

    private final ObjectNode loadNode() {
        return this.getState();
    }

    private final void saveNode(ObjectNode node) {
        this.setState(node);
    }

    private final <RESULT> TaskBuilder<RESULT> addAbstractOperation(String name, Function1<? super ObjectNode, ? extends RESULT> operation) {
        return TaskBuilder.TaskBuilderInfo.Companion.taskBuilder(this.project, name).task((Function1)new Function1<ProgressIndicator, CallEngineStatus<RESULT>>(this, operation){
            final /* synthetic */ FileInMemoryModificatorJson this$0;
            final /* synthetic */ Function1<ObjectNode, RESULT> $operation;
            {
                this.this$0 = $receiver;
                this.$operation = $operation;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final CallEngineStatus<RESULT> invoke(@NotNull ProgressIndicator progressIndicator) {
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                Object result = null;
                Lock lock = FileInMemoryModificatorJson.access$getFileLock$p(this.this$0);
                FileInMemoryModificatorJson fileInMemoryModificatorJson = this.this$0;
                Function1<ObjectNode, RESULT> function1 = this.$operation;
                lock.lock();
                try {
                    boolean bl = false;
                    Path path = fileInMemoryModificatorJson.getReadyPathWithCreating(progressIndicator);
                    if (path == null) {
                        Object[] objectArray = new Object[]{((Object)fileInMemoryModificatorJson.getPath()).toString()};
                        String string = PackageManagerBundle.message("manifest.manager.unable.to.create.file", objectArray);
                        objectArray = new Object[]{((Object)fileInMemoryModificatorJson.getPath()).toString()};
                        CallEngineStatus<RESULT> callEngineStatus = new CallEngineStatus<RESULT>(null, new VcpkgExecutionFail(string, PackageManagerBundle.message("manifest.manager.unable.to.create.file", objectArray)), null, 5, null);
                        return callEngineStatus;
                    }
                    ObjectNode mainNode = FileInMemoryModificatorJson.access$loadNode(fileInMemoryModificatorJson);
                    if (mainNode == null) {
                        Object[] objectArray = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)path.getFileName(), (String)"getFileName(...)");
                        String string = PackageManagerBundle.message("json.file.modificator.error.read.json", objectArray);
                        objectArray = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)path.getFileName(), (String)"getFileName(...)");
                        CallEngineStatus<RESULT> callEngineStatus = new CallEngineStatus<RESULT>(null, new VcpkgExecutionFail(string, PackageManagerBundle.message("json.file.modificator.error.read.json", objectArray)), null, 5, null);
                        return callEngineStatus;
                    }
                    result = function1.invoke((Object)mainNode);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                return new CallEngineStatus<RESULT>(result, null, null, 6, null);
            }
        });
    }

    @NotNull
    public final <RESULT> TaskBuilder<RESULT> addWriteOperation(@NotNull Function1<? super ObjectNode, ? extends RESULT> adding) {
        Intrinsics.checkNotNullParameter(adding, (String)"adding");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.path.getFileName(), (String)"getFileName(...)");
        return this.addAbstractOperation(PackageManagerBundle.message("json.file.modificator.update", objectArray), (Function1)new Function1<ObjectNode, RESULT>(adding, this){
            final /* synthetic */ Function1<ObjectNode, RESULT> $adding;
            final /* synthetic */ FileInMemoryModificatorJson this$0;
            {
                this.$adding = $adding;
                this.this$0 = $receiver;
                super(1);
            }

            public final RESULT invoke(@NotNull ObjectNode mainNode) {
                Intrinsics.checkNotNullParameter((Object)mainNode, (String)"mainNode");
                Object result = this.$adding.invoke((Object)mainNode);
                FileInMemoryModificatorJson.access$saveNode(this.this$0, mainNode);
                return (RESULT)result;
            }
        });
    }

    @NotNull
    public final <RESULT> TaskBuilder<RESULT> addSlowReadOperation(@NotNull Function1<? super ObjectNode, ? extends RESULT> reading) {
        Intrinsics.checkNotNullParameter(reading, (String)"reading");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.path.getFileName(), (String)"getFileName(...)");
        return this.addAbstractOperation(PackageManagerBundle.message("json.file.modificator.read", objectArray), (Function1)new Function1<ObjectNode, RESULT>(reading){
            final /* synthetic */ Function1<ObjectNode, RESULT> $reading;
            {
                this.$reading = $reading;
                super(1);
            }

            public final RESULT invoke(@NotNull ObjectNode mainNode) {
                Intrinsics.checkNotNullParameter((Object)mainNode, (String)"mainNode");
                return (RESULT)this.$reading.invoke((Object)mainNode);
            }
        });
    }

    private final void launchRead() {
        Project project = this.project;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.path.getFileName(), (String)"getFileName(...)");
        String string = PackageManagerBundle.message("json.file.modificator.read", objectArray);
        new Task.Backgroundable(this, project, string){
            final /* synthetic */ FileInMemoryModificatorJson this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                FileInMemoryModificatorJson.access$getStateField$p(this.this$0).set((Object)this.this$0.loadNodeFromFile());
            }
        }.queue();
    }

    private final void launchWrite() {
        Project project = this.project;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.path.getFileName(), (String)"getFileName(...)");
        String string = PackageManagerBundle.message("json.file.modificator.write", objectArray);
        new Task.Backgroundable(this, project, string){
            final /* synthetic */ FileInMemoryModificatorJson this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.this$0.saveNodeToFile((ObjectNode)FileInMemoryModificatorJson.access$getStateField$p(this.this$0).get());
            }
        }.queue();
    }

    public static final /* synthetic */ ReentrantLock access$getFileLock$p(FileInMemoryModificatorJson $this) {
        return $this.fileLock;
    }

    public static final /* synthetic */ ObjectNode access$loadNode(FileInMemoryModificatorJson $this) {
        return $this.loadNode();
    }

    public static final /* synthetic */ void access$saveNode(FileInMemoryModificatorJson $this, ObjectNode node) {
        $this.saveNode(node);
    }

    public static final /* synthetic */ AtomicProperty access$getStateField$p(FileInMemoryModificatorJson $this) {
        return $this.stateField;
    }

    public static final /* synthetic */ List access$getSubscribers$p(FileInMemoryModificatorJson $this) {
        return $this.subscribers;
    }
}

