/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb.project;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseExpirableExecutor;
import com.intellij.openapi.application.ExpirableExecutor;
import com.intellij.openapi.application.impl.ExpirableExecutorImplKt;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureImpl;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.FailureResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.TaskOperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.TaskOperationDescriptorImpl;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.cidr.cpp.compdb.CompDBBundle;
import com.jetbrains.cidr.cpp.compdb.CompDBLog;
import com.jetbrains.cidr.cpp.compdb.CompDBUtilKt;
import com.jetbrains.cidr.cpp.compdb.CompDBWorkspace;
import com.jetbrains.cidr.cpp.compdb.model.CompDBModel;
import com.jetbrains.cidr.cpp.compdb.model.CompDBModelCommandObject;
import com.jetbrains.cidr.cpp.compdb.model.CompDBModelResult;
import com.jetbrains.cidr.cpp.compdb.model.CompDBModelResultKt;
import com.jetbrains.cidr.cpp.compdb.model.Success;
import com.jetbrains.cidr.cpp.compdb.project.CompDBStateData;
import com.jetbrains.cidr.cpp.compdb.project.EventData;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBExecutionSettings;
import com.jetbrains.cidr.cpp.external.system.project.CLionExternalResolverUtilKt;
import com.jetbrains.cidr.cpp.project.command.CPPCompilationCommandConverter;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.execution.build.issue.EnvironmentIssue;
import com.jetbrains.cidr.external.system.ExternalBundle;
import com.jetbrains.cidr.external.system.model.ExternalModule;
import com.jetbrains.cidr.external.system.model.ExternalResolveConfiguration;
import com.jetbrains.cidr.external.system.model.impl.ExternalModuleImpl;
import com.jetbrains.cidr.external.system.service.ExternalTaskDisposableCancellationService;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007JB\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\rH\u0002J>\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001a2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J6\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J*\u0010'\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010\b\u001a\u00020\t2\b\u0010*\u001a\u0004\u0018\u00010#H\u0002J\"\u0010+\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010*\u001a\u0004\u0018\u00010#H\u0002J8\u0010,\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010\b\u001a\u00020\t2\b\u0010*\u001a\u0004\u0018\u00010#2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0012H\u0002J\"\u0010/\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010*\u001a\u0004\u0018\u00010#H\u0002J(\u00100\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020#H\u0002J.\u00103\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u0018042\u0006\u0010\b\u001a\u00020\t2\u0006\u00105\u001a\u00020#H\u0002J8\u00106\u001a\b\u0012\u0004\u0012\u00020 0\u001a2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\u0006\u00107\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J.\u00108\u001a\b\u0012\u0004\u0012\u00020 0\u001a2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t\u00a8\u0006:"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/project/CompDBProjectResolver;", "Lcom/intellij/openapi/externalSystem/service/project/ExternalSystemProjectResolver;", "Lcom/jetbrains/cidr/cpp/compdb/settings/CompDBExecutionSettings;", "()V", "cancelTask", "", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "checkCancelled", "", "convertCommandsToConfigs", "", "Lcom/jetbrains/cidr/external/system/model/ExternalResolveConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "filteredCommands", "", "Lcom/jetbrains/cidr/cpp/compdb/model/CompDBModelCommandObject;", "resolveTaskId", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "unresolvedCompilers", "Ljava/io/File;", "doGenerateCPPModule", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "model", "Lcom/jetbrains/cidr/cpp/compdb/model/CompDBModel;", "settings", "doResolveProjectInfo", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "id", "projectPath", "", "generateCPPModule", "database", "Lcom/intellij/openapi/vfs/VirtualFile;", "reportImportFinish", "startEventData", "Lcom/jetbrains/cidr/cpp/compdb/project/EventData;", "parentId", "reportImportStart", "reportModelResults", "modelResults", "Lcom/jetbrains/cidr/cpp/compdb/model/CompDBModelResult;", "reportModelStartEvent", "reportSingleModelResult", "modelResult", "parseEventId", "reportUnresolvedCompilers", "", "parentEventId", "resolveProjectInfo", "isPreviewMode", "resolveProjectMakefile", "Companion", "intellij.clion.compdb"})
@SourceDebugExtension(value={"SMAP\nCompDBProjectResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompDBProjectResolver.kt\ncom/jetbrains/cidr/cpp/compdb/project/CompDBProjectResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n*L\n1#1,423:1\n1#2:424\n1536#3:425\n800#3,11:442\n1855#3,2:453\n526#4:426\n511#4,6:427\n215#5,2:433\n53#6:435\n80#6,6:436\n*S KotlinDebug\n*F\n+ 1 CompDBProjectResolver.kt\ncom/jetbrains/cidr/cpp/compdb/project/CompDBProjectResolver\n*L\n209#1:425\n300#1:442,11\n302#1:453,2\n211#1:426\n211#1:427,6\n212#1:433,2\n219#1:435\n219#1:436,6\n*E\n"})
public final class CompDBProjectResolver
implements ExternalSystemProjectResolver<CompDBExecutionSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<String> PARENT_EVENT_ID_KEY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, boolean isPreviewMode, @Nullable CompDBExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException, IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        try {
            Disposable cancellationDisposable = ExternalTaskDisposableCancellationService.Companion.getInstance().start(id);
            if (cancellationDisposable == null) {
                throw new IllegalArgumentException(CompDBBundle.message("project.resolver.unexpected.error.message", new Object[0]));
            }
            DataNode<ProjectData> dataNode = this.doResolveProjectInfo(id, projectPath, settings, listener2);
            return dataNode;
        }
        catch (ProcessCanceledException ex) {
            throw new ExternalSystemException(CompDBBundle.message("project.resolver.cancelled.message", new Object[0]));
        }
        finally {
            ExternalTaskDisposableCancellationService.Companion.getInstance().finish(id);
        }
    }

    @NotNull
    public final DataNode<ProjectData> resolveProjectMakefile(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @Nullable CompDBExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException, IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        try {
            Disposable cancellationDisposable = ExternalTaskDisposableCancellationService.Companion.getInstance().findDisposable(id);
            if (!(cancellationDisposable != null)) {
                boolean bl = false;
                String string = CompDBBundle.message("project.resolver.unexpected.error.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string2 = string;
                throw new IllegalArgumentException(string2.toString());
            }
            return this.doResolveProjectInfo(id, projectPath, settings, listener2);
        }
        catch (ProcessCanceledException ex) {
            throw new ExternalSystemException(CompDBBundle.message("project.resolver.cancelled.message", new Object[0]));
        }
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return ExternalTaskDisposableCancellationService.Companion.getInstance().cancel(taskId);
    }

    public final void checkCancelled(@NotNull ExternalSystemTaskId taskId) throws ProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        ExternalTaskDisposableCancellationService.Companion.getInstance().checkCancelled(taskId);
    }

    private final DataNode<ProjectData> doResolveProjectInfo(ExternalSystemTaskId id, String projectPath, CompDBExecutionSettings settings, ExternalSystemTaskNotificationListener listener2) {
        Project project = id.findProject();
        if (!(project != null)) {
            boolean $i$a$-require-CompDBProjectResolver$doResolveProjectInfo$52 = false;
            String string = CompDBBundle.message("project.resolver.unexpected.error.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String $i$a$-require-CompDBProjectResolver$doResolveProjectInfo$52 = string;
            throw new IllegalArgumentException($i$a$-require-CompDBProjectResolver$doResolveProjectInfo$52.toString());
        }
        File projectPathIO = new File(projectPath);
        File projectDirIO = projectPathIO.isDirectory() ? projectPathIO : projectPathIO.getParentFile();
        if (!(projectDirIO != null)) {
            boolean $i$a$-require-CompDBProjectResolver$doResolveProjectInfo$62 = false;
            Object[] objectArray = new Object[]{projectPath};
            String string = ExternalBundle.message((String)"project.path.invalid.message", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String $i$a$-require-CompDBProjectResolver$doResolveProjectInfo$62 = string;
            throw new IllegalArgumentException($i$a$-require-CompDBProjectResolver$doResolveProjectInfo$62.toString());
        }
        VirtualFile database = null;
        try {
            VirtualFile projectDir = VfsUtil.findFileByIoFile((File)projectDirIO, (boolean)true);
            if (!(projectDir != null)) {
                boolean $i$a$-require-CompDBProjectResolver$doResolveProjectInfo$72 = false;
                Object[] objectArray = new Object[]{projectDirIO.getPath()};
                String string = ExternalBundle.message((String)"project.path.invalid.message", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String $i$a$-require-CompDBProjectResolver$doResolveProjectInfo$72 = string;
                throw new IllegalArgumentException($i$a$-require-CompDBProjectResolver$doResolveProjectInfo$72.toString());
            }
            String[] stringArray = new String[]{"compile_commands.json"};
            database = VfsUtil.findRelativeFile((VirtualFile)projectDir, (String[])stringArray);
            if (!(database != null)) {
                boolean $i$a$-require-CompDBProjectResolver$doResolveProjectInfo$82 = false;
                Object[] objectArray = new Object[]{projectDirIO.getPath()};
                String string = CompDBBundle.message("compilation.database.file.not.found.message", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String $i$a$-require-CompDBProjectResolver$doResolveProjectInfo$82 = string;
                throw new IllegalArgumentException($i$a$-require-CompDBProjectResolver$doResolveProjectInfo$82.toString());
            }
            this.checkCancelled(id);
        }
        catch (ExecutionException ex) {
            throw new ExternalSystemException((Throwable)ex);
        }
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String projectName = string;
        String string2 = project.getBasePath();
        if (string2 == null) {
            string2 = projectDirIO.getPath();
        }
        String string3 = ExternalSystemApiUtil.toCanonicalPath((String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toCanonicalPath(...)");
        String ideProjectPath = string3;
        ProjectData projectData = new ProjectData(CompDBUtilKt.getID(), projectName, ideProjectPath, ExternalSystemApiUtil.toCanonicalPath((String)projectDirIO.getPath()));
        DataNode projectNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        this.checkCancelled(id);
        CompDBLog.INSTANCE.getLOG().debug("Resolving CompDB " + projectName + " project");
        CompDBExecutionSettings compDBExecutionSettings = settings;
        if (compDBExecutionSettings == null) {
            compDBExecutionSettings = CompDBExecutionSettings.Companion.default();
        }
        DataNode<ExternalModule> cppModuleNode = this.generateCPPModule(id, project, database, compDBExecutionSettings, listener2);
        ProjectSystemId projectSystemId = CompDBUtilKt.getID();
        Path path = projectPathIO.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        CLionExternalResolverUtilKt.attachExternalModule((Project)project, (ProjectSystemId)projectSystemId, (Path)path, (DataNode)projectNode, cppModuleNode);
        return projectNode;
    }

    private final DataNode<ExternalModule> generateCPPModule(ExternalSystemTaskId id, Project project, VirtualFile database, CompDBExecutionSettings settings, ExternalSystemTaskNotificationListener listener2) {
        DataNode<ExternalModule> dataNode;
        EnvironmentProblems environmentProblems = new EnvironmentProblems();
        CPPEnvironment environment = CompDBWorkspace.Companion.getInstance(project).createEnvironment(project, settings.getToolchainName(), environmentProblems, false, null);
        for (EnvironmentProblems.Problem problem : environmentProblems.getProblems()) {
            listener2.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(id, (BuildEvent)new BuildIssueEventImpl((Object)id, (BuildIssue)new EnvironmentIssue(problem), MessageEvent.Kind.ERROR)));
        }
        if (environment == null) {
            throw new ExternalSystemException();
        }
        this.checkCancelled(id);
        CompDBLog.INSTANCE.getLOG().debug("Resolving CompDB project in environment: " + environment);
        EventData modelStartEvent = this.reportModelStartEvent(id, listener2, (String)settings.getUserData(PARENT_EVENT_ID_KEY));
        Disposable disposable = ExternalTaskDisposableCancellationService.Companion.getInstance().findDisposable(id);
        if (disposable == null) {
            Disposable disposable2 = Disposer.newDisposable((String)id.toString());
            disposable = disposable2;
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        }
        Disposable cancellationDisposable = disposable;
        VirtualFile[] virtualFileArray = new VirtualFile[]{database};
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])virtualFileArray);
        List<CompDBModelResult> modelResults = ApplicationManager.getApplication().isUnitTestMode() ? CompDBModel.Companion.createFromJsonWithMacros(database, environment, settings.getDataContext(), cancellationDisposable) : CompDBModel.Companion.createFromJson(database, environment, cancellationDisposable);
        this.checkCancelled(id);
        CompDBModel model = this.reportModelResults(id, modelStartEvent, listener2, (String)settings.getUserData(PARENT_EVENT_ID_KEY), modelResults);
        DataNode<ExternalModule> it = dataNode = this.doGenerateCPPModule(project, id, model, environment, settings, listener2);
        boolean bl = false;
        this.checkCancelled(id);
        it = dataNode;
        boolean bl2 = false;
        it.addChild(Companion.createStateData(environment));
        it = dataNode;
        boolean bl3 = false;
        listener2.onTaskOutput(id, CompDBBundle.message("project.resolver.general.success.message", new Object[0]) + "\n", true);
        return dataNode;
    }

    /*
     * WARNING - void declaration
     */
    private final DataNode<ExternalModule> doGenerateCPPModule(Project project, ExternalSystemTaskId resolveTaskId, CompDBModel model, CPPEnvironment environment, CompDBExecutionSettings settings, ExternalSystemTaskNotificationListener listener2) {
        DataNode dataNode;
        void destination$iv$iv;
        void $this$aggregateTo$iv$iv;
        Object object;
        Grouping element$iv;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Map $this$filter$iv;
        EventData importEventData = this.reportImportStart(resolveTaskId, listener2, (String)settings.getUserData(PARENT_EVENT_ID_KEY));
        HashSet unresolvedCompilers = new HashSet();
        this.checkCancelled(resolveTaskId);
        Object $this$groupingBy$iv = model.getCommandObjects();
        boolean $i$f$groupingBy = false;
        Grouping grouping = (Grouping)new Grouping<CompDBModelCommandObject, File>((Iterable)$this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<CompDBModelCommandObject> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Object keyOf(Object element) {
                CompDBModelCommandObject it = (CompDBModelCommandObject)element;
                boolean bl = false;
                return it.getFile();
            }
        };
        $this$groupingBy$iv = GroupingKt.eachCount((Grouping)grouping);
        boolean $i$f$filter = false;
        void var12_13 = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((Number)it.getValue()).intValue() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv2;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            String message;
            Grouping it = element$iv = $this$filterTo$iv$iv.next();
            boolean bl = false;
            object = new Object[]{((File)it.getKey()).toString()};
            Intrinsics.checkNotNullExpressionValue((Object)CompDBBundle.message("project.resolver.several.commands.for.file.warning", (Object[])object), (String)"message(...)");
            listener2.onTaskOutput(resolveTaskId, message + "\n", true);
            CompDBLog.INSTANCE.getLOG().debug(message);
        }
        Grouping $this$aggregate$iv = grouping;
        boolean $i$f$aggregate = false;
        element$iv = $this$aggregate$iv;
        Map it = new LinkedHashMap();
        boolean $i$f$aggregateTo = false;
        object = $this$aggregateTo$iv$iv.sourceIterator();
        while (object.hasNext()) {
            void accumulator;
            void element;
            void first;
            Object e$iv$iv = object.next();
            Object key$iv$iv = $this$aggregateTo$iv$iv.keyOf(e$iv$iv);
            Object accumulator$iv$iv = destination$iv$iv.get(key$iv$iv);
            boolean bl = accumulator$iv$iv == null && !destination$iv$iv.containsKey(key$iv$iv);
            CompDBModelCommandObject compDBModelCommandObject = (CompDBModelCommandObject)e$iv$iv;
            CompDBModelCommandObject compDBModelCommandObject2 = (CompDBModelCommandObject)accumulator$iv$iv;
            File cfr_ignored_0 = (File)key$iv$iv;
            Object object2 = key$iv$iv;
            void var24_33 = destination$iv$iv;
            boolean bl2 = false;
            void var26_35 = first != false ? element : accumulator;
            var24_33.put(object2, var26_35);
        }
        List filteredCommands = CollectionsKt.filterNotNull((Iterable)destination$iv$iv.values());
        Set<ExternalResolveConfiguration> configurations = this.convertCommandsToConfigs(project, filteredCommands, resolveTaskId, environment, unresolvedCompilers);
        DataNode it2 = dataNode = new DataNode(ExternalModule.OC_MODULE_KEY, (Object)new ExternalModuleImpl(configurations), null);
        boolean bl = false;
        this.reportUnresolvedCompilers(resolveTaskId, unresolvedCompilers, listener2, importEventData.getId());
        it2 = dataNode;
        boolean bl3 = false;
        this.reportImportFinish(resolveTaskId, importEventData, listener2, (String)settings.getUserData(PARENT_EVENT_ID_KEY));
        return dataNode;
    }

    private final Set<ExternalResolveConfiguration> convertCommandsToConfigs(Project project, List<CompDBModelCommandObject> filteredCommands, ExternalSystemTaskId resolveTaskId, CPPEnvironment environment, Set<File> unresolvedCompilers) {
        Disposable disposable = ExternalTaskDisposableCancellationService.Companion.getInstance().findDisposable(resolveTaskId);
        if (disposable == null) {
            Disposable disposable2 = Disposer.newDisposable((String)resolveTaskId.toString());
            disposable = disposable2;
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        }
        Disposable cancellationDisposable = disposable;
        BaseExpirableExecutor baseExpirableExecutor = ExpirableExecutor.on((Executor)ConcurrencyUtil.newSameThreadExecutorService()).expireWith(cancellationDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)baseExpirableExecutor, (String)"expireWith(...)");
        ContinuationInterceptor context = ExpirableExecutorImplKt.coroutineDispatchingContext((ExpirableExecutor)((ExpirableExecutor)baseExpirableExecutor));
        CPPCompilationCommandConverter converter = new CPPCompilationCommandConverter(environment, project, context.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        LinkedHashSet<ExternalResolveConfiguration> configurations = new LinkedHashSet<ExternalResolveConfiguration>();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(filteredCommands, configurations, converter, unresolvedCompilers, null){
            int label;
            final /* synthetic */ List<CompDBModelCommandObject> $filteredCommands;
            final /* synthetic */ LinkedHashSet<ExternalResolveConfiguration> $configurations;
            final /* synthetic */ CPPCompilationCommandConverter $converter;
            final /* synthetic */ Set<File> $unresolvedCompilers;
            {
                this.$filteredCommands = $filteredCommands;
                this.$configurations = $configurations;
                this.$converter = $converter;
                this.$unresolvedCompilers = $unresolvedCompilers;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        for (CompDBModelCommandObject command : this.$filteredCommands) {
                            try {
                                this.$configurations.add(this.$converter.convert(command.toCPPCommandObject()));
                            }
                            catch (CPPCompilationCommandConverter.UnresolvedCompilerException ex) {
                                this.$unresolvedCompilers.add(ex.getCompilerExecutable());
                            }
                            catch (CancellationException ex) {
                                throw new ProcessCanceledException((Throwable)ex);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return configurations;
    }

    private final EventData reportModelStartEvent(ExternalSystemTaskId resolveTaskId, ExternalSystemTaskNotificationListener listener2, String parentId) {
        String parseEventId = "parse:" + UUID.randomUUID();
        TaskOperationDescriptorImpl parseTaskDescriptor = new TaskOperationDescriptorImpl(CompDBBundle.message("parse.task.display.name", new Object[0]), System.currentTimeMillis(), "config-parse");
        ExternalSystemStartEventImpl parseStartEvent = new ExternalSystemStartEventImpl(parseEventId, parentId, (OperationDescriptor)parseTaskDescriptor);
        listener2.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(resolveTaskId, (ExternalSystemProgressEvent)parseStartEvent));
        return new EventData(parseEventId, (TaskOperationDescriptor)parseTaskDescriptor, (ExternalSystemStartEvent<? extends TaskOperationDescriptor>)((ExternalSystemStartEvent)parseStartEvent));
    }

    /*
     * WARNING - void declaration
     */
    private final CompDBModel reportModelResults(ExternalSystemTaskId resolveTaskId, EventData startEventData, ExternalSystemTaskNotificationListener listener2, String parentId, List<? extends CompDBModelResult> modelResults) {
        void $this$forEach$iv;
        Collection collection;
        Collection collection2;
        Iterable $this$filterIsInstance$iv;
        CompDBModel model;
        OperationResult parseEventResult;
        block9: {
            void $this$filterIsInstanceTo$iv$iv;
            Object v1;
            Iterator iterator;
            block8: {
                parseEventResult = null;
                if (modelResults.isEmpty()) {
                    String string = CompDBBundle.message("model.unexpected.error.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String message = string;
                    FailureImpl failure = new FailureImpl(message, message, CollectionsKt.emptyList());
                    parseEventResult = (OperationResult)new FailureResultImpl(startEventData.getStartEvent().getEventTime(), startEventData.getStartEvent().getEventTime(), CollectionsKt.listOf((Object)failure));
                }
                iterator = modelResults;
                Iterator iterator2 = iterator.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    CompDBModelResult it = (CompDBModelResult)t;
                    boolean bl = false;
                    if (!(it instanceof Success)) continue;
                    v1 = t;
                    break block8;
                }
                v1 = null;
            }
            Success success = v1;
            model = success != null ? success.getModel() : null;
            CompDBProjectResolver.Companion.logModelResults(modelResults, resolveTaskId, listener2);
            $this$filterIsInstance$iv = modelResults;
            boolean $i$f$filterIsInstance22 = false;
            iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof com.jetbrains.cidr.cpp.compdb.model.Failure)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = modelResults;
            collection2 = (List)destination$iv$iv2;
            Iterable $i$f$filterIsInstance22 = $this$filterIsInstance$iv;
            for (Collection destination$iv$iv2 : $i$f$filterIsInstance22) {
                CompDBModelResult it = (CompDBModelResult)((Object)destination$iv$iv2);
                boolean bl = false;
                if (!(it instanceof Success)) continue;
                collection = destination$iv$iv2;
                break block9;
            }
            collection = null;
        }
        $this$filterIsInstance$iv = CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)collection2, collection));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompDBModelResult it = (CompDBModelResult)element$iv;
            boolean bl = false;
            this.reportSingleModelResult(resolveTaskId, listener2, it, startEventData.getId());
        }
        if (model == null) {
            String string = CompDBBundle.message("project.resolver.general.error.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            FailureImpl failure = new FailureImpl(message, message, CollectionsKt.emptyList());
            parseEventResult = (OperationResult)new FailureResultImpl(startEventData.getStartEvent().getEventTime(), startEventData.getStartEvent().getEventTime(), CollectionsKt.listOf((Object)failure));
        }
        String string = startEventData.getId();
        OperationDescriptor operationDescriptor = (OperationDescriptor)startEventData.getDescriptor();
        OperationResult operationResult = parseEventResult;
        if (operationResult == null) {
            operationResult = (OperationResult)new SuccessResultImpl(startEventData.getStartEvent().getEventTime(), startEventData.getStartEvent().getEventTime(), true);
        }
        ExternalSystemFinishEventImpl parseFinishEvent = new ExternalSystemFinishEventImpl(string, parentId, operationDescriptor, operationResult);
        listener2.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(resolveTaskId, (ExternalSystemProgressEvent)parseFinishEvent));
        if (parseEventResult instanceof FailureResult) {
            List list = ((FailureResult)parseEventResult).getFailures();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFailures(...)");
            Object object = CollectionsKt.firstOrNull((List)list);
            Intrinsics.checkNotNull((Object)object);
            throw new IllegalStateException(((Failure)object).getMessage());
        }
        CompDBModel compDBModel = model;
        Intrinsics.checkNotNull((Object)compDBModel);
        return compDBModel;
    }

    private final void reportSingleModelResult(ExternalSystemTaskId resolveTaskId, ExternalSystemTaskNotificationListener listener2, CompDBModelResult modelResult, String parseEventId) {
        Pair<ExternalSystemStartEvent<?>, ExternalSystemFinishEvent<?>> pair = CompDBModelResultKt.toEvents(modelResult, parseEventId);
        ExternalSystemStartEvent startEvent = (ExternalSystemStartEvent)pair.component1();
        ExternalSystemFinishEvent finishEvent = (ExternalSystemFinishEvent)pair.component2();
        listener2.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(resolveTaskId, (ExternalSystemProgressEvent)startEvent));
        listener2.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(resolveTaskId, (ExternalSystemProgressEvent)finishEvent));
    }

    private final EventData reportImportStart(ExternalSystemTaskId resolveTaskId, ExternalSystemTaskNotificationListener listener2, String parentId) {
        String importEventId = "import:" + UUID.randomUUID();
        TaskOperationDescriptorImpl importTaskDescriptor = new TaskOperationDescriptorImpl(CompDBBundle.message("import.task.display.name", new Object[0]), System.currentTimeMillis(), "import-model");
        ExternalSystemStartEventImpl importStartEvent = new ExternalSystemStartEventImpl(importEventId, parentId, (OperationDescriptor)importTaskDescriptor);
        listener2.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(resolveTaskId, (ExternalSystemProgressEvent)importStartEvent));
        return new EventData(importEventId, (TaskOperationDescriptor)importTaskDescriptor, (ExternalSystemStartEvent<? extends TaskOperationDescriptor>)((ExternalSystemStartEvent)importStartEvent));
    }

    private final void reportImportFinish(ExternalSystemTaskId resolveTaskId, EventData startEventData, ExternalSystemTaskNotificationListener listener2, String parentId) {
        SuccessResultImpl importEventResult = new SuccessResultImpl(startEventData.getStartEvent().getEventTime(), System.currentTimeMillis(), true);
        ExternalSystemFinishEventImpl importFinishEvent = new ExternalSystemFinishEventImpl(startEventData.getId(), parentId, (OperationDescriptor)startEventData.getDescriptor(), (OperationResult)importEventResult);
        listener2.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(resolveTaskId, (ExternalSystemProgressEvent)importFinishEvent));
    }

    private final void reportUnresolvedCompilers(ExternalSystemTaskId resolveTaskId, Set<? extends File> unresolvedCompilers, ExternalSystemTaskNotificationListener listener2, String parentEventId) {
        if (unresolvedCompilers.isEmpty()) {
            return;
        }
        for (File file : unresolvedCompilers) {
            String message;
            Object[] objectArray = new Object[]{file};
            Intrinsics.checkNotNullExpressionValue((Object)CompDBBundle.message("project.resolver.cannot.resolve.compiler.error", objectArray), (String)"message(...)");
            listener2.onTaskOutput(resolveTaskId, message + "\n", false);
            CompDBLog.INSTANCE.getLOG().debug(message);
            String compilerEventId = "unresolved-compiler:" + UUID.randomUUID();
            TaskOperationDescriptorImpl compilerTaskDescriptor = new TaskOperationDescriptorImpl(message, System.currentTimeMillis(), "unresolved-compiler");
            ExternalSystemStartEventImpl compilerStartEvent = new ExternalSystemStartEventImpl(compilerEventId, parentEventId, (OperationDescriptor)compilerTaskDescriptor);
            FailureResultImpl compilerEventResult = new FailureResultImpl(compilerStartEvent.getEventTime(), compilerStartEvent.getEventTime(), CollectionsKt.listOf((Object)new FailureImpl(message, message, CollectionsKt.emptyList())));
            ExternalSystemFinishEventImpl compilerFinishEvent = new ExternalSystemFinishEventImpl(compilerEventId, parentEventId, (OperationDescriptor)compilerTaskDescriptor, (OperationResult)compilerEventResult);
            listener2.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(resolveTaskId, (ExternalSystemProgressEvent)compilerStartEvent));
            listener2.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(resolveTaskId, (ExternalSystemProgressEvent)compilerFinishEvent));
        }
    }

    static {
        Key key = Key.create((String)"COMPDB_PARENT_EVENT_ID");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PARENT_EVENT_ID_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/project/CompDBProjectResolver$Companion;", "", "()V", "PARENT_EVENT_ID_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPARENT_EVENT_ID_KEY", "()Lcom/intellij/openapi/util/Key;", "createStateData", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/jetbrains/cidr/cpp/compdb/project/CompDBStateData;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "logModelResults", "", "results", "", "Lcom/jetbrains/cidr/cpp/compdb/model/CompDBModelResult;", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "intellij.clion.compdb"})
    @SourceDebugExtension(value={"SMAP\nCompDBProjectResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompDBProjectResolver.kt\ncom/jetbrains/cidr/cpp/compdb/project/CompDBProjectResolver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,423:1\n800#2,11:424\n1855#2,2:435\n1855#2,2:438\n1#3:437\n*S KotlinDebug\n*F\n+ 1 CompDBProjectResolver.kt\ncom/jetbrains/cidr/cpp/compdb/project/CompDBProjectResolver$Companion\n*L\n398#1:424,11\n402#1:435,2\n411#1:438,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<String> getPARENT_EVENT_ID_KEY() {
            return PARENT_EVENT_ID_KEY;
        }

        @NotNull
        public final DataNode<CompDBStateData> createStateData(@NotNull CPPEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            CompDBStateData stateData = new CompDBStateData(environment.calcToolchainHash());
            return new DataNode(CompDBStateData.Companion.getCOMPDB_STATE_DATA_KEY(), (Object)stateData, null);
        }

        private final void logModelResults(List<? extends CompDBModelResult> results, ExternalSystemTaskId id, ExternalSystemTaskNotificationListener listener2) {
            Iterator $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = results;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                if (!(element$iv$iv instanceof com.jetbrains.cidr.cpp.compdb.model.Failure)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List failures = (List)destination$iv$iv;
            CompDBLog.INSTANCE.getLOG().debug("CompDB model parsing finished with " + failures.size() + " failures!");
            Iterable $this$forEach$iv = failures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                com.jetbrains.cidr.cpp.compdb.model.Failure it = (com.jetbrains.cidr.cpp.compdb.model.Failure)element$iv;
                boolean bl = false;
                listener2.onTaskOutput(id, it.getMessage() + "\n", false);
                CompDBLog.INSTANCE.getLOG().debug("Failure: " + it);
            }
            if (CompDBLog.INSTANCE.getLOG().isDebugEnabled()) {
                CompDBModel model;
                Object v0;
                block6: {
                    Iterable iterable2 = results;
                    Iterator it = iterable2.iterator();
                    while (it.hasNext()) {
                        Object bl = it.next();
                        CompDBModelResult it2 = (CompDBModelResult)bl;
                        boolean bl2 = false;
                        if (!(it2 instanceof Success)) continue;
                        v0 = bl;
                        break block6;
                    }
                    v0 = null;
                }
                Success success = v0;
                CompDBModel compDBModel = model = success != null ? success.getModel() : null;
                if (model != null) {
                    CompDBLog.INSTANCE.getLOG().debug("Parsed model: ");
                    Iterable $this$forEach$iv2 = model.getCommandObjects();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        CompDBModelCommandObject it = (CompDBModelCommandObject)element$iv;
                        boolean bl = false;
                        CompDBLog.INSTANCE.getLOG().debug(it.toString());
                    }
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

