/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.cidr.cpp.compdb.CompDBUtilKt;
import com.jetbrains.cidr.cpp.compdb.CompDBWorkspace;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBProjectSettings;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBSettings;
import com.jetbrains.cidr.cpp.external.system.CLionExternalUtilKt;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0007J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/CompDBUtil;", "", "()V", "changeLinkedProjectPath", "", "project", "Lcom/intellij/openapi/project/Project;", "newProjectPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "findDatabaseFile", "findDatabaseFiles", "", "isCompDBFile", "", "file", "isCompDBProject", "linkCompDBProject", "projectPath", "linkedProjectSettings", "", "Lcom/jetbrains/cidr/cpp/compdb/settings/CompDBProjectSettings;", "markAllCompDBProjectsDirty", "markProjectDirty", "", "intellij.clion.compdb"})
@SourceDebugExtension(value={"SMAP\nCompDBUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompDBUtil.kt\ncom/jetbrains/cidr/cpp/compdb/CompDBUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1549#2:96\n1620#2,3:97\n1603#2,9:100\n1855#2:109\n1856#2:111\n1612#2:112\n1603#2,9:113\n1855#2:122\n1856#2:124\n1612#2:125\n1855#2,2:126\n1#3:110\n1#3:123\n*S KotlinDebug\n*F\n+ 1 CompDBUtil.kt\ncom/jetbrains/cidr/cpp/compdb/CompDBUtil\n*L\n45#1:96\n45#1:97,3\n49#1:100,9\n49#1:109\n49#1:111\n49#1:112\n50#1:113,9\n50#1:122\n50#1:124\n50#1:125\n63#1:126,2\n49#1:110\n50#1:123\n*E\n"})
public final class CompDBUtil {
    @NotNull
    public static final CompDBUtil INSTANCE = new CompDBUtil();

    private CompDBUtil() {
    }

    public final boolean isCompDBFile(@Nullable VirtualFile file) {
        return file != null && !file.isDirectory() && StringUtil.equalsIgnoreCase((CharSequence)file.getName(), (CharSequence)"compile_commands.json");
    }

    public final boolean isCompDBProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !this.linkedProjectSettings(project).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<CompDBProjectSettings> linkedProjectSettings(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection collection = CompDBSettings.Companion.getInstance(project).getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompDBProjectSettings compDBProjectSettings = (CompDBProjectSettings)((Object)item$iv$iv);
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.compdb.settings.CompDBProjectSettings");
            collection2.add(it);
        }
        return (List)destination$iv$iv;
    }

    private final List<VirtualFile> findDatabaseFiles(Project project) {
        String it$iv$iv;
        boolean bl;
        Object it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.linkedProjectSettings(project);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (CompDBProjectSettings)((Object)element$iv$iv);
            boolean bl3 = false;
            if (it.getExternalProjectPath() == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (String)element$iv$iv;
            boolean bl4 = false;
            if (VfsUtil.findFileByIoFile((File)new File((String)it, "compile_commands.json"), (boolean)false) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final VirtualFile findDatabaseFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (VirtualFile)CollectionsKt.firstOrNull(this.findDatabaseFiles(project));
    }

    public final void markProjectDirty(@NotNull Project project, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(projectPath);
    }

    public final void markAllCompDBProjectsDirty(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$forEach$iv = this.linkedProjectSettings(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompDBProjectSettings it = (CompDBProjectSettings)((Object)element$iv);
            boolean bl = false;
            ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(it.getExternalProjectPath());
        }
    }

    @RequiresEdt
    public final void linkCompDBProject(@NotNull Project project, @NotNull VirtualFile projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        CompDBProjectSettings settings = CompDBProjectSettings.Companion.default();
        settings.setExternalProjectPath(projectPath.getPath());
        CompDBWorkspace workspace = CompDBWorkspace.Companion.getInstance(project);
        CLionExternalUtilKt.linkExternalProject((Project)project, (ProjectSystemId)CompDBUtilKt.getID(), (ExternalProjectSettings)settings, (ExternalWorkspace)workspace);
    }

    @RequiresEdt
    public final void changeLinkedProjectPath(@NotNull Project project, @NotNull VirtualFile newProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newProjectPath, (String)"newProjectPath");
        CompDBWorkspace workspace = CompDBWorkspace.Companion.getInstance(project);
        CLionExternalUtilKt.changeLinkedExternalProjectPath((Project)project, (ProjectSystemId)CompDBUtilKt.getID(), (VirtualFile)newProjectPath, (ExternalWorkspace)workspace);
    }
}

