/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.treetable;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.treetable.ColumnNode;
import com.intellij.database.run.ui.treetable.LazyValueWrapper;
import com.intellij.database.run.ui.treetable.Node;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b0\nH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/run/ui/treetable/ColumnsWrapper;", "Lcom/intellij/database/run/ui/treetable/LazyValueWrapper;", "Lcom/intellij/database/run/ui/treetable/Node;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "rowIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/database/datagrid/ModelIndex;)V", "children", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "Lcom/intellij/database/datagrid/GridColumn;", "", "createChildren", "", "createValue", "", "estimateChildCount", "", "estimateIsLeaf", "", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nValueWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueWrapper.kt\ncom/intellij/database/run/ui/treetable/ColumnsWrapper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,142:1\n1155#2,3:143\n*S KotlinDebug\n*F\n+ 1 ValueWrapper.kt\ncom/intellij/database/run/ui/treetable/ColumnsWrapper\n*L\n111#1:143,3\n*E\n"})
public final class ColumnsWrapper
extends LazyValueWrapper<Node> {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final ModelIndex<GridRow> rowIdx;

    public ColumnsWrapper(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(rowIdx, (String)"rowIdx");
        this.grid = grid;
        this.rowIdx = rowIdx;
    }

    @Override
    @NotNull
    protected String createValue() {
        ObjectFormatter formatter = this.grid.getObjectFormatter();
        ObjectFormatterMode objectFormatterMode = GridHelper.get(this.grid).getDefaultMode();
        Intrinsics.checkNotNullExpressionValue((Object)objectFormatterMode, (String)"getDefaultMode(...)");
        ObjectFormatterMode mode = objectFormatterMode;
        return SequencesKt.joinToString$default((Sequence)SequencesKt.take(this.children(), (int)100), null, (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)((Function1)new Function1<Pair<? extends GridColumn, ? extends Object>, CharSequence>(formatter, mode){
            final /* synthetic */ ObjectFormatter $formatter;
            final /* synthetic */ ObjectFormatterMode $mode;
            {
                this.$formatter = $formatter;
                this.$mode = $mode;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Pair<? extends GridColumn, ? extends Object> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                GridColumn column = (GridColumn)pair.component1();
                Object value = pair.component2();
                ObjectFormatter objectFormatter = this.$formatter;
                Intrinsics.checkNotNullExpressionValue((Object)objectFormatter, (String)"$formatter");
                String json = JsonUtilKt.toJson$default((Object)value, (ObjectFormatter)objectFormatter, (ObjectFormatterMode)this.$mode, (boolean)false, (boolean)false, (boolean)false, (int)56, null);
                String string = column.getName();
                ObjectFormatter objectFormatter2 = this.$formatter;
                Intrinsics.checkNotNullExpressionValue((Object)objectFormatter2, (String)"$formatter");
                return JsonUtilKt.toJson$default((Object)string, (ObjectFormatter)objectFormatter2, (ObjectFormatterMode)this.$mode, (boolean)false, (boolean)false, (boolean)false, (int)56, null) + ": " + json;
            }
        }), (int)25, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<Node> createChildren() {
        void var2_2;
        void $this$mapTo$iv;
        Sequence<Pair<GridColumn, Object>> sequence = this.children();
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Pair pair = (Pair)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            GridColumn column = (GridColumn)pair.component1();
            String string = column.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ModelIndex modelIndex = ModelIndex.forColumn((CoreGrid)this.grid, (int)column.getColumnNumber());
            Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"forColumn(...)");
            collection.add(new ColumnNode(string, this.grid, this.rowIdx, (ModelIndex<GridColumn>)modelIndex));
        }
        return (List)var2_2;
    }

    private final Sequence<Pair<GridColumn, Object>> children() {
        GridModel gridModel = this.grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel model2 = gridModel;
        GridRow gridRow = (GridRow)model2.getRow(this.rowIdx);
        if (gridRow == null) {
            return SequencesKt.emptySequence();
        }
        GridRow row = gridRow;
        JBIterable jBIterable = model2.getColumnsAsIterable();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getColumnsAsIterable(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)jBIterable)), (Function1)((Function1)new Function1<GridColumn, Pair<? extends GridColumn, ? extends Object>>(row){
            final /* synthetic */ GridRow $row;
            {
                this.$row = $row;
                super(1);
            }

            @Nullable
            public final Pair<GridColumn, Object> invoke(GridColumn column) {
                Object value = column.getValue(this.$row);
                return value == ReservedCellValue.UNSET ? null : new Pair((Object)column, value);
            }
        }));
    }

    @Override
    protected int estimateChildCount() {
        return SequencesKt.count(this.children());
    }

    @Override
    protected boolean estimateIsLeaf() {
        return !SequencesKt.any(this.children());
    }
}

