/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ResultViewColumn;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0002H\u0096\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002R>\u0010\u000b\u001a2\u0012(\u0012&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010\u0012\u001af\u0012(\u0012&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r \u000f*1\u0012(\u0012&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r0\u0015\u00a2\u0006\u0002\b\u00140\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0016\u001a2\u0012(\u0012&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/run/ui/table/AdjustColumnsAfterMoveInData;", "Lkotlin/Function0;", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "tableView", "Lcom/intellij/database/run/ui/table/TableResultView;", "from", "", "to", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/database/run/ui/table/TableResultView;II)V", "columnWidths", "", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridColumn;", "kotlin.jvm.PlatformType", "fromBeforeTo", "", "originallyVisibleColumns", "", "Lorg/jetbrains/annotations/NotNull;", "", "sortOrder", "invoke", "toOriginalIndex", "idx", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nAdjustColumnsAfterMoveInData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdjustColumnsAfterMoveInData.kt\ncom/intellij/database/run/ui/table/AdjustColumnsAfterMoveInData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1620#2,3:97\n1179#2,2:100\n1253#2,4:102\n1864#2,3:106\n1855#2,2:109\n*S KotlinDebug\n*F\n+ 1 AdjustColumnsAfterMoveInData.kt\ncom/intellij/database/run/ui/table/AdjustColumnsAfterMoveInData\n*L\n19#1:97,3\n25#1:100,2\n25#1:102,4\n81#1:106,3\n87#1:109,2\n*E\n"})
public final class AdjustColumnsAfterMoveInData
implements Function0<Unit> {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final TableResultView tableView;
    private final int from;
    private final int to;
    @NotNull
    private final Set<ModelIndex<GridColumn>> originallyVisibleColumns;
    @NotNull
    private final Map<ModelIndex<GridColumn>, Integer> columnWidths;
    @NotNull
    private final Map<ModelIndex<GridColumn>, Integer> sortOrder;
    private final boolean fromBeforeTo;

    /*
     * WARNING - void declaration
     */
    public AdjustColumnsAfterMoveInData(@NotNull DataGrid grid, @NotNull TableResultView tableView, int from, int to) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void destination$iv;
        Iterable $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)tableView, (String)"tableView");
        this.grid = grid;
        this.tableView = tableView;
        this.from = from;
        this.to = to;
        Set set = this.grid.getVisibleColumns().asIterable().toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
        this.originallyVisibleColumns = set;
        Iterable iterable = this.originallyVisibleColumns;
        Collection collection = new ArrayList();
        AdjustColumnsAfterMoveInData adjustColumnsAfterMoveInData = this;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void modelIndex;
            ModelIndex modelIndex2 = (ModelIndex)item$iv;
            void var17_18 = destination$iv;
            boolean bl = false;
            ResultViewColumn resultViewColumn = this.tableView.getLayoutColumn((ModelIndex<?>)modelIndex);
            int width = resultViewColumn != null ? resultViewColumn.getColumnWidth() : 0;
            var17_18.add(new Pair((Object)modelIndex, (Object)width));
        }
        adjustColumnsAfterMoveInData.columnWidths = MapsKt.toMap((Iterable)((Iterable)destination$iv));
        List list = this.grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        $this$mapTo$iv = list;
        adjustColumnsAfterMoveInData = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterator iterator = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            GridColumn it = (GridColumn)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)ModelIndex.forColumn((CoreGrid)this.grid, (int)it.getColumnNumber()), (Object)this.grid.getSortOrder(it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        adjustColumnsAfterMoveInData.sortOrder = destination$iv$iv;
        this.fromBeforeTo = this.from < this.to;
    }

    private final int toOriginalIndex(int idx) {
        int left = Math.min(this.from, this.to);
        int right = Math.max(this.from, this.to);
        if (idx < left || idx > right) {
            return idx;
        }
        if (idx == this.to) {
            return this.from;
        }
        return this.fromBeforeTo ? idx + 1 : idx - 1;
    }

    private final ModelIndex<GridColumn> toOriginalIndex(ModelIndex<GridColumn> idx) {
        ModelIndex modelIndex = ModelIndex.forColumn((CoreGrid)this.grid, (int)this.toOriginalIndex(idx.value));
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"forColumn(...)");
        return modelIndex;
    }

    public void invoke() {
        ModelIndex modelIndex;
        ModelIndexSet modelIndexSet = this.grid.getDataModel(DataAccessType.DATABASE_DATA).getColumnIndices();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndexSet, (String)"getColumnIndices(...)");
        ModelIndexSet columnIndices = modelIndexSet;
        for (ModelIndex columnIdx : columnIndices.asIterable()) {
            this.grid.setColumnEnabled(columnIdx, true);
        }
        int[] currentOrder = this.grid.getVisibleColumns().asArray();
        int n = currentOrder.length;
        for (int i = 0; i < n; ++i) {
            int min = Integer.MAX_VALUE;
            int argMin = -1;
            for (int j = i; j < n; ++j) {
                if (currentOrder[j] >= min) continue;
                min = currentOrder[j];
                argMin = j;
            }
            if (argMin == -1 || argMin == i) continue;
            this.tableView.moveColumn(i, argMin);
            currentOrder = this.grid.getVisibleColumns().asArray();
        }
        for (ModelIndex columnIdx : columnIndices.asIterable()) {
            Intrinsics.checkNotNull((Object)columnIdx);
            ModelIndex<GridColumn> originalIndex = this.toOriginalIndex((ModelIndex<GridColumn>)columnIdx);
            this.grid.setColumnEnabled(columnIdx, this.originallyVisibleColumns.contains(originalIndex));
        }
        JBIterable jBIterable = this.grid.getVisibleColumns().asIterable();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"asIterable(...)");
        Iterable $this$forEachIndexed$iv = (Iterable)jBIterable;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ModelIndex modelIndex2 = (ModelIndex)item$iv;
            int viewIndex = n2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)modelIndex);
            ModelIndex<GridColumn> originalIndex = this.toOriginalIndex((ModelIndex<GridColumn>)modelIndex);
            ResultViewColumn resultViewColumn = this.tableView.getLayoutColumn(modelIndex);
            if (resultViewColumn == null) continue;
            Integer n3 = this.columnWidths.get(originalIndex);
            Intrinsics.checkNotNull((Object)n3);
            resultViewColumn.setColumnWidth(((Number)n3).intValue());
        }
        List list = this.grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GridColumn it = (GridColumn)element$iv;
            boolean bl = false;
            modelIndex = ModelIndex.forColumn((CoreGrid)this.grid, (int)it.getColumnNumber());
            Intrinsics.checkNotNull((Object)modelIndex);
            ModelIndex<GridColumn> originalIndex = this.toOriginalIndex((ModelIndex<GridColumn>)modelIndex);
            Integer n4 = this.sortOrder.get(originalIndex);
            this.grid.getColumnAttributes().setSortOrder(it, n4 != null ? n4 : 0);
        }
        this.grid.updateSortKeysFromColumnAttributes();
        this.grid.getLocalFilterState().shiftColumns((ModelIndexSet<GridColumn>)columnIndices, (Function1<? super ModelIndex<GridColumn>, ? extends ModelIndex<GridColumn>>)((Function1)new Function1<ModelIndex<GridColumn>, ModelIndex<GridColumn>>((Object)this){

            @NotNull
            public final ModelIndex<GridColumn> invoke(@NotNull ModelIndex<GridColumn> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return AdjustColumnsAfterMoveInData.access$toOriginalIndex((AdjustColumnsAfterMoveInData)this.receiver, p0);
            }
        }));
        this.tableView.updateRowFilter();
    }

    public static final /* synthetic */ ModelIndex access$toOriginalIndex(AdjustColumnsAfterMoveInData $this, ModelIndex idx) {
        return $this.toOriginalIndex((ModelIndex<GridColumn>)idx);
    }
}

