/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.DataGridSearchSessionWorker;
import com.intellij.database.run.ui.grid.GridSearchSession;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.EditorHeaderToggleAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.ClientProperty;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.JComponent;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridSearchSession
implements GridSearchSession<GridRow, GridColumn>,
DataProvider,
SearchReplaceComponent.Listener,
FindModel.FindModelObserver,
Disposable {
    private static final String FILTERING_ENABLED_PROPERTY = "grid.search.filter.rows";
    private final Project myProject;
    private final DataGrid myGrid;
    private final FindModel myFindModel;
    private final SearchReplaceComponent mySearchComponent;
    private final Component myPreviousFilterComponent;
    private final EventDispatcher<GridSearchSession.Listener> myDispatcher;
    private boolean myFilteringEnabled;
    private final DataGridSearchSessionWorker worker;
    private final CoroutineScope myCoroutineScope;

    public DataGridSearchSession(@NotNull Project project, @NotNull DataGrid grid, @NotNull FindModel findModel, @Nullable Component previousFilterComponent) {
        if (project == null) {
            DataGridSearchSession.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            DataGridSearchSession.$$$reportNull$$$0(1);
        }
        if (findModel == null) {
            DataGridSearchSession.$$$reportNull$$$0(2);
        }
        this.myDispatcher = EventDispatcher.create(GridSearchSession.Listener.class);
        this.myProject = project;
        this.myGrid = grid;
        this.myFindModel = findModel;
        this.myPreviousFilterComponent = previousFilterComponent;
        this.myFindModel.addObserver((FindModel.FindModelObserver)this);
        this.mySearchComponent = this.createSearchComponent();
        DataGridSearchSession.applyFindModel(this.mySearchComponent, this.myFindModel);
        this.myCoroutineScope = CoroutineScopeKt.childScope((CoroutineScope)grid.getCoroutineScope(), (String)this.getClass().getName(), (CoroutineContext)Dispatchers.getDefault(), (boolean)true);
        Disposer.register((Disposable)grid, (Disposable)this);
        this.worker = new DataGridSearchSessionWorker(this.myCoroutineScope, grid, FindManager.getInstance((Project)this.myProject), this.myFindModel);
        this.worker.submitStartSearch();
        this.worker.subscribeOnUpdateEDT((Function0<Unit>)((Function0)() -> {
            FindUtil.updateFindInFileModel((Project)this.myProject, (FindModel)this.myFindModel, (boolean)true);
            this.fireSessionUpdated();
            String stringToFind = this.myFindModel.getStringToFind();
            boolean incorrectRegex = this.myFindModel.isRegularExpressions() && this.myFindModel.compileRegExp() == null;
            boolean hasMatches = this.hasMatches();
            if (incorrectRegex || StringUtil.isNotEmpty((String)stringToFind) && !hasMatches) {
                this.mySearchComponent.setNotFoundBackground();
            } else {
                this.mySearchComponent.setRegularBackground();
            }
            this.mySearchComponent.setStatusText(incorrectRegex ? FindBundle.message((String)"find.incorrect.regexp", (Object[])new Object[0]) : "");
            this.mySearchComponent.update(stringToFind, "", false, this.myFindModel.isMultiline());
            if (hasMatches) {
                this.selectOccurrence(true, DataGridSearchSessionWorker.SearchDirection.FORWARD);
            }
            return Unit.INSTANCE;
        }), this.myCoroutineScope);
        grid.addDataGridListener(new DataGridListener(){

            @Override
            public void onContentChanged(DataGrid dataGrid, // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable GridRequestSource.RequestPlace place) {
                DataGridSearchSession.this.worker.submitStartSearch();
            }

            @Override
            public void onCellDisplayTypeChanged(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull DisplayType type) {
                if (columnIdx == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                DataGridSearchSession.this.worker.submitStartSearch();
            }

            @Override
            public void onCellLanguageChanged(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull Language language) {
                if (columnIdx == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (language == null) {
                    1.$$$reportNull$$$0(3);
                }
                DataGridSearchSession.this.worker.submitStartSearch();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "columnIdx";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "language";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/ui/grid/DataGridSearchSession$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onCellDisplayTypeChanged";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onCellLanguageChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
        this.myFilteringEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(FILTERING_ENABLED_PROPERTY);
        this.myGrid.getPanel().setSecondTopComponent((Component)this.mySearchComponent);
        this.myGrid.searchSessionStarted(this);
        ClientProperty.put((JComponent)this.mySearchComponent, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<Component>(){

            @Override
            @NotNull
            public Iterator<Component> iterator() {
                Component component = DataGridSearchSession.this.myPreviousFilterComponent;
                if (component != null && component.getParent() == null) {
                    Iterator<Component> iterator = Collections.singleton(component).iterator();
                    if (iterator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return iterator;
                }
                Iterator<Component> iterator = Collections.emptyIterator();
                if (iterator == null) {
                    2.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession$2", "iterator"));
            }
        });
    }

    @Override
    @Nullable
    public Component getPreviousFilterComponent() {
        return this.myPreviousFilterComponent;
    }

    private static void applyFindModel(@NotNull SearchReplaceComponent component, @NotNull FindModel findModel) {
        if (component == null) {
            DataGridSearchSession.$$$reportNull$$$0(3);
        }
        if (findModel == null) {
            DataGridSearchSession.$$$reportNull$$$0(4);
        }
        component.getSearchTextComponent().setText(findModel.getStringToFind());
    }

    @NotNull
    private SearchReplaceComponent createSearchComponent() {
        SearchReplaceComponent searchReplaceComponent = SearchReplaceComponent.buildFor((Project)this.myProject, (JComponent)this.myGrid.getPanel().getComponent()).addPrimarySearchActions(new AnAction[]{new PrevOccurrenceAction(), new NextOccurrenceAction()}).addExtraSearchActions(new AnAction[]{new ToggleMatchCase(), new ToggleRegex(), new ToggleWholeWordsOnlyAction(), new ToggleFilteringAction(), new StatusTextAction()}).withCloseAction(this::close).withDataProvider((DataProvider)this).build();
        searchReplaceComponent.addListener((SearchReplaceComponent.Listener)this);
        SearchReplaceComponent searchReplaceComponent2 = searchReplaceComponent;
        if (searchReplaceComponent2 == null) {
            DataGridSearchSession.$$$reportNull$$$0(5);
        }
        return searchReplaceComponent2;
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        SearchReplaceComponent searchReplaceComponent = this.mySearchComponent;
        if (searchReplaceComponent == null) {
            DataGridSearchSession.$$$reportNull$$$0(6);
        }
        return searchReplaceComponent;
    }

    @Override
    public boolean isMatchedCell(@NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (rowIdx == null) {
            DataGridSearchSession.$$$reportNull$$$0(7);
        }
        if (columnIdx == null) {
            DataGridSearchSession.$$$reportNull$$$0(8);
        }
        return this.worker.isMatchedCell(rowIdx, columnIdx);
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.myFilteringEnabled && this.isFilteringAvailable();
    }

    @Override
    public void addListener(@NotNull GridSearchSession.Listener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            DataGridSearchSession.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            DataGridSearchSession.$$$reportNull$$$0(10);
        }
        this.myDispatcher.addListener((EventListener)listener2, parent);
    }

    public void searchFieldDocumentChanged() {
        String textToFind = this.mySearchComponent.getSearchTextComponent().getText();
        this.myFindModel.setStringToFind(textToFind);
        this.myFindModel.setMultiline(textToFind.contains("\n"));
    }

    public void multilineStateChanged() {
        this.myFindModel.setMultiline(this.mySearchComponent.isMultiline());
    }

    @NotNull
    public FindModel getFindModel() {
        FindModel findModel = this.myFindModel;
        if (findModel == null) {
            DataGridSearchSession.$$$reportNull$$$0(11);
        }
        return findModel;
    }

    public boolean hasMatches() {
        return this.worker.getOccurence(true, DataGridSearchSessionWorker.SearchDirection.FORWARD) != null;
    }

    public void searchForward() {
        this.selectOccurrence(false, DataGridSearchSessionWorker.SearchDirection.FORWARD);
    }

    public void searchBackward() {
        this.selectOccurrence(false, DataGridSearchSessionWorker.SearchDirection.BACKWARD);
    }

    public boolean isSearchInProgress() {
        return !this.worker.hasInfo();
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DataGridSearchSession.$$$reportNull$$$0(12);
        }
        if (SearchSession.KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    public void findModelChanged(FindModel findModel) {
        this.worker.submitStartSearch();
    }

    public void close() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myGrid.getPreferredFocusedComponent(), false);
        this.myGrid.getPanel().setSecondTopComponent(this.myPreviousFilterComponent);
        this.myGrid.searchSessionStopped(this);
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)this.myCoroutineScope, null);
    }

    private void fireSessionUpdated() {
        ((GridSearchSession.Listener)this.myDispatcher.getMulticaster()).searchSessionUpdated();
    }

    private boolean isFilteringAvailable() {
        return this.myGrid.getPresentationMode() == GridPresentationMode.TABLE && !this.myGrid.getResultView().isTransposed();
    }

    private void selectOccurrence(boolean selectCurrent, DataGridSearchSessionWorker.SearchDirection direction) {
        Pair<ModelIndex<GridRow>, ModelIndex<GridColumn>> cell = this.worker.getOccurence(selectCurrent, direction);
        if (cell != null) {
            SelectionModel selectionModel = this.myGrid.getSelectionModel();
            selectionModel.setSelection((ModelIndex)cell.getFirst(), (ModelIndex)cell.getSecond());
        }
    }

    public static void configureFindModel(@NotNull DataGrid grid, @NotNull FindModel model2) {
        if (grid == null) {
            DataGridSearchSession.$$$reportNull$$$0(13);
        }
        if (model2 == null) {
            DataGridSearchSession.$$$reportNull$$$0(14);
        }
        FindUtil.configureFindModel((boolean)false, (FindModel)model2, (boolean)false, (String)DataGridSearchSession.getSelectedText(grid));
    }

    private static String getSelectedText(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridSearchSession.$$$reportNull$$$0(15);
        }
        ModelIndex row = grid.getSelectionModel().getLeadSelectionRow();
        ModelIndex column = grid.getSelectionModel().getLeadSelectionColumn();
        if (!row.isValid((CoreGrid)grid) || !column.isValid((CoreGrid)grid)) {
            return null;
        }
        GridModel model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        GridColumn c = (GridColumn)model2.getColumn(column);
        if (c == null) {
            return null;
        }
        return grid.getObjectFormatter().objectToString(model2.getValueAt(row, column), c, GridUtil.getConfigProvider(grid).apply(c.getColumnNumber()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/DataGridSearchSession";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/DataGridSearchSession";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFindModel";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMatchedCell";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "configureFindModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 11 -> new IllegalStateException(string);
        };
    }

    private class ToggleFilteringAction
    extends EditorHeaderToggleAction {
        protected ToggleFilteringAction() {
            super(DataGridBundle.message((String)"checkbox.filter.rows", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleFilteringAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(DataGridSearchSession.this.isFilteringAvailable());
            super.update(e);
        }

        protected boolean isSelected(@NotNull SearchSession session) {
            if (session == null) {
                ToggleFilteringAction.$$$reportNull$$$0(1);
            }
            return DataGridSearchSession.this.myFilteringEnabled && DataGridSearchSession.this.isFilteringAvailable();
        }

        protected void setSelected(@NotNull SearchSession session, boolean selected) {
            if (session == null) {
                ToggleFilteringAction.$$$reportNull$$$0(2);
            }
            boolean wasEnabled = DataGridSearchSession.this.myFilteringEnabled;
            DataGridSearchSession.this.myFilteringEnabled = selected;
            if (wasEnabled != selected) {
                DataGridSearchSession.this.fireSessionUpdated();
            }
            if (DataGridSearchSession.this.myProject != null) {
                PropertiesComponent.getInstance((Project)DataGridSearchSession.this.myProject).setValue(DataGridSearchSession.FILTERING_ENABLED_PROPERTY, DataGridSearchSession.this.myFilteringEnabled);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/DataGridSearchSession$ToggleFilteringAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

