/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.run.ui.MinimizedFormat;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\r\u0012\u0004\u0012\u00020\n0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/run/ui/MongoJSFormat;", "Lcom/intellij/database/run/ui/MinimizedFormat;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "value", "", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/database/datagrid/DataGrid;Ljava/lang/Object;Lcom/intellij/openapi/editor/Document;)V", "reformat", "", "disableUpdateListener", "Lkotlin/Function1;", "Lkotlin/Function0;", "restore", "", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.grid.impl"})
public final class MongoJSFormat
implements MinimizedFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGrid grid;
    @Nullable
    private final Object value;
    @NotNull
    private final Document document;

    public MongoJSFormat(@NotNull DataGrid grid, @Nullable Object value, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.grid = grid;
        this.value = value;
        this.document = document;
    }

    @Override
    @NotNull
    public String restore(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Override
    public void reformat(@NotNull Function1<? super Function0<Unit>, Unit> disableUpdateListener) {
        Intrinsics.checkNotNullParameter(disableUpdateListener, (String)"disableUpdateListener");
        ObjectFormatter objectFormatter = this.grid.getObjectFormatter();
        Intrinsics.checkNotNullExpressionValue((Object)objectFormatter, (String)"getObjectFormatter(...)");
        String formatted = JsonUtilKt.toJson$default((Object)this.value, (ObjectFormatter)objectFormatter, (ObjectFormatterMode)ObjectFormatterMode.JS_SCRIPT, (boolean)true, (boolean)false, (boolean)false, (int)48, null);
        disableUpdateListener.invoke((Object)new Function0<Unit>(this, formatted){
            final /* synthetic */ MongoJSFormat this$0;
            final /* synthetic */ String $formatted;
            {
                this.this$0 = $receiver;
                this.$formatted = $formatted;
                super(0);
            }

            public final void invoke() {
                MongoJSFormat.access$getDocument$p(this.this$0).setText((CharSequence)this.$formatted);
            }
        });
    }

    public static final /* synthetic */ Document access$getDocument$p(MongoJSFormat $this) {
        return $this.document;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/run/ui/MongoJSFormat$Companion;", "", "()V", "detect", "Lcom/intellij/database/run/ui/MongoJSFormat;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "value", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MongoJSFormat detect(@NotNull DataGrid grid, @Nullable Object value, @NotNull Project project, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            PsiFile psiFile = file;
            return Intrinsics.areEqual((Object)(psiFile != null && (psiFile = psiFile.getLanguage()) != null ? psiFile.getID() : null), (Object)"MongoJS") && (value instanceof List || value instanceof Map) ? new MongoJSFormat(grid, value, document) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

