/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorsHelper;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.settings.CsvSettings;
import com.intellij.database.util.DataGridUIUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseExtractorAction
extends ActionGroup
implements GridAction,
DumbAware {
    private final String myPopupGroupId;

    public ChooseExtractorAction() {
        this("Console.TableResult.ChooseExtractor.Group");
    }

    public ChooseExtractorAction(@NotNull String popupGroupId) {
        if (popupGroupId == null) {
            ChooseExtractorAction.$$$reportNull$$$0(0);
        }
        this.setPopup(true);
        this.getTemplatePresentation().setPerformGroup(true);
        this.myPopupGroupId = popupGroupId;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (AnAction.EMPTY_ARRAY == null) {
            ChooseExtractorAction.$$$reportNull$$$0(1);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChooseExtractorAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            ChooseExtractorAction.$$$reportNull$$$0(3);
        }
        boolean enabled = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
        if (!enabled || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            Presentation p = e.getPresentation();
            Presentation tp = this.getTemplatePresentation();
            p.setText(tp.getText());
            p.setDescription(tp.getDescription());
            return;
        }
        List scripts = DataExtractorFactories.getExtractorScripts((ExtractorsHelper)ExtractorsHelper.getInstance((CoreGrid)dataGrid), null);
        String displayName = DataExtractorFactories.getDisplayName((DataExtractorFactory)DataExtractorFactories.getExtractorFactory((CoreGrid)dataGrid, GridUtil::suggestPlugin), (List)scripts);
        String trimmedName = StringUtil.firstLast((String)displayName, (int)24);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setText(this.getTemplatePresentation().getText() + " (" + trimmedName + ")", false);
        } else {
            e.getPresentation().setText(trimmedName, false);
            e.getPresentation().setDescription(displayName);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        InputEvent inputEvent;
        if (e == null) {
            ChooseExtractorAction.$$$reportNull$$$0(4);
        }
        JComponent button = (inputEvent = e.getInputEvent()) == null ? null : (JComponent)ObjectUtils.tryCast((Object)inputEvent.getSource(), JComponent.class);
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction(this.myPopupGroupId);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(DataGridBundle.message((String)"settings.ChooseExtractorAction.title", (Object[])new Object[0]), actionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        popup.setAdText(this.toHtml(DataGridBundle.message((String)"settings.extractors.PopupAd", (Object[])new Object[0])), 2);
        if (button != null) {
            popup.showUnderneathOf((Component)button);
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    @Nls
    @NotNull
    protected String toHtml(@Nls @NotNull String text) {
        if (text == null) {
            ChooseExtractorAction.$$$reportNull$$$0(5);
        }
        String string = "<html>" + text.replaceAll("\n", "<br>") + "</html>";
        if (string == null) {
            ChooseExtractorAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupGroupId";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6 -> new IllegalStateException(string);
        };
    }

    public static class GoToScriptsDirectoryAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                GoToScriptsDirectoryAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoToScriptsDirectoryAction.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            File scriptsDir = ExtractorScripts.getExtractorScriptsDirectory();
            e.getPresentation().setEnabledAndVisible(project != null && scriptsDir != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GoToScriptsDirectoryAction.$$$reportNull$$$0(2);
            }
            Project project = e.getProject();
            File scriptsDir = ExtractorScripts.getExtractorScriptsDirectory();
            if (project == null || scriptsDir == null) {
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(scriptsDir);
                if (virtualFile == null) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, -1).navigate(true));
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction$GoToScriptsDirectoryAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$GoToScriptsDirectoryAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class SelectExtractorAction
    extends ToggleAction
    implements DumbAware {
        private final DataExtractorFactory factory;
        private final Consumer<AnActionEvent> myOnExtractorSelected;

        public SelectExtractorAction(@NotNull DataExtractorFactory factory, List<? extends DataExtractorFactory> factories, @Nullable Consumer<AnActionEvent> onExtractorSelected) {
            if (factory == null) {
                SelectExtractorAction.$$$reportNull$$$0(0);
            }
            super(StringUtil.escapeMnemonics((String)DataExtractorFactories.getDisplayName((DataExtractorFactory)factory, factories)));
            this.factory = factory;
            this.myOnExtractorSelected = onExtractorSelected;
            this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfRequested);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SelectExtractorAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            DataGrid dataGrid;
            if (e == null) {
                SelectExtractorAction.$$$reportNull$$$0(2);
            }
            if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return false;
            }
            return DataExtractorFactories.getExtractorFactory((CoreGrid)dataGrid, GridUtil::suggestPlugin).getId().equals(this.factory.getId());
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            DataGrid dataGrid;
            if (e == null) {
                SelectExtractorAction.$$$reportNull$$$0(3);
            }
            if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            DataExtractorFactories.setExtractorFactory((CoreGrid)dataGrid, (DataExtractorFactory)this.factory);
            Project project = dataGrid.getProject();
            DataExtractorProperties.setCurrentExportExtractorFactory((Project)project, (DataExtractorFactory)this.factory);
            DataExtractorProperties.setCurrentExtractorFactory((Project)project, (DataExtractorFactory)this.factory);
            if (this.myOnExtractorSelected != null) {
                this.myOnExtractorSelected.accept(e);
            }
            DataGridUIUtil.updateAllToolbarsUnder((Component)dataGrid.getPanel().getComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction$SelectExtractorAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$SelectExtractorAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class ScriptedGroup
    extends GroupBase {
        @Override
        @NotNull
        protected JBIterable<AnAction> getChildrenImpl(@NotNull DataGrid grid, BiFunction<? super DataExtractorFactory, List<? extends DataExtractorFactory>, ? extends AnAction> function) {
            if (grid == null) {
                ScriptedGroup.$$$reportNull$$$0(0);
            }
            List factories = DataExtractorFactories.getExtractorScripts((ExtractorsHelper)ExtractorsHelper.getInstance((CoreGrid)grid), GridUtil::suggestPlugin);
            JBIterable jBIterable = JBIterable.of((Object)Separator.create((String)DataGridBundle.message((String)"settings.extractors.ScriptExtractors", (Object[])new Object[0]))).append((Iterable)JBIterable.from((Iterable)factories).sort(Comparator.comparing(s -> StringUtil.toLowerCase((String)s.getName()))).filter(DataExtractorFactory.class).map(f -> (AnAction)function.apply((DataExtractorFactory)f, factories)));
            if (jBIterable == null) {
                ScriptedGroup.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction$ScriptedGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$ScriptedGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildrenImpl";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class CsvGroup
    extends GroupBase {
        @Override
        @NotNull
        protected JBIterable<AnAction> getChildrenImpl(@NotNull DataGrid grid, BiFunction<? super DataExtractorFactory, List<? extends DataExtractorFactory>, ? extends AnAction> function) {
            if (grid == null) {
                CsvGroup.$$$reportNull$$$0(0);
            }
            List factories = DataExtractorFactories.getCsvFormats((CsvFormatsSettings)CsvSettings.getSettings());
            JBIterable jBIterable = JBIterable.of((Object)Separator.create((String)DataGridBundle.message((String)"settings.extractors.CSV", (Object[])new Object[0]))).append((Iterable)JBIterable.from((Iterable)factories).filter(DataExtractorFactory.class).map(f -> (AnAction)function.apply((DataExtractorFactory)f, factories)));
            if (jBIterable == null) {
                CsvGroup.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction$CsvGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$CsvGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildrenImpl";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class BuiltInGroup
    extends GroupBase {
        @Override
        @NotNull
        protected JBIterable<AnAction> getChildrenImpl(@NotNull DataGrid grid, BiFunction<? super DataExtractorFactory, List<? extends DataExtractorFactory>, ? extends AnAction> function) {
            if (grid == null) {
                BuiltInGroup.$$$reportNull$$$0(0);
            }
            List factories = JBIterable.from((Iterable)DataExtractorFactories.getBuiltInFactories((CoreGrid)grid)).filter(DataExtractorFactory.class).filter(DataExtractorFactory::supportsText).toList();
            JBIterable jBIterable = JBIterable.of((Object)Separator.create((String)DataGridBundle.message((String)"settings.extractors.BuiltIn", (Object[])new Object[0]))).append((Iterable)JBIterable.from((Iterable)factories).map(f -> (AnAction)function.apply((DataExtractorFactory)f, factories)));
            if (jBIterable == null) {
                BuiltInGroup.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction$BuiltInGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$BuiltInGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildrenImpl";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class GroupBase
    extends ActionGroup
    implements DumbAware {
        private GroupBase() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                GroupBase.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            DataGrid dataGrid;
            DataGrid dataGrid2 = dataGrid = e == null ? null : (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            if (dataGrid == null) {
                if (EMPTY_ARRAY == null) {
                    GroupBase.$$$reportNull$$$0(1);
                }
                return EMPTY_ARRAY;
            }
            JBIterable<AnAction> children2 = this.getChildrenImpl(dataGrid, (factory, factories) -> GroupBase.createAction(factory, factories, dataGrid));
            if ("EditorPopup".equals(e.getPlace())) {
                AnAction[] anActionArray = (AnAction[])children2.map(o -> o instanceof Separator ? Separator.getInstance() : o).toArray((Object[])EMPTY_ARRAY);
                if (anActionArray == null) {
                    GroupBase.$$$reportNull$$$0(2);
                }
                return anActionArray;
            }
            AnAction[] anActionArray = (AnAction[])children2.toArray((Object[])EMPTY_ARRAY);
            if (anActionArray == null) {
                GroupBase.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        @NotNull
        private static SelectExtractorAction createAction(@NotNull DataExtractorFactory factory, List<? extends DataExtractorFactory> factories, @NotNull DataGrid grid) {
            if (factory == null) {
                GroupBase.$$$reportNull$$$0(4);
            }
            if (grid == null) {
                GroupBase.$$$reportNull$$$0(5);
            }
            return new SelectExtractorAction(factory, factories, e -> GridHelper.get(grid).syncExtractorsInNotebook(grid, factory));
        }

        @NotNull
        protected abstract JBIterable<AnAction> getChildrenImpl(@NotNull DataGrid var1, BiFunction<? super DataExtractorFactory, List<? extends DataExtractorFactory>, ? extends AnAction> var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction$GroupBase";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$GroupBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createAction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

