/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.BaseExtractorsHelper;
import com.intellij.database.extractors.DataAggregatorFactory;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ExtractorsHelper;
import com.intellij.database.run.ui.AggregateView;
import com.intellij.database.run.ui.AggregatesTabInfoProvider;
import com.intellij.database.run.ui.Aggregator;
import com.intellij.database.run.ui.EditMaximizedView;
import com.intellij.database.run.ui.EditMaximizedViewKt;
import com.intellij.database.run.ui.TableAggregatorWidgetHelper;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChooseAggregatorsAction {
    @NotNull
    public static JBIterable<AnAction> getChildrenImpl(@NotNull DataGrid grid, BiFunction<? super DataAggregatorFactory, List<? extends DataAggregatorFactory>, ? extends AnAction> function) {
        if (grid == null) {
            ChooseAggregatorsAction.$$$reportNull$$$0(0);
        }
        List scripts = DataExtractorFactories.getAggregatorScripts((ExtractorsHelper)ExtractorsHelper.getInstance((CoreGrid)grid), GridUtil::suggestPlugin);
        JBIterable jBIterable = JBIterable.of((Object)Separator.create((String)DataGridBundle.message((String)"settings.aggregators.ScriptAggregators", (Object[])new Object[0]))).append((Iterable)JBIterable.from((Iterable)scripts).sort(Comparator.comparing(s -> StringUtil.toLowerCase((String)s.getName()))).map(s -> (AnAction)function.apply((DataAggregatorFactory)s, scripts)));
        if (jBIterable == null) {
            ChooseAggregatorsAction.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    private static void checkEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseAggregatorsAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        EditMaximizedView view = (EditMaximizedView)e.getData(EditMaximizedViewKt.EDIT_MAXIMIZED_KEY);
        File scriptsDir = ExtractorScripts.getAggregatorScriptsDirectory();
        if (view == null || scriptsDir == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        AggregateView viewer = (AggregateView)view.getAggregateViewer();
        if (viewer == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(project != null && view.getCurrentTabInfoProvider() instanceof AggregatesTabInfoProvider);
    }

    private static void updateAllAggregatorsState(@NotNull AnActionEvent e, List<DataAggregatorFactory> aggregators, boolean status) {
        if (e == null) {
            ChooseAggregatorsAction.$$$reportNull$$$0(3);
        }
        EditMaximizedView view = (EditMaximizedView)e.getData(EditMaximizedViewKt.EDIT_MAXIMIZED_KEY);
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (view == null || grid == null) {
            return;
        }
        AggregateView viewer = (AggregateView)view.getAggregateViewer();
        if (viewer == null) {
            return;
        }
        for (DataAggregatorFactory aggregator : aggregators) {
            viewer.setAggregatorSelection(aggregator.getName(), status);
        }
        ApplicationManager.getApplication().invokeLater(() -> viewer.update(null));
        DataGridSettings settings = GridUtil.getSettings(grid);
        if (settings != null) {
            settings.setDisabledAggregators(viewer.getDisabledAggregatorsScripts());
            settings.fireChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseAggregatorsAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseAggregatorsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenImpl";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateAllAggregatorsState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class DisableAllAggregatorsAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DisableAllAggregatorsAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DisableAllAggregatorsAction.$$$reportNull$$$0(1);
            }
            ChooseAggregatorsAction.checkEnabled(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid grid;
            if (e == null) {
                DisableAllAggregatorsAction.$$$reportNull$$$0(2);
            }
            if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            ChooseAggregatorsAction.updateAllAggregatorsState(e, DataExtractorFactories.getAggregatorScripts((ExtractorsHelper)ExtractorsHelper.getInstance((CoreGrid)grid), null), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseAggregatorsAction$DisableAllAggregatorsAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseAggregatorsAction$DisableAllAggregatorsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class EnableAllAggregatorsAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                EnableAllAggregatorsAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EnableAllAggregatorsAction.$$$reportNull$$$0(1);
            }
            ChooseAggregatorsAction.checkEnabled(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid grid;
            if (e == null) {
                EnableAllAggregatorsAction.$$$reportNull$$$0(2);
            }
            if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            ChooseAggregatorsAction.updateAllAggregatorsState(e, DataExtractorFactories.getAggregatorScripts((ExtractorsHelper)ExtractorsHelper.getInstance((CoreGrid)grid), null), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseAggregatorsAction$EnableAllAggregatorsAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseAggregatorsAction$EnableAllAggregatorsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class SelectSingleAggregatorAction
    extends ToggleAction
    implements DumbAware {
        private final Project myProject;
        final TableAggregatorWidgetHelper helper;
        final DataAggregatorFactory script;
        private final Supplier<@Nullable DataGridSettings> mySettingsSupplier;
        final StatusBar statusBar;
        @Nullable
        Aggregator aggregator;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SelectSingleAggregatorAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public SelectSingleAggregatorAction(@NotNull DataGrid grid, @NotNull StatusBar statusBar, @NotNull TableAggregatorWidgetHelper helper, @NotNull DataAggregatorFactory script, @NotNull List<? extends DataAggregatorFactory> factories, @NotNull Supplier<DataGridSettings> settingsSupplier) {
            if (grid == null) {
                SelectSingleAggregatorAction.$$$reportNull$$$0(1);
            }
            if (statusBar == null) {
                SelectSingleAggregatorAction.$$$reportNull$$$0(2);
            }
            if (helper == null) {
                SelectSingleAggregatorAction.$$$reportNull$$$0(3);
            }
            if (script == null) {
                SelectSingleAggregatorAction.$$$reportNull$$$0(4);
            }
            if (factories == null) {
                SelectSingleAggregatorAction.$$$reportNull$$$0(5);
            }
            if (settingsSupplier == null) {
                SelectSingleAggregatorAction.$$$reportNull$$$0(6);
            }
            super(StringUtil.escapeMnemonics((String)DataExtractorFactories.getDisplayName((DataExtractorFactory)script, factories)));
            this.myProject = grid.getProject();
            this.statusBar = statusBar;
            this.helper = helper;
            this.script = script;
            this.mySettingsSupplier = settingsSupplier;
            ApplicationManager.getApplication().invokeLater(() -> {
                ExtractorConfig config = ExtractorsHelper.getInstance((CoreGrid)grid).createExtractorConfig((CoreGrid)grid, grid.getObjectFormatter());
                DataExtractor extractor = script.createAggregator(config);
                if (extractor == null) {
                    return;
                }
                this.aggregator = new Aggregator(grid, extractor, script.getSimpleName(), script.getName());
            });
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectSingleAggregatorAction.$$$reportNull$$$0(7);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(true);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectSingleAggregatorAction.$$$reportNull$$$0(8);
            }
            return this.helper.getAggregator() != null && StringUtil.equals((CharSequence)this.helper.getAggregator().getName(), (CharSequence)this.script.getId());
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SelectSingleAggregatorAction.$$$reportNull$$$0(9);
            }
            DataGridSettings settings = this.mySettingsSupplier.get();
            if (state) {
                if (this.aggregator == null) {
                    String scriptExtension;
                    BaseExtractorsHelper.Script s = (BaseExtractorsHelper.Script)ObjectUtils.tryCast((Object)this.script, BaseExtractorsHelper.Script.class);
                    String string = scriptExtension = s == null ? null : FileUtilRt.getExtension((String)s.getScriptFileName());
                    if (scriptExtension != null) {
                        ExtensionScriptsUtil.showEngineNotFoundBalloon((Project)this.myProject, GridUtil::suggestPlugin, (String)scriptExtension);
                    }
                }
                this.helper.setAggregator(this.aggregator);
                if (settings != null) {
                    settings.setWidgetAggregator(this.aggregator == null ? null : this.aggregator.getName());
                }
            } else {
                this.helper.setAggregator(null);
                if (settings != null) {
                    settings.setWidgetAggregator(null);
                }
            }
            this.statusBar.updateWidget("GridAggregator");
            if (settings != null) {
                settings.fireChanged();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseAggregatorsAction$SelectSingleAggregatorAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factories";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsSupplier";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseAggregatorsAction$SelectSingleAggregatorAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class SelectAggregatorAction
    extends ToggleAction
    implements DumbAware {
        final DataAggregatorFactory factory;
        final boolean selected;
        private final Supplier<DataGridSettings> mySettings;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SelectAggregatorAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        SelectAggregatorAction(@NotNull DataAggregatorFactory factory, boolean selected, @NotNull List<? extends DataAggregatorFactory> scripts, @NotNull Supplier<DataGridSettings> settings) {
            if (factory == null) {
                SelectAggregatorAction.$$$reportNull$$$0(1);
            }
            if (scripts == null) {
                SelectAggregatorAction.$$$reportNull$$$0(2);
            }
            if (settings == null) {
                SelectAggregatorAction.$$$reportNull$$$0(3);
            }
            super(StringUtil.escapeMnemonics((String)DataExtractorFactories.getDisplayName((DataExtractorFactory)factory, scripts)));
            this.factory = factory;
            this.selected = selected;
            this.mySettings = settings;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectAggregatorAction.$$$reportNull$$$0(4);
            }
            super.update(e);
            ChooseAggregatorsAction.checkEnabled(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectAggregatorAction.$$$reportNull$$$0(5);
            }
            return this.selected;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            EditMaximizedView view;
            if (e == null) {
                SelectAggregatorAction.$$$reportNull$$$0(6);
            }
            if ((view = (EditMaximizedView)e.getData(EditMaximizedViewKt.EDIT_MAXIMIZED_KEY)) == null) {
                return;
            }
            AggregateView viewer = (AggregateView)view.getAggregateViewer();
            if (viewer == null) {
                return;
            }
            viewer.setAggregatorSelection(this.factory.getId(), state);
            ApplicationManager.getApplication().invokeLater(() -> viewer.update(null));
            DataGridSettings settings = this.mySettings.get();
            if (settings != null) {
                settings.setDisabledAggregators(viewer.getDisabledAggregatorsScripts());
                settings.fireChanged();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseAggregatorsAction$SelectAggregatorAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scripts";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseAggregatorsAction$SelectAggregatorAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class GoToScriptsDirectoryAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                GoToScriptsDirectoryAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoToScriptsDirectoryAction.$$$reportNull$$$0(1);
            }
            ChooseAggregatorsAction.checkEnabled(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GoToScriptsDirectoryAction.$$$reportNull$$$0(2);
            }
            Project project = e.getProject();
            File scriptsDir = ExtractorScripts.getAggregatorScriptsDirectory();
            if (project == null || scriptsDir == null) {
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(scriptsDir);
                if (virtualFile == null) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, -1).navigate(true));
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseAggregatorsAction$GoToScriptsDirectoryAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseAggregatorsAction$GoToScriptsDirectoryAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class ScriptedGroup
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ScriptedGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            DataGrid grid;
            EditMaximizedView view = e == null ? null : (EditMaximizedView)e.getData(EditMaximizedViewKt.EDIT_MAXIMIZED_KEY);
            DataGrid dataGrid = grid = e == null ? null : (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            if (view == null || grid == null) {
                if (EMPTY_ARRAY == null) {
                    ScriptedGroup.$$$reportNull$$$0(1);
                }
                return EMPTY_ARRAY;
            }
            final AggregateView viewer = (AggregateView)view.getAggregateViewer();
            if (viewer == null) {
                if (EMPTY_ARRAY == null) {
                    ScriptedGroup.$$$reportNull$$$0(2);
                }
                return EMPTY_ARRAY;
            }
            JBIterable<AnAction> children2 = ChooseAggregatorsAction.getChildrenImpl(grid, (BiFunction<? super DataAggregatorFactory, List<? extends DataAggregatorFactory>, ? extends AnAction>)new BiFunction<DataAggregatorFactory, List<? extends DataAggregatorFactory>, AnAction>(){
                final List<String> selectedIdList;
                {
                    this.selectedIdList = viewer.getEnabledAggregatorsScripts();
                }

                @Override
                public AnAction apply(DataAggregatorFactory factory, List<? extends DataAggregatorFactory> factories) {
                    String id = factory.getId();
                    return new SelectAggregatorAction(factory, this.selectedIdList.contains(id), factories, () -> GridUtil.getSettings(grid));
                }
            });
            if ("EditorPopup".equals(e.getPlace())) {
                AnAction[] anActionArray = (AnAction[])children2.map(o -> o instanceof Separator ? Separator.getInstance() : o).toArray((Object[])EMPTY_ARRAY);
                if (anActionArray == null) {
                    ScriptedGroup.$$$reportNull$$$0(3);
                }
                return anActionArray;
            }
            AnAction[] anActionArray = (AnAction[])children2.toArray((Object[])EMPTY_ARRAY);
            if (anActionArray == null) {
                ScriptedGroup.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/run/actions/ChooseAggregatorsAction$ScriptedGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

