/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ExtractorsHelper;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.actions.DumpSourceNameProvider;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.Out;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public abstract class GridHandler
extends DumpHandler<DataGrid> {
    public GridHandler(@NotNull Project project, @NotNull DataGrid target, @NotNull DumpSourceNameProvider<DataGrid> nameProvider, @NotNull ExtractionHelper manager, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        if (project == null) {
            GridHandler.$$$reportNull$$$0(0);
        }
        if (target == null) {
            GridHandler.$$$reportNull$$$0(1);
        }
        if (nameProvider == null) {
            GridHandler.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            GridHandler.$$$reportNull$$$0(3);
        }
        if (factory == null) {
            GridHandler.$$$reportNull$$$0(4);
        }
        if (config == null) {
            GridHandler.$$$reportNull$$$0(5);
        }
        super(project, JBIterable.of((Object)target), nameProvider, manager, target.getDisplayName(), factory, config);
    }

    @Override
    @NotNull
    protected ExtractorConfig createExtractorConfig(@NotNull DataGrid source, @Nullable Project project) {
        if (source == null) {
            GridHandler.$$$reportNull$$$0(6);
        }
        ExtractorConfig extractorConfig = ExtractorsHelper.getInstance((CoreGrid)source).createExtractorConfig((CoreGrid)source, source.getObjectFormatter());
        if (extractorConfig == null) {
            GridHandler.$$$reportNull$$$0(7);
        }
        return extractorConfig;
    }

    @Override
    @NotNull
    protected ObjectFormatter getFormatter(@NotNull DataGrid source) {
        if (source == null) {
            GridHandler.$$$reportNull$$$0(8);
        }
        ObjectFormatter objectFormatter = source.getObjectFormatter();
        if (objectFormatter == null) {
            GridHandler.$$$reportNull$$$0(9);
        }
        return objectFormatter;
    }

    @Override
    @Nullable
    protected String getSourceName(int count) {
        return null;
    }

    @Override
    @NlsSafe
    @Nullable
    protected String getDatabaseSystemName() {
        DataGrid grid = (DataGrid)this.mySources.first();
        return grid == null ? null : GridHelper.get(grid).getDatabaseSystemName(grid);
    }

    @Override
    @Nullable
    protected ModelIndexSet<GridColumn> getSelectedColumns(@NotNull DataGrid source) {
        ModelIndexSet visibleColumns2;
        if (source == null) {
            GridHandler.$$$reportNull$$$0(10);
        }
        return (visibleColumns2 = source.getVisibleColumns()).size() == source.getDataModel(DataAccessType.DATABASE_DATA).getColumnCount() ? null : visibleColumns2;
    }

    public static boolean hasTruncatedData(@NotNull List<? extends GridColumn> columns, List<? extends GridRow> rows) {
        if (columns == null) {
            GridHandler.$$$reportNull$$$0(11);
        }
        for (GridRow gridRow : rows) {
            for (GridColumn gridColumn : columns) {
                Object value = gridColumn.getValue(gridRow);
                if (!(value instanceof LobInfo) || !((LobInfo)value).isTruncated()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    protected AsyncPromise<Void> run(@NotNull DataGrid source, @NotNull DataExtractor extractor, @NotNull Out out, @NotNull DumpHandler.DumpHandlerParameters dumpParameters) {
        if (source == null) {
            GridHandler.$$$reportNull$$$0(12);
        }
        if (extractor == null) {
            GridHandler.$$$reportNull$$$0(13);
        }
        if (out == null) {
            GridHandler.$$$reportNull$$$0(14);
        }
        if (dumpParameters == null) {
            GridHandler.$$$reportNull$$$0(15);
        }
        DataProducer producer = this.getProducer(source, dumpParameters.subQueryIndex, dumpParameters.resultSetIndex);
        GridDataRequest.GridDataRequestOwner owner = this.getOwner(source);
        return producer != null ? ((GridDataRequest)this.newSimpleRunner(producer, owner, out, dumpParameters).fun((Object)extractor)).getPromise() : null;
    }

    @NotNull
    protected abstract GridDataRequest.GridDataRequestOwner getOwner(@NotNull DataGrid var1);

    @Nullable
    protected abstract DataProducer getProducer(@NotNull DataGrid var1, int var2, int var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dump/GridHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dump/GridHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractorConfig";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExtractorConfig";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFormatter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedColumns";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasTruncatedData";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9 -> new IllegalStateException(string);
        };
    }
}

