/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrDebugTestDataFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrProjectMarkup;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.CidrTestCaseBase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.TimeoutAssertionFailedError;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisSettings;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assume;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class CidrDebuggerTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, PROJECT_MARKUP extends CidrProjectMarkup>
extends CidrTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CidrCodeInsightFixture> {
    public static final String DEFAULT_BUILD_TYPE = "Debug";
    public static final String LOCALHOST_4242 = "localhost:4242";
    public static final Pattern GDBSERVER_TARGET_PID_PATTERN = Pattern.compile("(?:Process .* created; pid =|Detaching from process) (\\d+)");
    public static final Key<Boolean> IS_BUNDLED_LLDB = Key.create((String)"IS_BUNDLED_LLDB");
    protected DebuggerDriver myDriver;
    protected DebuggerDriver.Inferior myInferior;
    @NotNull
    protected final DebuggerDriverKind myBackend;
    @NotNull
    protected final String myTargetName;
    @NotNull
    private final BackendKindAssumption myBackendKindAssumption;
    @NotNull
    private final DebuggerAssumption myDebuggerAssumption;
    @NotNull
    private final CidrTestCaseBase.SystemAssumption mySystemAssumption;
    @NotNull
    private final CidrTestCaseBase.ArchitectureAssumption myArchitectureAssumption;
    protected PROJECT_MARKUP myProjectMarkup;
    protected CidrTestProjectDescription myTestProjectDescription;
    protected CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DebuggerState, CidrDebuggingFixture.DebuggerState> PAUSED;
    protected CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DebuggerState, CidrDebuggingFixture.DebuggerState> STOPPED;
    protected CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DriverEvent, CidrDebuggingFixture.DriverCodepointEvent> BREAKPOINT;
    protected CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DriverEvent, CidrDebuggingFixture.DriverFinishedEvent> FINISHED;
    @Nullable
    protected Function.Mono<GeneralCommandLine> myDriverCommandLineConfigurator;

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(0);
        }
        try {
            testRunnable.run();
        }
        catch (TimeoutAssertionFailedError e) {
            try {
                this.collectThreadsForInvestigation();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    protected void collectThreadsForInvestigation() throws Exception {
        if (this.myDriver == null) {
            return;
        }
        BlockingQueue<CidrDebuggingFixture.DriverEvent> events = ((CidrDebuggingFixture)this.myDebuggingFixture).spyOnDriverEvents(this.targetExecutionCheckpointEvents());
        this.myDriver.interrupt();
        CidrDebuggingFixture.DriverEvent event = CidrExecutionFixture.waitFor(events, 3000L);
        if (event == null || CidrDebuggingFixture.isEvent(event, CidrDebuggingFixture.DriverEvent.Kind.FINISHED)) {
            return;
        }
        List threads = this.myDriver.getThreads();
        for (LLThread thread : threads) {
            this.myDriver.getFrames(thread, 0, 50, false);
        }
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrDebugTestDataFixture();
    }

    @NotNull
    protected DebuggerDriverConfiguration createDriverConfiguration() {
        DebuggerDriverConfiguration debuggerDriverConfiguration = ((CidrDebuggingFixture)this.myDebuggingFixture).createDriverConfiguration(this.myDriverCommandLineConfigurator);
        if (debuggerDriverConfiguration == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(1);
        }
        return debuggerDriverConfiguration;
    }

    @NotNull
    protected Installer createInstaller(GeneralCommandLine cl) {
        return new TrivialInstaller(cl);
    }

    protected void startDriver() throws com.intellij.execution.ExecutionException {
        this.startDriver((DebuggerDriver.Handler)null);
    }

    protected void startDriver(@Nullable DebuggerDriver.Handler handler) throws com.intellij.execution.ExecutionException {
        this.startDriver(handler, null);
    }

    @Contract(value="!null -> !null;  null ->  null")
    protected <T> BlockingQueue<? extends T> startDriver(@Nullable CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DriverEvent, T> eventFilter) throws com.intellij.execution.ExecutionException {
        return this.startDriver(null, eventFilter);
    }

    @Contract(value="_, !null -> !null; _,  null ->  null")
    protected <T> BlockingQueue<? extends T> startDriver(@Nullable DebuggerDriver.Handler handler, @Nullable CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DriverEvent, T> eventFilter) throws com.intellij.execution.ExecutionException {
        BlockingQueue<T> eventQueue = ((CidrDebuggingFixture)this.myDebuggingFixture).startDriver(handler, this.myDriverCommandLineConfigurator, eventFilter);
        this.myDriver = ((CidrDebuggingFixture)this.myDebuggingFixture).getDriver();
        return eventQueue;
    }

    protected void stopDebugDriver() throws Exception {
        this.myDriver = null;
        ((CidrDebuggingFixture)this.myDebuggingFixture).stopDebugDriver();
    }

    protected void addDriverHandler(@NotNull DebuggerDriver.Handler handler) {
        if (handler == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(2);
        }
        ((CidrDebuggingFixture)this.myDebuggingFixture).addDriverHandler(handler);
    }

    @NotNull
    protected BlockingQueue<String> spyOnOutputLines() {
        BlockingQueue<String> blockingQueue = ((CidrDebuggingFixture)this.myDebuggingFixture).spyOnOutputLines();
        if (blockingQueue == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(3);
        }
        return blockingQueue;
    }

    @NotNull
    protected String getTestExecutablePath() throws Exception {
        String string = this.myExecutionFixture.getTestExecutablePath(this.myTargetName);
        if (string == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected abstract PROJECT_MARKUP createProjectMarkup(@NotNull VirtualFile var1) throws Exception;

    protected void buildConfiguration() throws Exception {
        this.myExecutionFixture.buildIfNeeded();
    }

    public CidrDebuggerTestCase(@NotNull DebuggerDriverKind backend, @NotNull String targetName, @NotNull CidrTestProjectDescription testProjectDescription) {
        if (backend == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(5);
        }
        if (targetName == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(6);
        }
        if (testProjectDescription == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(7);
        }
        this.myDriverCommandLineConfigurator = null;
        this.myBackend = backend;
        this.myTargetName = targetName;
        this.myTestProjectDescription = testProjectDescription;
        this.myBackendKindAssumption = new BackendKindAssumption(backend);
        this.myDebuggerAssumption = new DebuggerAssumption();
        this.mySystemAssumption = new CidrTestCaseBase.SystemAssumption(() -> this.getHostMachine().getOSType());
        this.myArchitectureAssumption = new CidrTestCaseBase.ArchitectureAssumption(() -> ((CidrDebuggingFixture)this.myDebuggingFixture).getArchitectureType());
    }

    @NotNull
    public String getTestProjectRootPath() {
        String string = ((CidrProjectFixture)this.myProjectFixture).getProjectDir().getPath();
        if (string == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    @Contract(value="!null, !null -> !null")
    protected <TYPE> TYPE selectDriver(TYPE gdb, TYPE lldb) {
        return this.myBackend == DebuggerDriverKind.LLDB ? lldb : gdb;
    }

    @Nullable
    @Contract(value="!null, !null, !null -> !null")
    protected <TYPE> TYPE selectByCompiler(TYPE gcc, TYPE clang, TYPE msvc) throws RuntimeException {
        OCCompilerKind compilerKind = ((CidrProjectFixture)this.myProjectFixture).getCompilerType();
        if (compilerKind == GCCCompilerKind.INSTANCE) {
            return gcc;
        }
        if (compilerKind == ClangCompilerKind.INSTANCE || compilerKind == AppleClangCompilerKind.INSTANCE) {
            return clang;
        }
        if (compilerKind == MSVCCompilerKind.INSTANCE) {
            return msvc;
        }
        throw new RuntimeException(String.format("Unsupported compiler kind '%s' used in debugger test", compilerKind.getDisplayName()));
    }

    @Nullable
    @Contract(value="!null, !null -> !null")
    @RegExp
    protected String selectDriverRegExp(@RegExp String gdb, @RegExp String lldb) {
        return this.myBackend == DebuggerDriverKind.LLDB ? lldb : gdb;
    }

    protected boolean isExternalLLDB() {
        DebuggerDriverConfiguration driverConfiguration = this.createDriverConfiguration();
        if (driverConfiguration instanceof LLDBDriverConfiguration) {
            return !Boolean.TRUE.equals(driverConfiguration.getUserData(IS_BUNDLED_LLDB));
        }
        return false;
    }

    @Override
    protected boolean runInDispatchThread() {
        return false;
    }

    @Override
    protected boolean shouldRunTest() {
        return super.shouldRunTest() && CidrDebuggingFixture.shouldRunTest(this.myBackend, this.getName(), this.getClass()) && (!this.isTargetLibcxx() || SystemInfo.isMac);
    }

    protected boolean isTargetLibcxx() {
        return StringUtil.containsIgnoreCase((String)this.myTargetName, (String)"libcxx");
    }

    protected boolean isMSVCRuntime() {
        return SystemInfo.isWindows && this.myBackend == DebuggerDriverKind.LLDB;
    }

    @NotNull
    protected static String getDefaultTargetName(@NotNull DebuggerDriverKind backend) {
        if (backend == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(9);
        }
        return SystemInfo.isMac && backend == DebuggerDriverKind.LLDB ? "Target_Libcxx" : "Target_Libstdcxx";
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ((CidrProjectFixture)this.myProjectFixture).initProject(this.myTestProjectDescription);
        try {
            this.myProjectMarkup = this.createProjectMarkup(((CidrProjectFixture)this.myProjectFixture).getProjectDir());
            this.buildConfiguration();
        }
        catch (Exception e) {
            ((CidrProjectFixture)this.myProjectFixture).closeProject();
            throw e;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.stopDebugDriver();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myExecutionFixture.initTargetAndConfiguration(this.myTargetName, DEFAULT_BUILD_TYPE);
        this.PAUSED = ((CidrDebuggingFixture)this.myDebuggingFixture).fixupDebuggerStateFilter(CidrDebuggingFixture.DebuggerState.PAUSED);
        this.STOPPED = ((CidrDebuggingFixture)this.myDebuggingFixture).fixupDebuggerStateFilter(CidrDebuggingFixture.DebuggerState.STOPPED);
        this.BREAKPOINT = ((CidrDebuggingFixture)this.myDebuggingFixture).fixupDriverEventFilter(CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT);
        this.FINISHED = ((CidrDebuggingFixture)this.myDebuggingFixture).fixupDriverEventFilter(CidrDebuggingFixture.DriverEvent.Kind.FINISHED);
    }

    @Override
    public void afterProjectOpened() throws Exception {
        super.afterProjectOpened();
        this.setDefaultSettings();
    }

    private void setDefaultSettings() {
        NatvisSettings settings = NatvisSettings.getInstance((Project)this.getProject());
        settings.searchInVS = false;
        settings.searchPaths.clear();
        URL visualizersResource = this.getClass().getResource("/visualizers");
        if (visualizersResource != null) {
            File testVisualizersDir = new File(visualizersResource.getPath());
            settings.searchPaths.add(new kotlin.Pair((Object)testVisualizersDir, (Object)true));
        }
    }

    protected boolean isGdbOnMacOsSierraWithBrokenArgsPassing() {
        return this.myBackend == DebuggerDriverKind.GDB && SystemInfo.isMac;
    }

    protected int mainThreadID() {
        return this.myBackend == DebuggerDriverKind.GDB && SystemInfo.isMac ? 2 : 1;
    }

    protected boolean steppingWorksWellWithLibcDebugInfo() {
        return false;
    }

    @SafeVarargs
    protected final void startDriverAndLaunch(ThrowableConsumer<? super DebuggerDriver, ? extends Exception> ... beforeLaunch) throws Exception {
        if (beforeLaunch == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(10);
        }
        this.startDriverAndLaunch((String)null, beforeLaunch);
    }

    @SafeVarargs
    protected final void startDriverAndLaunch(@Nullable String params, ThrowableConsumer<? super DebuggerDriver, ? extends Exception> ... beforeLaunch) throws Exception {
        if (beforeLaunch == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(11);
        }
        this.startDriverAndLaunch(params, (CidrDebuggingFixture.EventFilter)null, beforeLaunch);
    }

    @SafeVarargs
    @Contract(value="!null, _ -> !null;  null, _ ->  null")
    protected final <T> BlockingQueue<? extends T> startDriverAndLaunch(@Nullable CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DriverEvent, T> eventFilter, ThrowableConsumer<? super DebuggerDriver, ? extends Exception> ... beforeLaunch) throws Exception {
        if (beforeLaunch == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(12);
        }
        return this.startDriverAndLaunch((String)null, eventFilter, beforeLaunch);
    }

    @SafeVarargs
    @Contract(value="_, !null, _ -> !null; _,  null, _ ->  null")
    protected final <T> BlockingQueue<? extends T> startDriverAndLaunch(@Nullable String params, @Nullable CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DriverEvent, T> eventFilter, ThrowableConsumer<? super DebuggerDriver, ? extends Exception> ... beforeLaunch) throws Exception {
        if (beforeLaunch == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(13);
        }
        return this.startDriverAndLaunch(this.createCommandLine(params), eventFilter, beforeLaunch);
    }

    @SafeVarargs
    @Contract(value="_, !null, _ -> !null; _,  null, _ ->  null")
    protected final <T> BlockingQueue<? extends T> startDriverAndLaunch(@NotNull GeneralCommandLine cl, @Nullable CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DriverEvent, T> eventFilter, ThrowableConsumer<? super DebuggerDriver, ? extends Exception> ... beforeLaunch) throws Exception {
        if (cl == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(14);
        }
        if (beforeLaunch == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(15);
        }
        BlockingQueue<T> events = this.startDriver(eventFilter);
        this.loadApp(cl);
        for (ThrowableConsumer<? super DebuggerDriver, ? extends Exception> task2 : beforeLaunch) {
            task2.consume((Object)this.myDriver);
        }
        this.myInferior.start();
        return events;
    }

    @NotNull
    protected CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DriverEvent, CidrDebuggingFixture.DriverEvent> targetExecutionCheckpointEvents() {
        CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DriverEvent, CidrDebuggingFixture.DriverEvent> eventFilter = ((CidrDebuggingFixture)this.myDebuggingFixture).targetExecutionCheckpointEvents();
        if (eventFilter == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(16);
        }
        return eventFilter;
    }

    @NotNull
    protected static ThrowableConsumer<DebuggerDriver, Exception> withBreakpoint(@NotNull VirtualFile file2, int line) {
        if (file2 == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(17);
        }
        return CidrDebuggerTestCase.withBreakpoint(file2.getPath(), line);
    }

    @NotNull
    protected static ThrowableConsumer<DebuggerDriver, Exception> withBreakpoint(@NotNull String fileName, int line) {
        if (fileName == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(18);
        }
        ThrowableConsumer throwableConsumer = driver -> driver.addBreakpoint(fileName, line);
        if (throwableConsumer == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(19);
        }
        return throwableConsumer;
    }

    protected GeneralCommandLine createCommandLine(@Nullable String params) throws Exception {
        return this.createCommandLine(this.getTestExecutablePath(), params);
    }

    protected GeneralCommandLine createCommandLine(String exePath, @Nullable String params) throws Exception {
        return this.createCommandLine(exePath, params == null ? null : StringUtil.split((String)params, (String)" "));
    }

    protected GeneralCommandLine createCommandLine(@Nullable List<String> params) throws Exception {
        return this.createCommandLine(this.getTestExecutablePath(), params);
    }

    protected GeneralCommandLine createCommandLine(String exePath, @Nullable List<String> params) throws Exception {
        GeneralCommandLine cl = new GeneralCommandLine().withCharset(StandardCharsets.UTF_8);
        cl.setExePath(exePath);
        cl = cl.withWorkDirectory(new File(cl.getExePath()).getParent());
        if (params != null) {
            cl.addParameters(params);
        }
        cl.getEnvironment().put("NSUnbufferedIO", "YES");
        ((CidrDebuggingFixture)this.myDebuggingFixture).getEnvironment().prepare(cl, CidrToolEnvironment.PrepareFor.RUN);
        return cl;
    }

    protected Pair<? extends BaseProcessHandler<?>, Integer> launchAppAndAttach(@Nullable String params) throws Exception {
        return this.launchAppAndAttach(params, null);
    }

    protected Pair<? extends BaseProcessHandler<?>, Integer> launchAppAndAttach(@Nullable String params, @Nullable ThrowableRunnable<? extends Exception> beforeAttach) throws Exception {
        Pair<BaseProcessHandler<?>, Integer> result2 = this.launchApp(params);
        this.loadAppForAttach((Integer)result2.second);
        if (beforeAttach != null) {
            beforeAttach.run();
        }
        this.myInferior.start();
        return result2;
    }

    protected Pair<? extends BaseProcessHandler<?>, Integer> launchApp(@Nullable String params) throws Exception {
        return this.launchApp(params, null);
    }

    protected Pair<? extends BaseProcessHandler<?>, Integer> launchApp(@Nullable String params, @Nullable String overridesExeName) throws Exception {
        HostMachine host;
        GeneralCommandLine cl = this.createCommandLine(params);
        if (overridesExeName != null) {
            Path exeFullPath = Paths.get(cl.getExePath(), new String[0]);
            cl.setExePath(exeFullPath.getParent().resolve(overridesExeName).toString());
        }
        Pair<BaseProcessHandler<?>, Integer> handlerAndPid = !(host = this.getHostMachine()).isWsl() ? this.startProcess(cl) : this.startProcessWithGetPidWorkaround(cl);
        ProcessHandler handler = (ProcessHandler)handlerAndPid.first;
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> handler.destroyProcess());
        handler.startNotify();
        return handlerAndPid;
    }

    @NotNull
    private Pair<BaseProcessHandler<?>, Integer> startProcess(@NotNull GeneralCommandLine cl) throws Exception {
        if (cl == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(20);
        }
        BaseProcessHandler handler = this.getHostMachine().createProcess(cl, false, true);
        int pid = OSProcessUtil.getProcessID((Process)handler.getProcess());
        Pair pair = Pair.create((Object)handler, (Object)pid);
        if (pair == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(21);
        }
        return pair;
    }

    @NotNull
    private Pair<BaseProcessHandler<?>, Integer> startProcessWithGetPidWorkaround(@NotNull GeneralCommandLine cl) throws Exception {
        if (cl == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(22);
        }
        CidrDebuggerTestCase.assertTrue((String)"Cannot get PID of a short-lived process using the workaround", (boolean)cl.getParametersList().getList().contains("loop"));
        HostMachine host = this.getHostMachine();
        Set pidsBeforeAppLaunch = ContainerUtil.map2Set((Collection)host.getProcessList(), p -> p.getPid());
        BaseProcessHandler handler = host.createProcess(cl, false, true);
        int pid = -1;
        String executablePath = this.getEnvironment().toEnvPath(this.getTestExecutablePath());
        List processList = host.getProcessList();
        for (ProcessInfo info : processList) {
            if (pidsBeforeAppLaunch.contains(info.getPid()) || !info.getCommandLine().startsWith(executablePath)) continue;
            if (pid != -1) {
                CidrDebuggerTestCase.fail((String)("Unable to find PID: more than one process with executable " + executablePath));
            }
            pid = info.getPid();
        }
        if (pid == -1) {
            CidrDebuggerTestCase.fail((String)("Unable to find PID: no process with executable " + executablePath));
        }
        Pair pair = Pair.create((Object)handler, (Object)pid);
        if (pair == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @NotNull
    protected CidrToolEnvironment getEnvironment() {
        return new CidrToolEnvironment();
    }

    @NotNull
    protected HostMachine getHostMachine() {
        HostMachine hostMachine = this.getEnvironment().getHostMachine();
        if (hostMachine == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(24);
        }
        return hostMachine;
    }

    protected void loadApp() throws Exception {
        this.loadApp((String)null);
    }

    protected void loadApp(@Nullable String params) throws Exception {
        this.loadApp(this.createCommandLine(params));
    }

    protected void loadApp(@NotNull GeneralCommandLine cl) throws Exception {
        if (cl == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(25);
        }
        this.myInferior = this.myDriver.loadForLaunch(this.createInstaller(cl), ((CidrDebuggingFixture)this.myDebuggingFixture).getArchitectureType().getId());
    }

    protected void loadAppForAttach(int pid) throws Exception {
        this.myInferior = this.myDriver.loadForAttach(pid);
    }

    protected Pair<File, OSProcessHandler> launchRemoteApp(@Nullable String params) throws Exception {
        GeneralCommandLine appCommandLine = this.createCommandLine(params);
        File gdbserver = ((CidrDebuggingFixture)this.myDebuggingFixture).getGdbserverExecutable();
        GeneralCommandLine cl = new GeneralCommandLine();
        ((CidrDebuggingFixture)this.myDebuggingFixture).getEnvironment().prepare(cl, CidrToolEnvironment.PrepareFor.RUN);
        cl.setExePath(gdbserver.getPath());
        cl.addParameters(new String[]{"--once", LOCALHOST_4242});
        cl.addParameter(FileUtil.toSystemIndependentName((String)appCommandLine.getExePath()));
        if (SystemInfo.isWindows) {
            cl.addParameter("--");
        }
        cl.addParameters(appCommandLine.getParametersList().getParameters());
        CidrDebuggerLog.LOG.debug("Starting test gdbserver: " + cl.getCommandLineString());
        final FutureResult pidResult = new FutureResult();
        OSProcessHandler handler = new OSProcessHandler(cl);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                String text = StringUtil.trimEnd((String)event.getText(), (String)"\n");
                CidrDebuggerLog.LOG.debug("gdbserver>" + text);
                Matcher pidMatcher = GDBSERVER_TARGET_PID_PATTERN.matcher(text);
                if (pidMatcher.matches()) {
                    this.setPid(Integer.parseInt(pidMatcher.group(1)));
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                int exitCode = event.getExitCode();
                CidrDebuggerLog.LOG.debug("gdbserver finished, exit code: " + exitCode);
                this.setPid(-exitCode);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setPid(int result2) {
                FutureResult futureResult = pidResult;
                synchronized (futureResult) {
                    if (!pidResult.isDone()) {
                        pidResult.set((Object)result2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerTestCase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> {
            Integer pid;
            if (!CidrDebuggingFixture.waitFor((ProcessHandler)handler, 3000L)) {
                handler.destroyProcess();
            }
            try {
                pid = (Integer)pidResult.tryGet();
            }
            catch (ExecutionException ignored) {
                pid = null;
            }
            if (pid != null) {
                if (pid > 0) {
                    CidrDebuggerLog.LOG.debug("Killing gdbserver inferior PID: " + pid);
                    OSProcessUtil.killProcess((int)pid);
                }
            } else {
                CidrDebuggerLog.LOG.warn("gdbserver inferior PID is unknown: target process might be left unattended and cause subsequent tests to fail");
            }
        });
        handler.startNotify();
        Integer pid = (Integer)CidrDebuggingFixture.waitFor(pidResult, 3000L);
        if (pid != null) {
            CidrDebuggerTestCase.assertTrue((String)("gdbserver exited with code " + -pid.intValue()), (pid > 0 ? 1 : 0) != 0);
        } else {
            CidrDebuggerLog.LOG.warn("gdbserver inferior PID is unknown: gdbserver didn't report PID after startup");
        }
        return Pair.create((Object)new File(appCommandLine.getExePath()), (Object)handler);
    }

    protected void loadForRemote(@NotNull String connectionString, @Nullable File symbolFile, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws com.intellij.execution.ExecutionException {
        if (connectionString == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(26);
        }
        if (pathMappings == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(27);
        }
        this.myInferior = this.myDriver.loadForRemote(connectionString, symbolFile, new File("/"), pathMappings);
    }

    @NotNull
    protected Pair<GeneralCommandLine, String> createPrintArgsCommandLineAndExpectedOutput(String ... args) throws Exception {
        args = (String[])ArrayUtil.prepend((Object)"printArgs", (Object[])args);
        StringBuilder outputBuilder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            outputBuilder.append(i + 1).append(": ").append(args[i]).append("\n");
        }
        Pair pair = Pair.create((Object)this.createCommandLine(Arrays.asList(args)), (Object)outputBuilder.toString());
        if (pair == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(28);
        }
        return pair;
    }

    protected void changeTestToolchainToWindows() {
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable VirtualFile file2, @Nullable Integer lineNum) {
        this.assertFrame(frame, frameNum, file2, lineNum, null);
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable VirtualFile file2, @Nullable Integer lineNum, @RegExp @Nullable String funcPattern) {
        this.assertFrame(frame, frameNum, file2, lineNum, funcPattern, true);
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable VirtualFile file2, @Nullable Integer lineNum, @RegExp @Nullable String funcPattern, boolean hasProgramCounter) {
        this.assertFrame(frame, frameNum, file2 == null ? null : file2.getPath(), lineNum, funcPattern, hasProgramCounter);
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable String fileName, @Nullable Integer lineNum) {
        this.assertFrame(frame, frameNum, fileName, lineNum, null);
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable String fileName, @Nullable Integer lineNum, @RegExp @Nullable String funcPattern) {
        this.assertFrame(frame, frameNum, fileName, lineNum, funcPattern, true);
    }

    public void assertFrame(LLFrame frame, @Nullable Integer frameNum, @Nullable String fileName, @Nullable Integer lineNum, @RegExp @Nullable String funcPattern, boolean hasProgramCounter) {
        ((CidrDebuggingFixture)this.myDebuggingFixture).assertFrame(frame, frameNum, fileName, lineNum, funcPattern, hasProgramCounter);
    }

    @NotNull
    public BackendKindAssumption assumeBackendKind() {
        BackendKindAssumption backendKindAssumption = this.myBackendKindAssumption;
        if (backendKindAssumption == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(29);
        }
        return backendKindAssumption;
    }

    @NotNull
    public DebuggerAssumption assumeDebugger() {
        DebuggerAssumption debuggerAssumption = this.myDebuggerAssumption;
        if (debuggerAssumption == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(30);
        }
        return debuggerAssumption;
    }

    @Override
    @NotNull
    public CidrTestCaseBase.SystemAssumption assumeSystem() {
        CidrTestCaseBase.SystemAssumption systemAssumption = this.mySystemAssumption;
        if (systemAssumption == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(31);
        }
        return systemAssumption;
    }

    @Override
    @NotNull
    public CidrTestCaseBase.ArchitectureAssumption assumeArchitecture() {
        CidrTestCaseBase.ArchitectureAssumption architectureAssumption = this.myArchitectureAssumption;
        if (architectureAssumption == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(32);
        }
        return architectureAssumption;
    }

    public boolean isWindowsHost() {
        return this.getHostMachine().getOSType() == OSType.WIN;
    }

    public boolean isUnixHost() {
        return !this.isWindowsHost();
    }

    public boolean isLinuxHost() {
        return this.getHostMachine().getOSType() == OSType.LINUX;
    }

    public boolean isMacHost() {
        return this.getHostMachine().getOSType() == OSType.MAC;
    }

    public boolean isArchX86() {
        return ((CidrDebuggingFixture)this.myDebuggingFixture).getArchitectureType() == ArchitectureType.I386;
    }

    public boolean isArchX64() {
        return ((CidrDebuggingFixture)this.myDebuggingFixture).getArchitectureType() == ArchitectureType.X86_64;
    }

    public boolean isArchX86orX64() {
        return this.isArchX86() || this.isArchX64();
    }

    public boolean isArchAarch64() {
        return ((CidrDebuggingFixture)this.myDebuggingFixture).getArchitectureType() == ArchitectureType.ARM64;
    }

    @NotNull
    public String getExpectedSourceFilePath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(33);
        }
        String string = this.getExpectedSourceFilePath(file2.getPath());
        if (string == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public String getExpectedSourceFilePath(@NotNull String path) {
        if (path == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(35);
        }
        if (((CidrProjectFixture)this.myProjectFixture).getCompilerType() == MSVCCompilerKind.INSTANCE) {
            String string = path;
            if (string == null) {
                CidrDebuggerTestCase.$$$reportNull$$$0(36);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            CidrDebuggerTestCase.$$$reportNull$$$0(37);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 8, 16, 19, 21, 23, 24, 28, 29, 30, 31, 32, 34, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerTestCase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backend";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProjectDescription";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeLaunch";
                break;
            }
            case 14: 
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriverConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "spyOnOutputLines";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestExecutablePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestProjectRootPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "targetExecutionCheckpointEvents";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withBreakpoint";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessWithGetPidWorkaround";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostMachine";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrintArgsCommandLineAndExpectedOutput";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "assumeBackendKind";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "assumeDebugger";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "assumeSystem";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "assumeArchitecture";
                break;
            }
            case 34: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedSourceFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDriverHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTargetName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "startDriverAndLaunch";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withBreakpoint";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "startProcessWithGetPidWorkaround";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadApp";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadForRemote";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedSourceFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 8, 16, 19, 21, 23, 24, 28, 29, 30, 31, 32, 34, 36, 37 -> new IllegalStateException(string);
        };
    }

    public static class BackendKindAssumption {
        @NotNull
        private final DebuggerDriverKind myKind;

        public BackendKindAssumption(@NotNull DebuggerDriverKind kind) {
            if (kind == null) {
                BackendKindAssumption.$$$reportNull$$$0(0);
            }
            this.myKind = kind;
        }

        public void isGDB() {
            Assume.assumeTrue((String)"for GDB only", (this.myKind == DebuggerDriverKind.GDB ? 1 : 0) != 0);
        }

        public void isLLDB() {
            Assume.assumeTrue((String)"for LLDB only", (this.myKind == DebuggerDriverKind.LLDB ? 1 : 0) != 0);
        }

        public void isNotGDB() {
            Assume.assumeFalse((String)"not for GDB", (this.myKind == DebuggerDriverKind.GDB ? 1 : 0) != 0);
        }

        public void isNotLLDB() {
            Assume.assumeFalse((String)"not for LLDB", (this.myKind == DebuggerDriverKind.LLDB ? 1 : 0) != 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/execution/debugger/CidrDebuggerTestCase$BackendKindAssumption", "<init>"));
        }
    }

    public class DebuggerAssumption {
        public void supportsTargetInputOutput() {
            Assume.assumeTrue((String)"target input/output", (boolean)((CidrDebuggingFixture)CidrDebuggerTestCase.this.myDebuggingFixture).isTargetInputOutputSupported());
        }

        public void supportsFinishNonZeroExitCode() {
            Assume.assumeTrue((String)"target finish non-zero exit code", (boolean)((CidrDebuggingFixture)CidrDebuggerTestCase.this.myDebuggingFixture).isTargetFinishNonZeroExitCodeSupported());
        }

        public void supportsLocalAttach() {
            Assume.assumeTrue((String)"attach to local process", (boolean)CidrDebuggerTestCase.this.createDriverConfiguration().isAttachSupported());
        }

        public void supportsRemoteDebug() {
            Assume.assumeTrue((String)"remote debugging", (boolean)((CidrDebuggingFixture)CidrDebuggerTestCase.this.myDebuggingFixture).isRemoteDebugSupported());
        }

        public void supportsDisassembly() {
            Assume.assumeTrue((String)"disassembly", (boolean)((CidrDebuggingFixture)CidrDebuggerTestCase.this.myDebuggingFixture).isDisasmSupported());
        }
    }

    public static class PIDReader
    implements Consumer<Pair<String, Key>> {
        private final FutureResult<Integer> myPidResult = new FutureResult();

        public void consume(Pair<String, Key> value2) {
            String text = (String)value2.first;
            String prefix = "PID: ";
            if (text.startsWith(prefix)) {
                this.myPidResult.set((Object)Integer.valueOf(text.substring(prefix.length()).trim()));
            }
        }

        public FutureResult<Integer> getResult() {
            return this.myPidResult;
        }
    }

    public static class NullHandler
    implements DebuggerDriver.Handler {
    }
}

