/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.junit.rules;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.cidr.cpp.junit.api.CPPDisposableHolder;
import com.jetbrains.cidr.cpp.junit.rules.ExternalResourceEx;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.runner.Description;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/cpp/junit/rules/CPPDisposableHoldingRule;", "Lcom/jetbrains/cidr/cpp/junit/rules/ExternalResourceEx;", "Lcom/jetbrains/cidr/cpp/junit/api/CPPDisposableHolder;", "()V", "<set-?>", "Lcom/intellij/openapi/Disposable;", "rootDisposable", "getRootDisposable", "()Lcom/intellij/openapi/Disposable;", "setUpCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "after", "", "before", "description", "Lorg/junit/runner/Description;", "intellij.clion.testFramework"})
public final class CPPDisposableHoldingRule
extends ExternalResourceEx
implements CPPDisposableHolder {
    private volatile Disposable rootDisposable;
    @NotNull
    private final AtomicInteger setUpCount = new AtomicInteger();

    @Override
    @NotNull
    public Disposable getRootDisposable() {
        Disposable disposable = this.rootDisposable;
        if (disposable != null) {
            return disposable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rootDisposable");
        return null;
    }

    @Override
    protected void before(@NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        if (this.setUpCount.getAndIncrement() == 0) {
            Disposable disposable = Disposer.newDisposable((String)description.getDisplayName());
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            this.rootDisposable = disposable;
        }
    }

    @Override
    protected void after() {
        if (this.setUpCount.decrementAndGet() == 0) {
            Disposer.dispose((Disposable)this.getRootDisposable());
        }
    }
}

