/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.CpuArch;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.FlakyConditionKt;
import com.jetbrains.cidr.cpp.CPPTestCase;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspendContext;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CLionDebuggingFixture<EXECUTION_FIXTURE extends CidrExecutionFixture<?>>
extends CidrDebuggingFixture<EXECUTION_FIXTURE> {
    public CLionDebuggingFixture(@NotNull DebuggerDriverKind driverKind, EXECUTION_FIXTURE fixture) {
        if (driverKind == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(0);
        }
        super(driverKind, fixture);
    }

    @NotNull
    public CPPEnvironment getEnvironment() {
        CPPEnvironment cPPEnvironment = CPPTestCase.getTestCPPEnvironment();
        if (cPPEnvironment == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(1);
        }
        return cPPEnvironment;
    }

    @Override
    @NotNull
    protected ArchitectureType getArchitectureType() {
        CPPEnvironment environment = this.getEnvironment();
        if (environment.isMSVC()) {
            List options2 = environment.getToolchain().getToolSetOptions();
            Triple optionsTriple = MSVC.getOptions((List)options2);
            String arch = ((MSVC.Arch)optionsTriple.getFirst()).getValue();
            String targetArch = (String)ContainerUtil.getLastItem((List)StringUtil.split((String)arch, (String)"_"));
            ArchitectureType architectureType = ArchitectureType.forArchitecture((String)targetArch);
            if (architectureType == null) {
                CLionDebuggingFixture.$$$reportNull$$$0(2);
            }
            return architectureType;
        }
        ArchitectureType architectureType = ArchitectureType.forVmCpuArch((CpuArch)CpuArch.CURRENT);
        if (architectureType == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(3);
        }
        return architectureType;
    }

    @Override
    @NotNull
    public File getGdbserverExecutable() {
        GDB gdb = this.getEnvironment().getGDB();
        CLionDebuggingFixture.assertNotNull((String)"GDB is not set for tests", (Object)gdb);
        return new File(gdb.getExecutable().getParent(), "gdbserver" + (SystemInfo.isWindows ? ".exe" : ""));
    }

    @Override
    @NotNull
    protected String toAppEnvPath(@NotNull String path) {
        if (path == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(4);
        }
        if (CPPTestCase.getTestMinGW() != null || CPPTestCase.getTestMSVC() != null) {
            String string = StringUtil.escapeBackSlashes((String)PathUtil.toSystemDependentName((String)path));
            if (string == null) {
                CLionDebuggingFixture.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.getEnvironment().toEnvPath(path);
        if (string == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isOCDebuggingSupported() {
        return false;
    }

    @Override
    public boolean isTargetInputOutputSupported() {
        return !this.getEnvironment().isCygwin();
    }

    @Override
    public boolean isTargetFinishNonZeroExitCodeSupported() {
        return !this.getEnvironment().isCygwin();
    }

    @Override
    public boolean isRemoteDebugSupported() {
        if (this.getEnvironment().isCygwin()) {
            return false;
        }
        return super.isRemoteDebugSupported();
    }

    @Override
    @NotNull
    public CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DebuggerState, CidrDebuggingFixture.DebuggerState> fixupDebuggerStateFilter(@NotNull CidrDebuggingFixture.DebuggerState debuggerState) {
        if (debuggerState == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(7);
        }
        Consumer<CidrDebuggingFixture.DebuggerState> preAssert = this.getDebuggerStatePreAssertFor(debuggerState);
        CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DebuggerState, CidrDebuggingFixture.DebuggerState> eventFilter = debuggerState.withPreAssert(preAssert);
        if (eventFilter == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(8);
        }
        return eventFilter;
    }

    @Nullable
    private Consumer<CidrDebuggingFixture.DebuggerState> getDebuggerStatePreAssertFor(@NotNull CidrDebuggingFixture.DebuggerState debuggerState) {
        if (debuggerState == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(9);
        }
        if (debuggerState == CidrDebuggingFixture.DebuggerState.PAUSED) {
            OSType osType = this.getEnvironment().getHostMachine().getOSType();
            if (osType == OSType.LINUX && this.myDriverKind == DebuggerDriverKind.LLDB) {
                return event -> {
                    CidrSuspensionCause suspensionCause;
                    FlakyConditionKt.flakyCondition("Sometimes the debugger reports a breakpoint as a SIGTRAP signal", CLionDebuggingFixture.isEvent(event, CidrDebuggingFixture.DebuggerState.PAUSED) && (suspensionCause = this.getSuspensionCause()) != null && suspensionCause.type.equals(CidrDebuggerBundle.message((String)"debug.signal.suspension.cause", (Object[])new Object[0])) && suspensionCause.reason.contains("SIGTRAP"));
                };
            }
            if (osType == OSType.MAC && this.myDriverKind == DebuggerDriverKind.LLDB) {
                return event -> {
                    CidrStackFrame stackFrame;
                    FlakyConditionKt.flakyCondition("Sometimes the debugger reports a breakpoint as ThreadStopReasonInvalid", CLionDebuggingFixture.isEvent(event, CidrDebuggingFixture.DebuggerState.PAUSED) && (stackFrame = this.getStackFrame()) != null && stackFrame.getThreadId() == -1L && stackFrame.getFrameIndex() == -1);
                };
            }
        }
        if (debuggerState == CidrDebuggingFixture.DebuggerState.STOPPED && this.getEnvironment().isCygwin()) {
            return event -> {
                Integer exitCode;
                CidrSuspensionCause suspensionCause;
                FlakyConditionKt.flakyCondition("Sometimes GDB on Cygwin intercepts a SIGNAL in ntdll!KiRaiseUserExceptionDispatcher", CLionDebuggingFixture.isEvent(event, CidrDebuggingFixture.DebuggerState.PAUSED) && (suspensionCause = this.getSuspensionCause()) != null && suspensionCause.type.equals(CidrDebuggerBundle.message((String)"debug.signal.suspension.cause", (Object[])new Object[0])) && suspensionCause.reason.contains("Unknown signal"));
                FlakyConditionKt.flakyCondition("Sometimes GDB on Cygwin reports program as terminated by a real-time signal of the same number as the expected exit code", CLionDebuggingFixture.isEvent(event, CidrDebuggingFixture.DebuggerState.STOPPED) && (exitCode = this.getSession().getDebugProcess().getProcessHandler().getExitCode()) != null && exitCode == -1);
            };
        }
        return null;
    }

    @Nullable
    private CidrSuspensionCause getSuspensionCause() {
        CidrExecutionStack executionStack = this.getExecutionStack();
        return executionStack == null ? null : executionStack.getSuspensionCause();
    }

    @Nullable
    private CidrStackFrame getStackFrame() {
        CidrExecutionStack executionStack = this.getExecutionStack();
        return executionStack == null ? null : executionStack.getTopFrame();
    }

    @Nullable
    private CidrExecutionStack getExecutionStack() {
        XSuspendContext xSuspendContext = this.getSession().getSuspendContext();
        if (xSuspendContext instanceof CidrSuspendContext) {
            CidrSuspendContext suspendContext = (CidrSuspendContext)xSuspendContext;
            return suspendContext.getActiveExecutionStack();
        }
        return null;
    }

    @Override
    @NotNull
    public <T extends CidrDebuggingFixture.DriverEvent> CidrDebuggingFixture.EventFilter<CidrDebuggingFixture.DriverEvent, T> fixupDriverEventFilter(@NotNull CidrDebuggingFixture.DriverEvent.Kind<T> eventKind) {
        if (eventKind == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(10);
        }
        Consumer<CidrDebuggingFixture.DriverEvent> preAssert = this.getDriverEventPreAssertFor(eventKind);
        CidrDebuggingFixture.EventFilter eventFilter = eventKind.withPreAssert(preAssert);
        if (eventFilter == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(11);
        }
        return eventFilter;
    }

    @Nullable
    private Consumer<CidrDebuggingFixture.DriverEvent> getDriverEventPreAssertFor(@NotNull CidrDebuggingFixture.DriverEvent.Kind<?> eventKind) {
        if (eventKind == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(12);
        }
        if (eventKind == CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT) {
            OSType osType = this.getEnvironment().getHostMachine().getOSType();
            if (osType == OSType.LINUX && this.myDriverKind == DebuggerDriverKind.LLDB) {
                return event -> FlakyConditionKt.flakyCondition("Sometimes the debugger reports a breakpoint as a SIGTRAP signal", CLionDebuggingFixture.probeEvent(event, CidrDebuggingFixture.DriverEvent.Kind.SIGNAL, e -> e.name.equals("SIGTRAP")));
            }
            if (osType == OSType.MAC && this.myDriverKind == DebuggerDriverKind.LLDB) {
                return event -> FlakyConditionKt.flakyCondition("Sometimes the debugger reports a breakpoint as ThreadStopReasonInvalid", CLionDebuggingFixture.probeEvent(event, CidrDebuggingFixture.DriverEvent.Kind.INTERRUPTED, e -> e.stopPlace.thread.getId() == -1L && e.stopPlace.frame.getIndex() == -1));
            }
        }
        if (eventKind == CidrDebuggingFixture.DriverEvent.Kind.FINISHED && this.getEnvironment().isCygwin()) {
            return event -> FlakyConditionKt.flakyCondition("Sometimes GDB on Cygwin intercepts a SIGNAL in ntdll!KiRaiseUserExceptionDispatcher", CLionDebuggingFixture.probeEvent(event, CidrDebuggingFixture.DriverEvent.Kind.SIGNAL, e -> e.description != null && e.description.contains("Unknown signal")));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverKind";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CLionDebuggingFixture";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerState";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CLionDebuggingFixture";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchitectureType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toAppEnvPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fixupDebuggerStateFilter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fixupDriverEventFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toAppEnvPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fixupDebuggerStateFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDebuggerStatePreAssertFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fixupDriverEventFilter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDriverEventPreAssertFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 8, 11 -> new IllegalStateException(string);
        };
    }
}

