/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.system.CpuArch;
import com.jetbrains.cidr.CidrTestCaseBase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPTestCase;
import com.jetbrains.cidr.cpp.cmake.CMakeProjectFixture;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeListener;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakePlainGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeMessagesCollector;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeMessagesContainer;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeOutputConsole;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeModelFixture {
    private final CidrTestDataFixture myTestDataFixture;
    @Nullable
    private final String myMinimumCmakeVersionOrNullForDefault;
    private int configCounter = 0;

    public CMakeModelFixture(CidrTestDataFixture testDataFixture, @Nullable String minimumCmakeVersionOrNullForDefault) {
        this.myTestDataFixture = testDataFixture;
        this.myMinimumCmakeVersionOrNullForDefault = minimumCmakeVersionOrNullForDefault;
    }

    @NotNull
    public File prepareTestData(@NotNull String relativeTestProject) {
        if (relativeTestProject == null) {
            CMakeModelFixture.$$$reportNull$$$0(0);
        }
        File file2 = this.prepareTestData(relativeTestProject, this.myTestDataFixture.createTempIODir());
        if (file2 == null) {
            CMakeModelFixture.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @NotNull
    public File prepareTestData(@NotNull String relativeTestProject, @NotNull File copyInto) {
        if (relativeTestProject == null) {
            CMakeModelFixture.$$$reportNull$$$0(2);
        }
        if (copyInto == null) {
            CMakeModelFixture.$$$reportNull$$$0(3);
        }
        File testData = this.myTestDataFixture.getTestDataProjectsFile(relativeTestProject);
        this.myTestDataFixture.copyTestData(testData, copyInto);
        File result2 = new File(copyInto, testData.getName());
        FileUtil.processFilesRecursively((File)result2, file2 -> {
            try {
                if (file2.getName().equalsIgnoreCase("CMakeLists.txt") && FileUtil.loadFile((File)file2).contains("project(")) {
                    String version = this.myMinimumCmakeVersionOrNullForDefault == null ? CMakeModelFixture.getCurrentCMakeVersion() : this.myMinimumCmakeVersionOrNullForDefault;
                    String updateWith = "cmake_minimum_required(VERSION " + version + ")";
                    this.myTestDataFixture.updateIOFileRegexpText((File)file2, "(.*)cmake_minimum_required\\(VERSION .*?\\)(.*)", "$1" + Matcher.quoteReplacement(updateWith) + "$2");
                    return false;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Main CMakeLists.txt should contain cmake_minimum_required() line ", e);
            }
            return true;
        });
        File file3 = result2;
        if (file3 == null) {
            CMakeModelFixture.$$$reportNull$$$0(4);
        }
        return file3;
    }

    @NotNull
    private static String getCurrentCMakeVersion() {
        String string = CPPTestCase.getTestCMakeVersion();
        if (string == null) {
            CMakeModelFixture.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public GenerateInfo generateProjectFromScratch(@NotNull String relativeTestProject, String ... configNames) {
        if (relativeTestProject == null) {
            CMakeModelFixture.$$$reportNull$$$0(6);
        }
        File projectDir = this.prepareTestData(relativeTestProject);
        if (configNames.length == 0) {
            configNames = new String[]{"Debug"};
        }
        GenerateInfo generateInfo = this.generateProject(projectDir, null, ContainerUtil.map((Object[])configNames, name -> this.config((String)name, this.myTestDataFixture.createTempIODir())));
        if (generateInfo == null) {
            CMakeModelFixture.$$$reportNull$$$0(7);
        }
        return generateInfo;
    }

    @NotNull
    public CMakeGeneratorParameters config(@NotNull String profileAndBuildType) {
        if (profileAndBuildType == null) {
            CMakeModelFixture.$$$reportNull$$$0(8);
        }
        CMakeGeneratorParameters cMakeGeneratorParameters = this.config(profileAndBuildType, this.myTestDataFixture.createTempIODir());
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(9);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public CMakeGeneratorParameters config(@NotNull String profileAndBuildType, @NotNull File generatedDir) {
        if (profileAndBuildType == null) {
            CMakeModelFixture.$$$reportNull$$$0(10);
        }
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(11);
        }
        CMakeGeneratorParameters cMakeGeneratorParameters = this.config(profileAndBuildType, generatedDir, Collections.emptyList(), true, Collections.emptyMap());
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(12);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public CMakeGeneratorParameters withAdditionalOptions(@NotNull String profileAndBuildType, String ... additionalOptions) {
        if (profileAndBuildType == null) {
            CMakeModelFixture.$$$reportNull$$$0(13);
        }
        if (additionalOptions == null) {
            CMakeModelFixture.$$$reportNull$$$0(14);
        }
        CMakeGeneratorParameters cMakeGeneratorParameters = this.withAdditionalOptions(profileAndBuildType, this.myTestDataFixture.createTempIODir(), additionalOptions);
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(15);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public CMakeGeneratorParameters withAdditionalOptions(@NotNull String profileAndBuildType, @NotNull File generatedDir, String ... additionalOptions) {
        if (profileAndBuildType == null) {
            CMakeModelFixture.$$$reportNull$$$0(16);
        }
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(17);
        }
        if (additionalOptions == null) {
            CMakeModelFixture.$$$reportNull$$$0(18);
        }
        CMakeGeneratorParameters cMakeGeneratorParameters = this.config(profileAndBuildType, generatedDir, Arrays.asList(additionalOptions), true, Collections.emptyMap());
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(19);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public CMakeGeneratorParameters withEnvironment(@NotNull String profileAndBuildType, @NotNull File generatedDir, boolean passSystem, String ... additionalVariables) {
        if (profileAndBuildType == null) {
            CMakeModelFixture.$$$reportNull$$$0(20);
        }
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(21);
        }
        if (additionalVariables == null) {
            CMakeModelFixture.$$$reportNull$$$0(22);
        }
        Map<String, String> map = IntStream.range(0, additionalVariables.length / 2).mapToObj(i -> Map.entry(additionalVariables[2 * i], additionalVariables[2 * i + 1])).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        CMakeGeneratorParameters cMakeGeneratorParameters = this.config(profileAndBuildType, generatedDir, Collections.emptyList(), passSystem, map);
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(23);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public CMakeGeneratorParameters debug() {
        CMakeGeneratorParameters cMakeGeneratorParameters = this.debug(this.myTestDataFixture.createTempIODir());
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(24);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public CMakeGeneratorParameters debug(@NotNull File generatedDir) {
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(25);
        }
        CMakeGeneratorParameters cMakeGeneratorParameters = this.config("Debug", generatedDir);
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(26);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public CMakeGeneratorParameters debugWithAdditionalOptions(String ... additionalOptions) {
        if (additionalOptions == null) {
            CMakeModelFixture.$$$reportNull$$$0(27);
        }
        CMakeGeneratorParameters cMakeGeneratorParameters = this.withAdditionalOptions("Debug", additionalOptions);
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(28);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public CMakeGeneratorParameters debugWithAdditionalOptions(@NotNull File generatedDir, String ... additionalOptions) {
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(29);
        }
        if (additionalOptions == null) {
            CMakeModelFixture.$$$reportNull$$$0(30);
        }
        CMakeGeneratorParameters cMakeGeneratorParameters = this.withAdditionalOptions("Debug", generatedDir, additionalOptions);
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(31);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public CMakeGeneratorParameters debugWithEnvironment(@NotNull File generatedDir, boolean passSystem, String ... additionalEnvironment) {
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(32);
        }
        if (additionalEnvironment == null) {
            CMakeModelFixture.$$$reportNull$$$0(33);
        }
        CMakeGeneratorParameters cMakeGeneratorParameters = this.withEnvironment("Debug", generatedDir, passSystem, additionalEnvironment);
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(34);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public CMakeGeneratorParameters config(@NotNull String profileAndBuildType, @NotNull File generatedDir, @NotNull List<String> additionalOptions, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment) {
        if (profileAndBuildType == null) {
            CMakeModelFixture.$$$reportNull$$$0(35);
        }
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(36);
        }
        if (additionalOptions == null) {
            CMakeModelFixture.$$$reportNull$$$0(37);
        }
        if (additionalEnvironment == null) {
            CMakeModelFixture.$$$reportNull$$$0(38);
        }
        CMakeSettings.Profile profile = new CMakeSettings.Profile(profileAndBuildType, profileAndBuildType, CPPTestCase.getTestCPPEnvironment().getToolchain().getName(), ParametersListUtil.join(additionalOptions), passSystemEnvironment, additionalEnvironment, generatedDir, "");
        CMakeGeneratorParameters parameters = CMakeGeneratorParameters.calculateFromProfile(null, (CMakeSettings.Profile)profile, (int)this.configCounter++, (File)generatedDir, (ToolVersion)CPPTestCase.getTestCMakeParsedToolVersion(), (CPPEnvironment)CPPTestCase.getTestCPPEnvironment());
        TestCase.assertNotNull((Object)parameters);
        CMakeGeneratorParameters cMakeGeneratorParameters = parameters;
        if (cMakeGeneratorParameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(39);
        }
        return cMakeGeneratorParameters;
    }

    @NotNull
    public GenerateInfo generateProject(@NotNull GenerateInfo info) {
        if (info == null) {
            CMakeModelFixture.$$$reportNull$$$0(40);
        }
        GenerateInfo generateInfo = this.generateProject(info.projectDir, info.model, ContainerUtil.map((Collection)info.model.getConfigurationData(), each -> each.asGeneratorParameters(CPPTestCase.getTestCPPEnvironment())));
        if (generateInfo == null) {
            CMakeModelFixture.$$$reportNull$$$0(41);
        }
        return generateInfo;
    }

    @NotNull
    public GenerateInfo generateProject(@NotNull File projectDir, @Nullable CMakeModel existingModel, CMakeGeneratorParameters ... parameters) {
        if (projectDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(42);
        }
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(43);
        }
        GenerateInfo generateInfo = this.generateProject(projectDir, existingModel, Arrays.asList(parameters));
        if (generateInfo == null) {
            CMakeModelFixture.$$$reportNull$$$0(44);
        }
        return generateInfo;
    }

    @NotNull
    public GenerateInfo generateProject(@NotNull File projectDir, @Nullable CMakeModel existingModel, @NotNull List<CMakeGeneratorParameters> parameters) {
        if (projectDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(45);
        }
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(46);
        }
        GenerateInfo generateInfo = this.generateProject(projectDir, existingModel, Charset.defaultCharset(), parameters);
        if (generateInfo == null) {
            CMakeModelFixture.$$$reportNull$$$0(47);
        }
        return generateInfo;
    }

    @NotNull
    public GenerateInfo generateProject(@NotNull File projectDir, @Nullable CMakeModel existingModel, @NotNull Charset charset, @NotNull List<CMakeGeneratorParameters> parameters) {
        if (projectDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(48);
        }
        if (charset == null) {
            CMakeModelFixture.$$$reportNull$$$0(49);
        }
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(50);
        }
        GenerateInfo generateInfo = this.generateProject(projectDir, existingModel, charset, true, parameters);
        if (generateInfo == null) {
            CMakeModelFixture.$$$reportNull$$$0(51);
        }
        return generateInfo;
    }

    @NotNull
    public GenerateInfo generateProject(@NotNull File projectDir, @Nullable CMakeModel existingModel, @NotNull Charset charset, boolean enableCacheGeneration, @NotNull List<CMakeGeneratorParameters> parameters) {
        if (projectDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(52);
        }
        if (charset == null) {
            CMakeModelFixture.$$$reportNull$$$0(53);
        }
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(54);
        }
        List preparedParameters = ContainerUtil.map(parameters, p -> {
            TestCMakeListener listener = new TestCMakeListener(p.getEnvironment(), projectDir);
            p = p.withListener((CMakeListener)listener);
            if (enableCacheGeneration) {
                p = CMakeProjectFixture.prepareCMakeProjectCache(p);
            }
            return p;
        });
        CMakePlainGenerator generator = new CMakePlainGenerator(ProjectManager.getInstance().getDefaultProject(), CMakeModelFixture.toNonCanonicalPath(projectDir), preparedParameters, charset.name(), charset);
        CMakeModel model2 = generator.generate(existingModel, (ProgressIndicator)new EmptyProgressIndicator());
        CMakeMessagesContainer messagesContainer = new CMakeMessagesContainer();
        for (CMakeGeneratorParameters p2 : preparedParameters) {
            messagesContainer.addAll(p2.getProfileName(), ((TestCMakeListener)p2.getListener()).getMessages());
        }
        return new GenerateInfo(projectDir, model2, (CMakeData<List<CMakeMessage>>)messagesContainer.getMessages(), parameters);
    }

    private static File toNonCanonicalPath(File projectDir) {
        return new File(projectDir.getPath() + "/../" + projectDir.getName());
    }

    public List<String> getTargetNames(GenerateInfo info) {
        return ContainerUtil.map((Collection)info.model.getTargets(), target2 -> target2.getName());
    }

    public void assertTargets(GenerateInfo info, String ... expectedTargets) {
        UsefulTestCase.assertSameElements(this.getTargetNames(info), expectedTargets);
    }

    @Nullable
    public CMakeTarget findTarget(GenerateInfo info, @NotNull String targetName) {
        if (targetName == null) {
            CMakeModelFixture.$$$reportNull$$$0(55);
        }
        for (CMakeTarget eachTarget : info.model.getTargets()) {
            if (!eachTarget.getName().equals(targetName)) continue;
            return eachTarget;
        }
        return null;
    }

    @Nullable
    public CMakeConfiguration findConfig(GenerateInfo info, @NotNull String targetName, @NotNull String configName) {
        if (targetName == null) {
            CMakeModelFixture.$$$reportNull$$$0(56);
        }
        if (configName == null) {
            CMakeModelFixture.$$$reportNull$$$0(57);
        }
        CMakeTarget target2 = this.findTarget(info, targetName);
        TestCase.assertNotNull((String)("target not found " + targetName), (Object)target2);
        for (CMakeConfiguration eachConfig : target2.getBuildConfigurations()) {
            if (!eachConfig.getName().equals(configName)) continue;
            return eachConfig;
        }
        return null;
    }

    public void assertTargetConfigs(GenerateInfo info, String targetName, String ... expectedConfigs) {
        this.assertTargetConfigs(info, targetName, Arrays.asList(expectedConfigs));
    }

    public void assertTargetConfigs(GenerateInfo info, String targetName, List<String> expectedConfigs) {
        for (CMakeTarget eachTarget : info.model.getTargets()) {
            if (!eachTarget.getName().equals(targetName)) continue;
            UsefulTestCase.assertOrderedEquals(ContainerUtil.map((Collection)eachTarget.getBuildConfigurations(), each -> each.getName()), expectedConfigs);
            return;
        }
        UsefulTestCase.fail((String)("target not found " + targetName));
    }

    public void assertSources(GenerateInfo info, @Nullable String targetOrNullForAll, @Nullable String configNameOrNullForAll, String ... relativePaths) {
        ArrayList<File> result2 = new ArrayList<File>(relativePaths.length);
        for (String t : relativePaths) {
            result2.add(this.subFile(info, t));
        }
        UsefulTestCase.assertSameElements(this.getSources(info, targetOrNullForAll, configNameOrNullForAll), result2);
    }

    public Set<File> getSources(GenerateInfo info, @Nullable String targetOrNullForAll, @Nullable String configNameOrNullForAll) {
        boolean targetFound = targetOrNullForAll == null;
        boolean configFound = configNameOrNullForAll == null;
        HashSet<File> actualFiles = new HashSet<File>();
        for (CMakeTarget eachTarget : info.model.getTargets()) {
            if (targetOrNullForAll != null && !eachTarget.getName().equals(targetOrNullForAll)) continue;
            targetFound = true;
            for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                configFound = true;
                if (configNameOrNullForAll != null && !eachConfig.getName().equals(configNameOrNullForAll)) continue;
                actualFiles.addAll(eachConfig.getSources());
            }
        }
        UsefulTestCase.assertTrue((String)("target not found " + targetOrNullForAll), (boolean)targetFound);
        UsefulTestCase.assertTrue((String)("config not found " + configNameOrNullForAll), (boolean)configFound);
        return actualFiles;
    }

    public void assertFileLanguage(GenerateInfo info, @NotNull String relativeFile, @NotNull String targetName, @NotNull String configName, @Nullable OCLanguageKind expectedLanguage) {
        if (relativeFile == null) {
            CMakeModelFixture.$$$reportNull$$$0(58);
        }
        if (targetName == null) {
            CMakeModelFixture.$$$reportNull$$$0(59);
        }
        if (configName == null) {
            CMakeModelFixture.$$$reportNull$$$0(60);
        }
        CMakeConfiguration config = this.findConfig(info, targetName, configName);
        String targetConfig = targetName + "-" + configName;
        TestCase.assertNotNull((String)("config not found " + targetConfig), (Object)config);
        CMakeFileSettings fileSettings = config.getFileSettings(this.subFile(info, relativeFile));
        TestCase.assertNotNull((String)("file settings not found for " + relativeFile + " in " + targetConfig), (Object)fileSettings);
        TestCase.assertEquals((Object)expectedLanguage, (Object)fileSettings.getLanguageKind());
    }

    @Nullable
    public File getProductFile(GenerateInfo info, String targetName, String configName) {
        CMakeConfiguration config = this.findConfig(info, targetName, configName);
        TestCase.assertNotNull((String)("Config " + targetName + "-" + configName + " not found"), (Object)config);
        File productFile = config.getProductFile();
        if (productFile != null) {
            productFile = new File(FileUtil.toCanonicalPath((String)productFile.getPath()));
        }
        return productFile;
    }

    @NotNull
    public File subFile(GenerateInfo info, String relativePath) {
        return new File(FileUtil.toCanonicalPath((String)new File(info.projectDir, relativePath).getPath()));
    }

    public Collection<String> configurationsForFile(GenerateInfo info, @NotNull String relativePath) {
        if (relativePath == null) {
            CMakeModelFixture.$$$reportNull$$$0(61);
        }
        return this.configurationsForFile(info, this.subFile(info, relativePath));
    }

    public Collection<String> configurationsForFile(GenerateInfo info, @NotNull File file2) {
        if (file2 == null) {
            CMakeModelFixture.$$$reportNull$$$0(62);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (CMakeTarget eachTarget : info.model.getTargets()) {
            for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                if (!eachConfig.getSources().contains(file2)) continue;
                result2.add(eachConfig.getName());
            }
        }
        return result2;
    }

    public void assertNoConfigurationErrors(GenerateInfo info) {
        for (List each : info.messages.getAll().values()) {
            UsefulTestCase.assertEmpty(each);
        }
    }

    public void assertMessageMatches(CMakeMessage actualMessage, CMakeMessage.MessageLevel error2, File file2, Integer line, @RegExp String textRegexp) {
        String str = actualMessage.toString();
        TestCase.assertEquals((String)str, (Object)error2, (Object)actualMessage.getLevel());
        TestCase.assertEquals((String)str, (Object)file2, (Object)actualMessage.getFile());
        TestCase.assertEquals((String)str, (Object)line, (Object)actualMessage.getLine());
        CidrTestCaseBase.assertMatches(actualMessage.getText(), textRegexp, 40);
    }

    public CMakeVariable findVariable(Collection<CMakeVariable> variables, String variableName) {
        for (CMakeVariable each : variables) {
            if (!each.getName().equals(variableName)) continue;
            return each;
        }
        return null;
    }

    public static void assertFlags(List<String> actualFlags, List<String> expectedFlags) {
        CMakeModelFixture.assertFlags(actualFlags, expectedFlags, true);
    }

    public static void assertFlags(List<String> actualFlags, List<String> expectedFlags, boolean assertOrder) {
        expectedFlags = ContainerUtil.map(expectedFlags, s -> FileUtil.toSystemIndependentName((String)s));
        ArrayList<String> effectiveFlags = new ArrayList<String>(ContainerUtil.map(actualFlags, s -> FileUtil.toSystemIndependentName((String)s)));
        int iSysrootIdx = effectiveFlags.indexOf("-isysroot");
        if (iSysrootIdx >= 0) {
            effectiveFlags.remove(iSysrootIdx);
            effectiveFlags.remove(iSysrootIdx);
        }
        effectiveFlags.removeIf(string -> string.contains("-mmacosx-version-min"));
        effectiveFlags.removeIf(string -> string.contains("diagnostics-color"));
        effectiveFlags.removeIf(string -> string.contains("color-diagnostics"));
        if (SystemInfo.isMac && CpuArch.isArm64()) {
            for (int i = 0; i < effectiveFlags.size() - 1; ++i) {
                if (((String)effectiveFlags.get(i)).equals("-arch") && ((String)effectiveFlags.get(i + 1)).equals("arm64")) {
                    effectiveFlags.remove(i + 1);
                    effectiveFlags.remove(i);
                    break;
                }
                if (!((String)effectiveFlags.get(i)).equals("-arch arm64")) continue;
                effectiveFlags.remove(i);
                break;
            }
        }
        if (assertOrder) {
            UsefulTestCase.assertOrderedEquals(effectiveFlags, expectedFlags);
        } else {
            UsefulTestCase.assertSameElements(effectiveFlags, expectedFlags);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 7, 9, 12, 15, 19, 23, 24, 26, 28, 31, 34, 39, 41, 44, 47, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeTestProject";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 39: 
            case 41: 
            case 44: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyInto";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileAndBuildType";
                break;
            }
            case 11: 
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedDir";
                break;
            }
            case 14: 
            case 18: 
            case 27: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalOptions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalVariables";
                break;
            }
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEnvironment";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 42: 
            case 45: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 43: 
            case 46: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 55: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFile";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTestData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCMakeVersion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProjectFromScratch";
                break;
            }
            case 9: 
            case 12: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "config";
                break;
            }
            case 15: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withAdditionalOptions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvironment";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "debug";
                break;
            }
            case 28: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "debugWithAdditionalOptions";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "debugWithEnvironment";
                break;
            }
            case 41: 
            case 44: 
            case 47: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestData";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 39: 
            case 41: 
            case 44: 
            case 47: 
            case 51: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateProjectFromScratch";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "config";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withAdditionalOptions";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withEnvironment";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "debugWithAdditionalOptions";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "debugWithEnvironment";
                break;
            }
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findTarget";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "findConfig";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "assertFileLanguage";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "configurationsForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 7, 9, 12, 15, 19, 23, 24, 26, 28, 31, 34, 39, 41, 44, 47, 51 -> new IllegalStateException(string);
        };
    }

    public static class GenerateInfo {
        public File projectDir;
        public CMakeModel model;
        public CMakeData<List<CMakeMessage>> messages;
        public final List<CMakeGeneratorParameters> parameters;

        public GenerateInfo(File projectDir, CMakeModel model2, CMakeData<List<CMakeMessage>> messages, List<CMakeGeneratorParameters> parameters) {
            this.projectDir = projectDir;
            this.model = model2;
            this.messages = messages;
            this.parameters = parameters;
        }

        @NotNull
        public List<String> getConfigNames() {
            List list = ContainerUtil.map((Collection)this.model.getConfigurationData(), it -> it.getConfigName());
            if (list == null) {
                GenerateInfo.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public File getGenerationDir(String configType) {
            File file2 = this.getConfigurationData(configType).getGenerationDir();
            if (file2 == null) {
                GenerateInfo.$$$reportNull$$$0(1);
            }
            return file2;
        }

        @NotNull
        public CMakeModelConfigurationData getConfigurationData(String configName) {
            CMakeModelConfigurationData cMakeModelConfigurationData = this.model.getConfigurationData().stream().filter(it -> it.getConfigName().equals(configName)).findFirst().get();
            if (cMakeModelConfigurationData == null) {
                GenerateInfo.$$$reportNull$$$0(2);
            }
            return cMakeModelConfigurationData;
        }

        @NotNull
        public CMakeGeneratorSpec getGeneratorSpec() {
            CMakeGeneratorSpec cMakeGeneratorSpec = this.getGeneratorSpec(null);
            if (cMakeGeneratorSpec == null) {
                GenerateInfo.$$$reportNull$$$0(3);
            }
            return cMakeGeneratorSpec;
        }

        @NotNull
        public CMakeGeneratorSpec getGeneratorSpec(@Nullable String configNameOrNullForDefault) {
            CMakeGeneratorParameters parameters = this.getParameters(configNameOrNullForDefault);
            TestCase.assertNotNull((Object)parameters);
            CMakeGeneratorSpec cMakeGeneratorSpec = parameters.getGeneratorSpec();
            if (cMakeGeneratorSpec == null) {
                GenerateInfo.$$$reportNull$$$0(4);
            }
            return cMakeGeneratorSpec;
        }

        public boolean isApi() {
            return this.isApi(null);
        }

        public boolean isApi(@Nullable String configNameOrNullForDefault) {
            CMakeGeneratorParameters parameters = this.getParameters(configNameOrNullForDefault);
            TestCase.assertNotNull((Object)parameters);
            return parameters.getShouldUseAPI();
        }

        @Nullable
        public CMakeGeneratorParameters getParameters(@Nullable String configNameOrNullForDefault) {
            if (configNameOrNullForDefault == null) {
                return this.parameters.get(0);
            }
            return this.parameters.stream().filter(it -> it.getProfileName().equals(configNameOrNullForDefault)).findFirst().get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture$GenerateInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigNames";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGenerationDir";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationData";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGeneratorSpec";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class TestCMakeListener
    implements CMakeListener {
        private final CMakeMessagesCollector myMessagesCollector;

        TestCMakeListener(@NotNull CPPEnvironment environment, @NotNull File projectDir) {
            if (environment == null) {
                TestCMakeListener.$$$reportNull$$$0(0);
            }
            if (projectDir == null) {
                TestCMakeListener.$$$reportNull$$$0(1);
            }
            this.myMessagesCollector = new CMakeMessagesCollector(null, environment, projectDir.toPath());
        }

        public void message(@NotNull CMakeMessage message) {
            if (message == null) {
                TestCMakeListener.$$$reportNull$$$0(2);
            }
            this.myMessagesCollector.addMessage(message);
        }

        public void messageWithFix(@NotNull CMakeMessage message, @NotNull CMakeOutputConsole.Fix fix) {
            if (message == null) {
                TestCMakeListener.$$$reportNull$$$0(3);
            }
            if (fix == null) {
                TestCMakeListener.$$$reportNull$$$0(4);
            }
            this.myMessagesCollector.addMessage(message);
        }

        public void attachTo(@NotNull ProcessHandler handler) {
            if (handler == null) {
                TestCMakeListener.$$$reportNull$$$0(5);
            }
            this.myMessagesCollector.attachToProcess(handler);
        }

        @NotNull
        public List<CMakeMessage> getMessages() {
            List list = this.myMessagesCollector.getMessages();
            if (list == null) {
                TestCMakeListener.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectDir";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture$TestCMakeListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture$TestCMakeListener";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "message";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "messageWithFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "attachTo";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }
}

