/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.actions.OCExtractBlockParameterAction;
import com.jetbrains.cidr.lang.refactoring.changeSignature.actions.OCExtractLambdaParameterAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceConstantAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceDefineAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceIvarAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceParameterAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroducePropertyAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceTypedefAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceVariableAction;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrRefactoringFixture {
    public static final RefactoringActionHandler ourVariableIntroducer = new OCIntroduceVariableAction().getHandler();
    public static final RefactoringActionHandler ourConstIntroducer = new OCIntroduceConstantAction().getHandler();
    public static final RefactoringActionHandler ourParamIntroducer = new OCIntroduceParameterAction().getHandler();
    public static final RefactoringActionHandler ourPropertyIntroducer = new OCIntroducePropertyAction().getHandler();
    public static final RefactoringActionHandler ourIvarIntroducer = new OCIntroduceIvarAction().getHandler();
    public static final RefactoringActionHandler ourTypedefIntroducer = new OCIntroduceTypedefAction().getHandler();
    public static final RefactoringActionHandler ourDefineIntroducer = new OCIntroduceDefineAction().getHandler();
    public static final RefactoringActionHandler ourExtractBlockParameterHandler = new OCExtractBlockParameterAction().getHandler();
    public static final RefactoringActionHandler ourExtractLambdaParameterHandler = new OCExtractLambdaParameterAction().getHandler();
    public static final RefactoringActionHandler ourExtractMethodHandler = new OCExtractBlockParameterAction(){

        @Nullable
        protected OCCallableKind getCallableKind() {
            return null;
        }
    }.getHandler();

    public static LanguageCodeInsightActionHandler getActionFromRefactoringActionHandler(final RefactoringActionHandler actionHandler) {
        return new LanguageCodeInsightActionHandler(){

            public boolean isValidFor(Editor editor, PsiFile file2) {
                return true;
            }

            public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                actionHandler.invoke(project2, editor, file2, EditorUtil.getEditorDataContext((Editor)editor));
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/CidrRefactoringFixture$2";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static void performMoveFile(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiDirectory target2) {
        if (project2 == null) {
            CidrRefactoringFixture.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CidrRefactoringFixture.$$$reportNull$$$0(1);
        }
        if (target2 == null) {
            CidrRefactoringFixture.$$$reportNull$$$0(2);
        }
        new MoveFilesOrDirectoriesProcessor(project2, new PsiElement[]{file2}, target2, RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE, false, false, null, null).run();
    }

    public static void performRename(Editor editor, String newName) {
        CidrRefactoringFixture.performRename(editor, newName, null, true);
    }

    public static void performRename(Editor editor, String newName, @Nullable String assertException, boolean inPlace) {
        CidrRefactoringFixture.performRename(editor, newName, assertException, inPlace, true, true);
    }

    public static void performRename(Editor editor, String newName, @Nullable String assertException, boolean inPlace, boolean searchInComments, boolean searchInTextOccurrences) {
        PsiElement element = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
        TestCase.assertNotNull((String)"Element to rename not found", (Object)element);
        CidrRefactoringFixture.performRename(editor.getProject(), element, newName, assertException, inPlace, searchInComments, searchInTextOccurrences);
    }

    public static void performRenameFile(Project project2, @NotNull PsiFile file2, String newName) {
        if (file2 == null) {
            CidrRefactoringFixture.$$$reportNull$$$0(3);
        }
        CidrRefactoringFixture.performRename(project2, (PsiElement)file2, newName, null, false);
    }

    public static void performRename(@Nullable Project project2, PsiElement element, String newName, @Nullable String assertException, boolean inPlace) {
        CidrRefactoringFixture.performRename(project2, element, newName, assertException, inPlace, true, true);
    }

    private static void performRename(@Nullable Project project2, PsiElement element, String newName, @Nullable String assertException, boolean inPlace, boolean searchInComments, boolean searchInTextOccurrences) {
        try {
            Editor editor;
            Editor editor2 = editor = element.getContainingFile() == null ? null : CodeInsightTestUtil.openEditorFor(element);
            if (inPlace) {
                OCInplaceRenamer renamer = (OCInplaceRenamer)new OCInplaceRenameHandler().createRenamer(element, editor);
                assert (renamer != null);
                renamer.performRefactoringForTest(newName);
            } else {
                PsiElement substitution = RenamePsiElementProcessor.forElement((PsiElement)element).substituteElementToRename(element, editor);
                if (substitution == null) {
                    return;
                }
                new RenameProcessor(project2, substitution, newName, searchInComments, searchInTextOccurrences).run();
            }
        }
        catch (Exception e) {
            if (assertException == null) {
                throw e;
            }
            TestCase.assertEquals((String)e.getMessage(), (String)assertException);
            return;
        }
        if (assertException != null) {
            TestCase.fail((String)("Exception was not thrown: " + assertException));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/CidrRefactoringFixture";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performMoveFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performRenameFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

