/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.PairProcessor;
import com.intellij.util.PathUtilRt;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrRefactoringFixture;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public class CidrIncludeModificationsFixture {
    @NotNull
    private final CidrCodeInsightFixture myCodeInsightFixture;
    @NotNull
    private final CidrProjectFixture myProjectFixture;
    @NotNull
    private final Project myProject;
    private final int myExpectedFilesCount;

    public CidrIncludeModificationsFixture(@NotNull CidrProjectFixture projectFixture2, @NotNull CidrCodeInsightFixture fixture, int expectedFilesCount) {
        if (projectFixture2 == null) {
            CidrIncludeModificationsFixture.$$$reportNull$$$0(0);
        }
        if (fixture == null) {
            CidrIncludeModificationsFixture.$$$reportNull$$$0(1);
        }
        this.myCodeInsightFixture = fixture;
        this.myProjectFixture = projectFixture2;
        this.myProject = projectFixture2.getProject();
        this.myExpectedFilesCount = expectedFilesCount;
    }

    public static String @NotNull [] affects(String filename, String before2, String after2) {
        String[] stringArray = new String[]{filename, before2, after2};
        if (stringArray == null) {
            CidrIncludeModificationsFixture.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    public static String includeQ(String path) {
        String string = "#include \"" + path + "\"";
        if (string == null) {
            CidrIncludeModificationsFixture.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String includeB(String path) {
        String string = "#include <" + path + ">";
        if (string == null) {
            CidrIncludeModificationsFixture.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String importQ(String path) {
        String string = "#import \"" + path + "\"";
        if (string == null) {
            CidrIncludeModificationsFixture.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String importB(String path) {
        String string = "#import <" + path + ">";
        if (string == null) {
            CidrIncludeModificationsFixture.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void doTestRename(String from, String to, String[] ... affected) {
        Map<VirtualFile, List<String>> expected = this.prepareExpected(affected);
        CidrRefactoringFixture.performRenameFile(this.myProject, (PsiFile)this.myCodeInsightFixture.getOCFile(from), to);
        TestCase.assertNull((String)("Renamed file still exists with old name " + from), (Object)this.myProjectFixture.findProjectSubFile(from));
        String parentPath = PathUtilRt.getParentPath((String)from);
        TestCase.assertNotNull((String)("Renamed file not found with new name " + from + " -> " + to), (Object)this.myProjectFixture.findProjectSubFile(parentPath + (parentPath.isEmpty() ? "" : "/") + to));
        this.checkIncludes(expected);
    }

    public void doTestMove(String filePath, String newLocation, String[] ... affected) {
        Map<VirtualFile, List<String>> expected = this.prepareExpected(affected);
        OCFile file2 = this.myCodeInsightFixture.getOCFile(filePath);
        PsiDirectory target2 = this.myProjectFixture.findProjectSubPsiDirectory(newLocation);
        TestCase.assertNotNull((String)"Invalid move target", (Object)target2);
        CidrRefactoringFixture.performMoveFile(this.myProject, (PsiFile)file2, target2);
        TestCase.assertNull((String)("Moved file still exists " + filePath), (Object)this.myProjectFixture.findProjectSubFile(filePath));
        TestCase.assertNotNull((String)("Moved file not found at the new location " + filePath + " -> " + newLocation), (Object)this.myProjectFixture.findProjectSubFile(newLocation + (newLocation.isEmpty() ? "" : "/") + PathUtilRt.getFileName((String)filePath)));
        this.checkIncludes(expected);
    }

    @NotNull
    private Map<VirtualFile, List<String>> prepareExpected(String[][] affected) {
        HashMap<VirtualFile, List<String>> expected = new HashMap<VirtualFile, List<String>>();
        HashMap<Pair, String> affectedFiles = new HashMap<Pair, String>();
        for (String[] triplet : affected) {
            affectedFiles.put(Pair.create((Object)this.myProjectFixture.getProjectSubFile(triplet[0]), (Object)triplet[1]), triplet[2]);
        }
        this.myCodeInsightFixture.processOCFiles((PairProcessor<? super OCFile, ? super VirtualFile>)((PairProcessor)(ocFile, file2) -> {
            ArrayList<String> includes = new ArrayList<String>();
            for (OCIncludeDirective directive : ocFile.findIncludeDirectives()) {
                if (directive.getDelimiters() == OCIncludeDirective.Delimiters.NONE) continue;
                String newText = (String)affectedFiles.get(Pair.create((Object)file2, (Object)directive.getText()));
                includes.add(newText != null ? newText : directive.getText());
            }
            expected.put((VirtualFile)file2, (List<String>)includes);
            return true;
        }), this.myExpectedFilesCount);
        HashMap<VirtualFile, List<String>> hashMap = expected;
        if (hashMap == null) {
            CidrIncludeModificationsFixture.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    private void checkIncludes(Map<VirtualFile, List<String>> expected) {
        this.myCodeInsightFixture.processOCFiles((PairProcessor<? super OCFile, ? super VirtualFile>)((PairProcessor)(ocFile, file2) -> {
            ArrayList<String> actualIncludes = new ArrayList<String>();
            for (OCIncludeDirective directive : ocFile.findIncludeDirectives()) {
                if (directive.getDelimiters() == OCIncludeDirective.Delimiters.NONE) continue;
                actualIncludes.add(directive.getText());
            }
            UsefulTestCase.assertOrderedEquals("Unexpected includes for " + file2.getName(), actualIncludes, (Iterable)expected.get(file2));
            return true;
        }), this.myExpectedFilesCount);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrIncludeModificationsFixture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrIncludeModificationsFixture";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "affects";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "includeQ";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "includeB";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "importQ";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "importB";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareExpected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

