/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.impl.DirectorySpecBase;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH&J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/io/impl/ZipSpecBase;", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "extension", "", "(Ljava/lang/String;)V", "compress", "", "contentDir", "Ljava/io/File;", "target", "generate", "generateInTempDir", "Ljava/nio/file/Path;", "Lcom/intellij/util/io/impl/JarSpec;", "Lcom/intellij/util/io/impl/ZipSpec;", "intellij.platform.testFramework"})
public abstract class ZipSpecBase
extends DirectorySpecBase {
    @NotNull
    private final String extension;

    private ZipSpecBase(String extension) {
        super(null, null);
        this.extension = extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@NotNull File target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        File file2 = FileUtil.createTempDirectory((String)(this.extension + "-content"), null, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempDirectory(...)");
        File contentDir = file2;
        try {
            this.generateInDirectory(contentDir);
            FileUtil.createParentDirs((File)target2);
            this.compress(contentDir, target2);
        }
        finally {
            FileUtil.delete((File)contentDir);
        }
    }

    public abstract void compress(@NotNull File var1, @NotNull File var2);

    @Override
    @NotNull
    public Path generateInTempDir() {
        File file2 = FileUtil.createTempFile((String)(this.extension + "-by-spec"), (String)("." + this.extension), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
        File target2 = file2;
        this.generate(target2);
        Path path = target2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    public /* synthetic */ ZipSpecBase(String extension, DefaultConstructorMarker $constructor_marker) {
        this(extension);
    }
}

