/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.InlayDumpUtil;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayHintsSinkImpl;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.testFramework.utils.inlays.InlayHintsProviderTestCase;
import com.intellij.util.containers.UtilKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b2\b\b\u0002\u0010\f\u001a\u0002H\u00052\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ7\u0010\u0010\u001a\u00020\b\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b2\b\b\u0002\u0010\f\u001a\u0002H\u0005H\u0004\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "()V", "doTestProvider", "", "T", "", "fileName", "", "expectedText", "provider", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "settings", "verifyHintPresence", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/codeInsight/hints/InlayHintsProvider;Ljava/lang/Object;Z)V", "dumpInlayHints", "sourceText", "(Ljava/lang/String;Lcom/intellij/codeInsight/hints/InlayHintsProvider;Ljava/lang/Object;)Ljava/lang/String;", "Companion", "intellij.platform.testFramework"})
public abstract class InlayHintsProviderTestCase
extends BasePlatformTestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NO_HINTS_PREFIX = "// NO_HINTS";

    @JvmOverloads
    public final <T> void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings, boolean verifyHintPresence) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        String sourceText = InlayDumpUtil.INSTANCE.removeHints(expectedText);
        this.myFixture.configureByText(fileName, sourceText);
        String actualText = this.dumpInlayHints(sourceText, provider, settings);
        BasePlatformTestCase.assertEquals((String)expectedText, (String)actualText);
        if (verifyHintPresence) {
            Companion.verifyHintsPresence(expectedText);
        }
    }

    public static /* synthetic */ void doTestProvider$default(InlayHintsProviderTestCase inlayHintsProviderTestCase, String string, String string2, InlayHintsProvider inlayHintsProvider, Object object, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTestProvider");
        }
        if ((n & 8) != 0) {
            object = inlayHintsProvider.createSettings();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        inlayHintsProviderTestCase.doTestProvider(string, string2, inlayHintsProvider, object, bl);
    }

    @NotNull
    protected final <T> String dumpInlayHints(@NotNull String sourceText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings) {
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        Editor editor = this.myFixture.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        InlayHintsSinkImpl sink = new InlayHintsSinkImpl(editor);
        InlayHintsCollector inlayHintsCollector = provider.getCollectorFor(file2, editor, settings, (InlayHintsSink)sink);
        if (inlayHintsCollector == null) {
            throw new IllegalStateException("Collector is expected".toString());
        }
        InlayHintsCollector collector = inlayHintsCollector;
        SettingsKey settingsKey = provider.getKey();
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        CollectorWithSettings collectorWithSettings = new CollectorWithSettings(collector, settingsKey, language, sink);
        collectorWithSettings.collectTraversingAndApply(editor, file2, true);
        Function2 function2 = dumpInlayHints.1.INSTANCE;
        PsiFile psiFile2 = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Editor editor2 = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        PsiFile psiFile3 = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile3);
        Document document = this.myFixture.getDocument(psiFile3);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return InlayDumpUtil.dumpHintsInternal$default((InlayDumpUtil)InlayDumpUtil.INSTANCE, (String)sourceText, null, (Function2)function2, (PsiFile)psiFile2, (Editor)editor2, (Document)document, (int)0, (int)66, null);
    }

    public static /* synthetic */ String dumpInlayHints$default(InlayHintsProviderTestCase inlayHintsProviderTestCase, String string, InlayHintsProvider inlayHintsProvider, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dumpInlayHints");
        }
        if ((n & 4) != 0) {
            object = inlayHintsProvider.createSettings();
        }
        return inlayHintsProviderTestCase.dumpInlayHints(string, inlayHintsProvider, object);
    }

    @JvmOverloads
    public final <T> void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        InlayHintsProviderTestCase.doTestProvider$default(this, fileName, expectedText, provider, settings, false, 16, null);
    }

    @JvmOverloads
    public final <T> void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider<T> provider) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        InlayHintsProviderTestCase.doTestProvider$default(this, fileName, expectedText, provider, null, false, 24, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$Companion;", "", "()V", "NO_HINTS_PREFIX", "", "verifyHintsPresence", "", "expectedText", "HintPresence", "intellij.platform.testFramework"})
    @SourceDebugExtension(value={"SMAP\nInlayHintsProviderTestCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayHintsProviderTestCase.kt\ncom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,58:1\n1247#2,2:59\n*S KotlinDebug\n*F\n+ 1 InlayHintsProviderTestCase.kt\ncom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$Companion\n*L\n16#1:59,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void verifyHintsPresence(@NotNull String expectedText) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
                Sequence $this$any$iv = StringsKt.lineSequence((CharSequence)expectedText);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)InlayHintsProviderTestCase.NO_HINTS_PREFIX, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            HintPresence expectedHintPresence = bl ? HintPresence.NO_HINTS : HintPresence.SOME_HINTS;
            HintPresence actualHintPresence = UtilKt.isEmpty(InlayDumpUtil.INSTANCE.getInlayPattern().matcher(expectedText).results()) ? HintPresence.NO_HINTS : HintPresence.SOME_HINTS;
            BasePlatformTestCase.assertEquals((String)"Hint presence should match the use of the // NO_HINTS directive.", (Object)((Object)expectedHintPresence), (Object)((Object)actualHintPresence));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$Companion$HintPresence;", "", "(Ljava/lang/String;I)V", "NO_HINTS", "SOME_HINTS", "intellij.platform.testFramework"})
        private static final class HintPresence
        extends Enum<HintPresence> {
            public static final /* enum */ HintPresence NO_HINTS = new HintPresence();
            public static final /* enum */ HintPresence SOME_HINTS = new HintPresence();
            private static final /* synthetic */ HintPresence[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static HintPresence[] values() {
                return (HintPresence[])$VALUES.clone();
            }

            public static HintPresence valueOf(String value2) {
                return Enum.valueOf(HintPresence.class, value2);
            }

            @NotNull
            public static EnumEntries<HintPresence> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = hintPresenceArray = new HintPresence[]{HintPresence.NO_HINTS, HintPresence.SOME_HINTS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

