/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.UnindexedFilesScannerExecutor;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.testFramework.DumbModeTestUtils;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.indexing.UnindexedFilesScannerExecutorImpl;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/testFramework/IndexingTestUtil;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "shouldWait", "", "suspendUntilIndexesAreReady", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitAfterWriteAction", "waitNow", "waitUntilFinished", "Companion", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nIndexingTestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexingTestUtil.kt\ncom/intellij/testFramework/IndexingTestUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,166:1\n23#2:167\n23#2:168\n23#2:169\n23#2:170\n23#2:171\n23#2:172\n23#2:173\n*S KotlinDebug\n*F\n+ 1 IndexingTestUtil.kt\ncom/intellij/testFramework/IndexingTestUtil\n*L\n54#1:167\n60#1:168\n93#1:169\n112#1:170\n123#1:171\n134#1:172\n140#1:173\n*E\n"})
public final class IndexingTestUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public IndexingTestUtil(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    private final void waitAfterWriteAction() {
        if (this.project.isDisposed()) {
            return;
        }
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable listenerDisposable = disposable;
        UnindexedFilesScannerExecutor unindexedFilesScannerExecutor = UnindexedFilesScannerExecutor.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)unindexedFilesScannerExecutor, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        Disposable parentDisposable = (Disposable)unindexedFilesScannerExecutor;
        Disposer.register((Disposable)parentDisposable, (Disposable)listenerDisposable);
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(listenerDisposable, this){
            private volatile int nested;
            final /* synthetic */ Disposable $listenerDisposable;
            final /* synthetic */ IndexingTestUtil this$0;
            {
                this.$listenerDisposable = $listenerDisposable;
                this.this$0 = $receiver;
                this.nested = 1;
            }

            public void beforeWriteActionStart(@NotNull Object action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                int n = this.nested;
                this.nested = n + 1;
            }

            public void afterWriteActionFinished(@NotNull Object action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                int n = this.nested;
                this.nested = n + -1;
                int n2 = n = this.nested >= 0 ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    boolean bl = false;
                    String string = "We counted more finished write actions than started.";
                    throw new AssertionError((Object)string);
                }
                if (this.nested <= 0) {
                    Disposer.dispose((Disposable)this.$listenerDisposable);
                    IndexingTestUtil.access$waitNow(this.this$0);
                }
            }
        }, listenerDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitNow() {
        IndexingTestUtil $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexingTestUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("waitNow, thread=" + Thread.currentThread());
        Assert.assertFalse((String)"Should not be invoked from write action", (boolean)ApplicationManager.getApplication().isWriteAccessAllowed());
        if (!this.shouldWait()) {
            return;
        }
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(IndexingTestUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.debug("waitNow will be waiting, thread=" + Thread.currentThread());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            CoroutineScope scope = CoroutineScopeKt.childScope$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (String)"Indexing waiter", (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (boolean)false, (int)4, null);
            Job waiting2 = BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ IndexingTestUtil this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = IndexingTestUtil.access$suspendUntilIndexesAreReady(this.this$0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            try {
                PlatformTestUtil.waitWithEventsDispatching("Indexing timeout", () -> IndexingTestUtil.waitNow$lambda$0(waiting2), 600);
                PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            }
            finally {
                Job.DefaultImpls.cancel$default((Job)waiting2, null, (int)1, null);
            }
        } else {
            CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ IndexingTestUtil this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = IndexingTestUtil.access$suspendUntilIndexesAreReady(this.this$0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    private final boolean shouldWait() {
        DumbServiceImpl dumbService = DumbServiceImpl.Companion.getInstance(this.project);
        dumbService.ensureInitialDumbTaskRequiredForSmartModeSubmitted();
        UnindexedFilesScannerExecutorImpl scannerExecutor = UnindexedFilesScannerExecutorImpl.Companion.getInstance(this.project);
        if (scannerExecutor.getHasQueuedTasks()) {
            boolean bl;
            if (scannerExecutor.scanningWaitsForNonDumbMode() && dumbService.isDumb()) {
                boolean isEternal = DumbModeTestUtils.INSTANCE.isEternalDumbTaskRunning$intellij_platform_testFramework(this.project);
                if (isEternal) {
                    IndexingTestUtil $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(IndexingTestUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("Do not wait for queued scanning task, because eternal dumb task is running in the project [" + this.project + "]");
                }
                bl = !isEternal;
            } else {
                bl = true;
            }
            return bl;
        }
        if (dumbService.hasScheduledTasks()) {
            return true;
        }
        if (((Boolean)scannerExecutor.isRunning().getValue()).booleanValue() || dumbService.isRunning()) {
            return true;
        }
        if (dumbService.isDumb()) {
            boolean isEternal = DumbModeTestUtils.INSTANCE.isEternalDumbTaskRunning$intellij_platform_testFramework(this.project);
            if (isEternal) {
                IndexingTestUtil $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(IndexingTestUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Do not wait for smart mode, because eternal dumb task is running in the project [" + this.project + "]");
            }
            return !isEternal;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final Object suspendUntilIndexesAreReady(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof suspendUntilIndexesAreReady.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IndexingTestUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexingTestUtil.access$suspendUntilIndexesAreReady(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.shouldWait()) {
                    $i$f$thisLogger = false;
                    v0 = Logger.getInstance(IndexingTestUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                    v0.debug("suspendUntilIndexesAreReady will be waiting, thread=" + Thread.currentThread());
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)600, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ IndexingTestUtil this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                // 3 sources

                                while (IndexingTestUtil.access$shouldWait(this.this$0)) {
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)1L, (Continuation)((Continuation)this));
                                    if (v0 != var2_2) continue;
                                    return var2_2;
                                }
                                break;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl5
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var7_4) goto lbl25
lbl24:
                // 1 sources

                return var7_4;
lbl25:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                this = (IndexingTestUtil)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (TimeoutCancellationException e) {
                    $i$f$thisLogger = false;
                    v2 = Logger.getInstance(IndexingTestUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                    v2.warn(ThreadDumper.dumpThreadsToString(), (Throwable)e);
                    throw e;
                }
lbl39:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void waitUntilFinished() {
        IndexingTestUtil $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexingTestUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("waitUntilFinished, thread=" + Thread.currentThread() + ", WA=" + ApplicationManager.getApplication().isWriteAccessAllowed());
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            this.waitAfterWriteAction();
        } else {
            this.waitNow();
        }
    }

    private static final boolean waitNow$lambda$0(Job $waiting) {
        Intrinsics.checkNotNullParameter((Object)$waiting, (String)"$waiting");
        return !$waiting.isActive();
    }

    @JvmStatic
    public static final void waitUntilIndexesAreReadyInAllOpenedProjects() {
        Companion.waitUntilIndexesAreReadyInAllOpenedProjects();
    }

    @JvmStatic
    public static final void waitUntilIndexesAreReady(@NotNull Project project2) {
        Companion.waitUntilIndexesAreReady(project2);
    }

    public static final /* synthetic */ void access$waitNow(IndexingTestUtil $this) {
        $this.waitNow();
    }

    public static final /* synthetic */ boolean access$shouldWait(IndexingTestUtil $this) {
        return $this.shouldWait();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086@\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/testFramework/IndexingTestUtil$Companion;", "", "()V", "suspendUntilIndexesAreReady", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitUntilIndexesAreReady", "waitUntilIndexesAreReadyInAllOpenedProjects", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void waitUntilIndexesAreReadyInAllOpenedProjects() {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project2 : projectArray) {
                Intrinsics.checkNotNull((Object)project2);
                new IndexingTestUtil(project2).waitUntilFinished();
            }
        }

        @JvmStatic
        public final void waitUntilIndexesAreReady(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            new IndexingTestUtil(project2).waitUntilFinished();
        }

        @Nullable
        public final Object suspendUntilIndexesAreReady(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
            Object object = new IndexingTestUtil(project2).suspendUntilIndexesAreReady((Continuation<? super Unit>)$completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

