/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssCustomPropertyAtRule;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.fixes.CssAddPrefixQuickFix;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/psi/css/inspections/invalid/CssInvalidCustomPropertyAtRuleNameInspection;", "Lcom/intellij/psi/css/inspections/CssBaseInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.css.analysis"})
public final class CssInvalidCustomPropertyAtRuleNameInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new CssElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitCssCustomPropertyAtRule(@NotNull CssCustomPropertyAtRule customProperty) {
                Intrinsics.checkNotNullParameter((Object)customProperty, (String)"customProperty");
                CssAddPrefixQuickFix quickFix = new CssAddPrefixQuickFix("--", CssCustomPropertyAtRule.class, CssBundle.message("css.inspections.invalid.custom.property.at.rule.name.fix", new Object[0]));
                ASTNode child = customProperty.getNode().findChildByType(CssElementTypes.CSS_IDENT);
                if (child != null) {
                    String string = child.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)"--", (boolean)false, (int)2, null)) {
                        TextRange textRange = TextRange.from((int)child.getStartOffsetInParent(), (int)child.getTextLength());
                        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
                        TextRange textRange2 = textRange;
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{quickFix};
                        ProblemDescriptor problemDescriptor = this.$holder.getManager().createProblemDescriptor((PsiElement)customProperty, textRange2, CssBundle.message("css.inspections.invalid.custom.property.at.rule.name.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR, true, localQuickFixArray);
                        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                        ProblemDescriptor problemDescriptor2 = problemDescriptor;
                        this.$holder.registerProblem(problemDescriptor2);
                    }
                }
            }
        };
    }
}

