/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.ruleset.StyleCreatorWithFileChooser;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingFileStyleCreatorWithChooser
extends StyleCreatorWithFileChooser {
    public ExistingFileStyleCreatorWithChooser(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            ExistingFileStyleCreatorWithChooser.$$$reportNull$$$0(0);
        }
        super(CssBundle.message("css.inspections.create.style.existing.file", new Object[0]), contextFile);
    }

    @Override
    @Nullable
    protected StylesheetFile chooseFile() {
        FileChooserDescriptor descriptor = this.createCssFileChooserDescriptor();
        Project project = this.myContextFile.getProject();
        Ref result = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, null);
            VirtualFile[] cssFiles = chooser.choose(project, new VirtualFile[0]);
            if (cssFiles.length > 0) {
                VirtualFile cssFile = cssFiles[0];
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(cssFile);
                if (psiFile instanceof StylesheetFile) {
                    result.set((Object)((StylesheetFile)psiFile));
                }
            }
        });
        return (StylesheetFile)result.get();
    }

    @NotNull
    private FileChooserDescriptor createCssFileChooserDescriptor() {
        CssFileChooserDescriptor descriptor = new CssFileChooserDescriptor();
        Project project = this.myContextFile.getProject();
        descriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        descriptor.withTreeRootVisible(true);
        CssFileChooserDescriptor cssFileChooserDescriptor = descriptor;
        if (cssFileChooserDescriptor == null) {
            ExistingFileStyleCreatorWithChooser.$$$reportNull$$$0(1);
        }
        return cssFileChooserDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreatorWithChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreatorWithChooser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCssFileChooserDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class CssFileChooserDescriptor
    extends FileChooserDescriptor {
        CssFileChooserDescriptor() {
            super(true, false, false, false, false, false);
        }

        public boolean isFileVisible(@NotNull VirtualFile file, boolean showHiddenFiles) {
            if (file == null) {
                CssFileChooserDescriptor.$$$reportNull$$$0(0);
            }
            return super.isFileVisible(file, showHiddenFiles) || CssSupportedFileTypesProvider.isSupportedFileType(file.getFileType());
        }

        public boolean isFileSelectable(@Nullable VirtualFile file) {
            return super.isFileSelectable(file) && CssSupportedFileTypesProvider.isSupportedFileType(file.getFileType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreatorWithChooser$CssFileChooserDescriptor", "isFileVisible"));
        }
    }
}

