/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clion.performanceTesting;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManagerListener;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.InitProjectActivity;
import com.intellij.openapi.ui.playback.PlaybackCommandReporter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.clion.performanceTesting.CLionPerformanceTestingBundle;
import com.jetbrains.clion.performanceTesting.CLionScriptRunner;
import com.jetbrains.performancePlugin.ProjectLoaded;
import com.jetbrains.performancePlugin.utils.ReporterCommandAsTelemetrySpan;
import com.jetbrains.performancePlugin.utils.ScriptRunner;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/jetbrains/clion/performanceTesting/CLionScriptRunner;", "Lcom/intellij/openapi/startup/InitProjectActivity;", "()V", "run", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.clion.performanceTesting"})
public final class CLionScriptRunner
implements InitProjectActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SCRIPT_FILE_NAME = "autorun.ijperf";
    @NotNull
    public static final String REPORT_FILE_NAME = "autorunReport.txt";
    @NotNull
    private static final Logger LOG;
    private static int insideActiveScript;
    @NotNull
    private static final HashSet<Task> tasksInProgress;
    @NotNull
    private static final ReentrantLock lockTasksOperations;
    private static final Condition noTasksCondition;

    @Nullable
    public Object run(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        String scriptCommands;
        VirtualFile autorunScript;
        if (!Registry.is((String)"clion.enable.script.autorun") || ProjectLoaded.TEST_SCRIPT_FILE_PATH != null || insideActiveScript > 0 || !TrustedProjects.isTrusted((Project)project)) {
            return Unit.INSTANCE;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && (autorunScript = baseDir.findChild(SCRIPT_FILE_NAME)) != null && (scriptCommands = (String)ApplicationManager.getApplication().runReadAction(() -> CLionScriptRunner.run$lambda$0(autorunScript))) != null) {
            Companion.runScript(project, scriptCommands, new File(baseDir.getPath()));
        }
        return Unit.INSTANCE;
    }

    private static final String run$lambda$0(VirtualFile $autorunScript) {
        Document document = FileDocumentManager.getInstance().getDocument($autorunScript);
        return document != null ? document.getText() : null;
    }

    @JvmStatic
    public static final void waitAllTasksExceptScriptRunner() {
        Companion.waitAllTasksExceptScriptRunner();
    }

    @JvmStatic
    public static final void runScript(@NotNull Project project, @NotNull String script, @NotNull File workingDir) {
        Companion.runScript(project, script, workingDir);
    }

    @JvmStatic
    public static final void debugToConsole(@NotNull String debugMessage) {
        Companion.debugToConsole(debugMessage);
    }

    public static final /* synthetic */ void access$setInsideActiveScript$cp(int n) {
        insideActiveScript = n;
    }

    public static final /* synthetic */ int access$getInsideActiveScript$cp() {
        return insideActiveScript;
    }

    static {
        Logger logger = Logger.getInstance(CLionScriptRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        tasksInProgress = new HashSet();
        lockTasksOperations = new ReentrantLock();
        noTasksCondition = lockTasksOperations.newCondition();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J \u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u0015H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/clion/performanceTesting/CLionScriptRunner$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REPORT_FILE_NAME", "", "SCRIPT_FILE_NAME", "insideActiveScript", "", "lockTasksOperations", "Ljava/util/concurrent/locks/ReentrantLock;", "noTasksCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "tasksInProgress", "Ljava/util/HashSet;", "Lcom/intellij/openapi/progress/Task;", "Lkotlin/collections/HashSet;", "debugToConsole", "", "debugMessage", "runScript", "project", "Lcom/intellij/openapi/project/Project;", "script", "workingDir", "Ljava/io/File;", "waitAllTasksExceptScriptRunner", "intellij.clion.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void waitAllTasksExceptScriptRunner() {
            Lock lock = lockTasksOperations;
            lock.lock();
            try {
                boolean bl = false;
                if (tasksInProgress.size() <= 1) {
                    return;
                }
                noTasksCondition.await();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        @JvmStatic
        public final void runScript(@NotNull Project project, @NotNull String script, @NotNull File workingDir) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)project), (String)"Autorun Script");
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable projectBkTasksListener = disposable;
            boolean origShowProgress = AdvancedSettings.Companion.getBoolean("cidr.test.framework.showIndexingAsTask");
            Disposer.register((Disposable)projectBkTasksListener, () -> Companion.runScript$lambda$1(origShowProgress));
            AdvancedSettings.Companion.setBoolean("cidr.test.framework.showIndexingAsTask", false);
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(projectBkTasksListener);
            Topic topic = ProgressManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new ProgressManagerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void beforeTaskStart(@NotNull Task task, @NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Lock lock = CLionScriptRunner.access$getLockTasksOperations$cp();
                    lock.lock();
                    try {
                        boolean bl = false;
                        CLionScriptRunner.Companion.debugToConsole("{Script Engine: add:    " + task.getClass().getName());
                        boolean bl2 = CLionScriptRunner.access$getTasksInProgress$cp().add(task);
                    }
                    finally {
                        lock.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterTaskFinished(@NotNull Task task) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    Lock lock = CLionScriptRunner.access$getLockTasksOperations$cp();
                    lock.lock();
                    try {
                        boolean bl = false;
                        CLionScriptRunner.access$getTasksInProgress$cp().remove(task);
                        CLionScriptRunner.Companion.debugToConsole("}Script Engine: remove: " + task.getClass().getName());
                        if (CLionScriptRunner.access$getTasksInProgress$cp().size() == 1) {
                            ApplicationManager.getApplication().invokeLater(runScript.2::afterTaskFinished$lambda$3$lambda$2);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private static final void afterTaskFinished$lambda$3$lambda$2() {
                    Lock lock = CLionScriptRunner.access$getLockTasksOperations$cp();
                    lock.lock();
                    try {
                        boolean bl = false;
                        if (CLionScriptRunner.access$getTasksInProgress$cp().size() == 1) {
                            CLionScriptRunner.access$getNoTasksCondition$cp().signalAll();
                            CLionScriptRunner.Companion.debugToConsole("Script Engine: All background tasks were finished");
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            });
            new ScriptRunner().setScriptRunnerReporter((PlaybackCommandReporter)new ReporterCommandAsTelemetrySpan(new PlaybackCommandReporter(projectBkTasksListener, workingDir){
                private long scriptStartTime;
                private boolean scriptIsCanceled;
                private long commandStartTime;
                @NotNull
                private String executedCommandLine;
                @NotNull
                private StringBuilder scriptReport;
                final /* synthetic */ Disposable $projectBkTasksListener;
                final /* synthetic */ File $workingDir;
                {
                    this.$projectBkTasksListener = $projectBkTasksListener;
                    this.$workingDir = $workingDir;
                    this.executedCommandLine = "";
                    this.scriptReport = new StringBuilder();
                }

                public void startOfScript(@Nullable Project project) {
                    CLionScriptRunner.access$setInsideActiveScript$cp(CLionScriptRunner.access$getInsideActiveScript$cp() + 1);
                    CLionScriptRunner.access$getInsideActiveScript$cp();
                    String string = CLionPerformanceTestingBundle.message("CIDR.Perf.notification.started", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.notify(string);
                    this.scriptStartTime = System.currentTimeMillis();
                }

                public void scriptCanceled() {
                    this.scriptIsCanceled = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void endOfScript(@Nullable Project project) {
                    long scriptDuration = System.currentTimeMillis() - this.scriptStartTime;
                    this.reportScriptResult(project, scriptDuration);
                    Object[] objectArray = new Object[]{scriptDuration};
                    String string = CLionPerformanceTestingBundle.message("CIDR.Perf.notification.finished", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.notify(string);
                    CLionScriptRunner.access$setInsideActiveScript$cp(CLionScriptRunner.access$getInsideActiveScript$cp() + -1);
                    CLionScriptRunner.access$getInsideActiveScript$cp();
                    if (CLionScriptRunner.access$getInsideActiveScript$cp() == 0) {
                        Lock lock = CLionScriptRunner.access$getLockTasksOperations$cp();
                        lock.lock();
                        try {
                            boolean bl = false;
                            CLionScriptRunner.access$getTasksInProgress$cp().clear();
                            CLionScriptRunner.access$getNoTasksCondition$cp().signalAll();
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                        Disposer.dispose((Disposable)this.$projectBkTasksListener);
                    }
                }

                public void startOfCommand(@NotNull String fullCommandLine) {
                    Intrinsics.checkNotNullParameter((Object)fullCommandLine, (String)"fullCommandLine");
                    CLionScriptRunner.Companion.debugToConsole("  {startOfCommand: " + fullCommandLine);
                    this.executedCommandLine = fullCommandLine;
                    this.commandStartTime = System.currentTimeMillis();
                }

                public void endOfCommand(@Nullable String errDescriptionOrNull) {
                    this.scriptReport.append(this.executedCommandLine + " -> " + (System.currentTimeMillis() - this.commandStartTime) + "ms");
                    String string = errDescriptionOrNull;
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        this.scriptReport.append(" with error {" + errDescriptionOrNull + "}");
                    }
                    this.scriptReport.append("\n");
                    CLionScriptRunner.Companion.debugToConsole("  }endOfCommand err: " + errDescriptionOrNull + "\n");
                }

                public final void reportScriptResult(@Nullable Project project, long scriptDuration) {
                    Object projectMark;
                    Project project2 = project;
                    Object object = projectMark = project2 == null ? "default" : project2.getBasePath();
                    if (this.scriptIsCanceled) {
                        projectMark = (String)projectMark + "\nWarning: Script has been canceled!";
                    }
                    String reportContent = "\n================== Script Report: ==================\nProject: " + (String)projectMark + "\n\n" + this.scriptReport + "\nScript Duration: " + scriptDuration + "ms\n====================================================";
                    if (Registry.is((String)"clion.write.script.report")) {
                        try {
                            File file = new File(this.$workingDir, "autorunReport.txt");
                            FileUtil.writeToFile((File)file, (String)reportContent);
                            Object[] objectArray = new Object[]{file.getPath()};
                            String string = CLionPerformanceTestingBundle.message("CIDR.Perf.notification.write.report", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.notify(string);
                        }
                        catch (IOException e) {
                            Object[] objectArray = new Object[]{e.getMessage()};
                            String string = CLionPerformanceTestingBundle.message("CIDR.Perf.notification.exception.write.report", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.notify(string);
                        }
                    }
                    System.out.println(reportContent);
                }

                public final void notify(@NlsContexts.NotificationContent @NotNull String message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    CLionScriptRunner.Companion.debugToConsole(message);
                    ApplicationManager.getApplication().invokeLater(() -> runScript.3.notify$lambda$2(message));
                }

                private static final void notify$lambda$2(String $message) {
                    Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
                    Notifications.Bus.notify((Notification)new Notification("PerformancePlugin", CLionPerformanceTestingBundle.message("CIDR.Perf.notification.title", new Object[0]), $message, NotificationType.INFORMATION));
                }
            })).doRunScript(project, script, workingDir);
        }

        @JvmStatic
        public final void debugToConsole(@NotNull String debugMessage) {
            Intrinsics.checkNotNullParameter((Object)debugMessage, (String)"debugMessage");
            if (Registry.is((String)"clion.enable.script.verbose")) {
                System.out.println(System.currentTimeMillis() + " " + debugMessage);
                LOG.info(debugMessage);
            }
        }

        private static final void runScript$lambda$1(boolean $origShowProgress) {
            AdvancedSettings.Companion.setBoolean("cidr.test.framework.showIndexingAsTask", $origShowProgress);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

