/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.rules.patterns.PasswordAuthenticator;
import org.languagetool.rules.patterns.bitext.BitextPatternRule;
import org.languagetool.rules.patterns.bitext.BitextPatternRuleLoader;
import org.languagetool.rules.patterns.bitext.FalseFriendsAsBitextLoader;
import org.xml.sax.SAXException;

public final class Tools {
    private static LinguServices linguServices = null;

    private Tools() {
    }

    public static String i18n(ResourceBundle messages, String key2, Object ... messageArguments) {
        MessageFormat formatter = new MessageFormat("");
        formatter.applyPattern(messages.getString(key2));
        return formatter.format(messageArguments);
    }

    public static List<RuleMatch> checkBitext(String src, String trg, JLanguageTool srcLt, JLanguageTool trgLt, List<BitextRule> bRules) throws IOException {
        AnalyzedSentence srcText = srcLt.getAnalyzedSentence(src);
        AnalyzedSentence trgText = trgLt.getAnalyzedSentence(trg);
        List<Rule> nonBitextRules = trgLt.getAllActiveRules();
        List<RuleMatch> ruleMatches = trgLt.checkAnalyzedSentence(JLanguageTool.ParagraphHandling.NORMAL, nonBitextRules, trgText, true);
        for (BitextRule bRule : bRules) {
            RuleMatch[] curMatch = bRule.match(srcText, trgText);
            if (curMatch == null || curMatch.length <= 0) continue;
            for (RuleMatch match : curMatch) {
                if (match.getColumn() < 0) {
                    match.setColumn(1);
                }
                if (match.getEndColumn() < 0) {
                    match.setEndColumn(trg.length() + 1);
                }
                if (match.getLine() < 0) {
                    match.setLine(1);
                }
                if (match.getEndLine() < 0) {
                    match.setEndLine(1);
                }
                ruleMatches.add(match);
            }
        }
        return ruleMatches;
    }

    public static List<BitextRule> getBitextRules(Language source, Language target) throws IOException, ParserConfigurationException, SAXException {
        return Tools.getBitextRules(source, target, null);
    }

    public static List<BitextRule> getBitextRules(Language source, Language target, File externalBitextRuleFile) throws IOException, ParserConfigurationException, SAXException {
        InputStream is;
        ArrayList<BitextRule> bRules = new ArrayList<BitextRule>();
        BitextPatternRuleLoader ruleLoader = new BitextPatternRuleLoader();
        String name = "/" + target.getShortCode() + "/bitext.xml";
        if (JLanguageTool.getDataBroker().ruleFileExists(name) && (is = JLanguageTool.getDataBroker().getFromRulesDirAsStream(name)) != null) {
            bRules.addAll(ruleLoader.getRules(is, name));
        }
        if (externalBitextRuleFile != null) {
            bRules.addAll(ruleLoader.getRules(new FileInputStream(externalBitextRuleFile), externalBitextRuleFile.getAbsolutePath()));
        }
        FalseFriendsAsBitextLoader fRuleLoader = new FalseFriendsAsBitextLoader();
        String falseFriendsFile = "/false-friends.xml";
        List<BitextPatternRule> rules = fRuleLoader.getFalseFriendsAsBitext(falseFriendsFile, source, target);
        bRules.addAll(rules);
        bRules.addAll(Tools.getAllBuiltinBitextRules(source, null));
        return bRules;
    }

    private static List<BitextRule> getAllBuiltinBitextRules(Language language, ResourceBundle messages) {
        ArrayList<BitextRule> rules = new ArrayList<BitextRule>();
        try {
            List<Class<? extends BitextRule>> classes = BitextRule.getRelevantRules();
            for (Class<? extends BitextRule> class1 : classes) {
                Object[] constructors = class1.getConstructors();
                boolean foundConstructor = false;
                for (Constructor<?> constructor : constructors) {
                    Class<?>[] paramTypes = constructor.getParameterTypes();
                    if (paramTypes.length == 0) {
                        rules.add((BitextRule)constructor.newInstance(new Object[0]));
                        foundConstructor = true;
                        break;
                    }
                    if (paramTypes.length == 1 && paramTypes[0].equals(ResourceBundle.class)) {
                        rules.add((BitextRule)constructor.newInstance(messages));
                        foundConstructor = true;
                        break;
                    }
                    if (paramTypes.length != 2 || !paramTypes[0].equals(ResourceBundle.class) || !paramTypes[1].equals(Language.class)) continue;
                    rules.add((BitextRule)constructor.newInstance(messages, language));
                    foundConstructor = true;
                    break;
                }
                if (foundConstructor) continue;
                throw new RuntimeException("Unknown constructor type for rule class " + class1.getName() + ", it supports only these constructors: " + Arrays.toString(constructors));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load bitext rules", e);
        }
        return rules;
    }

    public static int profileRulesOnLine(String contents, JLanguageTool lt, Rule rule) throws IOException {
        int count = 0;
        for (String sentence : lt.sentenceTokenize(contents)) {
            count += rule.match(lt.getAnalyzedSentence(sentence)).length;
        }
        return count;
    }

    public static String correctText(String contents, JLanguageTool lt) throws IOException {
        List<RuleMatch> ruleMatches = lt.check(contents);
        if (ruleMatches.isEmpty()) {
            return contents;
        }
        return Tools.correctTextFromMatches(contents, ruleMatches);
    }

    public static String correctTextFromMatches(String contents, List<RuleMatch> matches) {
        StringBuilder sb = new StringBuilder(contents);
        ArrayList<String> errors = new ArrayList<String>();
        for (RuleMatch rm : matches) {
            List<String> replacements = rm.getSuggestedReplacements();
            if (replacements.isEmpty()) continue;
            errors.add(sb.substring(rm.getFromPos(), rm.getToPos()));
        }
        int offset = 0;
        int counter = 0;
        for (RuleMatch rm : matches) {
            List<String> replacements = rm.getSuggestedReplacements();
            if (replacements.isEmpty()) continue;
            if (rm.getFromPos() - offset >= 0 && rm.getToPos() - offset >= rm.getFromPos() - offset && ((String)errors.get(counter)).equals(sb.substring(rm.getFromPos() - offset, rm.getToPos() - offset))) {
                sb.replace(rm.getFromPos() - offset, rm.getToPos() - offset, replacements.get(0));
                offset += rm.getToPos() - rm.getFromPos() - replacements.get(0).length();
            }
            ++counter;
        }
        return sb.toString();
    }

    public static String getFullStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static InputStream getStream(String path) throws IOException {
        InputStream is = JLanguageTool.getDataBroker().getAsStream(path);
        if (is == null) {
            throw new IOException("Could not load file from classpath: '" + path + "'");
        }
        return is;
    }

    public static void selectRules(JLanguageTool lt, List<String> disabledRuleIds, List<String> enabledRuleIds, boolean useEnabledOnly) {
        HashSet<String> disabledRuleIdsSet = new HashSet<String>();
        disabledRuleIdsSet.addAll(disabledRuleIds);
        HashSet<String> enabledRuleIdsSet = new HashSet<String>();
        enabledRuleIdsSet.addAll(enabledRuleIds);
        Tools.selectRules(lt, Collections.emptySet(), Collections.emptySet(), disabledRuleIdsSet, enabledRuleIdsSet, useEnabledOnly, false);
    }

    public static void selectRules(JLanguageTool lt, Set<CategoryId> disabledCategories, Set<CategoryId> enabledCategories, Set<String> disabledRules, Set<String> enabledRules, boolean useEnabledOnly, boolean enableTempOff) {
        if (enableTempOff) {
            for (Rule rule : lt.getAllRules()) {
                if (!rule.isDefaultTempOff()) continue;
                System.out.println("Activating " + rule.getFullId() + ", which is default='temp_off'");
                lt.enableRule(rule.getFullId());
            }
        }
        for (CategoryId id : disabledCategories) {
            lt.disableCategory(id);
        }
        if (enabledCategories.size() > 0) {
            for (CategoryId id : enabledCategories) {
                lt.enableRuleCategory(id);
            }
            if (useEnabledOnly) {
                for (Rule rule : lt.getAllRules()) {
                    Category category = rule.getCategory();
                    if (enabledCategories.contains(category.getId())) continue;
                    lt.disableRule(rule.getFullId());
                }
            }
        }
        for (String disabledRule : disabledRules) {
            lt.disableRule(disabledRule);
        }
        if (enabledRules.size() > 0) {
            for (String ruleName : enabledRules) {
                lt.enableRule(ruleName);
            }
            if (useEnabledOnly) {
                for (Rule rule : lt.getAllRules()) {
                    if (enabledRules.contains(rule.getFullId()) || enabledRules.contains(rule.getId())) continue;
                    lt.disableRule(rule.getFullId());
                }
            }
        }
    }

    public static List<BitextRule> selectBitextRules(List<BitextRule> bRules, List<String> disabledRules, List<String> enabledRules, boolean useEnabledOnly) {
        ArrayList<BitextRule> newBRules = new ArrayList<BitextRule>(bRules.size());
        newBRules.addAll(bRules);
        ArrayList<BitextRule> rulesToDisable = new ArrayList<BitextRule>();
        if (useEnabledOnly) {
            for (String enabledRule : enabledRules) {
                for (BitextRule b : bRules) {
                    if (b.getId().equals(enabledRule)) continue;
                    rulesToDisable.add(b);
                }
            }
        } else {
            for (String disabledRule : disabledRules) {
                for (BitextRule b : newBRules) {
                    if (!b.getId().equals(disabledRule)) continue;
                    rulesToDisable.add(b);
                }
            }
        }
        newBRules.removeAll(rulesToDisable);
        return newBRules;
    }

    public static void setPasswordAuthenticator() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkPermission(new NetPermission("setDefaultAuthenticator"));
                Authenticator.setDefault(new PasswordAuthenticator());
            }
            catch (SecurityException securityException) {}
        } else {
            Authenticator.setDefault(new PasswordAuthenticator());
        }
    }

    public static URL getUrl(String url2) {
        try {
            return new URL(url2);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isParagraphEnd(List<AnalyzedSentence> sentences2, int nTest, Language lang) {
        if (nTest >= sentences2.size() - 1) {
            return true;
        }
        if (lang.getSentenceTokenizer().singleLineBreaksMarksPara() ? sentences2.get(nTest).getText().endsWith("\n") || sentences2.get(nTest).getText().endsWith("\n\r") : sentences2.get(nTest).getText().endsWith("\n\n") || sentences2.get(nTest).getText().endsWith("\n\r\n\r") || sentences2.get(nTest).getText().endsWith("\r\n\r\n")) {
            return true;
        }
        return sentences2.get(nTest + 1).getText().startsWith("\n") || sentences2.get(nTest + 1).getText().startsWith("\r\n");
    }

    public static void setLinguisticServices(LinguServices ls) {
        linguServices = ls;
    }

    public static boolean isExternSpeller() {
        return linguServices != null;
    }

    public static LinguServices getLinguisticServices() {
        return linguServices;
    }
}

