/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.fullLine.cppCore;

import com.intellij.ml.inline.completion.features.correctness.CorrectnessError;
import com.intellij.ml.inline.completion.features.correctness.Severity;
import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricher;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.AbstractFullLineContext;
import com.jetbrains.rd.ide.model.CheckSemanticArgs;
import com.jetbrains.rd.ide.model.CheckSemanticResult;
import com.jetbrains.rd.ide.model.CppContext;
import com.jetbrains.rd.ide.model.CppFullLineModel;
import com.jetbrains.rd.ide.model.CppFullLineModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.SemanticErrorSeverity;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.model.RdFrontendDocumentId;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J@\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016H\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/fullLine/cppCore/CppSuggestionEnricher;", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricher;", "()V", "createCheckResult", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricher$Enrichment;", "result", "Lcom/jetbrains/rd/ide/model/CheckSemanticResult;", "file", "Lcom/intellij/psi/PsiFile;", "createContext", "Lcom/jetbrains/rd/ide/model/CppContext;", "offset", "", "enrich", "editor", "Lcom/intellij/openapi/editor/Editor;", "originalFile", "suggestionOffset", "suggestion", "", "suffix", "matchedEnclosuresIndices", "", "toIdea", "Lcom/intellij/ml/inline/completion/features/correctness/Severity;", "Lcom/jetbrains/rd/ide/model/SemanticErrorSeverity;", "intellij.fullLine.cppCore"})
@SourceDebugExtension(value={"SMAP\nCppSuggestionEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CppSuggestionEnricher.kt\ncom/intellij/fullLine/cppCore/CppSuggestionEnricher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n11065#2:72\n11400#2,3:73\n*S KotlinDebug\n*F\n+ 1 CppSuggestionEnricher.kt\ncom/intellij/fullLine/cppCore/CppSuggestionEnricher\n*L\n60#1:72\n60#1:73,3\n*E\n"})
public final class CppSuggestionEnricher
implements SuggestionEnricher {
    private final CppContext createContext(PsiFile file, int offset) {
        int lineNumber = file.getFileDocument().getLineNumber(offset);
        TextRange lineRange = new TextRange(file.getFileDocument().getLineStartOffset(lineNumber), file.getFileDocument().getLineEndOffset(lineNumber));
        String string = file.getFileDocument().getText(lineRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String lineText = string;
        CppContext context = new CppContext(lineNumber, lineText);
        return context;
    }

    @NotNull
    public SuggestionEnricher.Enrichment enrich(@NotNull Editor editor, @NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion, @NotNull String suffix, @Nullable Set<Integer> matchedEnclosuresIndices) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Project project = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CppFullLineModel fullLineModel = CppFullLineModel_PregeneratedKt.getCppFullLineModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project));
        List errors = new ArrayList();
        TextRange errorRange = new TextRange(suggestionOffset, suggestionOffset);
        Document document = FileDocumentManager.getInstance().getDocument(originalFile.getVirtualFile());
        if (document == null) {
            return new SuggestionEnricher.Enrichment(errors, originalFile, errorRange);
        }
        Document document2 = document;
        Project project2 = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        RdDocumentId rdDocumentId = DocumentExKt.getDocumentId((Document)document2, (Project)project2);
        RdFrontendDocumentId rdFrontendDocumentId = rdDocumentId instanceof RdFrontendDocumentId ? (RdFrontendDocumentId)rdDocumentId : null;
        if (rdFrontendDocumentId == null) {
            return new SuggestionEnricher.Enrichment(errors, originalFile, errorRange);
        }
        RdFrontendDocumentId documentId = rdFrontendDocumentId;
        String extraPrefix = "";
        int lineIndex = document2.getLineNumber(suggestionOffset);
        String text = originalFile.getText();
        Intrinsics.checkNotNull((Object)text);
        String string = text.substring(document2.getLineStartOffset(lineIndex), document2.getLineEndOffset(lineIndex));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string)).toString(), (String)"#", (boolean)false, (int)2, null)) {
            int ppDirectiveIndex = StringsKt.indexOf$default((CharSequence)text, (String)"#", (int)document2.getLineStartOffset(lineIndex), (boolean)false, (int)4, null);
            if (ppDirectiveIndex < suggestionOffset) {
                String string2 = text.substring(ppDirectiveIndex, suggestionOffset);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                extraPrefix = string2;
            }
        } else if (!CharsKt.isWhitespace((char)text.charAt(suggestionOffset - 1))) {
            int extraPrefixOffset = suggestionOffset - 1;
            while (!CharsKt.isWhitespace((char)text.charAt(extraPrefixOffset - 1))) {
                --extraPrefixOffset;
            }
            String string3 = text.substring(extraPrefixOffset, suggestionOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            extraPrefix = string3;
        }
        CheckSemanticArgs cppFullLineContext = new CheckSemanticArgs(documentId, extraPrefix + suggestion, suggestionOffset - extraPrefix.length(), (AbstractFullLineContext)this.createContext(originalFile, suggestionOffset), null);
        CheckSemanticResult checkResult = (CheckSemanticResult)RdTaskUtilKt.callWithCancellation$default((IRdCall)((IRdCall)fullLineModel.getCheckSemantic()), (Object)cppFullLineContext, (long)0L, (int)2, null);
        return this.createCheckResult(checkResult, originalFile);
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestionEnricher.Enrichment createCheckResult(CheckSemanticResult result, PsiFile file) {
        void $this$mapTo$iv$iv;
        com.jetbrains.rd.ide.model.CorrectnessError[] $this$map$iv = result.getErrors();
        boolean $i$f$map = false;
        com.jetbrains.rd.ide.model.CorrectnessError[] correctnessErrorArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CorrectnessError(new TextRange(it.getRange().getStartRange(), it.getRange().getEndRange()), this.toIdea(it.getSeverity()), it.getDebugName()));
        }
        List errors = (List)destination$iv$iv;
        return new SuggestionEnricher.Enrichment(errors, file, new TextRange(result.getSuggestionRange().getStartRange(), result.getSuggestionRange().getEndRange()));
    }

    private final Severity toIdea(SemanticErrorSeverity $this$toIdea) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toIdea.ordinal()]) {
            case 1 -> Severity.CRITICAL;
            case 2 -> Severity.ACCEPTABLE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SemanticErrorSeverity.values().length];
            try {
                nArray[SemanticErrorSeverity.CRITICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SemanticErrorSeverity.ACCEPTABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

