/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.refactoring;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2ClassBasedEntity;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.Angular2Pipe;
import org.angular2.lang.Angular2LangUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0016J,\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u0018H\u0016J5\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006!"}, d2={"Lorg/angular2/refactoring/Angular2PipeRenameProcessor;", "Lcom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "createRenameDialog", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "nameSuggestionContext", "editor", "Lcom/intellij/openapi/editor/Editor;", "getDefaultPipeClassName", "", "pipeName", "getDefaultPipeFileName", "getDefaultPipeSpecFileName", "isInplaceRenameSupported", "prepareRenaming", "", "newName", "allRenames", "", "renameElement", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "substituteElementToRename", "intellij.angular"})
@SourceDebugExtension(value={"SMAP\nAngular2PipeRenameProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Angular2PipeRenameProcessor.kt\norg/angular2/refactoring/Angular2PipeRenameProcessor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,99:1\n14#2:100\n14#2:101\n*S KotlinDebug\n*F\n+ 1 Angular2PipeRenameProcessor.kt\norg/angular2/refactoring/Angular2PipeRenameProcessor\n*L\n50#1:100\n71#1:101\n*E\n"})
public final class Angular2PipeRenameProcessor
extends JSDefaultRenameProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Angular2EntitiesProvider.getPipe(element) != null && Angular2LangUtil.isAngular2Context(element);
    }

    public boolean isInplaceRenameSupported() {
        return false;
    }

    @NotNull
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Angular2Pipe angular2Pipe = Angular2EntitiesProvider.getPipe(element);
        Intrinsics.checkNotNull((Object)angular2Pipe);
        return angular2Pipe.getSourceElement();
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        if (element instanceof JSImplicitElement && element.getParent() instanceof TypeScriptClass) {
            PsiReference[] property;
            PsiElement psiElement = element.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.ecma6.TypeScriptClass");
            ES6Decorator decorator = Angular2DecoratorUtil.findDecorator((JSAttributeListOwner)((TypeScriptClass)psiElement), "Pipe");
            PsiReference[] psiReferenceArray = property = Angular2DecoratorUtil.getProperty(decorator, "name");
            if (property != null && (psiReferenceArray = psiReferenceArray.getValue()) != null) {
                PsiReference[] $this$asSafely$iv = psiReferenceArray;
                boolean $i$f$asSafely = false;
                PsiReference[] psiReferenceArray2 = $this$asSafely$iv;
                if (!($this$asSafely$iv instanceof JSLiteralExpression)) {
                    psiReferenceArray2 = null;
                }
                if ((psiReferenceArray = (PsiReference[])psiReferenceArray2) != null && (psiReferenceArray = psiReferenceArray.getReferences()) != null) {
                    PsiReference[] refs = psiReferenceArray;
                    boolean bl = false;
                    for (PsiReference ref2 : refs) {
                        if (ref2.resolve() != element) continue;
                        ref2.handleElementRename(newName);
                    }
                }
            }
        }
        RenameUtil.doRenameGenericNamedElement((PsiElement)element, (String)newName, (UsageInfo[])usages, (RefactoringElementListener)listener);
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Angular2Pipe angular2Pipe = Angular2EntitiesProvider.getPipe(element);
        Intrinsics.checkNotNull((Object)angular2Pipe);
        RenameDialog renameDialog = super.createRenameDialog(project, angular2Pipe.getSourceElement(), nameSuggestionContext, editor);
        Intrinsics.checkNotNullExpressionValue((Object)renameDialog, (String)"createRenameDialog(...)");
        return renameDialog;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Angular2Entity angular2Entity;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
                boolean bl = element instanceof JSImplicitElement;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                angular2Entity = Angular2EntitiesProvider.getPipe(element);
                if (angular2Entity == null) break block7;
                Angular2Pipe $this$asSafely$iv = angular2Entity;
                boolean $i$f$asSafely = false;
                Angular2Pipe angular2Pipe = $this$asSafely$iv;
                if (!(angular2Pipe instanceof Angular2ClassBasedEntity)) {
                    angular2Pipe = null;
                }
                if ((angular2Entity = (Angular2ClassBasedEntity)((Object)angular2Pipe)) != null && (angular2Entity = angular2Entity.getTypeScriptClass()) != null) break block8;
            }
            return;
        }
        JSClass pipeClass = (JSClass)angular2Entity;
        allRenames.put((PsiElement)pipeClass, this.getDefaultPipeClassName(newName));
        String string = pipeClass.getContainingFile().getName();
        String string2 = ((JSImplicitElement)element).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (Intrinsics.areEqual((Object)string, (Object)this.getDefaultPipeFileName(string2))) {
            PsiFile specPsiFile;
            Map<PsiElement, String> map = allRenames;
            PsiFile psiFile = pipeClass.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiFile psiFile2 = psiFile;
            String string3 = this.getDefaultPipeFileName(newName);
            map.put((PsiElement)psiFile2, string3);
            VirtualFile virtualFile = pipeClass.getContainingFile().getVirtualFile().getParent();
            String string4 = ((JSImplicitElement)element).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            VirtualFile specFile = virtualFile.findFileByRelativePath(this.getDefaultPipeSpecFileName(string4));
            if (specFile != null && (specPsiFile = pipeClass.getManager().findFile(specFile)) != null) {
                allRenames.put((PsiElement)specPsiFile, this.getDefaultPipeSpecFileName(newName));
            }
        }
    }

    private final String getDefaultPipeFileName(String pipeName) {
        return pipeName + ".pipe.ts";
    }

    private final String getDefaultPipeSpecFileName(String pipeName) {
        return pipeName + ".pipe.spec.ts";
    }

    private final String getDefaultPipeClassName(String pipeName) {
        return StringUtil.capitalize((String)pipeName) + "Pipe";
    }
}

