/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.source.Angular2SourceDeclaration;
import org.angular2.inspections.actions.Angular2ActionFactory;
import org.angular2.inspections.actions.ExportNgModuleDeclarationAction;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\fH\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\fH\u0016J3\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0096\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/angular2/inspections/quickfixes/ExportNgModuleDeclarationQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "context", "Lcom/intellij/psi/PsiElement;", "declaration", "Lorg/angular2/entities/source/Angular2SourceDeclaration;", "(Lcom/intellij/psi/PsiElement;Lorg/angular2/entities/source/Angular2SourceDeclaration;)V", "myDeclarationDecorator", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/lang/javascript/psi/ecma6/ES6Decorator;", "myDeclarationName", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "getText", "invoke", "", "startElement", "endElement", "Companion", "intellij.angular"})
public final class ExportNgModuleDeclarationQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements PriorityAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String myDeclarationName;
    @NotNull
    private final SmartPsiElementPointer<ES6Decorator> myDeclarationDecorator;

    private ExportNgModuleDeclarationQuickFix(PsiElement context, Angular2SourceDeclaration declaration) {
        super(context);
        String string = declaration.getTypeScriptClass().getName();
        Intrinsics.checkNotNull((Object)string);
        this.myDeclarationName = string;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)declaration.getDecorator()));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.myDeclarationDecorator = smartPsiElementPointer;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.myDeclarationName};
        return Angular2Bundle.Companion.message("angular.quickfix.ngmodule.export.name", objectArray);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.quickfix.ngmodule.export.family", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (this.myDeclarationDecorator.getElement() == null) {
            return;
        }
        ExportNgModuleDeclarationAction action2 = Angular2ActionFactory.INSTANCE.createExportNgModuleDeclarationAction(editor, startElement, this.myDeclarationDecorator, this.getText(), false);
        List<JSImportCandidate> candidates = action2.getCandidates();
        if (candidates.size() == 1 || editor != null) {
            action2.execute();
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.HIGH;
    }

    public /* synthetic */ ExportNgModuleDeclarationQuickFix(PsiElement context, Angular2SourceDeclaration declaration, DefaultConstructorMarker $constructor_marker) {
        this(context, declaration);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"Lorg/angular2/inspections/quickfixes/ExportNgModuleDeclarationQuickFix$Companion;", "", "()V", "add", "", "context", "Lcom/intellij/psi/PsiElement;", "declaration", "Lorg/angular2/entities/Angular2Declaration;", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.angular"})
    public static final class Companion {
        private Companion() {
        }

        public final void add(@NotNull PsiElement context, @NotNull Angular2Declaration declaration, @NotNull List<LocalQuickFix> fixes) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            if (declaration instanceof Angular2SourceDeclaration && ((Angular2SourceDeclaration)declaration).getTypeScriptClass().getName() != null) {
                fixes.add((LocalQuickFix)new ExportNgModuleDeclarationQuickFix(context, (Angular2SourceDeclaration)declaration, null));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

