/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.codeInsight;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.JSTooltipWithHtmlHighlighter;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.codeInsight.blocks.Angular2BlockParameterSymbol;
import org.angular2.codeInsight.blocks.Angular2HtmlBlockSymbol;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.Angular2Module;
import org.angular2.entities.Angular2Pipe;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.html.highlighting.Angular2HtmlHighlighterColors;
import org.angular2.lang.html.psi.Angular2HtmlBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0016\u001a\u00020\n\"\b\b\u0000\u0010\u0017*\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0007J\u0012\u0010\u0010\u001a\u00020\n*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u0010\u001a\u00020\n*\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001f\u0010\u001e\u001a\u00070\n\u00a2\u0006\u0002\b\u001f*\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001f\u0010\u001e\u001a\u00070\n\u00a2\u0006\u0002\b\u001f*\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0017\u0010$\u001a\u00070\n\u00a2\u0006\u0002\b\u001f*\u00020\n2\u0006\u0010%\u001a\u00020\u001cR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0015\u0010\t\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0015\u0010\u0010\u001a\u00020\n*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\u0010\u001a\u00020\n*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/angular2/codeInsight/Angular2HighlightingUtils;", "", "()V", "NG_EXPORT_AS_KEY", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getNG_EXPORT_AS_KEY", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "NG_PIPE_KEY", "getNG_PIPE_KEY", "htmlClassName", "", "Lorg/angular2/entities/Angular2Entity;", "getHtmlClassName", "(Lorg/angular2/entities/Angular2Entity;)Ljava/lang/String;", "htmlLabel", "getHtmlLabel", "htmlName", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "getHtmlName", "(Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;)Ljava/lang/String;", "Lorg/angular2/lang/html/psi/Angular2HtmlBlock;", "(Lorg/angular2/lang/html/psi/Angular2HtmlBlock;)Ljava/lang/String;", "renderEntityList", "T", "entities", "", "Lorg/angular2/codeInsight/blocks/Angular2BlockParameterSymbol;", "context", "Lcom/intellij/psi/PsiElement;", "Lorg/angular2/codeInsight/blocks/Angular2HtmlBlockSymbol;", "withColor", "Lcom/intellij/openapi/util/NlsSafe;", "language", "Lcom/intellij/lang/Language;", "attributes", "Lorg/angular2/codeInsight/Angular2HighlightingUtils$TextAttributesKind;", "withNameColor", "element", "TextAttributesKind", "intellij.angular"})
public final class Angular2HighlightingUtils {
    @NotNull
    public static final Angular2HighlightingUtils INSTANCE = new Angular2HighlightingUtils();
    @NotNull
    private static final TextAttributesKey NG_EXPORT_AS_KEY;
    @NotNull
    private static final TextAttributesKey NG_PIPE_KEY;

    private Angular2HighlightingUtils() {
    }

    @NotNull
    public final TextAttributesKey getNG_EXPORT_AS_KEY() {
        return NG_EXPORT_AS_KEY;
    }

    @NotNull
    public final TextAttributesKey getNG_PIPE_KEY() {
        return NG_PIPE_KEY;
    }

    @NotNull
    public final String getHtmlLabel(@NotNull Angular2Entity $this$htmlLabel) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$htmlLabel, (String)"<this>");
        Angular2Entity angular2Entity = $this$htmlLabel;
        if (angular2Entity instanceof Angular2Module) {
            string = "angular.entity.module";
        } else if (angular2Entity instanceof Angular2Component) {
            string = "angular.entity.component";
        } else if (angular2Entity instanceof Angular2Directive) {
            string = "angular.entity.directive";
        } else if (angular2Entity instanceof Angular2Pipe) {
            string = "angular.entity.pipe";
        } else {
            throw new IllegalStateException($this$htmlLabel.getClass().getName());
        }
        return Angular2Bundle.Companion.message(string, new Object[0]) + " " + this.getHtmlClassName($this$htmlLabel);
    }

    @NotNull
    public final String getHtmlClassName(@NotNull Angular2Entity $this$htmlClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$htmlClassName, (String)"<this>");
        PsiElement psiElement = $this$htmlClassName.getEntitySource();
        if (psiElement == null) {
            psiElement = $this$htmlClassName.getSourceElement();
        }
        return JSTooltipWithHtmlHighlighter.Companion.highlightName$default((JSTooltipWithHtmlHighlighter.Companion)JSTooltipWithHtmlHighlighter.Companion, (PsiElement)psiElement, (String)$this$htmlClassName.getEntitySourceName(), (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getHtmlName(@NotNull JSClass $this$htmlName) {
        Intrinsics.checkNotNullParameter((Object)$this$htmlName, (String)"<this>");
        PsiElement psiElement = (PsiElement)$this$htmlName;
        String string = $this$htmlName.getName();
        if (string == null) {
            string = Angular2Bundle.Companion.message("angular.description.unknown-class", new Object[0]);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return JSTooltipWithHtmlHighlighter.Companion.highlightName$default((JSTooltipWithHtmlHighlighter.Companion)JSTooltipWithHtmlHighlighter.Companion, (PsiElement)psiElement, (String)string2, (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getHtmlName(@NotNull Angular2HtmlBlock $this$htmlName) {
        Intrinsics.checkNotNullParameter((Object)$this$htmlName, (String)"<this>");
        return this.withColor("@" + $this$htmlName.getName(), TextAttributesKind.NG_BLOCK, (PsiElement)$this$htmlName);
    }

    @NotNull
    public final String htmlName(@Nullable Angular2HtmlBlockSymbol $this$htmlName, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = $this$htmlName;
        if (object == null || (object = object.getName()) == null) {
            object = "<unknown>";
        }
        return this.withColor("@" + (String)object, TextAttributesKind.NG_BLOCK, context);
    }

    @NotNull
    public final String htmlName(@NotNull Angular2BlockParameterSymbol $this$htmlName, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$htmlName), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.withColor($this$htmlName.getName(), TextAttributesKind.NG_EXPRESSION_PREFIX, context);
    }

    @NotNull
    public final String withNameColor(@NotNull String $this$withNameColor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)$this$withNameColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return JSTooltipWithHtmlHighlighter.Companion.highlightName$default((JSTooltipWithHtmlHighlighter.Companion)JSTooltipWithHtmlHighlighter.Companion, (PsiElement)element, (String)$this$withNameColor, (boolean)false, (int)4, null);
    }

    @NotNull
    public final String withColor(@NotNull String $this$withColor, @NotNull TextAttributesKind attributes, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)$this$withColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)attributes), (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return JSTooltipWithHtmlHighlighter.Companion.applyAttributes$default((JSTooltipWithHtmlHighlighter.Companion)JSTooltipWithHtmlHighlighter.Companion, (Project)project, (String)$this$withColor, (TextAttributesKey)attributes.getKey(), (boolean)false, (int)8, null);
    }

    @NotNull
    public final String withColor(@NotNull String $this$withColor, @NotNull Language language2, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)$this$withColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return JSTooltipWithHtmlHighlighter.Companion.highlightWithLexer$default((JSTooltipWithHtmlHighlighter.Companion)JSTooltipWithHtmlHighlighter.Companion, (Project)project, (String)$this$withColor, (Language)language2, (boolean)false, (int)8, null);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Angular2Entity> String renderEntityList(@NotNull Collection<? extends T> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        StringBuilder result2 = new StringBuilder();
        int i = -1;
        for (Angular2Entity entity : entities) {
            if (++i > 0) {
                if (i == entities.size() - 1) {
                    result2.append(' ');
                    result2.append(Angular2Bundle.Companion.message("angular.description.and-separator", new Object[0]));
                    result2.append(' ');
                } else {
                    result2.append(", ");
                }
            }
            PsiElement sourceElement = entity.getSourceElement();
            result2.append(INSTANCE.getHtmlClassName(entity));
            if (entity instanceof Angular2Pipe) {
                result2.append(" (");
                result2.append(INSTANCE.withColor(entity.getName(), TextAttributesKind.NG_PIPE, sourceElement));
                result2.append(")");
                continue;
            }
            if (!(entity instanceof Angular2Directive)) continue;
            result2.append(" (");
            Project project = sourceElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String string = ((Angular2Directive)entity).getSelector().getText();
            CSSLanguage cSSLanguage = CSSLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)cSSLanguage, (String)"INSTANCE");
            result2.append(JSTooltipWithHtmlHighlighter.Companion.highlightWithLexer$default((JSTooltipWithHtmlHighlighter.Companion)JSTooltipWithHtmlHighlighter.Companion, (Project)project, (String)string, (Language)((Language)cSSLanguage), (boolean)false, (int)8, null));
            result2.append(')');
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        TextAttributesKey textAttributesKey = TypeScriptHighlighter.TS_INSTANCE_MEMBER_VARIABLE;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"TS_INSTANCE_MEMBER_VARIABLE");
        NG_EXPORT_AS_KEY = textAttributesKey;
        TextAttributesKey textAttributesKey2 = TypeScriptHighlighter.TS_GLOBAL_VARIABLE;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"TS_GLOBAL_VARIABLE");
        NG_PIPE_KEY = textAttributesKey2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lorg/angular2/codeInsight/Angular2HighlightingUtils$TextAttributesKind;", "", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "(Ljava/lang/String;ILcom/intellij/openapi/editor/colors/TextAttributesKey;)V", "getKey", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "TS_PROPERTY", "TS_FUNCTION", "TS_KEYWORD", "HTML_TAG", "HTML_ATTRIBUTE", "NG_INPUT", "NG_OUTPUT", "NG_IN_OUT", "NG_DIRECTIVE", "NG_PIPE", "NG_EXPORT_AS", "NG_BLOCK", "NG_DEFER_TRIGGER", "NG_EXPRESSION_PREFIX", "intellij.angular"})
    public static final class TextAttributesKind
    extends Enum<TextAttributesKind> {
        @NotNull
        private final TextAttributesKey key;
        public static final /* enum */ TextAttributesKind TS_PROPERTY;
        public static final /* enum */ TextAttributesKind TS_FUNCTION;
        public static final /* enum */ TextAttributesKind TS_KEYWORD;
        public static final /* enum */ TextAttributesKind HTML_TAG;
        public static final /* enum */ TextAttributesKind HTML_ATTRIBUTE;
        public static final /* enum */ TextAttributesKind NG_INPUT;
        public static final /* enum */ TextAttributesKind NG_OUTPUT;
        public static final /* enum */ TextAttributesKind NG_IN_OUT;
        public static final /* enum */ TextAttributesKind NG_DIRECTIVE;
        public static final /* enum */ TextAttributesKind NG_PIPE;
        public static final /* enum */ TextAttributesKind NG_EXPORT_AS;
        public static final /* enum */ TextAttributesKind NG_BLOCK;
        public static final /* enum */ TextAttributesKind NG_DEFER_TRIGGER;
        public static final /* enum */ TextAttributesKind NG_EXPRESSION_PREFIX;
        private static final /* synthetic */ TextAttributesKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TextAttributesKind(TextAttributesKey key) {
            this.key = key;
        }

        @NotNull
        public final TextAttributesKey getKey() {
            return this.key;
        }

        public static TextAttributesKind[] values() {
            return (TextAttributesKind[])$VALUES.clone();
        }

        public static TextAttributesKind valueOf(String value) {
            return Enum.valueOf(TextAttributesKind.class, value);
        }

        @NotNull
        public static EnumEntries<TextAttributesKind> getEntries() {
            return $ENTRIES;
        }

        static {
            TextAttributesKey textAttributesKey = TypeScriptHighlighter.TS_INSTANCE_MEMBER_VARIABLE;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"TS_INSTANCE_MEMBER_VARIABLE");
            TS_PROPERTY = new TextAttributesKind(textAttributesKey);
            TextAttributesKey textAttributesKey2 = TypeScriptHighlighter.TS_EXPORTED_FUNCTION;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"TS_EXPORTED_FUNCTION");
            TS_FUNCTION = new TextAttributesKind(textAttributesKey2);
            TextAttributesKey textAttributesKey3 = TypeScriptHighlighter.TS_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"TS_KEYWORD");
            TS_KEYWORD = new TextAttributesKind(textAttributesKey3);
            TextAttributesKey textAttributesKey4 = XmlHighlighterColors.HTML_TAG_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey4, (String)"HTML_TAG_NAME");
            HTML_TAG = new TextAttributesKind(textAttributesKey4);
            TextAttributesKey textAttributesKey5 = XmlHighlighterColors.HTML_ATTRIBUTE_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey5, (String)"HTML_ATTRIBUTE_NAME");
            HTML_ATTRIBUTE = new TextAttributesKind(textAttributesKey5);
            NG_INPUT = new TextAttributesKind(Angular2HtmlHighlighterColors.NG_PROPERTY_BINDING_ATTR_NAME);
            NG_OUTPUT = new TextAttributesKind(Angular2HtmlHighlighterColors.NG_EVENT_BINDING_ATTR_NAME);
            NG_IN_OUT = new TextAttributesKind(Angular2HtmlHighlighterColors.NG_BANANA_BINDING_ATTR_NAME);
            TextAttributesKey textAttributesKey6 = TypeScriptHighlighter.TS_CLASS;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey6, (String)"TS_CLASS");
            NG_DIRECTIVE = new TextAttributesKind(textAttributesKey6);
            NG_PIPE = new TextAttributesKind(INSTANCE.getNG_PIPE_KEY());
            NG_EXPORT_AS = new TextAttributesKind(INSTANCE.getNG_EXPORT_AS_KEY());
            NG_BLOCK = new TextAttributesKind(Angular2HtmlHighlighterColors.NG_BLOCK_NAME);
            TextAttributesKey textAttributesKey7 = TypeScriptHighlighter.TS_GLOBAL_FUNCTION;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey7, (String)"TS_GLOBAL_FUNCTION");
            NG_DEFER_TRIGGER = new TextAttributesKind(textAttributesKey7);
            TextAttributesKey textAttributesKey8 = TypeScriptHighlighter.TS_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey8, (String)"TS_KEYWORD");
            NG_EXPRESSION_PREFIX = new TextAttributesKind(textAttributesKey8);
            $VALUES = textAttributesKindArray = new TextAttributesKind[]{TextAttributesKind.TS_PROPERTY, TextAttributesKind.TS_FUNCTION, TextAttributesKind.TS_KEYWORD, TextAttributesKind.HTML_TAG, TextAttributesKind.HTML_ATTRIBUTE, TextAttributesKind.NG_INPUT, TextAttributesKind.NG_OUTPUT, TextAttributesKind.NG_IN_OUT, TextAttributesKind.NG_DIRECTIVE, TextAttributesKind.NG_PIPE, TextAttributesKind.NG_EXPORT_AS, TextAttributesKind.NG_BLOCK, TextAttributesKind.NG_DEFER_TRIGGER, TextAttributesKind.NG_EXPRESSION_PREFIX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

