/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.javascript.JSRunConfigurationBuilder;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodePackageVersion;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonGetDependenciesAction;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.cli.config.AngularConfig;
import org.angular2.cli.config.AngularConfigProvider;
import org.angular2.cli.config.AngularProject;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0012H\u0002J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J,\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00052\b\b\u0001\u0010\r\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fH\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0014\u0010#\u001a\u0004\u0018\u00010\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u000fH\u0007J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\"\u001a\u00020\u000fH\u0007J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020&H\u0007J\u0012\u0010*\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020\u000fH\u0007J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u0005H\u0007J\"\u0010/\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00100\u001a\u00020\u000f2\b\b\u0001\u00101\u001a\u00020\u0005H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/angular2/cli/AngularCliUtil;", "", "()V", "ANGULAR_JSON_NAMES", "", "", "NG_CLI_DEFAULT_ADDRESS", "NOTIFICATION_GROUP_ID", "createIfNoSimilar", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "rcType", "project", "Lcom/intellij/openapi/project/Project;", "label", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "configPath", "options", "", "createJSDebugConfiguration", "", "url", "createKarmaConfigurations", "config", "Lorg/angular2/cli/config/AngularConfig;", "createNpmConfiguration", "packageJsonPath", "scriptName", "createProtractorConfigurations", "createRunConfigurations", "findAngularCliFolder", "file", "findAngularCliModuleInfo", "Lcom/intellij/javascript/nodejs/CompletionModuleInfo;", "cli", "findCliJson", "dir", "getAngularCliPackageVersion", "Lcom/intellij/util/text/SemVer;", "getCliParamText", "name", "cliVersion", "getPackageJson", "hasAngularCLIPackageInstalled", "", "isAngularJsonFile", "fileName", "notifyAngularCliNotInstalled", "cliFolder", "message", "intellij.angular"})
@SourceDebugExtension(value={"SMAP\nAngularCliUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngularCliUtil.kt\norg/angular2/cli/AngularCliUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1855#2,2:195\n1855#2,2:197\n*S KotlinDebug\n*F\n+ 1 AngularCliUtil.kt\norg/angular2/cli/AngularCliUtil\n*L\n150#1:195,2\n162#1:197,2\n*E\n"})
public final class AngularCliUtil {
    @NotNull
    public static final AngularCliUtil INSTANCE = new AngularCliUtil();
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "Angular CLI";
    @NonNls
    @NotNull
    private static final List<String> ANGULAR_JSON_NAMES;
    @NonNls
    @NotNull
    private static final String NG_CLI_DEFAULT_ADDRESS;

    private AngularCliUtil() {
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile findCliJson(@Nullable VirtualFile dir) {
        if (dir == null || !dir.isValid()) {
            return null;
        }
        for (String name2 : ANGULAR_JSON_NAMES) {
            VirtualFile cliJson = dir.findChild(name2);
            if (cliJson == null) continue;
            return cliJson;
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile findAngularCliFolder(@NotNull Project project, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!current.isDirectory()) continue;
            if (AngularCliUtil.findCliJson(current) == null) continue;
            return current;
        }
        return AngularCliUtil.findCliJson(project.getBaseDir()) != null ? project.getBaseDir() : null;
    }

    @JvmStatic
    public static final boolean hasAngularCLIPackageInstalled(@NotNull VirtualFile cli) {
        Intrinsics.checkNotNullParameter((Object)cli, (String)"cli");
        return INSTANCE.findAngularCliModuleInfo(cli) != null;
    }

    @JvmStatic
    @Nullable
    public static final SemVer getAngularCliPackageVersion(@NotNull VirtualFile cli) {
        NodePackageVersion nodePackageVersion;
        Intrinsics.checkNotNullParameter((Object)cli, (String)"cli");
        CompletionModuleInfo completionModuleInfo = INSTANCE.findAngularCliModuleInfo(cli);
        if (completionModuleInfo == null) {
            return null;
        }
        CompletionModuleInfo moduleInfo = completionModuleInfo;
        VirtualFile virtualFile = moduleInfo.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        NodePackageVersion nodePackageVersion2 = nodePackageVersion = NodePackageVersionUtil.getPackageVersion((String)virtualFile.getPath());
        return nodePackageVersion2 != null ? nodePackageVersion2.getSemVer() : null;
    }

    private final CompletionModuleInfo findAngularCliModuleInfo(VirtualFile cli) {
        ArrayList modules2 = new ArrayList();
        NodeModuleSearchUtil.findModulesWithName((List)modules2, (String)"@angular/cli", (VirtualFile)cli, null);
        CompletionModuleInfo moduleInfo = (CompletionModuleInfo)CollectionsKt.firstOrNull((List)modules2);
        return moduleInfo != null && moduleInfo.getVirtualFile() != null ? moduleInfo : null;
    }

    @JvmStatic
    public static final boolean isAngularJsonFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return ANGULAR_JSON_NAMES.contains(fileName);
    }

    @JvmStatic
    public static final void notifyAngularCliNotInstalled(@NotNull Project project, @NotNull VirtualFile cliFolder, @Nls @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cliFolder, (String)"cliFolder");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)cliFolder);
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID).createNotification(message, Angular2Bundle.Companion.message("angular.notify.cli.required-package-not-installed", new Object[0]), NotificationType.WARNING);
        if (packageJson != null) {
            notification.addAction((AnAction)new PackageJsonGetDependenciesAction(project, packageJson, notification));
        }
        notification.notify(project);
    }

    @JvmStatic
    public static final void createRunConfigurations(@NotNull Project project, @NotNull VirtualFile baseDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        ApplicationManager.getApplication().executeOnPooledThread(() -> AngularCliUtil.createRunConfigurations$lambda$1(project, baseDir));
    }

    private final String getPackageJson(VirtualFile baseDir) {
        VirtualFile pkg;
        VirtualFile virtualFile = pkg = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)baseDir);
        return virtualFile != null ? virtualFile.getPath() : null;
    }

    private final void createJSDebugConfiguration(Project project, @NonNls String label, String url) {
        this.createIfNoSimilar("jsdebug", project, label, null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"uri", (Object)url)));
    }

    private final RunnerAndConfigurationSettings createNpmConfiguration(Project project, String packageJsonPath, @NonNls String label, String scriptName) {
        return this.createIfNoSimilar("npm", project, label, null, packageJsonPath, MapsKt.mapOf((Pair)TuplesKt.to((Object)"run-script", (Object)scriptName)));
    }

    private final void createKarmaConfigurations(Project project, AngularConfig config) {
        Iterable $this$forEach$iv = config.getProjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AngularProject ngProject = (AngularProject)element$iv;
            boolean bl = false;
            VirtualFile karmaFile = ngProject.getKarmaConfigFile();
            VirtualFile rootDir = ngProject.getRootDir();
            if (karmaFile == null || rootDir == null) continue;
            INSTANCE.createIfNoSimilar("karma", project, "Tests (" + ngProject.getName() + ")", rootDir, karmaFile.getPath(), MapsKt.emptyMap());
        }
    }

    private final void createProtractorConfigurations(Project project, AngularConfig config) {
        Iterable $this$forEach$iv = config.getProjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AngularProject ngProject = (AngularProject)element$iv;
            boolean bl = false;
            VirtualFile protractorConfigFile = ngProject.getProtractorConfigFile();
            VirtualFile rootDir = ngProject.getRootDir();
            if (protractorConfigFile == null || rootDir == null) continue;
            INSTANCE.createIfNoSimilar("protractor", project, "E2E Tests (" + ngProject.getName() + ")", rootDir, protractorConfigFile.getPath(), MapsKt.emptyMap());
        }
    }

    private final RunnerAndConfigurationSettings createIfNoSimilar(@NonNls String rcType, Project project, @NonNls String label, VirtualFile baseDir, String configPath, Map<String, ? extends Object> options) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings;
        JSRunConfigurationBuilder jSRunConfigurationBuilder = JSRunConfigurationBuilder.getForName((String)rcType, (Project)project);
        if (jSRunConfigurationBuilder != null) {
            JSRunConfigurationBuilder builder = jSRunConfigurationBuilder;
            boolean bl = false;
            runnerAndConfigurationSettings = builder.findSimilarRunConfiguration(baseDir, configPath, options);
            if (runnerAndConfigurationSettings == null) {
                runnerAndConfigurationSettings = builder.createRunConfiguration(label, baseDir, configPath, options);
            }
        } else {
            runnerAndConfigurationSettings = null;
        }
        return runnerAndConfigurationSettings;
    }

    @JvmStatic
    @NotNull
    public static final String getCliParamText(@NotNull String name2, @NotNull SemVer cliVersion) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)cliVersion, (String)"cliVersion");
        boolean toKebabCase = cliVersion.isGreaterOrEqualThan(12, 0, 0);
        String paramText = toKebabCase ? JSStringUtil.toKebabCase((String)name2, (boolean)true, (boolean)true, (boolean)false) : name2;
        return "--" + paramText;
    }

    private static final void createRunConfigurations$lambda$1$lambda$0(Project $project, VirtualFile $baseDir) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$baseDir, (String)"$baseDir");
        if ($project.isDisposed()) {
            return;
        }
        String string = INSTANCE.getPackageJson($baseDir);
        if (string == null) {
            return;
        }
        String packageJsonPath = string;
        AngularConfig angularConfig = AngularConfigProvider.Companion.findAngularConfig($project, $baseDir);
        if (angularConfig == null) {
            return;
        }
        AngularConfig config = angularConfig;
        INSTANCE.createKarmaConfigurations($project, config);
        INSTANCE.createProtractorConfigurations($project, config);
        String nameSuffix = ModuleManager.Companion.getInstance($project).getModules().length > 1 ? " (" + $baseDir.getName() + ")" : "";
        INSTANCE.createJSDebugConfiguration($project, "Angular Application" + nameSuffix, NG_CLI_DEFAULT_ADDRESS);
        RunManager.Companion.getInstance($project).setSelectedConfiguration(INSTANCE.createNpmConfiguration($project, packageJsonPath, "Angular CLI Server" + nameSuffix, "start"));
    }

    private static final void createRunConfigurations$lambda$1(Project $project, VirtualFile $baseDir) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$baseDir, (String)"$baseDir");
        DumbService.Companion.getInstance($project).runReadActionInSmartMode(() -> AngularCliUtil.createRunConfigurations$lambda$1$lambda$0($project, $baseDir));
    }

    static {
        Object[] objectArray = new String[]{"angular.json", ".angular-cli.json", "angular-cli.json"};
        ANGULAR_JSON_NAMES = CollectionsKt.listOf((Object[])objectArray);
        NG_CLI_DEFAULT_ADDRESS = "http://localhost:4200";
    }
}

