/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.MutableAccessor;
import com.intellij.util.ThreeState;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.BeanBindingKt;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.DomAdapter;
import com.intellij.util.xmlb.JdomAdapter;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.RootBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlDomAdapter;
import com.intellij.util.xmlb.annotations.Property;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0000\u00a2\u0006\u0002\b\u0012J7\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u0002H\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0019H\u0017\u00a2\u0006\u0002\u0010\u001aJ5\u0010\u001b\u001a\u00020\u001c\"\b\b\u0000\u0010\u0015*\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u0002H\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0019H\u0007\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u001fH\u0007J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010#\u001a\u00020$J\u001e\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)J\u001c\u0010*\u001a\u0004\u0018\u00010\u00142\b\u0010&\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\"H\u0016J\u0016\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J-\u00100\u001a\u00020$\"\b\b\u0000\u0010\u0015*\u00020\u00142\u0006\u0010\u0017\u001a\u0002H\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0019H\u0017\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u0014H\u0016J\u001c\u00103\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u000104H\u0016J\"\u00103\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u00105\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u000104J \u00103\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u00106\u001a\u00020 2\b\u0010(\u001a\u0004\u0018\u000104J&\u00107\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u00142\b\u00108\u001a\u0004\u0018\u00010 2\b\u0010(\u001a\u0004\u0018\u000104H\u0007J&\u00109\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u00142\b\u00108\u001a\u0004\u0018\u00010 2\b\u0010(\u001a\u0004\u0018\u000104H\u0016J6\u0010:\u001a\u0004\u0018\u00010 2\u0006\u0010;\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010<\u001a\u0004\u0018\u00010 2\b\u0010(\u001a\u0004\u0018\u0001042\u0006\u0010=\u001a\u00020$H\u0007J0\u0010>\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\"\u0018\u00010?2\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u0001042\u0006\u0010#\u001a\u00020$H\u0002J\u0014\u0010@\u001a\u00020\u001c2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u001c\u0010B\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u000104H\u0016J'\u0010B\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u0001042\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\bCJ\b\u0010D\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/intellij/util/xmlb/BeanBinding;", "Lcom/intellij/util/xmlb/Binding;", "Lcom/intellij/util/xmlb/RootBinding;", "beanClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "bindings", "", "Lcom/intellij/util/xmlb/NestedBinding;", "[Lcom/intellij/util/xmlb/NestedBinding;", "compareByFields", "Lcom/intellij/util/ThreeState;", "tagName", "", "computeBindingWeights", "Lit/unimi/dsi/fastutil/objects/Object2FloatMap;", "accessorNameTracker", "", "computeBindingWeights$intellij_platform_util", "deserialize", "", "T", "context", "element", "adapter", "Lcom/intellij/util/xmlb/DomAdapter;", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/intellij/util/xmlb/DomAdapter;)Ljava/lang/Object;", "deserializeInto", "", "bean", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/intellij/util/xmlb/DomAdapter;)V", "Lcom/intellij/util/xml/dom/XmlElement;", "Lorg/jdom/Element;", "deserializeToJson", "Lkotlinx/serialization/json/JsonElement;", "includeClassDiscriminator", "", "equalByFields", "currentValue", "defaultValue", "filter", "Lcom/intellij/util/xmlb/SkipDefaultsSerializationFilter;", "fromJson", "init", "originalType", "Ljava/lang/reflect/Type;", "serializer", "Lcom/intellij/util/xmlb/Serializer;", "isBoundTo", "(Ljava/lang/Object;Lcom/intellij/util/xmlb/DomAdapter;)Z", "newInstance", "serialize", "Lcom/intellij/util/xmlb/SerializationFilter;", "createElementIfEmpty", "parent", "serializeInto", "preCreatedElement", "serializeProperties", "serializeProperty", "binding", "parentElement", "isFilterPropertyItself", "serializeToJsonImpl", "", "sortBindings", "weights", "toJson", "toJson$intellij_platform_util", "toString", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nBeanBinding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeanBinding.kt\ncom/intellij/util/xmlb/BeanBinding\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,794:1\n1#2:795\n*E\n"})
public class BeanBinding
implements Binding,
RootBinding {
    @JvmField
    @NotNull
    public final Class<?> beanClass;
    @JvmField
    @NotNull
    public final String tagName;
    @ApiStatus.Internal
    @JvmField
    @Nullable
    public NestedBinding[] bindings;
    @JvmField
    @NotNull
    public ThreeState compareByFields;

    public BeanBinding(@NotNull Class<?> beanClass) {
        boolean bl2;
        Intrinsics.checkNotNullParameter(beanClass, "beanClass");
        this.beanClass = beanClass;
        this.compareByFields = ThreeState.UNSURE;
        boolean bl3 = bl2 = !this.beanClass.isArray();
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-BeanBinding$42 = false;
            String $i$a$-assert-BeanBinding$42 = "Bean is an array: " + this.beanClass;
            throw new AssertionError((Object)$i$a$-assert-BeanBinding$42);
        }
        boolean bl4 = bl2 = !this.beanClass.isPrimitive();
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-BeanBinding$52 = false;
            String $i$a$-assert-BeanBinding$52 = "Bean is primitive type: " + this.beanClass;
            throw new AssertionError((Object)$i$a$-assert-BeanBinding$52);
        }
        this.tagName = BeanBindingKt.access$getTagName(this.beanClass);
        boolean bl5 = bl2 = !StringsKt.isBlank(this.tagName);
        if (_Assertions.ENABLED && !bl2) {
            boolean bl6 = false;
            String string2 = "Bean name is empty: " + this.beanClass;
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    public final synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        boolean bl2;
        Intrinsics.checkNotNullParameter(originalType, "originalType");
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        boolean bl3 = bl2 = this.bindings == null;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List<MutableAccessor> accessors = BeanBindingKt.access$getPROPERTY_COLLECTOR$p().collect(this.beanClass);
        if (accessors.isEmpty()) {
            this.bindings = BeanBindingKt.access$getEMPTY_BINDINGS$p();
        } else {
            Object object = this.beanClass.getAnnotation(Property.class);
            if (object == null || (object = object.style()) == null) {
                object = Property.Style.OPTION_TAG;
            }
            Object propertyStyle = object;
            int n2 = 0;
            int n3 = accessors.size();
            NestedBinding[] nestedBindingArray = new NestedBinding[n3];
            while (n2 < n3) {
                int n4 = n2++;
                NestedBinding binding = BeanBindingKt.access$createBinding(accessors.get(n4), serializer2, (Property.Style)((Object)propertyStyle));
                binding.init(originalType, serializer2);
                nestedBindingArray[n4] = binding;
            }
            NestedBinding[] result2 = nestedBindingArray;
            this.bindings = result2;
        }
    }

    @Override
    @Nullable
    public JsonElement toJson(@NotNull Object bean, @Nullable SerializationFilter filter2) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter(bean, "bean");
        Map<String, JsonElement> map2 = this.serializeToJsonImpl(bean, filter2, false);
        if (map2 == null) {
            Map map3 = Collections.emptyMap();
            Intrinsics.checkNotNullExpressionValue(map3, "emptyMap(...)");
            jsonElement = new JsonObject(map3);
        } else {
            jsonElement = new JsonObject(map2);
        }
        return jsonElement;
    }

    @NotNull
    public final JsonElement toJson$intellij_platform_util(@NotNull Object bean, @Nullable SerializationFilter filter2, boolean includeClassDiscriminator) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter(bean, "bean");
        Map<String, JsonElement> map2 = this.serializeToJsonImpl(bean, filter2, includeClassDiscriminator);
        if (map2 == null) {
            Map map3 = includeClassDiscriminator ? Collections.singletonMap("_class", JsonElementKt.JsonPrimitive(this.tagName)) : Collections.emptyMap();
            Intrinsics.checkNotNull(map3);
            jsonElement = new JsonObject(map3);
        } else {
            jsonElement = new JsonObject(map2);
        }
        return jsonElement;
    }

    @Override
    @NotNull
    public JsonElement deserializeToJson(@NotNull Element element) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNull(this.bindings);
        return BeanBindingKt.access$deserializeBeanXmlToJson(element, this.bindings, this.tagName, false);
    }

    @NotNull
    public final JsonElement deserializeToJson(@NotNull Element element, boolean includeClassDiscriminator) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNull(this.bindings);
        return BeanBindingKt.access$deserializeBeanXmlToJson(element, this.bindings, this.tagName, includeClassDiscriminator);
    }

    private final Map<String, JsonElement> serializeToJsonImpl(Object bean, SerializationFilter filter2, boolean includeClassDiscriminator) {
        Map map2;
        String[] keys2 = null;
        JsonElement[] values2 = null;
        Intrinsics.checkNotNull(this.bindings);
        NestedBinding[] bindings = this.bindings;
        int index = 0;
        int extraSize = includeClassDiscriminator ? 1 : 0;
        int n2 = bindings.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonElement jsonElement;
            NestedBinding binding = bindings[i2];
            if (BeanBindingKt.isPropertySkipped(filter2, binding, this, bean, true)) continue;
            if (keys2 == null) {
                keys2 = new String[bindings.length + extraSize];
                values2 = new JsonElement[bindings.length + extraSize];
                if (includeClassDiscriminator) {
                    keys2[index] = "_class";
                    values2[index] = JsonElementKt.JsonPrimitive(this.tagName);
                    ++index;
                }
            }
            if ((jsonElement = binding.toJson(bean, filter2)) == null) continue;
            keys2[index] = BeanBindingKt.normalizePropertyNameForKotlinx(binding);
            Intrinsics.checkNotNull(values2);
            values2[index] = jsonElement;
            ++index;
        }
        if (keys2 == null) {
            map2 = null;
        } else {
            Intrinsics.checkNotNull(values2);
            map2 = new Object2ObjectArrayMap(keys2, values2, index);
        }
        return map2;
    }

    @Override
    @Nullable
    public Object fromJson(@Nullable Object currentValue, @NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (element == JsonNull.INSTANCE) {
            return null;
        }
        Object result2 = this.newInstance();
        if (!(element instanceof JsonObject)) {
            BeanBindingKt.LOG.warn("JsonObject is expected but got " + element);
            return result2;
        }
        Intrinsics.checkNotNull(this.bindings);
        for (NestedBinding binding : this.bindings) {
            JsonElement value;
            String key = BeanBindingKt.normalizePropertyNameForKotlinx(binding);
            if ((JsonElement)((JsonObject)element).get((Object)key) == null) continue;
            binding.setFromJson(result2, value);
        }
        return result2;
    }

    @Override
    @Nullable
    public Element serialize(@NotNull Object bean, @Nullable SerializationFilter filter2) {
        Intrinsics.checkNotNullParameter(bean, "bean");
        return this.serializeProperties(bean, null, filter2);
    }

    @Override
    public final void serialize(@NotNull Object bean, @NotNull Element parent, @Nullable SerializationFilter filter2) {
        Intrinsics.checkNotNullParameter(bean, "bean");
        Intrinsics.checkNotNullParameter(parent, "parent");
        Element element = new Element(true, this.tagName, Namespace.NO_NAMESPACE);
        this.serializeProperties(bean, element, filter2);
        parent.addContent(element);
    }

    @Nullable
    public final Element serialize(@NotNull Object bean, boolean createElementIfEmpty, @Nullable SerializationFilter filter2) {
        Intrinsics.checkNotNullParameter(bean, "bean");
        return this.serializeProperties(bean, createElementIfEmpty ? new Element(this.tagName) : null, filter2);
    }

    @Nullable
    public Element serializeProperties(@NotNull Object bean, @Nullable Element preCreatedElement, @Nullable SerializationFilter filter2) {
        Intrinsics.checkNotNullParameter(bean, "bean");
        Element element = preCreatedElement;
        Intrinsics.checkNotNull(this.bindings);
        for (NestedBinding binding : this.bindings) {
            element = this.serializeProperty(binding, bean, element, filter2, true);
        }
        return element;
    }

    @ApiStatus.Internal
    @Nullable
    public final Element serializeProperty(@NotNull NestedBinding binding, @NotNull Object bean, @Nullable Element parentElement, @Nullable SerializationFilter filter2, boolean isFilterPropertyItself) {
        Intrinsics.checkNotNullParameter(binding, "binding");
        Intrinsics.checkNotNullParameter(bean, "bean");
        if (BeanBindingKt.isPropertySkipped(filter2, binding, this, bean, isFilterPropertyItself)) {
            return parentElement;
        }
        Element element = parentElement;
        if (element == null) {
            element = new Element(this.tagName);
        }
        Element element2 = element;
        binding.serialize(bean, element2, filter2);
        return element2;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public <T> Object deserialize(@Nullable Object context, @NotNull T element, @NotNull DomAdapter<T> adapter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        Object instance = this.newInstance();
        this.deserializeInto(instance, element, adapter);
        return instance;
    }

    public final void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        Intrinsics.checkNotNullParameter(bean, "bean");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNull(this.bindings);
        NestedBinding[] nestedBindingArray = this.bindings;
        BeanBindingKt.deserializeJdomIntoBean(bean, element, nestedBindingArray, null);
    }

    @ApiStatus.Internal
    public final <T> void deserializeInto(@NotNull Object bean, @NotNull T element, @NotNull DomAdapter<T> adapter) {
        Intrinsics.checkNotNullParameter(bean, "bean");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        DomAdapter<T> domAdapter = adapter;
        if (Intrinsics.areEqual(domAdapter, JdomAdapter.INSTANCE)) {
            Element element2 = (Element)element;
            Intrinsics.checkNotNull(this.bindings);
            NestedBinding[] nestedBindingArray = this.bindings;
            BeanBindingKt.deserializeJdomIntoBean(bean, element2, nestedBindingArray, null);
        } else if (Intrinsics.areEqual(domAdapter, XmlDomAdapter.INSTANCE)) {
            XmlElement xmlElement = (XmlElement)element;
            Intrinsics.checkNotNull(this.bindings);
            BeanBindingKt.access$deserializeBeanInto(bean, xmlElement, this.bindings);
        }
    }

    @ApiStatus.Internal
    public final void deserializeInto(@NotNull Object bean, @NotNull XmlElement element) {
        Intrinsics.checkNotNullParameter(bean, "bean");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNull(this.bindings);
        BeanBindingKt.access$deserializeBeanInto(bean, element, this.bindings);
    }

    @NotNull
    public Object newInstance() {
        try {
            Constructor<?> constructor = this.beanClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Object obj = constructor.newInstance(new Object[0]);
            Intrinsics.checkNotNullExpressionValue(obj, "newInstance(...)");
            return obj;
        }
        catch (InvocationTargetException e2) {
            Throwable throwable = e2.getTargetException();
            if (throwable == null) {
                throwable = e2;
            }
            throw throwable;
        }
    }

    public final boolean equalByFields(@NotNull Object currentValue, @NotNull Object defaultValue, @NotNull SkipDefaultsSerializationFilter filter2) {
        Intrinsics.checkNotNullParameter(currentValue, "currentValue");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNull(this.bindings);
        for (NestedBinding binding : this.bindings) {
            MutableAccessor accessor = binding.getAccessor();
            if (filter2.equal(binding, accessor.read(currentValue), accessor.read(defaultValue))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Object2FloatMap<String> computeBindingWeights$intellij_platform_util(@NotNull Set<String> accessorNameTracker) {
        Intrinsics.checkNotNullParameter(accessorNameTracker, "accessorNameTracker");
        Object2FloatOpenHashMap<String> weights = new Object2FloatOpenHashMap<String>(accessorNameTracker.size());
        float weight = 0.0f;
        Intrinsics.checkNotNull(this.bindings);
        float step = (float)this.bindings.length / (float)accessorNameTracker.size();
        for (String name : accessorNameTracker) {
            weights.put(name, weight);
            weight += step;
        }
        weight = 0.0f;
        Intrinsics.checkNotNull(this.bindings);
        for (NestedBinding binding : this.bindings) {
            String name;
            Intrinsics.checkNotNullExpressionValue(binding.getAccessor().getName(), "getName(...)");
            if (!weights.containsKey(name)) {
                weights.put(name, weight);
            }
            float f2 = weight;
            weight = f2 + 1.0f;
        }
        return weights;
    }

    public final void sortBindings(@NotNull Object2FloatMap<String> weights) {
        Intrinsics.checkNotNullParameter(weights, "weights");
        Intrinsics.checkNotNull(this.bindings);
        Arrays.sort(this.bindings, (arg_0, arg_1) -> BeanBinding.sortBindings$lambda$3(new Function2<NestedBinding, NestedBinding, Integer>(weights){
            final /* synthetic */ Object2FloatMap<String> $weights;
            {
                this.$weights = $weights;
                super(2);
            }

            @NotNull
            public final Integer invoke(NestedBinding o1, NestedBinding o2) {
                String string2 = o1.getAccessor().getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                String n1 = string2;
                String string3 = o2.getAccessor().getName();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                String n2 = string3;
                float w1 = this.$weights.getFloat(n1);
                float w2 = this.$weights.getFloat(n2);
                return (int)(w1 - w2);
            }
        }, arg_0, arg_1));
    }

    @Override
    @ApiStatus.Internal
    public <T> boolean isBoundTo(@NotNull T element, @NotNull DomAdapter<T> adapter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        return Intrinsics.areEqual(adapter.getName(element), this.tagName);
    }

    @NotNull
    public String toString() {
        return "BeanBinding(" + this.beanClass.getName() + ", tagName=" + this.tagName + ')';
    }

    @Deprecated(message="Don't use internal API", replaceWith=@ReplaceWith(expression="", imports={}))
    @Nullable
    public final Element serializeInto(@NotNull Object bean, @Nullable Element preCreatedElement, @Nullable SerializationFilter filter2) {
        Intrinsics.checkNotNullParameter(bean, "bean");
        return this.serializeProperties(bean, preCreatedElement, filter2);
    }

    private static final int sortBindings$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

