/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text.minimatch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.minimatch.DefaultPathAdapter;
import com.intellij.util.text.minimatch.GlobStar;
import com.intellij.util.text.minimatch.LiteralItem;
import com.intellij.util.text.minimatch.MagicItem;
import com.intellij.util.text.minimatch.MinimatchKt;
import com.intellij.util.text.minimatch.MinimatchOptions;
import com.intellij.util.text.minimatch.ParseContext;
import com.intellij.util.text.minimatch.ParseItem;
import com.intellij.util.text.minimatch.ParseResult;
import com.intellij.util.text.minimatch.PathAdapter;
import com.intellij.util.text.minimatch.PatternListItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001cJG\u0010\u001d\u001a.\u0012*\u0012(\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00030\u0003 \u001e*\u0014\u0012\u000e\b\u0001\u0012\n \u001e*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u00130\u00130\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016J\u0014\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0010H\u0002J3\u0010#\u001a\u00020\b\"\u0004\b\u0000\u0010$2\u0006\u0010%\u001a\u0002H$2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'2\b\b\u0002\u0010(\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010)J\u001a\u0010#\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u00032\b\b\u0002\u0010(\u001a\u00020\bH\u0007J\u001e\u0010#\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00102\b\b\u0002\u0010(\u001a\u00020\bJ,\u0010,\u001a\u00020\b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0\u00102\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010(\u001a\u00020\bH\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00100\u001a\u00020\bH\u0002J\b\u00101\u001a\u00020\u0003H\u0016J\u001c\u00101\u001a\u00020+2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00130\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/util/text/minimatch/Minimatch;", "", "pattern", "", "options", "Lcom/intellij/util/text/minimatch/MinimatchOptions;", "(Ljava/lang/String;Lcom/intellij/util/text/minimatch/MinimatchOptions;)V", "comment", "", "empty", "negate", "getNegate", "()Z", "getOptions", "()Lcom/intellij/util/text/minimatch/MinimatchOptions;", "set", "", "Lcom/intellij/util/text/minimatch/ParseItem;", "braceExpand", "", "(Ljava/lang/String;Lcom/intellij/util/text/minimatch/MinimatchOptions;)[Ljava/lang/String;", "clearStateChar", "", "ctx", "Lcom/intellij/util/text/minimatch/ParseContext;", "equals", "other", "expand", "(Ljava/lang/String;)[Ljava/lang/String;", "globParts", "kotlin.jvm.PlatformType", "([Ljava/lang/String;)Ljava/util/List;", "hashCode", "", "make", "match", "T", "input", "adapter", "Lcom/intellij/util/text/minimatch/PathAdapter;", "partial", "(Ljava/lang/Object;Lcom/intellij/util/text/minimatch/PathAdapter;Z)Z", "path", "", "matchOne", "file", "parse", "Lcom/intellij/util/text/minimatch/ParseResult;", "isSub", "toString", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nMinimatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Minimatch.kt\ncom/intellij/util/text/minimatch/Minimatch\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 util.kt\ncom/intellij/util/containers/UtilKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,782:1\n58#2,5:783\n58#2,5:788\n58#2,5:811\n58#2,5:823\n58#2,5:828\n58#2,5:833\n58#2,5:838\n58#2,5:843\n58#2,5:859\n58#2,5:864\n58#2,5:869\n58#2,5:874\n58#2,5:879\n58#2,5:884\n58#2,5:889\n58#2,5:894\n58#2,5:899\n58#2,5:904\n58#2,5:909\n58#2,5:914\n58#2,5:919\n58#2,5:924\n264#3,2:793\n247#3,4:795\n266#3,2:802\n247#3,4:806\n247#3,4:816\n11400#4,3:799\n11400#4,3:820\n1620#5,2:804\n1622#5:810\n731#5,9:848\n37#6,2:857\n*S KotlinDebug\n*F\n+ 1 Minimatch.kt\ncom/intellij/util/text/minimatch/Minimatch\n*L\n94#1:783,5\n99#1:788,5\n103#1:811,5\n164#1:823,5\n187#1:828,5\n201#1:833,5\n227#1:838,5\n391#1:843,5\n488#1:859,5\n504#1:864,5\n541#1:869,5\n542#1:874,5\n552#1:879,5\n555#1:884,5\n602#1:889,5\n606#1:894,5\n616#1:899,5\n632#1:904,5\n644#1:909,5\n647#1:914,5\n691#1:919,5\n702#1:924,5\n102#1:793,2\n102#1:795,4\n102#1:802,2\n102#1:806,4\n121#1:816,4\n102#1:799,3\n121#1:820,3\n102#1:804,2\n102#1:810\n434#1:848,9\n434#1:857,2\n*E\n"})
public final class Minimatch {
    @NotNull
    private final MinimatchOptions options;
    private final boolean comment;
    private final boolean empty;
    private final boolean negate;
    @NotNull
    private final List<List<ParseItem>> set;
    @NotNull
    private final String pattern;

    @JvmOverloads
    public Minimatch(@NotNull String pattern, @NotNull MinimatchOptions options) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(options, "options");
        this.options = options;
        String normalizedPattern = this.options.getAllowWindowsPaths() ? MinimatchKt.replaceEscapedBackSlash(pattern) : pattern;
        boolean bl2 = this.comment = !this.options.getNocomment() && StringsKt.startsWith$default((CharSequence)normalizedPattern, '#', false, 2, null);
        if (this.comment) {
            this.pattern = normalizedPattern;
            this.set = CollectionsKt.emptyList();
            this.negate = false;
        } else {
            if (this.options.getNonegate()) {
                this.pattern = normalizedPattern;
                this.negate = false;
            } else {
                String string2;
                int negateOffset;
                boolean negate = false;
                for (negateOffset = 0; negateOffset < pattern.length() && pattern.charAt(negateOffset) == '!'; ++negateOffset) {
                    negate = !negate;
                }
                this.negate = negate;
                if (negateOffset > 0) {
                    String string3 = pattern.substring(negateOffset);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                } else {
                    string2 = pattern;
                }
                this.pattern = string2;
            }
            this.set = this.make();
        }
    }

    public /* synthetic */ Minimatch(String string2, MinimatchOptions minimatchOptions, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            minimatchOptions = new MinimatchOptions(false, false, false, false, false, false, false, false, false, false, 1023, null);
        }
        this(string2, minimatchOptions);
    }

    @NotNull
    public final MinimatchOptions getOptions() {
        return this.options;
    }

    public final boolean getNegate() {
        return this.negate;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<ParseItem>> make() {
        List list;
        Object object;
        Object[] set = this.braceExpand(this.pattern, this.options);
        Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append(this.pattern).append(' ');
            String string2 = Arrays.toString(set);
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            ((Logger)object).debug(stringBuilder.append(string2).toString(), e$iv);
        }
        List<String[]> globParts = this.globParts((String[])set);
        Logger $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            object = $this$debug_u24default$iv2;
            boolean bl3 = false;
            ((Logger)object).debug(this.pattern + ' ' + this.toString(globParts), e$iv2);
        }
        Collection $this$mapSmart$iv = globParts;
        boolean $i$f$mapSmart = false;
        int size$iv = $this$mapSmart$iv.size();
        switch (size$iv) {
            case 1: {
                List list2;
                String[] it = (String[])CollectionsKt.first($this$mapSmart$iv);
                boolean bl4 = false;
                Intrinsics.checkNotNull(it);
                String[] $this$mapSmart$iv2 = it;
                boolean $i$f$mapSmart2 = false;
                int size$iv2 = $this$mapSmart$iv2.length;
                switch (size$iv2) {
                    case 1: {
                        String it2 = $this$mapSmart$iv2[0];
                        boolean bl5 = false;
                        Intrinsics.checkNotNull(it2);
                        ParseItem parseItem = this.parse(it2, false).getItem();
                        list2 = new SmartList<ParseItem>(parseItem);
                        break;
                    }
                    case 0: {
                        list2 = new SmartList();
                        break;
                    }
                    default: {
                        void $this$mapTo$iv$iv;
                        String[] stringArray = $this$mapSmart$iv2;
                        Collection destination$iv$iv2 = new ArrayList(size$iv2);
                        boolean $i$f$mapTo = false;
                        int it2 = ((void)$this$mapTo$iv$iv).length;
                        for (int i2 = 0; i2 < it2; ++i2) {
                            void it3;
                            void item$iv$iv;
                            void var21_36 = item$iv$iv = $this$mapTo$iv$iv[i2];
                            Collection collection = destination$iv$iv2;
                            boolean bl6 = false;
                            Intrinsics.checkNotNull(it3);
                            collection.add(this.parse((String)it3, false).getItem());
                        }
                        list2 = (List)destination$iv$iv2;
                    }
                }
                List list3 = list2;
                list = new SmartList<List>(list3);
                break;
            }
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                Iterable iterable = $this$mapSmart$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    List list4;
                    void it;
                    String[] bl4 = (String[])item$iv$iv;
                    object = destination$iv$iv;
                    boolean $i$a$-mapSmart-Minimatch$make$results$2 = false;
                    Intrinsics.checkNotNull(it);
                    void $this$mapSmart$iv3 = it;
                    boolean $i$f$mapSmart3 = false;
                    int size$iv3 = ((void)$this$mapSmart$iv3).length;
                    switch (size$iv3) {
                        case 1: {
                            void it4 = $this$mapSmart$iv3[0];
                            boolean bl7 = false;
                            Intrinsics.checkNotNull(it4);
                            ParseItem parseItem = this.parse((String)it4, false).getItem();
                            list4 = new SmartList<ParseItem>(parseItem);
                            break;
                        }
                        case 0: {
                            list4 = new SmartList();
                            break;
                        }
                        default: {
                            void $this$mapTo$iv$iv2;
                            void destination$iv$iv2 = $this$mapSmart$iv3;
                            Collection destination$iv$iv3 = new ArrayList(size$iv3);
                            boolean $i$f$mapTo2 = false;
                            int n2 = ((void)$this$mapTo$iv$iv2).length;
                            for (int i3 = 0; i3 < n2; ++i3) {
                                void it5;
                                void item$iv$iv2;
                                void bl6 = item$iv$iv2 = $this$mapTo$iv$iv2[i3];
                                Collection collection = destination$iv$iv3;
                                boolean $i$a$-mapSmart-Minimatch$make$results$1$2 = false;
                                Intrinsics.checkNotNull(it5);
                                collection.add(this.parse((String)it5, false).getItem());
                            }
                            list4 = (List)destination$iv$iv3;
                        }
                    }
                    object.add(list4);
                }
                list = (List)destination$iv$iv;
            }
        }
        List results = list;
        Logger $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
        Throwable e$iv3 = null;
        boolean $i$f$debug3 = false;
        if ($this$debug_u24default$iv3.isDebugEnabled()) {
            object = $this$debug_u24default$iv3;
            boolean bl8 = false;
            ((Logger)object).debug(this.pattern + ' ' + results, e$iv3);
        }
        return results;
    }

    private final CharSequence toString(List<String[]> globParts) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object[] objectArray : globParts) {
            String string2 = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            sb.append(string2);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String[]> globParts(String[] set) {
        List list;
        String[] $this$mapSmart$iv = set;
        boolean $i$f$mapSmart = false;
        int size$iv = $this$mapSmart$iv.length;
        switch (size$iv) {
            case 1: {
                String it = $this$mapSmart$iv[0];
                boolean bl2 = false;
                String[] stringArray = MinimatchKt.access$getSlashSplit$p().split(it, Integer.MAX_VALUE);
                list = new SmartList<String[]>(stringArray);
                break;
            }
            case 0: {
                list = new SmartList();
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                String[] stringArray = $this$mapSmart$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                boolean $i$f$mapTo = false;
                int n2 = ((void)$this$mapTo$iv$iv).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    void it;
                    void item$iv$iv;
                    void var11_14 = item$iv$iv = $this$mapTo$iv$iv[i2];
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(MinimatchKt.access$getSlashSplit$p().split((CharSequence)it, Integer.MAX_VALUE));
                }
                list = (List)destination$iv$iv;
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final ParseResult parse(String pattern, boolean isSub) {
        int n2;
        Logger logger;
        if (!this.options.getNoglobstar() && Intrinsics.areEqual("**", pattern)) {
            return new ParseResult(MinimatchKt.access$getGLOBSTAR$p(), false);
        }
        if (((CharSequence)pattern).length() == 0) {
            return new ParseResult(ParseItem.Empty, false);
        }
        ParseContext ctx = new ParseContext();
        ctx.re = "";
        ctx.hasMagic = this.options.getNocase();
        boolean escaping = false;
        Stack patternListStack = new Stack();
        Stack negativeListStack = new Stack();
        char plType = '\u0000';
        boolean inClass = false;
        int reClassStart = -1;
        int classStart = -1;
        String patternStart = pattern.charAt(0) == '.' ? "" : (this.options.getDot() ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)");
        int n3 = pattern.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            boolean $i$f$debug;
            Logger $this$debug_u24default$iv3;
            char c2 = '\u0000';
            c2 = pattern.charAt(i2);
            Logger $this$debug_u24default$iv22 = MinimatchKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv22.isDebugEnabled()) {
                logger = $this$debug_u24default$iv22;
                boolean bl2 = false;
                logger.debug(pattern + '\t' + i2 + ' ' + ctx.re + " \"" + c2 + '\"', e$iv);
            }
            if (escaping && StringsKt.contains$default((CharSequence)"().*{}+?[]^$\\!", c2, false, 2, null)) {
                ctx.re = ctx.re + '\\' + c2;
                escaping = false;
                continue;
            }
            char $this$debug_u24default$iv22 = c2;
            if ($this$debug_u24default$iv22 == '/') {
                throw new IllegalStateException();
            }
            if ($this$debug_u24default$iv22 == '\\') {
                this.clearStateChar(ctx);
                escaping = true;
                continue;
            }
            if (((($this$debug_u24default$iv22 == '?' ? true : $this$debug_u24default$iv22 == '*') ? true : $this$debug_u24default$iv22 == '+') ? true : $this$debug_u24default$iv22 == '@') ? true : $this$debug_u24default$iv22 == '!') {
                $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
                Throwable e$iv2 = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv3.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv3;
                    boolean bl3 = false;
                    logger.debug(pattern + '\t' + i2 + ' ' + ctx.re + " \"" + c2 + "\" <-- stateChar", e$iv2);
                }
                if (inClass) {
                    MinimatchKt.access$getLOG$p().debug("  in class");
                    if (c2 == '!' && i2 == classStart + 1) {
                        c2 = '^';
                    }
                    ctx.re = ctx.re + c2;
                    continue;
                }
                $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
                e$iv2 = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv3.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv3;
                    boolean bl4 = false;
                    logger.debug("call clearStateChar \"" + ctx.stateChar + '\"', e$iv2);
                }
                this.clearStateChar(ctx);
                ctx.stateChar = Character.valueOf(c2);
                if (!this.options.getNoext()) continue;
                this.clearStateChar(ctx);
                continue;
            }
            if ($this$debug_u24default$iv22 == '(') {
                if (inClass) {
                    ctx.re = ctx.re + '(';
                    continue;
                }
                if (ctx.stateChar == null) {
                    ctx.re = ctx.re + "\\(";
                    continue;
                }
                Character c3 = ctx.stateChar;
                Intrinsics.checkNotNull(c3);
                plType = c3.charValue();
                patternListStack.push((Object)new PatternListItem(plType, i2 - 1, ctx.re.length(), 0, 8, null));
                Character c4 = ctx.stateChar;
                char $this$debug_u24default$iv = '!';
                ctx.re = ctx.re + (c4 != null && c4.charValue() == $this$debug_u24default$iv ? "(?:(?!(?:" : "(?:");
                $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
                Throwable e$iv3 = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv3.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv3;
                    boolean bl5 = false;
                    logger.debug("plType \"" + ctx.stateChar + "\" \"" + ctx.re + '\"', e$iv3);
                }
                ctx.stateChar = null;
                continue;
            }
            if ($this$debug_u24default$iv22 == ')') {
                if (inClass || patternListStack.isEmpty()) {
                    ctx.re = ctx.re + "\\)";
                    continue;
                }
                this.clearStateChar(ctx);
                ctx.hasMagic = true;
                ctx.re = ctx.re + ')';
                PatternListItem pl = (PatternListItem)patternListStack.pop();
                char e$iv3 = plType = pl.getType();
                if (e$iv3 == '!') {
                    negativeListStack.push((Object)pl);
                    ctx.re = ctx.re + ")[^/]*?)";
                    pl.setReEnd(ctx.re.length());
                    continue;
                }
                if (!((e$iv3 == '?' ? true : e$iv3 == '+') ? true : e$iv3 == '*')) continue;
                ctx.re = ctx.re + plType;
                continue;
            }
            if ($this$debug_u24default$iv22 == '|') {
                if (inClass || patternListStack.size() == 0 || escaping) {
                    ctx.re = ctx.re + "\\|";
                    escaping = false;
                    continue;
                }
                this.clearStateChar(ctx);
                ctx.re = ctx.re + '|';
                continue;
            }
            if ($this$debug_u24default$iv22 == '[') {
                this.clearStateChar(ctx);
                if (inClass) {
                    ctx.re = ctx.re + '\\' + c2;
                    continue;
                }
                inClass = true;
                classStart = i2;
                reClassStart = ctx.re.length();
                ctx.re = ctx.re + c2;
                continue;
            }
            if ($this$debug_u24default$iv22 == ']') {
                if (i2 == classStart + 1 || !inClass) {
                    ctx.re = ctx.re + '\\' + c2;
                    escaping = false;
                    continue;
                }
                if (inClass) {
                    String cs;
                    Intrinsics.checkNotNullExpressionValue(pattern.substring(classStart + 1, i2), "substring(...)");
                    try {
                        Pattern.compile('[' + cs + ']');
                    }
                    catch (Throwable e2) {
                        ParseResult sp = this.parse(cs, true);
                        StringBuilder stringBuilder = new StringBuilder();
                        String string2 = ctx.re.substring(0, reClassStart);
                        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                        ctx.re = stringBuilder.append(string2).append("\\[").append(sp.getItem().getSource()).append("\\]").toString();
                        ctx.hasMagic = ctx.hasMagic || sp.isB();
                        inClass = false;
                        continue;
                    }
                }
                ctx.hasMagic = true;
                inClass = false;
                ctx.re = ctx.re + c2;
                continue;
            }
            this.clearStateChar(ctx);
            if (escaping) {
                escaping = false;
            } else if (StringsKt.contains$default((CharSequence)"().*{}+?[]^$\\!", c2, false, 2, null) && (c2 != '^' || !inClass)) {
                ctx.re = ctx.re + '\\';
            }
            ctx.re = ctx.re + c2;
        }
        if (inClass) {
            String string3 = pattern.substring(classStart + 1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            String cs = string3;
            ParseResult sp = this.parse(cs, true);
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = ctx.re.substring(0, reClassStart);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            ctx.re = stringBuilder.append(string4).append("\\[").append(sp.getItem().getSource()).toString();
            boolean bl6 = ctx.hasMagic = ctx.hasMagic || sp.isB();
        }
        while (!patternListStack.isEmpty()) {
            PatternListItem pl = (PatternListItem)patternListStack.pop();
            CharSequence tail = null;
            String string5 = ctx.re.substring(pl.getReStart() + 3);
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
            tail = string5;
            Pattern p2 = Pattern.compile("((?:\\\\{2})*)(\\\\?)\\|");
            Matcher m2 = p2.matcher(tail);
            StringBuilder sb = new StringBuilder();
            int lastEnd = 0;
            while (m2.find()) {
                String g1 = m2.group(1);
                String g2 = m2.group(2);
                CharSequence charSequence = g2;
                if (charSequence == null || charSequence.length() == 0) {
                    g2 = "\\";
                }
                sb.append(((Object)((CharSequence)tail).subSequence(lastEnd, m2.start())).toString());
                sb.append(g1).append(g1).append(g2).append("|");
                lastEnd = m2.end();
            }
            sb.append(tail, lastEnd, ((CharSequence)tail).length());
            tail = sb;
            Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
            Throwable e$iv22 = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                n2 = 0;
                logger.debug("tail=" + tail, e$iv22);
            }
            char e$iv22 = pl.getType();
            String t2 = e$iv22 == '*' ? "[^/]*?" : (e$iv22 == '?' ? "[^/]" : "" + '\\' + pl.getType());
            ctx.hasMagic = true;
            StringBuilder stringBuilder = new StringBuilder();
            String string6 = ctx.re.substring(0, pl.getReStart());
            Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
            ctx.re = stringBuilder.append(string6).append(t2).append("\\(").append((Object)tail).toString();
        }
        this.clearStateChar(ctx);
        if (escaping) {
            ctx.re = ctx.re + "\\\\";
        }
        boolean addPatternStart = false;
        char tail = ctx.re.charAt(0);
        if ((tail == '.' ? true : tail == '[') ? true : tail == '(') {
            addPatternStart = true;
        }
        while (!negativeListStack.isEmpty()) {
            String nlFirst;
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            String nlBefore;
            PatternListItem nl = (PatternListItem)negativeListStack.pop();
            Intrinsics.checkNotNullExpressionValue(ctx.re.substring(0, nl.getReStart()), "substring(...)");
            Intrinsics.checkNotNullExpressionValue(ctx.re.substring(nl.getReStart(), nl.getReEnd() - 8), "substring(...)");
            String string7 = ctx.re.substring(nl.getReEnd() - 8, nl.getReEnd());
            Intrinsics.checkNotNullExpressionValue(string7, "substring(...)");
            String nlLast = string7;
            String string8 = ctx.re.substring(nl.getReEnd());
            Intrinsics.checkNotNullExpressionValue(string8, "substring(...)");
            String nlAfter = string8;
            nlLast = nlLast + nlAfter;
            Object e$iv22 = nlBefore;
            Regex $i$f$debug = new Regex("\\(");
            n2 = 0;
            e$iv22 = $i$f$debug.split((CharSequence)e$iv22, n2);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String p0 = (String)iterator$iv.previous();
                    boolean bl7 = false;
                    if (((CharSequence)p0).length() == 0) continue;
                    list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            int openParensBefore = thisCollection$iv.toArray(new String[0]).length - 1;
            String cleanAfter = nlAfter;
            int i3 = 0;
            int n4 = openParensBefore - 1;
            if (i3 <= n4) {
                while (true) {
                    CharSequence charSequence = cleanAfter;
                    Regex regex = new Regex("\\)[+*?]?");
                    String string9 = "";
                    cleanAfter = regex.replace(charSequence, string9);
                    if (i3 == n4) break;
                    ++i3;
                }
            }
            nlAfter = cleanAfter;
            String dollar = "";
            if (((CharSequence)nlAfter).length() == 0 && !isSub) {
                dollar = "$";
            }
            ctx.re = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        }
        if (!(((CharSequence)ctx.re).length() == 0) && ctx.hasMagic) {
            ctx.re = "(?=.)" + ctx.re;
        }
        if (addPatternStart) {
            ctx.re = patternStart + ctx.re;
        }
        if (isSub) {
            return new ParseResult(new LiteralItem(ctx.re), ctx.hasMagic);
        }
        if (!ctx.hasMagic) {
            return new ParseResult(new LiteralItem(MinimatchKt.globUnescape(pattern)), false);
        }
        return new ParseResult(new MagicItem(ctx.re, this.options), false);
    }

    private final void clearStateChar(ParseContext ctx) {
        if (ctx.stateChar != null) {
            Character c2;
            Character c3 = c2 = ctx.stateChar;
            char c4 = '*';
            if (c3 != null && c3.charValue() == c4) {
                ctx.re = ctx.re + "[^/]*?";
                ctx.hasMagic = true;
            } else {
                Character c5 = c2;
                c4 = '?';
                if (c5 != null && c5.charValue() == c4) {
                    ctx.re = ctx.re + "[^/]";
                    ctx.hasMagic = true;
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append(ctx.re).append('\\');
                    Character c6 = ctx.stateChar;
                    Intrinsics.checkNotNull(c6);
                    ctx.re = stringBuilder.append(c6.charValue()).toString();
                }
            }
            Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("clearStateChar \"" + ctx.stateChar + "\" \"" + ctx.re + '\"', e$iv);
            }
            ctx.stateChar = null;
        }
    }

    private final String[] braceExpand(String pattern, MinimatchOptions options) {
        String[] stringArray;
        if (options.getNobrace() || !MinimatchKt.access$getHasBraces$p().matcher(pattern).matches()) {
            String[] stringArray2 = new String[]{pattern};
            stringArray = stringArray2;
        } else {
            stringArray = this.expand(pattern);
        }
        return stringArray;
    }

    private final String[] expand(String pattern) {
        String[] stringArray = new String[]{pattern};
        return stringArray;
    }

    public final boolean match(@NotNull List<? extends CharSequence> path, boolean partial) {
        int i2;
        Intrinsics.checkNotNullParameter(path, "path");
        Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug(this.pattern + " set " + this.set, e$iv);
        }
        CharSequence filename = null;
        for (i2 = path.size() - 1; i2 >= 0 && (filename = path.get(i2)).length() == 0; --i2) {
        }
        for (i2 = 0; i2 < this.set.size(); ++i2) {
            List<ParseItem> pattern = this.set.get(i2);
            List file2 = path;
            if (this.options.getMatchBase() && pattern.size() == 1) {
                CharSequence charSequence = filename;
                Intrinsics.checkNotNull(charSequence);
                file2 = new SmartList<CharSequence>(charSequence);
            }
            if (!this.matchOne(file2, pattern, partial)) continue;
            return this.options.getFlipNegate() || !this.negate;
        }
        if (this.options.getFlipNegate()) {
            return false;
        }
        return this.negate;
    }

    public static /* synthetic */ boolean match$default(Minimatch minimatch, List list, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        return minimatch.match(list, bl2);
    }

    private final boolean matchOne(List<? extends CharSequence> file2, List<? extends ParseItem> pattern, boolean partial) {
        int pi;
        Logger logger;
        Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug("matchOne\n\tOptions: " + this.options + "\n\tfile: " + file2 + "\n\tpattern: " + pattern, e$iv);
        }
        $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
        e$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl3 = false;
            logger.debug("matchOne " + file2.size() + ' ' + pattern.size(), e$iv);
        }
        int fi = 0;
        int fl = file2.size();
        int pl = pattern.size();
        for (pi = 0; fi < fl && pi < pl; ++fi, ++pi) {
            ParseItem p2 = pattern.get(pi);
            CharSequence f2 = file2.get(fi);
            Logger $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
            Throwable e$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl4 = false;
                logger.debug("" + pattern + ' ' + p2 + ' ' + f2, e$iv2);
            }
            if (p2 instanceof GlobStar) {
                $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
                e$iv2 = null;
                $i$f$debug2 = false;
                if ($this$debug_u24default$iv2.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv2;
                    boolean bl5 = false;
                    logger.debug("GLOBSTAR [" + pattern + ", " + p2 + ", " + f2 + ']', e$iv2);
                }
                int fr = 0;
                fr = fi;
                int pr = pi + 1;
                if (pr == pl) {
                    MinimatchKt.access$getLOG$p().debug("** at the end");
                    while (fi < fl) {
                        CharSequence item = file2.get(fi);
                        if (Intrinsics.areEqual(item, ".") || Intrinsics.areEqual(item, "..") || !this.options.getDot() && StringsKt.startsWith$default(item, '.', false, 2, null)) {
                            return false;
                        }
                        ++fi;
                    }
                    return true;
                }
                while (fr < fl) {
                    CharSequence swallowee = file2.get(fr);
                    Logger $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
                    Throwable e$iv3 = null;
                    boolean $i$f$debug3 = false;
                    if ($this$debug_u24default$iv3.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv3;
                        boolean bl6 = false;
                        logger.debug("\nglobstar while " + file2 + ' ' + fr + ' ' + pattern + ' ' + pr + ' ' + swallowee, e$iv3);
                    }
                    if (this.matchOne(file2.subList(fr, file2.size()), pattern.subList(pr, pattern.size()), partial)) {
                        $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
                        e$iv3 = null;
                        $i$f$debug3 = false;
                        if ($this$debug_u24default$iv3.isDebugEnabled()) {
                            logger = $this$debug_u24default$iv3;
                            boolean bl7 = false;
                            logger.debug("globstar found match! " + fr + ' ' + fl + ' ' + swallowee, e$iv3);
                        }
                        return true;
                    }
                    if (Intrinsics.areEqual(swallowee, ".") || Intrinsics.areEqual(swallowee, "..") || !this.options.getDot() && StringsKt.startsWith$default(swallowee, '.', false, 2, null)) {
                        $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
                        e$iv3 = null;
                        $i$f$debug3 = false;
                        if (!$this$debug_u24default$iv3.isDebugEnabled()) break;
                        logger = $this$debug_u24default$iv3;
                        boolean bl8 = false;
                        logger.debug("dot detected! " + file2 + ' ' + fr + ' ' + pattern + ' ' + pr, e$iv3);
                        break;
                    }
                    MinimatchKt.access$getLOG$p().debug("globstar swallow a segment, and continue");
                    int $this$debug_u24default$iv22 = fr;
                    fr = $this$debug_u24default$iv22 + 1;
                }
                if (partial) {
                    Logger $this$debug_u24default$iv4 = MinimatchKt.access$getLOG$p();
                    Throwable e$iv4 = null;
                    boolean $i$f$debug4 = false;
                    if ($this$debug_u24default$iv4.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv4;
                        boolean bl9 = false;
                        logger.debug("\n>>> no match, partial? " + file2 + ' ' + fr + ' ' + pattern + ' ' + pr, e$iv4);
                    }
                    if (fr == fl) {
                        return true;
                    }
                }
                return false;
            }
            if (!p2.match(f2, this.options)) {
                $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
                e$iv2 = null;
                $i$f$debug2 = false;
                if ($this$debug_u24default$iv2.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv2;
                    boolean bl10 = false;
                    logger.debug("pattern match " + p2 + ' ' + f2 + " false", e$iv2);
                }
                return false;
            }
            $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
            e$iv2 = null;
            $i$f$debug2 = false;
            if (!$this$debug_u24default$iv2.isDebugEnabled()) continue;
            logger = $this$debug_u24default$iv2;
            boolean bl11 = false;
            logger.debug("pattern match " + p2 + ' ' + f2 + " true", e$iv2);
        }
        if (fi == fl && pi == pl) {
            return true;
        }
        if (fi == fl) {
            return partial;
        }
        if (pi == pl) {
            return fi == fl - 1 && file2.get(fi).length() == 0;
        }
        throw new IllegalStateException("");
    }

    @JvmOverloads
    public final boolean match(@NotNull String input, boolean partial) {
        Intrinsics.checkNotNullParameter(input, "input");
        return this.match(input, DefaultPathAdapter.INSTANCE, partial);
    }

    public static /* synthetic */ boolean match$default(Minimatch minimatch, String string2, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        return minimatch.match(string2, bl2);
    }

    @JvmOverloads
    public final <T> boolean match(T input, @NotNull PathAdapter<? super T> adapter, boolean partial) {
        Logger logger;
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug("match " + input + ' ' + this.pattern, e$iv);
        }
        if (this.comment) {
            return false;
        }
        List<String> file2 = adapter.toArray(input, this.options);
        if (this.empty) {
            return file2.isEmpty();
        }
        Logger $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl3 = false;
            logger.debug(this.pattern + " split " + file2, e$iv2);
        }
        return this.match(file2, partial);
    }

    public static /* synthetic */ boolean match$default(Minimatch minimatch, Object object, PathAdapter pathAdapter, boolean bl2, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        return minimatch.match(object, pathAdapter, bl2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass())) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type com.intellij.util.text.minimatch.Minimatch");
        Minimatch cfr_ignored_0 = (Minimatch)other;
        if (!Intrinsics.areEqual(this.options, ((Minimatch)other).options)) {
            return false;
        }
        if (this.comment != ((Minimatch)other).comment) {
            return false;
        }
        if (this.empty != ((Minimatch)other).empty) {
            return false;
        }
        if (this.negate != ((Minimatch)other).negate) {
            return false;
        }
        return Intrinsics.areEqual(this.pattern, ((Minimatch)other).pattern);
    }

    public int hashCode() {
        int result2 = this.options.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.comment);
        result2 = 31 * result2 + Boolean.hashCode(this.empty);
        result2 = 31 * result2 + Boolean.hashCode(this.negate);
        result2 = 31 * result2 + this.pattern.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.pattern;
    }

    @JvmOverloads
    public Minimatch(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        this(pattern, null, 2, null);
    }

    @JvmOverloads
    public final boolean match(@NotNull String input) {
        Intrinsics.checkNotNullParameter(input, "input");
        return Minimatch.match$default(this, input, false, 2, null);
    }

    @JvmOverloads
    public final <T> boolean match(T input, @NotNull PathAdapter<? super T> adapter) {
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        return Minimatch.match$default(this, input, adapter, false, 4, null);
    }
}

