/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Debug.Renderer(text="\"size = \" + myList.size()", childrenArray="toStrongList().toArray()", hasChildren="!isEmpty()")
public class UnsafeWeakList<T>
extends AbstractCollection<T> {
    protected final List<MyReference<T>> myList;
    private final ReferenceQueue<T> myQueue = new ReferenceQueue();
    private int myAlive;
    private int modCount;

    public UnsafeWeakList() {
        this.myList = new ArrayList<MyReference<T>>();
    }

    public UnsafeWeakList(int capacity) {
        this.myList = new ArrayList<MyReference<T>>(capacity);
    }

    boolean processQueue() {
        MyReference reference;
        boolean processed = false;
        while ((reference = (MyReference)this.myQueue.poll()) != null) {
            int index = reference.index;
            if (index < this.myList.size() && reference == this.myList.get(index)) {
                this.nullizeAt(index);
            }
            processed = true;
        }
        if (this.myAlive < this.myList.size() / 2) {
            this.reduceCapacity();
        }
        return processed;
    }

    private void nullizeAt(int index) {
        this.myList.set(index, null);
        --this.myAlive;
    }

    private void reduceCapacity() {
        int toSaveAlive = 0;
        for (int i2 = 0; i2 < this.myList.size(); ++i2) {
            MyReference<T> reference = this.myList.get(i2);
            if (reference == null) continue;
            Object t2 = reference.get();
            if (t2 == null) {
                --this.myAlive;
                continue;
            }
            if (toSaveAlive != i2) {
                this.myList.set(toSaveAlive, new MyReference(toSaveAlive, t2, this.myQueue));
            }
            ++toSaveAlive;
        }
        if (toSaveAlive != this.myList.size()) {
            this.myList.subList(toSaveAlive, this.myList.size()).clear();
            ++this.modCount;
        }
        this.myAlive = toSaveAlive;
    }

    private void append(@NotNull T element) {
        if (element == null) {
            UnsafeWeakList.$$$reportNull$$$0(0);
        }
        this.myList.add(new MyReference(this.myList.size(), element, this.myQueue));
        ++this.myAlive;
        ++this.modCount;
    }

    @Override
    public boolean add(@NotNull T element) {
        if (element == null) {
            UnsafeWeakList.$$$reportNull$$$0(1);
        }
        this.processQueue();
        this.append(element);
        return true;
    }

    public boolean addIfAbsent(@NotNull T element) {
        if (element == null) {
            UnsafeWeakList.$$$reportNull$$$0(2);
        }
        this.processQueue();
        if (this.contains(element)) {
            return false;
        }
        this.append(element);
        return true;
    }

    @Override
    public boolean contains(Object o2) {
        return !this.isEmpty() && super.contains(o2);
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myList.clear();
        this.myAlive = 0;
        ++this.modCount;
    }

    @TestOnly
    int listSize() {
        return this.myList.size();
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull T> iterator() {
        return new MyIterator();
    }

    @Override
    public boolean remove(@NotNull Object o2) {
        if (o2 == null) {
            UnsafeWeakList.$$$reportNull$$$0(3);
        }
        this.processQueue();
        for (int i2 = 0; i2 < this.myList.size(); ++i2) {
            Object t2;
            Reference ref = this.myList.get(i2);
            Object object = t2 = ref == null ? null : (Object)ref.get();
            if (t2 == null || !t2.equals(o2)) continue;
            this.nullizeAt(i2);
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c2) {
        if (c2 == null) {
            UnsafeWeakList.$$$reportNull$$$0(4);
        }
        this.processQueue();
        return super.addAll(c2);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c2) {
        if (c2 == null) {
            UnsafeWeakList.$$$reportNull$$$0(5);
        }
        this.processQueue();
        return super.removeAll(c2);
    }

    @NotNull
    public @NotNull List<@NotNull T> toStrongList() {
        if (this.myList.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                UnsafeWeakList.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<Object> result2 = new ArrayList<Object>(this.myList.size());
        for (MyReference<T> t2 : this.myList) {
            Object o2 = t2 == null ? null : (Object)t2.get();
            if (o2 == null) continue;
            result2.add(o2);
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            UnsafeWeakList.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public int size() {
        UnsafeWeakList.throwNotAllowedException();
        return -1;
    }

    private static void throwNotAllowedException() {
        throw new UnsupportedOperationException("index/size-based operations in UnsafeWeakList are not supported because they don't make sense in the presence of weak references. Use .iterator() (which retains its elements to avoid sudden GC) instead.");
    }

    @Override
    public boolean isEmpty() {
        if (this.myList.isEmpty()) {
            return true;
        }
        for (MyReference<T> value : this.myList) {
            if (value == null || value.get() == null) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(@NotNull UnsafeWeakList<T> other, @NotNull Predicate<? super T> allowEntity) {
        if (other == null) {
            UnsafeWeakList.$$$reportNull$$$0(8);
        }
        if (allowEntity == null) {
            UnsafeWeakList.$$$reportNull$$$0(9);
        }
        List<MyReference<T>> myList = this.myList;
        List<MyReference<T>> otherList = other.myList;
        if (otherList.isEmpty()) {
            return true;
        }
        for (MyReference<T> otherReference : otherList) {
            T t2 = SoftReference.dereference(otherReference);
            if (t2 == null || !allowEntity.test(t2) || myList.contains(otherReference)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/UnsafeWeakList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowEntity";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/UnsafeWeakList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toStrongList";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addIfAbsent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyReference<T>
    extends WeakReference<T> {
        private final int index;

        private MyReference(int index, T referent, ReferenceQueue<? super T> queue) {
            super(referent, queue);
            this.index = index;
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && Objects.equals(this.get(), ((Reference)obj).get());
        }
    }

    private final class MyIterator
    implements Iterator<T> {
        private final int startModCount;
        private int curIndex;
        private T curElement;
        private int nextIndex = -1;
        private T nextElement;
        private boolean modified;

        private MyIterator() {
            this.startModCount = UnsafeWeakList.this.modCount;
            this.findNext();
        }

        private void findNext() {
            if (UnsafeWeakList.this.modCount != this.startModCount) {
                throw new ConcurrentModificationException();
            }
            this.curIndex = this.nextIndex;
            this.curElement = this.nextElement;
            this.nextElement = null;
            this.nextIndex = -1;
            for (int i2 = this.curIndex + 1; i2 < UnsafeWeakList.this.myList.size(); ++i2) {
                Object t2;
                Reference ref = UnsafeWeakList.this.myList.get(i2);
                Object v0 = t2 = ref == null ? null : ref.get();
                if (t2 == null) continue;
                this.nextElement = t2;
                this.nextIndex = i2;
                break;
            }
            if (this.nextIndex == -1 && this.modified) {
                UnsafeWeakList.this.modCount++;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.findNext();
            return this.curElement;
        }

        @Override
        public void remove() {
            if (this.curElement == null) {
                throw new NoSuchElementException();
            }
            int index = this.curIndex;
            UnsafeWeakList.this.nullizeAt(index);
            this.modified = true;
        }
    }
}

