/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.elevation.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.process.elevation.ElevationBundle;
import com.intellij.execution.process.elevation.settings.ExplanatoryTextUiUtil;
import com.intellij.execution.process.mediator.common.QuotaOptions;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Service
@State(name="Elevation", storages={@Storage(value="security.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003&'(B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u001c\u001a\u00020\u0005J\b\u0010\u001d\u001a\u00020\u0005H\u0002J\b\u0010\u001e\u001a\u00020\u0002H\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0016\u0010#\u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0002R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR$\u0010\f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\tR\u000e\u0010\u000e\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/intellij/execution/process/elevation/settings/ElevationSettings;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/intellij/execution/process/elevation/settings/ElevationSettings$ElevationOptions;", "()V", "value", "", "isKeepAuth", "()Z", "setKeepAuth", "(Z)V", "isRefreshable", "setRefreshable", "isSettingsUpdateDone", "setSettingsUpdateDone", "options", "newValue", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "quotaOptions", "getQuotaOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "setQuotaOptions", "(Lcom/intellij/execution/process/mediator/common/QuotaOptions;)V", "", "quotaTimeLimitMs", "getQuotaTimeLimitMs", "()J", "setQuotaTimeLimitMs", "(J)V", "askEnableKeepAuthIfNeeded", "doAskEnableKeepAuthIfNeeded", "getState", "getStateModificationCount", "loadState", "", "state", "updateQuotaOptions", "block", "Lkotlin/Function0;", "Companion", "ElevationOptions", "Listener", "intellij.execution.process.elevation"})
@SourceDebugExtension(value={"SMAP\nElevationSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElevationSettings.kt\ncom/intellij/execution/process/elevation/settings/ElevationSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class ElevationSettings
implements PersistentStateComponentWithModificationTracker<ElevationOptions> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ElevationOptions options = new ElevationOptions();
    private static final long DEFAULT_GRACE_PERIOD_MS = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES));

    @NotNull
    public final QuotaOptions getQuotaOptions() {
        return new QuotaOptions(this.options.isKeepAuth() ? this.options.getGracePeriodMs() : 0L, this.options.isKeepAuth() && this.options.isRefreshable());
    }

    public final void setQuotaOptions(@NotNull QuotaOptions newValue) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        this.updateQuotaOptions((Function0<Unit>)((Function0)new Function0<Unit>(newValue, this){
            final /* synthetic */ QuotaOptions $newValue;
            final /* synthetic */ ElevationSettings this$0;
            {
                this.$newValue = $newValue;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean isKeepAuth2 = this.$newValue.getTimeLimitMs() != 0L;
                ElevationSettings.access$getOptions$p(this.this$0).setKeepAuth(isKeepAuth2);
                if (isKeepAuth2) {
                    ElevationSettings.access$getOptions$p(this.this$0).setGracePeriodMs(this.$newValue.getTimeLimitMs());
                }
            }
        }));
    }

    public final boolean isKeepAuth() {
        return this.options.isKeepAuth();
    }

    public final void setKeepAuth(boolean value) {
        Unit unit;
        this.updateQuotaOptions((Function0<Unit>)((Function0)new Function0<Unit>(this, value){
            final /* synthetic */ ElevationSettings this$0;
            final /* synthetic */ boolean $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                ElevationSettings.access$getOptions$p(this.this$0).setKeepAuth(this.$value);
            }
        }));
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        if (value) {
            this.setSettingsUpdateDone(true);
        }
    }

    public final boolean isRefreshable() {
        return this.options.isRefreshable();
    }

    public final void setRefreshable(boolean value) {
        this.updateQuotaOptions((Function0<Unit>)((Function0)new Function0<Unit>(this, value){
            final /* synthetic */ ElevationSettings this$0;
            final /* synthetic */ boolean $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                ElevationSettings.access$getOptions$p(this.this$0).setRefreshable(this.$value);
            }
        }));
    }

    public final long getQuotaTimeLimitMs() {
        return this.options.getGracePeriodMs();
    }

    public final void setQuotaTimeLimitMs(long value) {
        this.updateQuotaOptions((Function0<Unit>)((Function0)new Function0<Unit>(this, value){
            final /* synthetic */ ElevationSettings this$0;
            final /* synthetic */ long $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                ElevationSettings.access$getOptions$p(this.this$0).setGracePeriodMs(this.$value);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isSettingsUpdateDone() {
        boolean bl;
        ElevationSettings elevationSettings = this;
        synchronized (elevationSettings) {
            boolean bl2 = false;
            bl = this.options.isSettingsUpdateDone();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setSettingsUpdateDone(boolean value) {
        ElevationSettings elevationSettings = this;
        synchronized (elevationSettings) {
            boolean bl = false;
            this.options.setSettingsUpdateDone(value);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void updateQuotaOptions(Function0<Unit> block) {
        QuotaOptions oldValue = this.getQuotaOptions();
        block.invoke();
        QuotaOptions newValue = this.getQuotaOptions();
        if (!Intrinsics.areEqual((Object)oldValue, (Object)newValue)) {
            ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(Listener.TOPIC)).onDaemonQuotaOptionsChanged(oldValue, newValue);
        }
    }

    @NotNull
    public ElevationOptions getState() {
        return this.options;
    }

    public void loadState(@NotNull ElevationOptions state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        BaseState.copyFrom$default((BaseState)this.options, (BaseState)state, (boolean)false, (int)2, null);
    }

    public long getStateModificationCount() {
        return this.options.getModificationCount();
    }

    public final boolean askEnableKeepAuthIfNeeded() {
        return this.isSettingsUpdateDone() || (Boolean)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ElevationSettings this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return ElevationSettings.access$doAskEnableKeepAuthIfNeeded(this.this$0);
            }
        }), (int)1, null) != false;
    }

    private final boolean doAskEnableKeepAuthIfNeeded() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isSettingsUpdateDone()) {
            return true;
        }
        Object[] objectArray = new Object[]{NlsMessages.formatDuration((long)DEFAULT_GRACE_PERIOD_MS)};
        String string = ElevationBundle.message("keep.authorized.for.0", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String yesText = string;
        String string2 = ElevationBundle.message("authorize.every.time", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String noText = string2;
        String string3 = ElevationBundle.message("text.you.are.about.to.run.privileges.process", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String message = ExplanatoryTextUiUtil.message$default(ExplanatoryTextUiUtil.INSTANCE, string3, 70, null, 4, null);
        String string4 = SystemInfo.isMac ? ElevationBundle.message("update.elevation.preferences", new Object[0]) : ElevationBundle.message("update.elevation.settings", new Object[0]);
        Intrinsics.checkNotNull((Object)string4);
        String title = string4;
        int yesNoCancelResult = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.Companion.yesNoCancel(title, message).yesText(yesText)).noText(noText)).guessWindowAndAsk();
        if (yesNoCancelResult == 2) {
            return false;
        }
        this.setQuotaTimeLimitMs(DEFAULT_GRACE_PERIOD_MS);
        this.setKeepAuth(yesNoCancelResult == 0);
        this.setSettingsUpdateDone(true);
        return true;
    }

    @JvmStatic
    @NotNull
    public static final ElevationSettings getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ ElevationOptions access$getOptions$p(ElevationSettings $this) {
        return $this.options;
    }

    public static final /* synthetic */ boolean access$doAskEnableKeepAuthIfNeeded(ElevationSettings $this) {
        return $this.doAskEnableKeepAuthIfNeeded();
    }

    public static final /* synthetic */ long access$getDEFAULT_GRACE_PERIOD_MS$cp() {
        return DEFAULT_GRACE_PERIOD_MS;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/process/elevation/settings/ElevationSettings$Companion;", "", "()V", "DEFAULT_GRACE_PERIOD_MS", "", "getInstance", "Lcom/intellij/execution/process/elevation/settings/ElevationSettings;", "intellij.execution.process.elevation"})
    @SourceDebugExtension(value={"SMAP\nElevationSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElevationSettings.kt\ncom/intellij/execution/process/elevation/settings/ElevationSettings$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,128:1\n40#2,3:129\n*S KotlinDebug\n*F\n+ 1 ElevationSettings.kt\ncom/intellij/execution/process/elevation/settings/ElevationSettings$Companion\n*L\n23#1:129,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ElevationSettings getInstance() {
            boolean $i$f$service = false;
            Class<ElevationSettings> serviceClass$iv = ElevationSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ElevationSettings)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR+\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R+\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R+\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u000b\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/intellij/execution/process/elevation/settings/ElevationSettings$ElevationOptions;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "gracePeriodMs", "getGracePeriodMs", "()J", "setGracePeriodMs", "(J)V", "gracePeriodMs$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "isKeepAuth", "()Z", "setKeepAuth", "(Z)V", "isKeepAuth$delegate", "isRefreshable", "setRefreshable", "isRefreshable$delegate", "isSettingsUpdateDone", "setSettingsUpdateDone", "isSettingsUpdateDone$delegate", "intellij.execution.process.elevation"})
    public static final class ElevationOptions
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty isSettingsUpdateDone$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty isKeepAuth$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[1]);
        @NotNull
        private final ReadWriteProperty isRefreshable$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[2]);
        @NotNull
        private final ReadWriteProperty gracePeriodMs$delegate = this.property(ElevationSettings.access$getDEFAULT_GRACE_PERIOD_MS$cp()).provideDelegate((Object)this, $$delegatedProperties[3]);

        public final boolean isSettingsUpdateDone() {
            return (Boolean)this.isSettingsUpdateDone$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setSettingsUpdateDone(boolean bl) {
            this.isSettingsUpdateDone$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
        }

        public final boolean isKeepAuth() {
            return (Boolean)this.isKeepAuth$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setKeepAuth(boolean bl) {
            this.isKeepAuth$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)bl);
        }

        public final boolean isRefreshable() {
            return (Boolean)this.isRefreshable$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        public final void setRefreshable(boolean bl) {
            this.isRefreshable$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
        }

        public final long getGracePeriodMs() {
            return ((Number)this.gracePeriodMs$delegate.getValue((Object)this, $$delegatedProperties[3])).longValue();
        }

        public final void setGracePeriodMs(long l) {
            this.gracePeriodMs$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)l);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ElevationOptions.class, "isSettingsUpdateDone", "isSettingsUpdateDone()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ElevationOptions.class, "isKeepAuth", "isKeepAuth()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ElevationOptions.class, "isRefreshable", "isRefreshable()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ElevationOptions.class, "gracePeriodMs", "getGracePeriodMs()J", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/execution/process/elevation/settings/ElevationSettings$Listener;", "", "onDaemonQuotaOptionsChanged", "", "oldValue", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "newValue", "Companion", "intellij.execution.process.elevation"})
    public static interface Listener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @JvmField
        @NotNull
        public static final Topic<Listener> TOPIC;

        default public void onDaemonQuotaOptionsChanged(@NotNull QuotaOptions oldValue, @NotNull QuotaOptions newValue) {
            Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        }

        static {
            Topic topic = Topic.create((String)"ElevationSettings.Listener", Listener.class);
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
            TOPIC = topic;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/process/elevation/settings/ElevationSettings$Listener$Companion;", "", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/execution/process/elevation/settings/ElevationSettings$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.execution.process.elevation"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

